/*
 * profileData.cpp
 *
 *  Created on: 04.11.2016
 *      Author: bn81lr
 */

#include <core/profileData.h>
#include "profileApp.h"

#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>

#include <string.h> //memcpy

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_usermanager_if.h"
#endif

#include "profileTrace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP
#include "trcGenProj/Header/profileData.cpp.trc.h"
#endif



namespace profileMngr {



//*************************** profileData()  *********************************

profileData::profileData():m_MaxProfiles(1),m_CurrentProfile(0),m_CheckPinCount(3),m_ChangePinTimeout(2000)
,m_bStartupUserChange(false),m_AppState(psInitalize),m_pinRequest(0)
{

}

//*************************** init()  *********************************
bool profileData::Init(const unsigned char maxProfile)
{
	m_MaxProfiles=maxProfile;
	m_Names.resize(m_MaxProfiles);
	m_Images.resize(m_MaxProfiles);
	m_ProfileStatus.resize(m_MaxProfiles);
	m_PinCounter.resize(m_MaxProfiles);
	m_PinHashes.assign(m_MaxProfiles,0);
	m_maxAttempsBeforeDelayTimeStamp.resize(m_MaxProfiles);

	return true;
}


//*************************** ~profileData()  ***********************************

profileData::~profileData()
{
}


//*************************** load()  ********************************************

void profileData::loadstring(unsigned char * &pBuff,std::string & str)
{
	unsigned char len=*pBuff;pBuff++;
	str.assign((char *)pBuff,len);
	pBuff+=len;
}

bool profileData::load()
{
	unsigned char buff[512];
    bool bFailed=false;

    dp_tclprofileMngrStartClients clients;
    uint32_t load=clients.s32GetData(buff,512);
    uint8_t *pName=buff;
    ETG_TRACE_USR4(("clients %d",load));

    if (load > 1)
    {
    	while (*pName> 0)
    	{
    		std::string add;
    		loadstring(pName,add);
    		m_StartClients.push_back(add);
    	}
    }

	dp_tclprofileMngrPinHash Hash;
	load=Hash.s32GetData(buff,512);
	if (load > 1)
	{
		pName=buff;
		for (int h=0;h < m_PinHashes.size();++h,pName+=CHECKSUM_DIGEST_LENGTH)
		{
			m_PinHashes[h]=new unsigned char[CHECKSUM_DIGEST_LENGTH];
			memcpy(m_PinHashes[h],pName,CHECKSUM_DIGEST_LENGTH);
		}
	}

	dp_tclprofileMngrPinCounter Counter;
	load=Counter.s32GetData(buff,512);
    if (load > 1)
	{
        unsigned char *pinCounter=buff;
        for (int idx=0;idx < m_PinCounter.size();++idx,pinCounter++)
             m_PinCounter[idx]=*pinCounter;
	}

	dp_tclprofileMngrProfiles profileValues;
	load = profileValues.s32GetData(buff,512);
	if(load <=1)
        bFailed=true;
	
	unsigned char *pIn=buff;
	unsigned char idx=0;
	for (;pIn-buff < load && bFailed==false;)
	{
		switch (*pIn)
		{
			case diName:
				idx=pIn[1];pIn+=2;
				if (idx < m_Names.size())
				{
					loadstring(pIn,m_Names[idx]);
					ETG_TRACE_USR4(("Name   :%s",m_Names[idx].c_str()));
				}
				else
                    bFailed=true;
			break;
			case diImage:
				 idx=pIn[1];
				 if (idx < m_Images.size())
				 {
				 m_Images[pIn[1]]= pIn[2];
				 pIn+=3;
			     ETG_TRACE_USR4(("Image :%u ", m_Images[pIn[1]]));
				 }
				 else
                    bFailed=true;
			break;
			case diStatus:
				idx=pIn[1];
				if (idx < m_ProfileStatus.size())
				{
				 m_ProfileStatus[pIn[1]]=(enUserStatus)pIn[2];
			     ETG_TRACE_USR4(("Status   :%d",ETG_ENUM(TR_PROFILE_STATUS,m_ProfileStatus[pIn[1]]) ));
			     pIn+=3;
				}
				else
				    bFailed=true;
			break;
			case diExtID://not used anymore. here for backward compatabillity of lastmode file
			     pIn+=sizeof(unsigned int)+2;
			break;
		    default:
                bFailed=true;
		}
	}
	if (bFailed)
        {ETG_TRACE_FATAL(("Invalid last mode file. Using defaults."))}
    else
	    {ETG_TRACE_COMP(("-->profileData::Lastmode[%i] loaded",load))}



	return !bFailed;
}
//*************************** store  **************************************************************

bool profileData::store()
{
	unsigned char buff[512],*pOut=buff;

	pOut=buff;
	for (int c=0;c < m_PinHashes.size();++c,pOut+=CHECKSUM_DIGEST_LENGTH)
	{
		if (m_PinHashes[c]!=0)
			memcpy(pOut,m_PinHashes[c],CHECKSUM_DIGEST_LENGTH);
		else
			memset(pOut,0,CHECKSUM_DIGEST_LENGTH);
	}
	dp_tclprofileMngrPinHash Hash;
	uint32_t ret=Hash.s32SetData(buff,pOut-buff);
	traceN(trWriteDPResult,ret==0?4:0,ret);
    pOut=buff;
    //maxCounter
	for (int idx=0;idx < m_PinCounter.size();++idx,pOut++)
	{
		 *pOut=m_PinCounter[idx];
	}
	dp_tclprofileMngrPinCounter Counter;
    ret=Counter.s32SetData(buff,pOut-buff);
	traceN(trWriteDPResult,ret==0?4:0,ret);

	pOut=buff;
	for (int k=0;k < m_MaxProfiles;++k)
	{
		setID(diName,k,pOut);
		storestring(m_Names[k],pOut);
		setID(diImage,k,pOut);
		*pOut=m_Images[k];++pOut;
		setID(diStatus,k,pOut);
		*pOut=m_ProfileStatus[k];++pOut;
	}

   	dp_tclprofileMngrProfiles profileValues;
	ret=profileValues.s32SetData(buff,pOut-buff);
	traceN(trWriteDPResult,ret==0?4:0,ret);
	return true;
}

void profileData::doDefSet()
{
	m_StartClients.clear();
	storeClients();
}

void profileData::storeClients()
{
	unsigned char buff[512],*pOut=buff;
	for (int c=0;c < m_StartClients.size();++c)
	{
		storestring(m_StartClients[c],pOut);
	}
	dp_tclprofileMngrStartClients clients;
	clients.s32SetData(buff,pOut-buff);
}

//*************************** getName  ********************************************

std::string profileData::getName() const
{
	return m_Names[m_CurrentProfile];
}
//*************************** getImage  ********************************************

unsigned char profileData::getImage() const
{
	return m_Images[m_CurrentProfile];
}

//*************************** getStatus  ********************************************

enUserStatus profileData::getStatus() const
{
	return m_ProfileStatus[m_CurrentProfile];
}

uint32_t profileData::getPrivacyMode() const
{
	tU32  iPrivacyMode;
	dp_tclprofileMngrPrivacyMode dpPrivacyMode;
	tS32 re = dpPrivacyMode.s32GetData(iPrivacyMode);

	return iPrivacyMode;
}

//*************************** getProfileNames  **********************************************

const std::vector<std::string>& profileData::getProfileNames()
{
	return m_Names;
}

//*************************** getProfileImages  ********************************************

const std::vector<unsigned char>& profileData::getProfileImages()
{
	return m_Images;
}

//*************************** getProfileStatus  ********************************************

const std::vector<profileMngr::enUserStatus>& profileData::getProfileStatus()
{
	return m_ProfileStatus;
}



//*************************** setImage  *******************************************************

bool profileData::setImage(unsigned char idx, unsigned char iprofileImage)
{
	m_Images.at(idx)=iprofileImage;
	return true;
}

//*************************** setName  **************************************************************

bool profileData::setName(unsigned char idx, const std::string& profileName)
{
	m_Names.at(idx)=profileName.c_str();
	return true;
}

//*************************** setStatus **************************************************************

bool profileData::setStatus(unsigned char idx, const enUserStatus eProfileStatus)
{
	m_ProfileStatus.at(idx)=eProfileStatus;
	return true;
}

bool profileData::setPrivacyMode(uint32_t iPrivacyMode)
{
	dp_tclprofileMngrPrivacyMode dpPrivacyMode;
	dpPrivacyMode.s32SetData(iPrivacyMode);

	return true;
}

//****************************setMaxCounter ********************
void profileData::increPinCounter(unsigned char idx )
{
	++m_PinCounter[idx];
}

//****************************setMaxCounter ********************
bool profileData::setPinCounter(unsigned char idx,unsigned char pinCounter)
{

	m_PinCounter[idx]=pinCounter;
	return true;

}

const std::vector<unsigned char > &profileData::getPinCounter(){return m_PinCounter;}

const std::vector<unsigned char *> & profileData::getPINHash() {return m_PinHashes;}

void profileData::setPINHash(uint8_t Index, unsigned char * Hash)
{
	m_PinHashes[Index]=new unsigned char[CHECKSUM_DIGEST_LENGTH];
	memcpy(m_PinHashes[Index],Hash,CHECKSUM_DIGEST_LENGTH);
}



//********************** setMaxPINAttemptsBeforeDelay ***********************************

bool profileData::setMaxPINAttemptsBeforeDelay(uint8_t iMaxPINAttempts)
{
	ETG_TRACE_COMP(("profileData: setMaxPINAttemptsBeforeDelay"));

	dp_tclprofileMngrMaxPINAttemptsBeforeDelay MaxPinAttempt;
	MaxPinAttempt.s32SetData(iMaxPINAttempts);
	return true;
}
//********************** setPINAuthenticationDelay ***********************************
bool profileData::setPINAuthenticationDelay(uint32_t iDelay)
{

	ETG_TRACE_COMP(("profileData: setPINAuthenticationDelay"));

	dp_tclprofileMngrPINAuthenticationDelay PinAuthenticationDealy;
	PinAuthenticationDealy.s32SetData(iDelay);
	return true;


}

//********************** setPinVerificationValidity ***********************************
bool profileData::setPinVerificationValidity(uint32_t iValidityTime)
{

	ETG_TRACE_COMP(("profileData: setPinVerificationValidity"));

	dp_tclprofileMngrPinVerificationValidity PinVerificationValidity;
	PinVerificationValidity.s32SetData(iValidityTime);
	return true;


}


//********************** getMaxPINAttemptsBeforeDelay ***********************************

uint32_t profileData::getMaxPINAttemptsBeforeDelay()
{
	tU8  iMaxPINAttempts;
	dp_tclprofileMngrMaxPINAttemptsBeforeDelay MaxPINAttempt;
	tS32 re = MaxPINAttempt.s32GetData(iMaxPINAttempts); //need to check about u32


	return iMaxPINAttempts;


}

//********************** getPINAuthenticationDelay ***********************************

uint32_t profileData::getPINAuthenticationDelay()
{
	tU32 /*uint32_t*/ iPINAuthenticationDelay;
	dp_tclprofileMngrPINAuthenticationDelay PINAuthenticationDelay;
	tS32 re = PINAuthenticationDelay.s32GetData(iPINAuthenticationDelay); //need to check about u32


	return iPINAuthenticationDelay;


}
//********************** getPinVerificationValidity ***********************************

uint32_t profileData::getPinVerificationValidity()
{
	tU32  iPinVerificationValidity;
	dp_tclprofileMngrPinVerificationValidity PinVerificationValidity;
	tS32 re = PinVerificationValidity.s32GetData(iPinVerificationValidity); //need to check about u32


	return iPinVerificationValidity;


}

bool profileData::setMaxAttempsBeforeDelayTimeStamp(uint32_t iDelatyTimeStamp,unsigned char index)
{
	m_maxAttempsBeforeDelayTimeStamp[index]=iDelatyTimeStamp;
	return true;
}
const std::vector<uint32_t>& profileData::getMaxAttempsBeforeDelayTimeStamp()
{
	return m_maxAttempsBeforeDelayTimeStamp;
}



//set and get MaxPINAttemptsTotal
bool profileData::setMaxPINAttemptsTotal(unsigned char  iMaxPinAttemptTotal)
{

	ETG_TRACE_COMP(("profileData: setMaxPINAttemptsTotal"));

	dp_tclprofileMngrMaxPINAttemptsTotal dpMaxPinAttemptTotal;
	dpMaxPinAttemptTotal.s32SetData(iMaxPinAttemptTotal);
	return true;

}
unsigned char profileData::getMaxPINAttemptsTotal()
{

	tU8  iMaxPINAttemptsTotal;
	dp_tclprofileMngrMaxPINAttemptsTotal dpMaxPINAttemptTotal;
	tS32 re = dpMaxPINAttemptTotal.s32GetData(iMaxPINAttemptsTotal);

	return iMaxPINAttemptsTotal;
}

uint32_t profileData::getOngoingProfileOperation()
{
	tU32 status=0;
	dp_tclprofileMngrprofileOperation dpCopyUSerStatus;
	tS32 re = dpCopyUSerStatus.s32GetData(status);
	return status;
}

bool profileData::setOngoingProfileOperation(uint8_t source, uint8_t dest,uint8_t mode)
{
	dp_tclprofileMngrprofileOperation dpCopyUSerStatus;
	dpCopyUSerStatus.s32SetData(source << 24 | dest << 16 | mode);
	return true;
}

bool profileData::setValetModeStatus(bool iValetModeStatus)
{
	dp_tclprofileMngrValetModeStatus dpValeModeStatus;
	dpValeModeStatus.s32SetData(iValetModeStatus);
	return true;

}
bool  profileData:: getValetModeStatus()
{
	tBool  iValetModeStatus;
	dp_tclprofileMngrValetModeStatus dpValeModeStatus;
	dpValeModeStatus.s32GetData(iValetModeStatus);

	return iValetModeStatus;
}

bool profileData::setLastActiveUser(uint8_t iUser)
{
	dp_tclprofileMngrLastActiveUser dpLastActiveUser;
	dpLastActiveUser.s32SetData(iUser);
	return true;

}
tU8 profileData::getLastActiveUser()
{
	tU8 iUser;
	dp_tclprofileMngrLastActiveUser dpLastActiveUser;
	dpLastActiveUser.s32GetData(iUser);
	return iUser;
}

bool profileData::setAuthenticationValidTime(uint32_t Time)
{
	dp_tclprofileMngrAuthenticationValidTime time;
	return time.s32SetData(Time)==0;
}

uint32_t profileData::getAuthenticationValidTime()
{
	dp_tclprofileMngrAuthenticationValidTime time;
	uint32_t vtime=0;
	time.s32GetData(vtime);
	return vtime;
}


bool profileData::storeLogoutTime(uint64_t time)
{
	dp_tclprofileMngrlogoffTimestamp stamp;
	return stamp.s32SetData(time)==0;
}

uint64_t profileData::getLogoutTime()
{
	dp_tclprofileMngrlogoffTimestamp stamp;
	uint64_t vstamp=0;
	stamp.s32GetData(vstamp);

	return vstamp;
}

}
