/*
 * jobCopyUser.cpp
 *
 *  Created on: 01.09.2017
 *      Author: bn81lr
 */

#include "core/jobs/valetMode.h"
#include "core/jobs/changeUser.h"
#include "core/profileApp.h"
#include "core/configInterface.h"
#include "core/jobs/deleteUser.h"

#include "core/profileTrace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP
#include "trcGenProj/Header/valetMode.cpp.trc.h"
#endif

namespace profileMngr {

ValetModeJob::ValetModeJob(uintptr_t act,bool valetMode,uint32_t numClients,ProfileAppIF & IF):Job(act, numClients),m_IF(IF),m_ValetModeStatus(valetMode),m_newUserID(0)
{
	m_State = Initializing;
	m_pChangeUser=0;
	m_pDeleteUser=0;
}

ValetModeJob::~ValetModeJob()
{
if (m_pChangeUser!=0)
	{delete m_pChangeUser;m_pChangeUser=0;}
if (m_pDeleteUser!=0)
	{delete m_pDeleteUser;m_pDeleteUser=0;}
}

bool ValetModeJob :: setValetMode()
{

	if (m_IF.getData().getValetModeStatus()!=m_ValetModeStatus) //check if the previous value is not same as new value
	{
	   //store the value in persistent memory
		m_IF.getData().setValetModeStatus(m_ValetModeStatus);

		//last Active user
		if (m_ValetModeStatus==true)
		{
			m_IF.getData().setLastActiveUser(m_IF.getData().currentProfile());
			m_IF.sendProfileStatus(psValetMode);
		}
		else
		{
			//set user ID as last active user ID
			m_newUserID=m_IF.getData().getLastActiveUser();
			ETG_TRACE_USR4(("-->Valet Mode Last Active UserID:%d",m_newUserID));

		}
		return true;
	}

	return false;

}
void ValetModeJob::finish()
{
	if (m_State!=Finished && m_Result==asSuccess)
		m_Result=asFailed;

	ETG_TRACE_COMP(("Change to Valet Mode ::Finish %u",ETG_ENUM(TR_EN_ACTIONSTATE,m_Result)));

	m_IF.sendDataUpdate(dsIdle); //
	if (m_pChangeUser!=0 && m_pChangeUser->isFinished()==false)
		m_pChangeUser->finish();

	if (m_ValetModeStatus==true)
		m_IF.sendProfileStatus(psValetMode); // valet mode send

	if (m_pRequester) m_pRequester->sendSetValetModeResult(m_Act,m_Result);
		m_pRequester=0;//make sure, result message is only sent once otherwise ASF reset

}


void ValetModeJob::HandleTimerExpired()
{
	finish();
}

uint32_t ValetModeJob::getTimer()
{
	return m_TimerHandle;
	//TODO: Will enable the Separate timers for each SUb Job later
	//return ((m_State != ChangeUser)?(m_TimerHandle):(m_pChangeUser->getTimer()));
}

void ValetModeJob::setTimer(uint32_t Timer)
{
	m_TimerHandle = Timer;
	/* TODO: Will enable the Separate timers for each SUb Job later
	if(m_State != ChangeUser)
        m_TimerHandle = Timer;
	else
	    m_pChangeUser->setTimer(Timer);*/
}

bool ValetModeJob::stateFunction()
{
	bool bSuccess=true;
	switch (m_State)
	{
	case Initializing:
         m_State=SetValetMode;
         if (configIF::getInst().isSetValetModeAllowed(m_newUserID)==false)
         {
         	m_Result=asDenied;
         	ETG_TRACE_FATAL(("Set Valet Mode Denied"));
         	finish();
         	return false;
         }
         if(setValetMode())
            return true;
         else
           {
        	 m_State=Finished;
        	 finish();
        	 return false;
            }
	case SetValetMode:
	{
         uint8_t current=m_IF.getData().currentProfile();
		 if (m_newUserID!= current)
		 {
			m_State=ChangeUser;
			m_pChangeUser=new ChangeUserJob(0,m_newUserID,current,m_NumClients,m_IF,true);
		    while (m_pChangeUser->stateFunction()==true) ;
		    m_ClientsOpen=0;  //making the clients zero here

             return false;
		  }
		 if (m_ValetModeStatus==true) //only for guest profile when valet mode is enable and guest profile is already there
		 {
			 m_State=DeleteUser;
			 ETG_TRACE_FATAL(("in guest change user"));
			 m_pDeleteUser= new DeleteUserJob(0,m_newUserID,m_NumClients,m_IF,false);
			 while (m_pDeleteUser->stateFunction()==true) ;

			 m_ClientsOpen=0;  //making the clients zero here

			 return false;
		 }

		  m_State=Finished;
		  finish();
		  return false;
	}
	case ChangeUser:
	{
		ETG_TRACE_FATAL(("in change user"));
		do {} while (m_pChangeUser->stateFunction()==true) ;
		ETG_TRACE_FATAL(("after change user"));
		if (m_pChangeUser->isFinished())
			{
				if (m_pChangeUser->result()!=asSuccess)
					m_Result=m_pChangeUser->result();
				else
					m_State=Finished;
				finish();
			}
			return false;
	}
	case DeleteUser:
	{
		do {} while (m_pDeleteUser->stateFunction()==true) ;
	    if (m_pDeleteUser->isFinished())
	    {
			if (m_pDeleteUser->result()!=asSuccess)
				m_Result=m_pDeleteUser->result();
			else
				m_State=Finished;
				finish();
		 }
				return false;
	}

	}

	return false;
}


void ValetModeJob::updateStatus(ClientStatusUpdate &status,uint32_t clientID)
{
	switch (m_State)
		{
		case ChangeUser:
			if (m_pChangeUser!=0)
				m_pChangeUser->updateStatus(status,clientID);
			break;
		case DeleteUser:
			if (m_pDeleteUser!=0)
				m_pDeleteUser->updateStatus(status,clientID);
			break;

		}
}


} /* namespace profileMngr */
