/*
 * loginUser.cpp
 *
 *  Created on: 12.09.2017
 *      Author: bn81lr
 */

#include "core/jobs/loginUser.h"
#include "core/profileApp.h"
#include "core/jobs/changeUser.h"

#include "openssl/sha.h"

#include "core/profileTrace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP
#include "trcGenProj/Header/loginUser.cpp.trc.h"
#endif

namespace profileMngr {

loginUser::loginUser(ChangeUserJob *pChUSer,ProfileAppIF & IF):Job(0,0),m_pChangeUser(pChUSer),m_bWaitingForPin(false),m_IF(IF),m_State(Init)
{
}

loginUser::~loginUser() {
	// TODO Auto-generated destructor stub
}

void loginUser::finish()
{
	m_IF.sendPinRequest(0);
	switch (m_State)
	{
	case  ChangeUser:
		if (m_pChangeUser)
			m_pChangeUser->finish();
		break;
	case Init:
		m_IF.sendProfileStatus(psLocked);
		break;//make sure, the profile is still locked if the login is cancelled
	}
	m_State=Done;
}

void loginUser::loginDone()
{
	m_State=ChangeUser;
	m_IF.sendPinRequest(0); //send false
	do {} while (stateFunction()==true) ;
}

bool loginUser::stateFunction()
{
	switch (m_State)
	{
	case Init:
		switch (m_IF.getData().getProfileStatus()[m_pChangeUser->newUser()])
		{
		case usProtectedPin:
		case usLinkedPin:{
			if (m_IF.getData().getPINHash()[m_pChangeUser->newUser()]==0)//type is protected , but hash is not available
			{adaptType(m_pChangeUser->newUser());m_State=ChangeUser;return true;}
			//send PinRequest
			unsigned char iPinRequest=m_IF.getData().getMaxPINAttemptsTotal() - m_IF.getData().getPinCounter()[m_pChangeUser->newUser()];
			m_IF.sendPinRequest(iPinRequest);
			return false;
		}
		case usProtectedRemember:
		case usLinkedRemember:
			m_State=ChangeUser;
			return true;
		}
	break;
	case ChangeUser:
		if (m_pChangeUser)
		{
			bool bRet=m_pChangeUser->stateFunction();
			if (m_pChangeUser->isFinished())
			{
				m_Result=m_pChangeUser->result();
				if (m_Result==asSuccess)
					m_State=Done;
			}
			return bRet;
		}
		break;
	}
	return false;
}

void loginUser::adaptType(uint8_t Index)
{
	switch (m_IF.getData().getProfileStatus()[Index])
	{
		case usProtectedPin:m_IF.getData().setStatus(Index,usProtectedRemember);break;
		case usLinkedPin:m_IF.getData().setStatus(Index,usLinkedRemember);break;
	}
}

actionState loginUser::setProfilePin(uint8_t Index,std::string Pin)
{
	profileData & data=m_IF.getData();
	unsigned char hash[SHA256_DIGEST_LENGTH];
	getSha(Pin,hash);

	switch (data.getProfileStatus()[Index])
	{
	case usProtectedPin:
	case usLinkedPin:
	if (ProfileApp::getInst().isUserUnlocked(Index))
	   {
	       data.setPINHash(Index,hash);
		   ETG_TRACE_COMP(("setProfilePin: pin changed"));
	   }
	else
		return asDenied;
	break;
	case usProtectedRemember:
	case usLinkedRemember:
	case usNormal:
		data.setPINHash(Index,hash);ETG_TRACE_COMP(("setProfilePin: pin changed"));
	break;
	case usGuest:
	case usEmpty:
		return asFailed;
	}
	switch (data.getProfileStatus()[Index])
	{
		case usProtectedPin:
		case usProtectedRemember:
		case usNormal:
			data.setStatus(Index,usProtectedPin);break;
		case usLinkedRemember:
			data.setStatus(Index,usLinkedPin);break;
	}
	data.store();
	m_IF.sendActiveProfileType();
	return asSuccess;
}


void loginUser::updateStatus(ClientStatusUpdate &status,uint32_t clientID)
{
	switch (m_State)
	{
	case ChangeUser:
		if (m_pChangeUser!=0)
			m_pChangeUser->updateStatus(status,clientID);
	}
};


void loginUser::getSha(std::string Pin,unsigned char * pSha)
{
	unsigned char hash[SHA256_DIGEST_LENGTH];
	SHA256_CTX sha256;
	SHA256_Init(&sha256);
	SHA256_Update(&sha256, Pin.c_str(), Pin.length());
	SHA256_Final(pSha, &sha256);
}


actionState loginUser::setRememberMe(uint8_t Index)
{
	profileData & data=m_IF.getData();
	bool bLocked=ProfileApp::getInst().isUserUnlocked(Index);

	switch (data.getProfileStatus()[Index])
	{
		case usGuest:
		case usEmpty:
			return asFailed;
		case usProtectedRemember:
		case usLinkedRemember:
			return asSuccess;
		case usProtectedPin:
			if (bLocked)
			{
				data.setStatus(Index,usProtectedRemember);
				data.store();
				m_IF.sendActiveProfileType();
				return asSuccess;
			}
			else
				return asDenied;
		case usLinkedPin:
			if (bLocked)
			{
				data.setStatus(Index,usLinkedRemember);
				data.store();
				m_IF.sendActiveProfileType();
				return asSuccess;
			}
			else
				return asDenied;
		case usNormal:
			data.setStatus(Index,usProtectedRemember);
			data.store();
			m_IF.sendActiveProfileType();
			return asSuccess;

	}
	return asFailed;
}

actionState loginUser::unprotectProfile(uint8_t Index)
{
	profileData & data=m_IF.getData();
	switch (data.getProfileStatus()[Index])
	{
		case usGuest:
		case usEmpty:
			return asFailed;
		case usNormal:
			return asSuccess;
		case usProtectedRemember:
			data.setStatus(Index,usNormal);
			data.store();
			m_IF.sendActiveProfileType();
			return asSuccess;
		case usLinkedRemember:
			return asFailed;
		case usProtectedPin:
			if (ProfileApp::getInst().isUserUnlocked(Index))
			{
				data.setStatus(Index,usNormal);
				data.store();
				m_IF.sendActiveProfileType();
				return asSuccess;
			}
			else
				return asDenied;
		case usLinkedPin:
			return asFailed;
	}
	return asFailed;
}

void loginUser::HandleTimerExpired()
{
	finish();
}
void loginUser::Cancel()
{

   finish();

}

} /* namespace profileMngr */
