#ifndef IMAGEJOB_H_
#define IMAGEJOB_H_

#include "core/jobs/job.h"

namespace profileMngr {

class ProfileAppIF;

class ImageJob:public Job
{
public:
	ImageJob(uintptr_t act,const std::string & FileName,uint32_t width,uint32_t height,uint32_t slot,bool bAssignToUser,ProfileAppIF & IF);
	virtual ~ImageJob(){};
	std::string & fileName(){return m_FileName;}
	virtual void HandleTimerExpired();
	uint32_t width(){return m_Width;}
	uint32_t height(){return m_Height;}
	uint32_t slot(){return m_Slot;}
	bool bAssign(){return m_bAssignToUser;}
	static bool deleteUserImage(unsigned short slotId);
	virtual bool stateFunction();
	virtual void finish();
	virtual bool isFinished();
	static void detachLib();
	virtual void updateStatus(ClientStatusUpdate &status,uint32_t clientID){};
	virtual uint32_t getTimer(){return m_TimerHandle;}
	virtual void setTimer(uint32_t Timer){m_TimerHandle = Timer; }
	virtual bool isTimerExpiredRequired(){return false;}
protected:
	std::string m_FileName;
	uint32_t m_Width;
	uint32_t m_Height;
	uint32_t m_Slot;
	bool m_bAssignToUser;
private:
	bool loadImgImport();
	void importImage();
	ProfileAppIF & m_IF;
	static int (*m_pImportImage)(std::string FileName,unsigned short width, unsigned short height,std::string outFileName,char *& Error);
	static void * importImgProc(void * pParam);
	static 	void* m_hLib;
	bool m_bStarted;

};

} /* namespace profileMngr */

#endif /* IMAGEJOB_H_ */
