/*
 * jobCopyUser.cpp
 *
 *  Created on: 01.09.2017
 *      Author: bn81lr
 */

#include "core/jobs/copyUser.h"
#include "core/jobs/changeUser.h"
#include "core/profileApp.h"
#include "core/configInterface.h"

#include "core/profileTrace.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_APP
#include "trcGenProj/Header/copyUser.cpp.trc.h"
#endif

namespace profileMngr {

CopyUserJob::CopyUserJob(uintptr_t act,uint8_t source,uint8_t dest, uint32_t numClients,ProfileAppIF & IF,bool skipInit):Job(act, numClients),m_Source(source),m_Dest(dest),m_IF(IF)
{
	if(skipInit == true)
		m_State = PrepareforRecover;
	else
		m_State = Initializing;
	m_pChangeUser=0;
}

CopyUserJob::~CopyUserJob()
{
if (m_pChangeUser!=0)
	{delete m_pChangeUser;m_pChangeUser=0;}
}


void CopyUserJob::start()
{
	 m_IF.sendProfileStatus(psLoading);
	 m_IF.sendDataUpdate(dsPrepare);
}

bool CopyUserJob::doCopy()
{
	reset();
	if (m_IF.lockDP()==false)
		return false;
	if(m_IF.copyDPUser(m_Source,m_Dest))
	{
        // Copying the Attributes will be done after copy operation is successful.
		m_IF.sendCopyProfile(m_Source,m_Dest);
	}
	else
		return false;
	return true;
}

void CopyUserJob::sendCopy()
{
	m_IF.sendDataUpdate(dsChanged);
	m_IF.sendProfileID(m_Dest);
}

void CopyUserJob::finish()
{
	if (m_State!=Finished && m_Result==asSuccess)
		m_Result=asFailed;
	ETG_TRACE_COMP(("copyProfile::Finish %u",ETG_ENUM(TR_EN_ACTIONSTATE,m_Result)));

	m_IF.sendProfileStatus(psUnlocked);
	m_IF.sendDataUpdate(dsIdle);
	m_IF.sendCopyProfile(255,255);

	if (m_pChangeUser!=0 && m_pChangeUser->isFinished()==false)
		m_pChangeUser->finish();

	m_IF.getData().setOngoingProfileOperation(0,0,0);

	if (m_pRequester) m_pRequester->sendCopyProfileResult(m_Act,m_Result);
	m_pRequester=0;//make sure, result message is only sent once otherwise ASF reset
	m_IF.unlockDP();
}


void CopyUserJob::HandleTimerExpired()
{
	finish();
}

uint32_t CopyUserJob::getTimer()
{
	return m_TimerHandle;
	//TODO: Will enable the Separate timers for each SUb Job later
	//return ((m_State != ChangeUser)?(m_TimerHandle):(m_pChangeUser->getTimer()));
}

void CopyUserJob::setTimer(uint32_t Timer)
{
	m_TimerHandle = Timer;
	/* TODO: Will enable the Separate timers for each SUb Job later
	if(m_State != ChangeUser)
        m_TimerHandle = Timer;
	else
	    m_pChangeUser->setTimer(Timer);*/
}

bool CopyUserJob::stateFunction()
{
	bool bSuccess=true;
	switch (m_State)
	{
	case Initializing:
		if (configIF::getInst().isCopyProfileAllowed(m_IF.getData(),m_Source,m_Dest)==false)
		{
			m_Result=asDenied;
			ETG_TRACE_FATAL(("Profile Copy Denied"));
			finish();
			return false;
		}
		m_State=PrepareData;start();
		return true;
	case PrepareData:
		if (m_ClientsOpen != 0)
			return false;

		for (int k=0;k < m_NumClients;++k)
			if (m_aClientStatus[k]!= csuPrepareChange)
			{
				ETG_TRACE_FATAL(("Client %s failed",m_IF.getClientName(k).c_str()));
				bSuccess=false;
			}
		if (bSuccess)
		{
			ETG_TRACE_USR4(("setLastModeCopyUserStatus called"));
			m_IF.getData().setOngoingProfileOperation(m_Source,m_Dest,0);
			bSuccess=doCopy();
		}
		if (!bSuccess)
			{m_Result=asFailed;	finish();return false;}
		m_State=Copying;
		return true;
	case Copying:
		if (m_ClientsOpen != 0)
			return false;

		for (int k=0;k < m_NumClients;++k)
			if (m_aClientStatus[k]!= csuUserCopied)
			{
				ETG_TRACE_FATAL(("Client %s failed",m_IF.getClientName(k).c_str()));
				bSuccess=false;
			}
		if (bSuccess)
			{
				uint8_t current=m_IF.getData().currentProfile();
				uint8_t newUser=current;
				configIF::getInst().copyProfileCompletionStatus(m_Result,m_IF.getData(),m_Source,m_Dest,newUser);
				configIF::getInst().store();
				m_IF.getData().store();

				if (newUser!= current)
				{
					m_State=ChangeUser;
					m_IF.getData().setOngoingProfileOperation(m_Source,m_Dest,1);// mode ==1: Copying is done and we got the reset in the change user part.
					m_pChangeUser=new ChangeUserJob(0,newUser,current,m_NumClients,m_IF,false);
					while (m_pChangeUser->stateFunction()==true) ;
					/*TODO: Will enable the Separate timers for each SUb Job later*/

					if (m_pChangeUser->isFinished()==true)
						{m_State=Finished;finish();}
					return false;
				}
				else
					m_State=Finished;
			}
			else
			{   //reset the destination  to default
				m_State=PrepareforRecover;
				return true;
			}
			finish();
		return false;
	case PrepareforRecover:
		if(!resetDestination())
		   {
			  m_Result=asFailed;
		   }
		else
		   {
			   m_State=RecoverFromError;
			   return true;
		    }
		finish();
		return false;
	case RecoverFromError:
	     {
	    	 ETG_TRACE_COMP(("RecoverFromError"));
	    	 if (m_ClientsOpen!=0)
	    	 	return false;

	    	 for (int k=0;k < m_NumClients;++k)
	    	 	if (m_aClientStatus[k]!= csuUserDeleted)
	    	 	{
	    	 		ETG_TRACE_FATAL(("Client %s failed",m_IF.getClientName(k).c_str()));
	    	 		bSuccess=false;
	    	 	}
  	 		   // here irrespective of the  bSucsess is true or false sending failed to HMI as it is just the
  	 		   // recovery from the error but copy process has already been failed by this time
	    	 	m_State=Finished;
	    	 	m_Result=asFailed;
	    	 	finish();

	    	 	return false; //end now
	    	 	break;
	     }
	case ChangeUser:
		do {} while (m_pChangeUser->stateFunction()==true) ;
		if (m_pChangeUser->isFinished())
			{
				if (m_pChangeUser->result()!=asSuccess)
					m_Result=m_pChangeUser->result();
				else
					m_State=Finished;
				finish();
			}
			return false;

	}
	return false;
}

bool CopyUserJob::resetDestination()
{
	reset();

	if (m_IF.lockDP()!=true)
		return false;
	if(m_IF.clearDPUser(m_Dest))
	{
		m_IF.unlockDP();
		profileData & data=m_IF.getData();
		configIF::getInst().doDefSet(m_IF.getData(),m_Dest);
		data.store();
		configIF::getInst().store();

     	m_IF.sendDeleteProfile(m_Dest);
	}
	else
		{m_Result=asFailed;m_IF.unlockDP();return false;}

	return true;
}


void CopyUserJob::updateStatus(ClientStatusUpdate &status,uint32_t clientID)
{
	switch (m_State)
		{
		case PrepareData:
			if (status == csuFailed || status == csuPrepareChange)
			setStatus(status,clientID);
			break;
		case Copying:
			if (status == csuFailed || status == csuUserCopied)
				setStatus(status,clientID);
			break;
		case ChangeUser:
			if (m_pChangeUser!=0)
				m_pChangeUser->updateStatus(status,clientID);
			break;
		case RecoverFromError:
			if (status == csuFailed||status == csuUserDeleted)   //need to check if delete need to be pass from Dbus
				setStatus(status,clientID);
		}
}


} /* namespace profileMngr */
