
#include "core/jobs/job.h"

namespace profileMngr {

class ProfileAppIF;

class ChangeUserJob:public Job
{
public:
	ChangeUserJob(uintptr_t act,uint8_t newUser, uint8_t oldUser,uint32_t numClients,ProfileAppIF & IF,bool bPrepareData=true);

	virtual ~ChangeUserJob(){};
	virtual void updateStatus(ClientStatusUpdate & status,uint32_t clientID);
	virtual void HandleTimerExpired();
	virtual uint32_t getTimer(){return m_TimerHandle;}
	virtual void setTimer(uint32_t Timer){m_TimerHandle = Timer; }
	uint8_t newUser(){return m_NewUser;}
	uint8_t oldUser(){return m_OldUser;}

	virtual bool stateFunction();
	virtual bool isFinished(){return m_State==Done || (m_State != Done && m_Result != asSuccess);}
	virtual void finish();
private:
	ProfileAppIF & m_IF;

	void sendPrepare();
	bool change(uint8_t userId);
	//bool changetoPrevld(); //in case of error
	uint8_t m_NewUser;
	uint8_t m_OldUser;
	enum ChUserState
	{
		Initializing,
		Preparing,
		skipPrepare,
		Changing,
		Done,
		RecoverFromError
	} m_State;
};

}
