#ifndef __CONFIG_IF_H
#define __CONFIG_IF_H

#include <vector>
#include "core/profileStatus.h"

#include <boost/smart_ptr/shared_ptr.hpp>

class ahl_tclBaseOneThreadApp;

namespace asf { namespace dbus {class DBusConnector;} namespace core {class ComponentContainer;} }

namespace profileMngr{
class ProfileApp;
class profileData;
class pluginService;

class configIF
{
public:
	virtual ~configIF();
	configIF():FailureTimeout(5000){}
	const std::vector<profileMngr::Client> & getExpectedClientList() const {return m_expectedClients;};
	static configIF & getInst();
	static const char * loadConfig(const char * File);


public: //pure virtual methods to override

	virtual void startASFClients(::boost::shared_ptr< asf::dbus::DBusConnector > & DBus,::boost::shared_ptr< asf::core::ComponentContainer > & App)=0;

	virtual bool Init(uint8_t & startUser)=0;
	virtual bool InitOnPowerMode(uint8_t & startUser)=0;
	virtual bool doDefSet(profileData & Data)=0;
	virtual bool doDefSet(profileData & Data, unsigned char ID)=0;

	//reset profile
	virtual bool deleteProfileData(profileData & Data,unsigned char ID)=0;

	//changeName in copy profile
	virtual bool doChangeName(profileData & Data,unsigned char ID,std::string & Name)=0;
	virtual bool doChangeImage(profileData & Data,unsigned char ID,unsigned char Idx)=0;
	virtual bool doCreateProfile(profileData & Data,unsigned char ID,const std::string & Name,unsigned char Idx)=0;

	//copy profile
	virtual bool isCopyProfileAllowed(profileData & Data,unsigned char srcID,unsigned char destID)=0;

	//isSetProfileNameAllowed
	virtual bool isSetProfileNameAllowed(profileData & Data,unsigned char userID,const std::string& profileName)=0;

	//isSetProfileImageAllowed
	virtual bool isSetProfileImageAllowed(profileData & Data,unsigned char userID)=0;

	//isDeleteProfileAllowed
	virtual bool isDeleteProfileAllowed(profileData & Data,unsigned char userID)=0;

	//isCreateProfileAllowed
	virtual bool isCreateProfileAllowed(profileData & Data,const std::string& name, unsigned char &userID)=0;

	//Switch profile
	virtual bool isProfileChangeAllowed(unsigned char profileIDX,unsigned char activeUser)=0;

	virtual bool isValetModeProfileChangeAllowed(profileData & Data,unsigned char &  userId)=0;

	//Maximum number of profiles
	virtual unsigned char maxProfiles()=0;

	//getDefaultProfile
	virtual bool getDefaultProfile(unsigned char & defaultUserId)=0;

	//Callback added for pivi
	//Change to profile
	virtual void changeToProfileCompetionStatus(actionState status, unsigned char oldUserID, unsigned char newUserID)=0;

	//copyProfile
	virtual void copyProfileCompletionStatus(actionState status,profileData & Data,unsigned char srcID, unsigned char destID, uint8_t & changeUser)=0;

	//Delete Profile
	virtual void deleteProfileCompletionStataus(actionState status, unsigned char userID, uint8_t & changeUser)=0;

	//create profile
	virtual void createProfileCompletionStatus(actionState status, unsigned char & newUserID)=0;

	//valet Mode
	virtual bool isSetValetModeAllowed(unsigned char & newUserId)=0;

	virtual void allClientsRegistered()=0;

	// Persistent Data handling
	virtual bool load()=0;
	virtual bool store()=0;

public:
	unsigned long FailureTimeout;
	std::vector<profileMngr::Client> m_expectedClients;
private:
	static configIF * m_pInstance;
	static char * m_LoadError;
	static void * m_hLib;
};


}
#endif
