/*
 * configInterface.cpp
 *
 *  Created on: 23.01.2017
 *      Author: bn81lr
 */

#include "configInterface.h"
#include <dlfcn.h>
#include <unistd.h>



const char * ConfigSym="getConfig";

namespace profileMngr {

configIF * configIF::m_pInstance=NULL;
char * configIF::m_LoadError=NULL;
void * configIF::m_hLib=NULL;

const char * errMsg="Error NULL Pointer received";


configIF & configIF::getInst()
{
	while (m_pInstance ==NULL)
		usleep(100);
	return *m_pInstance;
}
/* needs to be called before getInst()! getInst will block until this function returns **/
const char * configIF::loadConfig(const char* File)
    {
		static bool bLoading=false;
		void* (*get)(void);
    	dlerror();
    	m_hLib=dlopen(File,RTLD_LAZY | RTLD_GLOBAL);
    	m_LoadError=dlerror();
    	if (m_LoadError!=NULL)
			return m_LoadError;

        *(void**) (&get)= dlsym(m_hLib,ConfigSym);
        m_LoadError=dlerror();
        if (m_LoadError != NULL)
        	return m_LoadError;

        m_pInstance=(configIF*)(*get)();

        return (m_pInstance==NULL)? errMsg:NULL;
    }

configIF::~configIF()
{
	dlclose(m_hLib);
	m_hLib = NULL;
}

}

