/*
 * profileTrace.cpp
 *
 *  Created on: 26.09.2017
 *      Author: bn81lr
 */

#include "core/clientList.h"
#include "core/profileStatus.h"
#include "core/configInterface.h"

#include "core/profileTrace.h"
#include "core/profileApp.h"

namespace profileMngr
{

using namespace std;

clientList::clientList(ProfileAppIF & IF):m_IF(IF)
{
	const vector<Client> &cfgList=configIF::getInst().getExpectedClientList();
	for (vector<Client>::const_iterator ct=cfgList.begin();ct!= cfgList.end();++ct)
	{
		m_MissingClients.push_back(ct->getName());
	}
}

clientList::~clientList()
{
}

void clientList::filterBySPM(std::vector<std::string>& oProcesList)
{
	std::vector<std::string> ::iterator it;
	const vector<Client> &cfgList=configIF::getInst().getExpectedClientList();

	for (vector<string>::iterator mcl=m_MissingClients.begin();mcl!=m_MissingClients.end();++mcl)
	{
		int idx=mcl->find(':');
		if (idx==string::npos || idx >= mcl->size())
		{
			traceS(trInvalidClientName,0,mcl->c_str());
			continue;
		}
		string procName=mcl->substr(idx+1);
		for (it = oProcesList.begin(); it != oProcesList.end();it++)
		{
			if (procName==*it)
			{
				traceS(trRemovedClient,4,mcl->c_str());
				mcl=m_MissingClients.erase(mcl);
			}
		}
	}
}



bool clientList::systemIsUp()
{
	traceN(trSystemUP,4,m_MissingClients.size());
	return m_MissingClients.size()==0;
}

void clientList::onClientStarted(std::string& Name)
{
	for (vector<string>::iterator del=m_MissingClients.begin();del!= m_MissingClients.end();++del)
		if (Name.compare(*del)==0)
		{
			m_MissingClients.erase(del);
			return;
		}
}

bool clientList::isClientConfigured(std::string& Name)
{
	const vector<Client> &cfgList=configIF::getInst().getExpectedClientList();
	for (vector<Client>::const_iterator ci=cfgList.begin();ci!=cfgList.end();++ci)
		if (ci->getName().compare(Name)==0)
			return true;
	//trace command TR_PROFILE_CMD_DO_ADD_CLIENT
	for (std::vector<std::string>::iterator it=m_IF.getData().getStartClients().begin();it!= m_IF.getData().getStartClients().end();++it)
		if ( (*it) == Name )
			return true;
	return false;
}

} //namespace

bool profileMngr::clientList::onTraceCmd(uint16_t Cmd,	const unsigned char* pData)
{
	switch (Cmd)
	{
	case TR_PROFILEMANAGER_CMD_GET_CLIENT_LIST:
		for (vector<string>::iterator trc=m_MissingClients.begin();trc!= m_MissingClients.end();++trc)
				traceS(trMissingClient,0,trc->c_str());
		return true;
	case TR_PROFILEMANAGER_TST_REMOVE_CLIENT:
		for (int trc=0;trc < m_MissingClients.size();++trc)
		for (vector<string>::iterator trc=m_MissingClients.begin();trc!= m_MissingClients.end();++trc)
			if (trc->compare(reinterpret_cast<const char*>(pData))==0)
			{
				traceS(trMissingClient,0,trc->c_str());
				trc=m_MissingClients.erase(trc);
				return true;
			}
	}
	return false;
}
