#include "ServiceProfileMngrSysSettings.h"

#include "core/profileApp.h"
#include <sstream>

#include "asfComp/app/core/ProfileMngrComp.h"

namespace app { namespace core {

using namespace::asf::core;
using namespace::asf::stream;

using namespace profileMngr;

DEFINE_CLASS_LOGGER_AND_LEVEL("app/core/ServiceProfileMngrSysSettings", ServiceProfileMngrSysSettings, Info);

const std::string resetFactoryTypeHMI = "DIA_SYSSET_TYPE_HMI";
const std::string resetFactoryTypeProduction = "DIA_SYSSET_TYPE_PRODUCTION";
const std::string resetFactoryTypeUserProfile= "DIA_SYSSET_TYPE_USER_PROFILE";

ServiceProfileMngrSysSettings::ServiceProfileMngrSysSettings() : SystemSettings1Stub("profileMngrSysSettingsPort")
{

}


ServiceProfileMngrSysSettings::~ServiceProfileMngrSysSettings()
{

}

void ServiceProfileMngrSysSettings::onPrepareSystemSettingRequest(const ::boost::shared_ptr< PrepareSystemSettingRequest >& request)
{
   PrepareSystemSettingRequest ObjPrepareSystemSettingRequest = *request;
   std::vector< PrepareSystemSettingResponseExtendedDataStruct > extendedData;
   sendPrepareSystemSettingResponse(ObjPrepareSystemSettingRequest.getSysSetID(), ObjPrepareSystemSettingRequest.getSysSetType(), extendedData , 0, ObjPrepareSystemSettingRequest.getCookie());
   ObjPrepareSystemSettingRequest.clear();
}

void ServiceProfileMngrSysSettings::onExecuteSystemSettingRequest(const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request)
{
	const std::string SysSetType = request->getSysSetType();

    if (SysSetType.compare(resetFactoryTypeHMI)==0 || SysSetType.compare(resetFactoryTypeProduction)==0 || SysSetType.compare(resetFactoryTypeUserProfile)==0 )
    {
    	profileMngr::ProfileApp::getInst().doDefSet(ProfileApp::dsExecute);
    }

    ExecuteSystemSettingRequest ObjExecuteSystemSettingRequest = *request;
    std::vector< ExecuteSystemSettingResponseExtendedDataStruct > extendedData;
    sendExecuteSystemSettingResponse(ObjExecuteSystemSettingRequest.getSysSetID(), ObjExecuteSystemSettingRequest.getSysSetType(), extendedData , 0 , ObjExecuteSystemSettingRequest.getCookie());
    ObjExecuteSystemSettingRequest.clear();
}

void ServiceProfileMngrSysSettings::onFinalizeSystemSettingRequest(const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request)
{
	const std::string SysSetType = request->getSysSetType();
	if (SysSetType.compare(resetFactoryTypeHMI)==0 || SysSetType.compare(resetFactoryTypeProduction)==0 || SysSetType.compare(resetFactoryTypeUserProfile)==0 )
	{
	    	profileMngr::ProfileApp::getInst().doDefSet(ProfileApp::dsFinalize);
	}

	FinalizeSystemSettingRequest ObjFinalizeSystemSettingRequest = *request;



	std::vector< FinalizeSystemSettingResponseExtendedDataStruct > extendedData;
    sendFinalizeSystemSettingResponse(ObjFinalizeSystemSettingRequest.getSysSetID(), ObjFinalizeSystemSettingRequest.getSysSetType(), extendedData , 0, ObjFinalizeSystemSettingRequest.getCookie());
    ObjFinalizeSystemSettingRequest.clear();
}

} }//namespace
