#ifndef _PM_SERVERPROFILEMNGRDBUS_H
#define _PM_SERVERPROFILEMNGRDBUS_H

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"

#include "bosch/cm/profileStub.h"

#include "asf/stream/MemoryStream.h"
#include "core/profileStatus.h"

#include "core/profileData.h"
#include <string.h>

namespace profileMngr { class ProfileAppIF ;class profileData;}

namespace app { namespace core {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace bosch::cm::profile;
    using namespace::asf::core;


    class ServerProfileMngrDBUS : private ProfileStub, public profileMngr::commInterface
   {
    private:
        DECLARE_CLASS_LOGGER();

    public:
        ServerProfileMngrDBUS(profileMngr::ProfileAppIF & IF);
        virtual ~ServerProfileMngrDBUS();

    public:// commInterface
        	virtual void sendCopyProfile(unsigned char Source,unsigned char Dest);
        	virtual void sendDeleteProfile(unsigned char User);
        	virtual void sendDataUpdate(profileMngr::dataChangeStatus state);
        	virtual void sendCreateProfile(unsigned char User);
        	virtual void updatePinRequested();

            virtual void updateProfileStatus();
            virtual void updateProfileID();
            virtual void updateProfileImage();
        	virtual void updateProfileName( );
            virtual void updatePrivacyMode();

            virtual void updateActiveProfileType();

        	virtual void sendChangeProfileResult(uintptr_t,profileMngr::actionState result);
        	virtual void senddoImportImageResult(uintptr_t,profileMngr::actionState result);
        	virtual void sendDeleteProfileResult(uintptr_t,profileMngr::actionState result);
        	virtual void sendCopyProfileResult(uintptr_t,profileMngr::actionState result);
            virtual void sendCreateProfileResult(uintptr_t,profileMngr::actionState result);
            virtual void sendRemoveUserImageResult(uintptr_t,profileMngr::actionState result);
            virtual void sendSetValetModeResult(uintptr_t,profileMngr::actionState result);


        	virtual profileMngr::enInterfaceID getInterface();

public: //profilemanager common DBUS interfaces
       	virtual void onDoRegisterAppRequest (const ::boost::shared_ptr< DoRegisterAppRequest >& request);

       	virtual void onOnDataChangedRequest (const ::boost::shared_ptr< OnDataChangedRequest >& request);

       	virtual void onOnProfileDeletedRequest (const ::boost::shared_ptr< OnProfileDeletedRequest >& request);


       	virtual void onOnProfileCopiedRequest (const ::boost::shared_ptr< OnProfileCopiedRequest >& request);

       	virtual void onOnProfileCreatedRequest (const ::boost::shared_ptr< OnProfileCreatedRequest >& request);

    	virtual void onDoDeleteProfileRequest (const ::boost::shared_ptr< DoDeleteProfileRequest >& request);

    	virtual void onDoChangeToProfileRequest (const ::boost::shared_ptr< DoChangeToProfileRequest >& request);

    	virtual void onDoCopyProfileRequest (const ::boost::shared_ptr< DoCopyProfileRequest >& request) ;

    	virtual void onDoCreateProfileRequest (const ::boost::shared_ptr< DoCreateProfileRequest >& request);

    	virtual void onPrivacyModeSet(const ::boost::shared_ptr< PrivacyModeSet >& payload);
    	virtual void onMaxPINAttemptsSet(const ::boost::shared_ptr< MaxPINAttemptsSet >& payload);
    	virtual void onMaxPINAttemptsBeforeDelaySet(const ::boost::shared_ptr< MaxPINAttemptsBeforeDelaySet >& payload);
    	virtual void onPinAuthenticationDelayTimeSet(const ::boost::shared_ptr< PinAuthenticationDelayTimeSet >& payload);
    	virtual void onPinVerificationValidityTimeSet(const ::boost::shared_ptr< PinVerificationValidityTimeSet >& payload);
public: //Profile Manager DBUS only interfaces

    	virtual void onDoImportProfileImageRequest (const ::boost::shared_ptr< DoImportProfileImageRequest >& request);
    	virtual void onRemoveUserImageRequest (const ::boost::shared_ptr< RemoveUserImageRequest >& request);

        virtual void onGetProfileNamesRequest (const ::boost::shared_ptr< GetProfileNamesRequest >& request);

        virtual void onGetProfileImagesRequest (const ::boost::shared_ptr< GetProfileImagesRequest >& request);
        virtual void onGetProfileTypesRequest (const ::boost::shared_ptr< GetProfileTypesRequest >& request);

        //New Interfaces added as per pivi
      	virtual void onDo_SetProfileNameRequest (const ::boost::shared_ptr< Do_SetProfileNameRequest >& request);
        virtual void onDoSetProfileImageRequest (const ::boost::shared_ptr< DoSetProfileImageRequest  >& request) ;

        virtual void onSetProfilePinRequest(const boost::shared_ptr<bosch::cm::profile::SetProfilePinRequest>&);
        virtual void onSetRememberMeRequest(const boost::shared_ptr<bosch::cm::profile::SetRememberMeRequest>&);
        virtual void onCheckPinRequest(const boost::shared_ptr<bosch::cm::profile::CheckPinRequest>&);
        virtual void onUnProtectProfileRequest(const boost::shared_ptr<bosch::cm::profile::UnProtectProfileRequest>&);

        virtual void onLinkProfileRequest (const ::boost::shared_ptr< LinkProfileRequest >& request);
        virtual void onSetValetModeRequest (const ::boost::shared_ptr< SetValetModeRequest >& request);



public: //Attribute Update

        virtual void getActiveProfile(uint8 &iActiveProfile)
        {
        	iActiveProfile=ProfileStub::getActiveProfile();
        }
        virtual void getProfileName(std::string& iProfileName)
        {
        	iProfileName=ProfileStub::getProfileName();
        }
        virtual void getProfileImage(uint8 &iprofileImage)
        {
        	iprofileImage=ProfileStub::getProfileImage();
        }
        virtual void getStatus(ProfileStatus &iProfileStatus)
        {
        	iProfileStatus=ProfileStub::getStatus();
        }

private:
        serverResult mapAsResult(profileMngr::actionState result);
        void mapProfileTypes(const std::vector<profileMngr::enUserStatus> & userProfileType, std::vector<profileType> & profileTypeList);
    	static unsigned int m_NextAppID;
    	profileMngr::profileData & m_Data;
    };

}} // namespace org { namespace bosch { namespace cm { namespace pm {

#endif // ifndef _PM_SERVERPROFILEMNGRDBUS_H

