/*****************************************************************************
* FILE:         ServiceProfileMngrCCA.h
* PROJECT:      G3G project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef __ServiceProfileMngrCCA_H_
#define __ServiceProfileMngrCCA_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
class fi_tclMessageBase;

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"


#include "core/profileStatus.h"
namespace profileMngr{class profileData;}
using namespace profileMngr;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class ServiceProfileMngrCCA : public ahl_tclBaseOneThreadService,public profileMngr::commInterface
{
protected:
   class MethodResultManager
   {
   public:
      MethodResultManager():_bPending(false),_u16SourceAppID(0),_u16RegisterID(0),_u16CmdCounter(0),_u16FctID(0)
      { };
      ~MethodResultManager(){};

      MethodResultManager(amt_tclServiceData *pMsg): _bPending(true)
      {
    	  _u16SourceAppID=pMsg->u16GetSourceAppID();
    	  _u16RegisterID=pMsg->u16GetRegisterID();
    	  _u16CmdCounter=pMsg->u16GetCmdCounter();
    	  _u16FctID=pMsg->u16GetFunctionID();
      }
      void Memorize(tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID)
      {
         _bPending = true;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      bool createMessage(amt_tclServiceData & Message,unsigned char OpCode);
      bool isPending(){return _bPending;};
   public:
      bool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:
   ServiceProfileMngrCCA(ahl_tclBaseOneThreadApp * pMainApp,profileData & Data);
   virtual ~ServiceProfileMngrCCA();
/***************************************************************************
* Overriding ahl_tclBaseOneThreadClientHandler methods.
***************************************************************************/
   virtual void vOnServiceAvailable();
   virtual void vOnServiceUnavailable();
   
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId,amt_tclServiceData& roOutMsg,amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,tBool& bPropertyChanged,tU16& u16Error);
public:
/***************************************************************************
* commInterface Methods.
***************************************************************************/
	virtual void sendCopyProfile(unsigned char Source,unsigned char Dest);
	virtual void sendDeleteProfile(unsigned char User);
	virtual void sendDataUpdate(dataChangeStatus state);
	virtual void sendCreateProfile(unsigned char userID);

	virtual void updatePinRequested(){;}
	virtual void updateProfileStatus();
	virtual void updateProfileID();
	virtual void updateProfileImage(){;};
	virtual void updateProfileName(){;};
	virtual void updatePrivacyMode();
	virtual void updateActiveProfileType();

public:
	virtual void sendDeleteProfileResult(actionState result);
	virtual void sendChangeProfileResult(uintptr_t act,actionState result);
	virtual void senddoImportImageResult(uintptr_t act,actionState result){};
	virtual void sendCopyProfileResult(uintptr_t act,actionState result);
	virtual void sendDeleteProfileResult(uintptr_t act,actionState result){};
	virtual void sendCreateProfileResult(uintptr_t act,actionState result);
	virtual void sendRemoveUserImageResult(uintptr_t act,actionState result){};
	virtual void sendSetValetModeResult(uintptr_t act,actionState result){};

	virtual enInterfaceID getInterface(){return iidCCA;};
/***************************************************************************
* cca MEthod Handler Methods.
***************************************************************************/
	   void handleOnDoChangeToProfile(amt_tclServiceData* poMessage);
   void HandleCreateProfile(amt_tclServiceData* poMessage);

	   void HandleRegisterClient(amt_tclServiceData* poMessage);

	   void HandleonDataChange(amt_tclServiceData* poMessage);
	   void HandleonProfileCopied(amt_tclServiceData* poMessage);
	   void HandleonProfileDeleted(amt_tclServiceData* poMessage);
	   void HandleonProfileCreated(amt_tclServiceData* poMessage);

	   void HandleonDoCopyProfile(amt_tclServiceData* poMessage);
	   void HandleonDoDeleteProfile(amt_tclServiceData* poMessage);
	   void HandleActiveProfile(amt_tclServiceData* poMessage);
	   void HandleStatus(amt_tclServiceData* poMessage);
	   void HandleCopyProfileRequest(amt_tclServiceData* poMessage);
	   void HandleDeleteProfileRequest(amt_tclServiceData* poMessage);
	   void HandleDataChangeRequest(amt_tclServiceData* poMessage);
	   void vHandleTraceMessage(uint16_t Command,const tUChar* puchData);
	   struct ccaClientNameList
	   {
	      unsigned int  _clientAppId;
	      std::string _clientName;
	   } typedef clientNameIdList;
protected:
	   virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);
private:
   void sendChangeProfileResult(actionState result,MethodResultManager & Info);
   void sendCopyProfileResult(actionState result,MethodResultManager & Info);
   void sendDeleteProfileResult(actionState result,MethodResultManager & Info);
   void sendCreateProfileResult(actionState result,MethodResultManager & Info);
   tBool bSendCCaMsg(fi_tclMessageBase& otclObj, tU32 u32FctId, tU32 u32MsgOpCode);
   std::string getCcaClientName (unsigned int id);
   ServiceProfileMngrCCA(tVoid);
   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
   * 'pm_tclServiceProfileMngrCCA' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   ServiceProfileMngrCCA& operator = (const ServiceProfileMngrCCA &oClientHandler);
private:
   profileData & m_Data;
   // Add status information properties.
   std::map<tU32,tU32> m_AppIDTable;
   unsigned char m_CopyProfile_Source;
   unsigned char m_CopyProfile_Dest;
   unsigned char m_deleteProfile_ID;
   unsigned char m_createProfile_ID;
   dataChangeStatus m_DataChanged;
   MethodResultManager m_CurrentAction;
   DECLARE_MSG_MAP(ServiceProfileMngrCCA);

};

#endif // __pm_ServiceProfileMngrCCA_H_


