
/*****************************************************************************
* FILE:         ServiceProfileMngrCCA.cpp
* PROJECT:      G3G project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

//Include FI interface of used service
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_STDVISITORS
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_FUNCTIONIDS
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_SERVICEINFO
#include "profile_fi_if.h"

#include <core/profileApp.h>
#include <core/profileTrace.h>
#include <sstream>
#include <iomanip>

#include "asfComp/app/core/ProfileMngrComp.h"

#include "ServiceProfileMngrCCA.h"



#include "core/profileTrace.h"

#define CCA_SOURCE_ID(x) (x->u16GetSourceAppID() | x->u16GetSourceSubID() << 16)
#define CCA_DEST_ID(x) (x->u16GetDestAppID()  | x->u16GetDestSubID() << 16)

BEGIN_MSG_MAP(ServiceProfileMngrCCA, ahl_tclBaseWork)
ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_DOCHANGETOPROFILE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, handleOnDoChangeToProfile)
ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_DOCOPYPROFILE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, HandleonDoCopyProfile)
ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_DODELETEPROFILE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART,HandleonDoDeleteProfile )
ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_DOCREATEPROFILE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, HandleCreateProfile)
ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_ONDATACHANGED, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, HandleonDataChange)
ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_ONPROFILECOPIED, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, HandleonProfileCopied)
ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_ONPROFILEDELETED, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, HandleonProfileDeleted)
ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_ONPROFILECREATED, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, HandleonProfileCreated)
ON_MESSAGE_SVCDATA(PROFILE_MAINFI_C_U16_REGISTERCLIENT, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, HandleRegisterClient)
END_MSG_MAP()

using namespace profileMngr;

//Default name Array
static const ServiceProfileMngrCCA::clientNameIdList aCcaClientNameIdLst[] =
{
	#define CCACLIENT_NAME_MAP(clientId, ccaClientName )  { clientId,ccaClientName },
	#include "CCAClients.dat"
	#undef CCACLIENT_NAME_MAP
};
/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

ServiceProfileMngrCCA::ServiceProfileMngrCCA(ahl_tclBaseOneThreadApp * poMainAppl,profileData & Data) :
ahl_tclBaseOneThreadService(poMainAppl, CCA_C_U16_SRV_USERMANAGER, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION, PROFILE_MAINFI_C_U16_SERVICE_MINORVERSION )
,m_Data(Data)
{
	m_CopyProfile_Source=0;
	m_CopyProfile_Dest=0;
	m_deleteProfile_ID=0;
	m_DataChanged=dsIdle;
	m_createProfile_ID = 0;
	profileMngr::ProfileApp::getInst().AddInterface(this);
}

ServiceProfileMngrCCA::~ServiceProfileMngrCCA(tVoid)
{
}


/*******************************************************************************
* FUNCTION: tVoid ServiceProfileMngrCCA::vOnServiceAvailable()
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
****************************************************************************/
tVoid ServiceProfileMngrCCA::vOnServiceAvailable()
{
}

/*******************************************************************************
* FUNCTION: tVoid ServiceProfileMngrCCA::vOnServiceUnavailable()
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*******************************************************************************/
tVoid ServiceProfileMngrCCA::vOnServiceUnavailable()
{

}

/*******************************************************************************
* FUNCTION: tBool ServiceProfileMngrCCA::bStatusMessageFactory(tU16 u16FunctionId,amt_tclServiceData& roOutMsg,amt_tclServiceData* poInMsg)*
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*******************************************************************************/
tBool ServiceProfileMngrCCA::bStatusMessageFactory(tU16 u16FunctionId,amt_tclServiceData& roOutMsg,amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   traceN(tcCCAMsgFactoryCall,4,u16FunctionId);

   switch (u16FunctionId)
   {
   case PROFILE_MAINFI_C_U16_ACTIVEPROFILE:
      {
         profile_mainfi_tclMsgactiveProfileStatus oStatus;

         oStatus.ID = m_Data.currentProfile();
         fi_tclVisitorMessage oVisitor(oStatus, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION);
         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case PROFILE_MAINFI_C_U16_STATUS:
      {
         profile_mainfi_tclMsgstatusStatus oStatus;
         switch (m_Data.getAppState())
         {
         	 case psUnlocked:oStatus.status.enType=profile_fi_tcl_e8_profileStatus::FI_EN_UNLOCKED;break;
         	 case psLocked:oStatus.status.enType=profile_fi_tcl_e8_profileStatus::FI_EN_LOCKED;break;
         	 case psLoading:oStatus.status.enType=profile_fi_tcl_e8_profileStatus::FI_EN_LOADING;break;
         	 case psInitalize:oStatus.status.enType=profile_fi_tcl_e8_profileStatus::FI_EN_INITIALIZING;break;
         }
         fi_tclVisitorMessage oVisitor(oStatus, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION);
         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case PROFILE_MAINFI_C_U16_COPYPROFILE:
      {
         profile_mainfi_tclMsgcopyProfileStatus oStatus;

         oStatus.sourceID = m_CopyProfile_Source;
         oStatus.destinationID = m_CopyProfile_Dest;
         fi_tclVisitorMessage oVisitor(oStatus, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION);
         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case PROFILE_MAINFI_C_U16_DELETEPROFILE:
      {
         profile_mainfi_tclMsgdeleteProfileStatus oStatus;

         oStatus.ProfileID = m_deleteProfile_ID;
         fi_tclVisitorMessage oVisitor(oStatus, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION);
         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case PROFILE_MAINFI_C_U16_DATACHANGED:
      {
         profile_mainfi_tclMsgdataChangedStatus oStatus;
         switch (m_DataChanged)
         {
         case dsIdle:oStatus.reason.enType= profile_fi_tcl_e8_changeProfile::FI_EN_IDLE;;break;
         case dsPrepare:oStatus.reason.enType= profile_fi_tcl_e8_changeProfile::FI_EN_PREPARE;break;
         case dsChanged:oStatus.reason.enType= profile_fi_tcl_e8_changeProfile::FI_EN_PROFILECHANGED;break;
         case dsProfileReset:oStatus.reason.enType= profile_fi_tcl_e8_changeProfile::FI_EN_PROFILERESET;break;
         //FI_EN_PROFILERESET;break
         }

         fi_tclVisitorMessage oVisitor(oStatus, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION);
         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case PROFILE_MAINFI_C_U16_CREATEPROFILE:
      {
	     profile_mainfi_tclMsgcreateProfileStatus oStatus;
         oStatus.ID = m_createProfile_ID;
         fi_tclVisitorMessage oVisitor(oStatus, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION);
         bSuccess = oVisitor.bHandOver(&roOutMsg);
         oStatus.vDestroy();
      }
      break;
   case PROFILE_MAINFI_C_U16_PRIVACYSTATUS:
   {
	   profile_mainfi_tclMsgprivacyStatusStatus oMode;

	   	   oMode.Privacy = m_Data.getPrivacyMode();
	   	   fi_tclVisitorMessage oVisitor(oMode, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION);
	   	   bSuccess = oVisitor.bHandOver(&roOutMsg);

	   	   oMode.vDestroy();
   }
   break;
   default:
	  break;
   }

   if (!bSuccess)
   {
	  traceN(tcCCAMsgFactoryError,0,0);
   }
   return bSuccess;
}


/*******************************************************************************
* FUNCTION: tBool ServiceProfileMngrCCA::bProcessSet(amt_tclServiceData* poMessage,tBool& bPropertyChanged,tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*******************************************************************************/
tBool ServiceProfileMngrCCA::bProcessSet(amt_tclServiceData* poMessage,tBool& bPropertyChanged,tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.


   return false;
}

tVoid ServiceProfileMngrCCA::updateProfileID()
{
   eUpdateClients(PROFILE_MAINFI_C_U16_ACTIVEPROFILE);
}
tVoid ServiceProfileMngrCCA::updateProfileStatus()
{

   eUpdateClients(PROFILE_MAINFI_C_U16_STATUS);
}
tVoid ServiceProfileMngrCCA::sendCopyProfile(unsigned char sourceUserID, unsigned char destinationUserID)
{
   m_CopyProfile_Source = sourceUserID;
   m_CopyProfile_Dest = destinationUserID;
   eUpdateClients(PROFILE_MAINFI_C_U16_COPYPROFILE);
}
tVoid ServiceProfileMngrCCA::sendDeleteProfile(unsigned char userID)
{
   m_deleteProfile_ID = userID;
   eUpdateClients(PROFILE_MAINFI_C_U16_DELETEPROFILE);
}
void ServiceProfileMngrCCA::sendDataUpdate(dataChangeStatus state)
{
   m_DataChanged=state;
   eUpdateClients(PROFILE_MAINFI_C_U16_DATACHANGED);
}
tVoid ServiceProfileMngrCCA::sendCreateProfile(unsigned char userID)
{
   m_createProfile_ID = userID;
   eUpdateClients(PROFILE_MAINFI_C_U16_CREATEPROFILE);
}

void ServiceProfileMngrCCA::updatePrivacyMode()
{
	eUpdateClients(PROFILE_MAINFI_C_U16_PRIVACYSTATUS);
}
void ServiceProfileMngrCCA::updateActiveProfileType()
{

}

std::string ServiceProfileMngrCCA:: getCcaClientName (unsigned int id)
{
	std::string clientname;
	//Initialize  Vector with default array
	const int mapSize = sizeof(aCcaClientNameIdLst)/sizeof(clientNameIdList);

    for (int i=0;i<mapSize;i++)
    {
         if (aCcaClientNameIdLst[i]._clientAppId == id)
         {
        	 clientname=aCcaClientNameIdLst[i]._clientName;
        	 break;
         }
    }
	return clientname;
}

tVoid ServiceProfileMngrCCA::HandleCreateProfile(amt_tclServiceData* poMessage)
{
   if (poMessage != NULL)
   {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART )
      {
         fi_tclVisitorMessage            oInMsg( poMessage );
         profile_mainfi_tclMsgdoCreateProfileMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
         {
         	m_CurrentAction.Memorize(poMessage->u16GetSourceAppID(),poMessage->u16GetRegisterID(),poMessage->u16GetCmdCounter(),poMessage->u16GetFunctionID());
         	actionState res=profileMngr::ProfileApp::getInst().doCreateProfile(*this,0,oMStart.Name.szValue, oMStart.ImageID);

             if (res!=asSuccess) // in case action is not success, answer directly
             	sendCreateProfileResult(0,res);
             else // store caller info for later answer
             	;

         } else
        	 traceN(trCCAReceivedInvalidMsg,0,0);

         oMStart.vDestroy();
      }
   }
}
//******************************--------Client methods begin******************************************************
tVoid ServiceProfileMngrCCA::HandleRegisterClient(amt_tclServiceData* poMessage)
{
	if (poMessage != NULL && poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART )
	{
		fi_tclVisitorMessage            oInMsg( poMessage );
		profile_mainfi_tclMsgRegisterClientMethodStart  oMStart;

		if (oInMsg.s32GetData(oMStart, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
		{
			unsigned int id=CCA_SOURCE_ID(poMessage);
			std::string clientName = getCcaClientName(id);
			uint32_t Cid=ProfileApp::getInst().onNewClient(clientName);

			m_AppIDTable[id]=Cid;


			profile_mainfi_tclMsgRegisterClientMethodResult oResult;
			oResult.bReloadData=m_Data.getStartupUserChange();
			MethodResultManager Info(poMessage);
			fi_tclVisitorMessage oOutMessage(oResult);
		      if (Info.createMessage(oOutMessage,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT))
		      {
		    	  ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);
		          if (enResult != AIL_EN_N_NO_ERROR)
		        	  traceN(trCCASendMsgFailed,0,oOutMessage.u16GetFunctionID());
		      }
		      oResult.vDestroy();

		} else
			traceN(trCCAReceivedInvalidMsg,0,poMessage->u16GetFunctionID());
		oMStart.vDestroy();
	}
	else
		traceN(trCCAReceivedInvalidMsg,0,0);
}

void ServiceProfileMngrCCA::HandleonDataChange(amt_tclServiceData* poMessage)
{
	if (poMessage != NULL && poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART )
	{
		fi_tclVisitorMessage            oInMsg( poMessage );
		profile_mainfi_tclMsgonDataChangedMethodStart  oStart;

		if (oInMsg.s32GetData(oStart, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
		{
			ClientStatusUpdate res=csuFailed;
			switch (oStart.result.enType)
			{
			case profile_fi_tcl_e8_DataChangedResponse::FI_EN_FAILED:res=csuFailed;break;
			case profile_fi_tcl_e8_DataChangedResponse::FI_EN_PROFILE_CHANGED:res=csuUserChanged;break;
			case profile_fi_tcl_e8_DataChangedResponse::FI_EN_PREPARED:res=csuPrepareChange;break;

			}
			ProfileApp::getInst().onClientStatus(m_AppIDTable[CCA_SOURCE_ID(poMessage)],res);

		} else
			traceN(trCCAReceivedInvalidMsg,0,poMessage->u16GetFunctionID());
		oStart.vDestroy();
	}
	else
		traceN(trCCAReceivedInvalidMsg,0,0);
}
void ServiceProfileMngrCCA::HandleonProfileCopied(amt_tclServiceData* poMessage)
{
	if (poMessage != NULL && poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART )
	{
		fi_tclVisitorMessage            oInMsg( poMessage );
		profile_mainfi_tclMsgonProfileCopiedMethodStart  oStart;

		if (oInMsg.s32GetData(oStart, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
		{
			ClientStatusUpdate res;
			switch (oStart.result.enType)
			{
			case profile_fi_tcl_e8_ClientResponse::FI_EN_FAILED:res=csuFailed;break;
			case profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS:res=csuUserCopied;break;
			}
			ProfileApp::getInst().onClientStatus(m_AppIDTable[(CCA_SOURCE_ID(poMessage))],res);
		} else
			traceN(trCCAReceivedInvalidMsg,0,poMessage->u16GetFunctionID());
		oStart.vDestroy();
	}
	else
		traceN(trCCAReceivedInvalidMsg,0,0);
}
void ServiceProfileMngrCCA::HandleonProfileDeleted(amt_tclServiceData* poMessage)
{
	if (poMessage != NULL && poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART )
	{
		fi_tclVisitorMessage            oInMsg( poMessage );
		profile_mainfi_tclMsgonProfileDeletedMethodStart  oStart;

		if (oInMsg.s32GetData(oStart, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
		{
			ClientStatusUpdate res;
			switch (oStart.result.enType)
			{
			case profile_fi_tcl_e8_ClientResponse::FI_EN_FAILED:res=csuFailed;break;
			case profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS:res=csuUserDeleted;break;
			}
			ProfileApp::getInst().onClientStatus(m_AppIDTable[(CCA_SOURCE_ID(poMessage))],res);
		} else
			traceN(trCCAReceivedInvalidMsg,0,poMessage->u16GetFunctionID());
		oStart.vDestroy();
	}
	else
		traceN(trCCAReceivedInvalidMsg,0,0);

}

void ServiceProfileMngrCCA::HandleonProfileCreated(amt_tclServiceData* poMessage)
{
	if (poMessage != NULL && poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART )
	{
		fi_tclVisitorMessage            oInMsg( poMessage );
		profile_mainfi_tclMsgonProfileCreatedMethodStart  oStart;

		if (oInMsg.s32GetData(oStart, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
		{
			ClientStatusUpdate res;
			switch (oStart.result.enType)
			{
			case profile_fi_tcl_e8_ClientResponse::FI_EN_FAILED:res=csuFailed;break;
			case profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS:res=csuUserCreated;break;
			}
			ProfileApp::getInst().onClientStatus(m_AppIDTable[(CCA_SOURCE_ID(poMessage))],res);
		} else
			traceN(trCCAReceivedInvalidMsg,0,poMessage->u16GetFunctionID());
		oStart.vDestroy();
	}
	else
		traceN(trCCAReceivedInvalidMsg,0,0);
}
//*****************************--------------client methods end*************************************************

tVoid ServiceProfileMngrCCA::handleOnDoChangeToProfile(amt_tclServiceData* poMessage)
{
   if (poMessage != NULL)
   {
	  if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART )
      {
         fi_tclVisitorMessage            oInMsg( poMessage );
         profile_mainfi_tclMsgdoChangeToProfileMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
         {
        	m_CurrentAction.Memorize(poMessage->u16GetSourceAppID(),poMessage->u16GetRegisterID(),poMessage->u16GetCmdCounter(),poMessage->u16GetFunctionID());
        	actionState res=profileMngr::ProfileApp::getInst().doSwitchToProfile(this,0,oMStart.newUserID);

            if (res!=asSuccess) // in case action is not success, answer directly
            	sendChangeProfileResult(0,res);
            else // store caller info for later answer
            	;

         } else
        	 traceN(trCCAReceivedInvalidMsg,0,poMessage->u16GetFunctionID());

         oMStart.vDestroy();
      }
   }
}


void ServiceProfileMngrCCA::HandleonDoCopyProfile(amt_tclServiceData* poMessage)
{
	   if (poMessage != NULL)
	   {
		  if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART )
	      {
	         fi_tclVisitorMessage            oInMsg( poMessage );
	         profile_mainfi_tclMsgdoCopyProfileMethodStart  oMStart;

	         if (oInMsg.s32GetData(oMStart, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
	         {
	        	 m_CurrentAction.Memorize(poMessage->u16GetSourceAppID(),poMessage->u16GetRegisterID(),poMessage->u16GetCmdCounter(),poMessage->u16GetFunctionID());
	        	 actionState res=profileMngr::ProfileApp::getInst().doCopyProfile(*this,0,oMStart.sourceID, oMStart.destinationID);

	            if (res!=asSuccess) // in case action is not success, answer directly
	            	sendCopyProfileResult(0,res);
	            else // store caller info for later answer
	            	;
	         } else
	        	 traceN(trCCAReceivedInvalidMsg,0,poMessage->u16GetFunctionID());

	         oMStart.vDestroy();
	      }
	   }
}

void ServiceProfileMngrCCA::HandleonDoDeleteProfile(amt_tclServiceData* poMessage)
{
	   if (poMessage != NULL)
	   {
		  if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART )
	      {
	         fi_tclVisitorMessage            oInMsg( poMessage );
	         profile_mainfi_tclMsgdoDeleteProfileMethodStart  oMStart;

	         if (oInMsg.s32GetData(oMStart, PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION) != OSAL_ERROR)
	         {
	        	 m_CurrentAction.Memorize(poMessage->u16GetSourceAppID(),poMessage->u16GetRegisterID(),poMessage->u16GetCmdCounter(),poMessage->u16GetFunctionID());
	        	 actionState res=profileMngr::ProfileApp::getInst().doDeleteProfile(*this,0,oMStart.UserID);

	            if (res!=asSuccess) // in case action is not success, answer directly
	            	sendDeleteProfileResult(res);
	            else // store caller info for later answer
	            	;
	         } else
	        	 traceN(trCCAReceivedInvalidMsg,0,poMessage->u16GetFunctionID());

	         oMStart.vDestroy();
	      }
	   }
}
void ServiceProfileMngrCCA::HandleActiveProfile(amt_tclServiceData* poMessage)
{

}

void ServiceProfileMngrCCA::HandleStatus(amt_tclServiceData* poMessage)
{

}


void ServiceProfileMngrCCA::HandleCopyProfileRequest(amt_tclServiceData* poMessage)
{

}
void ServiceProfileMngrCCA::HandleDeleteProfileRequest(amt_tclServiceData* poMessage)
{

}
void ServiceProfileMngrCCA::HandleDataChangeRequest(amt_tclServiceData* poMessage)
{

}



void ServiceProfileMngrCCA::sendChangeProfileResult(uintptr_t act,profileMngr::actionState status)
{
	sendChangeProfileResult(status,m_CurrentAction);
}

void ServiceProfileMngrCCA::sendChangeProfileResult(actionState result,MethodResultManager & Info)
{
   if (Info.isPending())
   {
	  profile_mainfi_tclMsgdoChangeToProfileMethodResult oMResult;

      profile_fi_tcl_e8_ChangeProfileResult fiStatus;
      switch (result)
      {
      case profileMngr::asFailed:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_FAILED;break;
      case profileMngr::asSuccess:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_SUCCESS;break;
      case profileMngr::asLocked:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_LOCKED;break;
      }
      oMResult.result = fiStatus;

      fi_tclVisitorMessage oOutMessage(oMResult);

      if (Info.createMessage(oOutMessage,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT))
      {
    	  ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

          if (enResult != AIL_EN_N_NO_ERROR)
        	  traceN(trCCASendMsgFailed,0,oOutMessage.u16GetFunctionID());
      }
      oMResult.vDestroy();
   }
   return;
}

void ServiceProfileMngrCCA::sendCreateProfileResult(uintptr_t act,profileMngr::actionState status)
{
	sendCreateProfileResult(status,m_CurrentAction);
}

void ServiceProfileMngrCCA::sendCreateProfileResult(actionState result,MethodResultManager & Info)
{
   if (Info.isPending())
   {
	  profile_mainfi_tclMsgdoCreateProfileMethodResult oMResult;

      profile_fi_tcl_e8_ChangeProfileResult fiStatus;
      switch (result)
      {
      case profileMngr::asFailed:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_FAILED;break;
      case profileMngr::asSuccess:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_SUCCESS;break;
      case profileMngr::asLocked:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_LOCKED;break;
      }
      oMResult.result = fiStatus;
      oMResult.UserID = ((result == profileMngr::asSuccess)?(m_createProfile_ID):0);

      fi_tclVisitorMessage oOutMessage(oMResult);

      if (Info.createMessage(oOutMessage,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT))
      {
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR)
    	  traceN(trCCASendMsgFailed,0,oOutMessage.u16GetFunctionID());
      }
      oMResult.vDestroy();
   }
   return;
}

void ServiceProfileMngrCCA::sendCopyProfileResult(uintptr_t act,profileMngr::actionState status)
{sendCopyProfileResult(status,m_CurrentAction);}

void ServiceProfileMngrCCA::sendCopyProfileResult(actionState result,MethodResultManager & Info)
{
   if (Info.isPending())
   {
	  profile_mainfi_tclMsgdoCopyProfileMethodResult oMResult;

      profile_fi_tcl_e8_ChangeProfileResult fiStatus;
      switch (result)
      {
      case profileMngr::asFailed:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_FAILED;break;
      case profileMngr::asSuccess:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_SUCCESS;break;
      case profileMngr::asLocked:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_LOCKED;break;
      }
      oMResult.result = fiStatus;

      fi_tclVisitorMessage oOutMessage(oMResult);

      if (Info.createMessage(oOutMessage,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT))
      {
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR)
    	  traceN(trCCASendMsgFailed,0,oOutMessage.u16GetFunctionID());
      }
      oMResult.vDestroy();
   }
   return;
}

void ServiceProfileMngrCCA::sendDeleteProfileResult(profileMngr::actionState status)
{sendDeleteProfileResult(status,m_CurrentAction);}

void ServiceProfileMngrCCA::sendDeleteProfileResult(actionState result,MethodResultManager & Info)
{
	if (Info.isPending())
   {
	  profile_mainfi_tclMsgdoDeleteProfileMethodResult oMResult;

      profile_fi_tcl_e8_ChangeProfileResult fiStatus;
      switch (result)
      {
      case profileMngr::asFailed:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_FAILED;break;
      case profileMngr::asSuccess:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_SUCCESS;break;
      case profileMngr::asLocked:	  fiStatus.enType= profile_fi_tcl_e8_ChangeProfileResult::FI_EN_LOCKED;break;
      }
      oMResult.result = fiStatus;

      fi_tclVisitorMessage oOutMessage(oMResult);

      if (Info.createMessage(oOutMessage,AMT_C_U8_CCAMSG_OPCODE_METHODRESULT))
      {
    	  ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

          if (enResult != AIL_EN_N_NO_ERROR)
        	  traceN(trCCASendMsgFailed,0,oOutMessage.u16GetFunctionID());
      }
      oMResult.vDestroy();
   }
   return;
}


void ServiceProfileMngrCCA::vHandleTraceMessage(uint16_t command,const tUChar* puchData)
{
	tU32 u32BufLen = puchData[0];
	tU32 u32Param1 = (u32BufLen > 2) ? puchData[3]:0;
	tU32 u32Param2 = (u32BufLen > 3) ? puchData[4]:0;
	switch(command)
	{
		case TR_PROFILEMANAGER_CMD_DO_SWITCH_TO_PROFILE:
		{
			profile_mainfi_tclMsgdoChangeToProfileMethodStart oChangeToProfileMethodStart;
			oChangeToProfileMethodStart.newUserID = u32Param1;
			bSendCCaMsg(oChangeToProfileMethodStart,PROFILE_MAINFI_C_U16_DOCHANGETOPROFILE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
			break;
		}

		case TR_PROFILEMANAGER_CMD_DO_DELETE_PROFILE:
		{
			profile_mainfi_tclMsgdoDeleteProfileMethodStart oDeleteProfileMethodStart;
			oDeleteProfileMethodStart.UserID = u32Param1;
			bSendCCaMsg(oDeleteProfileMethodStart,PROFILE_MAINFI_C_U16_DODELETEPROFILE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
			break;
		}
		case TR_PROFILEMANAGER_CMD_DO_COPY_PROFILE:
		{
			profile_mainfi_tclMsgdoCopyProfileMethodStart oCopyProfileMethodStart;
			oCopyProfileMethodStart.sourceID = u32Param1;
			oCopyProfileMethodStart.destinationID = u32Param2;
			bSendCCaMsg(oCopyProfileMethodStart,PROFILE_MAINFI_C_U16_DOCOPYPROFILE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
			break;
		}
		case TR_PROFILEMANAGER_CMD_DO_CREATE_PROFILE:
		{
			profile_mainfi_tclMsgdoCreateProfileMethodStart oCreateProfileMethodStart;
			oCreateProfileMethodStart.Name.bSet("NewProfile",profile_fi_tclString::FI_EN_UTF8);
			oCreateProfileMethodStart.ImageID = u32Param1;
			bSendCCaMsg(oCreateProfileMethodStart,PROFILE_MAINFI_C_U16_DOCREATEPROFILE,AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
			break;
		}
		case TR_PROFILEMANAGER_CMD_ON_DATA_CHANGED:
		{
			profile_mainfi_tclMsgonDataChangedMethodStart oOnDataChangedMethodStart;
			oOnDataChangedMethodStart.result.enType = (u32Param1)?(profile_fi_tcl_e8_DataChangedResponse::FI_EN_FAILED):(profile_fi_tcl_e8_DataChangedResponse::FI_EN_PROFILE_CHANGED);
			bSendCCaMsg(oOnDataChangedMethodStart,PROFILE_MAINFI_C_U16_ONDATACHANGED,AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
			break;
		}
		case TR_PROFILEMANAGER_CMD_ON_PROFILE_CREATED:
		{
			profile_mainfi_tclMsgonProfileCreatedMethodStart oOnProfileCreatedMethodStart;
			oOnProfileCreatedMethodStart.result.enType = (u32Param1)?(profile_fi_tcl_e8_ClientResponse::FI_EN_FAILED):(profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS);
			bSendCCaMsg(oOnProfileCreatedMethodStart,PROFILE_MAINFI_C_U16_ONPROFILECREATED,AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
			break;
		}
		case TR_PROFILEMANAGER_CMD_ON_PROFILE_COPIED:
		{
			profile_mainfi_tclMsgonProfileCopiedMethodStart oOnProfileCopiedMethodStart;
			oOnProfileCopiedMethodStart.result.enType = (u32Param1)?(profile_fi_tcl_e8_ClientResponse::FI_EN_FAILED):(profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS);
			bSendCCaMsg(oOnProfileCopiedMethodStart,PROFILE_MAINFI_C_U16_ONPROFILECOPIED,AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
			break;
		}


    default:
//        ETG_TRACE_FATAL(("pm_tclAppMain::vHandleTraceMessage(): unknown command %d.", command));
        break;
    }

}

tBool ServiceProfileMngrCCA::bSendCCaMsg(fi_tclMessageBase& otclObj, tU32 u32FctId, tU32 u32MsgOpCode)
{
	fi_tclVisitorMessage fi_obj(dynamic_cast<fi_tclTypeBase&>(otclObj),PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION);
	amt_tclServiceData oServiceData;
    if(true == fi_obj.bHandOver(&oServiceData))
    {
    	oServiceData.vInitServiceData(
    			CCA_C_U16_APP_UI,         // Source AppID
    			CCA_C_U16_APP_FC_USERMANAGER,         // Target AppID
                AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    // StreamType
				 0,                                   // StreamCounter
				  fi_obj.u16GetRegisterID(),                        // RegisterID
				  0,//fi_obj.u16GetCmdCounter(),                        // CmdCounter,
				  PROFILE_MAINFI_C_U16_SERVICE_ID,//fi_obj.u16GetServiceID() ,                        // ServiceID,
				  u32FctId,                        // Function ID
				  u32MsgOpCode                             // Opcode STATUS
				 );
        if(false == bDefaultSvcDataHandler(this, &oServiceData))
        {
        	traceN(trCCAReceivedInvalidMsg,0,0);
    		return FALSE;
        }
    }
    else
    {
    	traceN(trCCAReceivedInvalidMsg,0,0xFFFFFFFF);
    	return FALSE;
    }
    return TRUE;
}

bool ServiceProfileMngrCCA::MethodResultManager::createMessage(amt_tclServiceData & Message,unsigned char OpCode)
      {
    	  if (_bPending==false)
    		  return false;
    	  Message.vInitServiceData
    	  (
			  CCA_C_U16_APP_FC_USERMANAGER,         // Source AppID
			  _u16SourceAppID,                      // Target AppID
			  AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    // StreamType
			  0,                                    // StreamCounter
			  _u16RegisterID,                       // RegisterID
			  _u16CmdCounter,                       // CmdCounter
			  CCA_C_U16_SRV_USERMANAGER,            // ServiceID
			  _u16FctID,                            // Function ID
			  OpCode                                // Opcode STATUS
		  );

    	  _bPending=false;
    	  return true;
      }

tVoid ServiceProfileMngrCCA::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
{
	traceN(trServerState,4,u32AppState << 16 | u32OldAppState);//TODO for checking if the state is also used in A-IVI Project
	if (u32AppState==8 && u32OldAppState==3 )//TODO find enumeration for appstate value 8 & 3
	{
		ProfileApp::getInst().storeLogoffTime();
	}
	ahl_tclBaseOneThreadService::vOnNewAppState(u32OldAppState,u32AppState);
}

