
/*****************************************************************************
* FILE:         ProfileMngrSpmClient.cpp
* PROJECT:      G3G project
* SW-COMPONENT: profilemanager
*----------------------------------------------------------------------------
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

// Include SPM interface
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
#include "spm_fi_if.h"



#include "ProfileMngrSpmClient.h"
#include "core/profileTrace.h"
#include "core/configInterface.h"
#include "core/profileApp.h"
#include "CCAAppMain.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_PROFILEMANAGER_CCA
#include "trcGenProj/Header/ProfileMngrSpmClient.cpp.trc.h"
#endif



BEGIN_MSG_MAP (ProfileMngrSpmClient, ahl_tclBaseWork)
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_PROCESSLIST, AMT_C_U8_CCAMSG_OPCODE_STATUS, handleProcessListChangeUpdate)
ON_MESSAGE_SVCDATA(SPM_COREFI_C_U16_SYSPWRMODE, AMT_C_U8_CCAMSG_OPCODE_STATUS, handleSystemPowerModeChangeUpdate)

END_MSG_MAP ()
using namespace profileMngr;

ProfileMngrSpmClient::ProfileMngrSpmClient(CCAAppMain *MainApp):
                      m_App(MainApp)
                     ,ahl_tclBaseOneThreadClientHandler(MainApp ,CCA_C_U16_SRV_SPM, SPM_COREFI_C_U16_SERVICE_MAJORVERSION,SPM_COREFI_C_U16_SERVICE_MINORVERSION, CCA_C_U16_APP_SPM,1)
{
	vAddAutoRegisterForProperty(SPM_COREFI_C_U16_PROCESSLIST);
	vAddAutoRegisterForProperty(SPM_COREFI_C_U16_SYSPWRMODE);
	m_configuredProcessList.clear();
	m_coldStartActive = true;
	ETG_TRACE_USR4(("ProfileMngrSpmClient::ProfileMngrSpmClient(%i)",_u16ServiceID));
}

ProfileMngrSpmClient::~ProfileMngrSpmClient()
{
}


tVoid ProfileMngrSpmClient::handleSystemPowerModeChangeUpdate(amt_tclServiceData* poMessage)
{
	ETG_TRACE_USR4(("ProfileMngrSpmClient::handleSystemPowerModeChangeUpdate"));
	if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
	{
		fi_tclVisitorMessage  oInMsg(poMessage);
		spm_corefi_tclMsgSysPwrModeStatus  oStatus;
		if (oInMsg.s32GetData(oStatus) != OSAL_ERROR)
		{
			ETG_TRACE_USR4(("ProfileMngrSpmClient::handleSystemPowerModeChangeUpdate Mode:%d",oStatus.SysPwrMode.enType));
			if((oStatus.SysPwrMode.enType == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_ACCESSORY) ||
					(oStatus.SysPwrMode.enType == spm_fi_tcl_SPM_e32_SYSPWRMODE::FI_EN_SPM_U32_SYSPWRMODE_RUN))
			{
				if(m_coldStartActive)
				{
					m_coldStartActive = false;
				}
				else
				{
					profileMngr::ProfileApp::getInst().handleSysPwrModeTrigger();
				}
			}
		}
		oStatus.vDestroy();
	}
}
tVoid ProfileMngrSpmClient::handleProcessListChangeUpdate(amt_tclServiceData* poMessage)
{
	ETG_TRACE_COMP(("ProfileMngrSpmClient::handleProcessListChangeUpdate KAN"));
	if(!m_configuredProcessList.size())
	{
		if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS )
		{
			fi_tclVisitorMessage  oInMsg(poMessage);
			spm_corefi_tclMsgProcessListStatus  oStatus;

			if (oInMsg.s32GetData(oStatus) != OSAL_ERROR)
			{
				std::vector<spm_fi_tcl_ProcessElement, std::allocator<spm_fi_tcl_ProcessElement> > ::iterator it;
				for (it = oStatus.tProcesses.tProcesses.begin(); it != oStatus.tProcesses.tProcesses.end();it++)
				{
					tString processName = it->tConfiguredProcessName.szGet(spm_fi_tclString::FI_EN_UTF8);
					if (processName!=0)
					{
						if(it->eProcState.enType == spm_fi_tcl_e8_ProcessState::FI_EN_SPM_E8_PROCESSCONFIGUREDOUT)
						{
							m_configuredProcessList.push_back(processName);
							ETG_TRACE_USR4(("Process not started:'%s'",processName));
						}
						delete [] processName;
					}
				}
				profileMngr::ProfileApp::getInst().updateConfiguredProcessList(m_configuredProcessList);
			}
			else
			{
				ETG_TRACE_ERR(("Received message is invalid!"));
			}

			oStatus.vDestroy();
		}
	}
}


tVoid ProfileMngrSpmClient::vOnServiceAvailable()
{
	ETG_TRACE_USR1(("vOnServiceAvailable"));
	spm_corefi_tclMsgProcessListGet iget;
	fi_tclVisitorMessage oMsg(dynamic_cast<fi_tclTypeBase&>(iget) ,SPM_COREFI_C_U16_SERVICE_MAJORVERSION);

	oMsg.vInitServiceData(
			CCA_C_U16_APP_SPM                               // Source AppID
			,u16GetServerAppID()				     		        // Target AppID
			,AMT_C_U8_CCAMSG_STREAMTYPE_NODATA             // StreamType
			,0                                             // StreamCounter
			,u16GetRegID()								           // RegisterID
			,0                                 // CmdCounter,
			,_u16ServiceID                                   // ServiceID,
			,iget.u16GetFunctionID()                  // Function ID
			,iget.u8GetOpCode()		                 // Opcode
	);
	oMsg.vSetSourceSubID(1);

	bool bRetval;
	// Send message
	if (oMsg.bIsValid())
	{
		if (!(_poMainAppl->enPostMessage(&oMsg, TRUE, 7) != AIL_EN_N_NO_ERROR))
		{
			bRetval = TRUE;
		}
	}
}






///////////////////////////////////////////////////////////////////////////////
// <EOF>






