/*****************************************************************************
* FILE:         CCAAppMain.h
* PROJECT:      A-IVI project
* SW-COMPONENT: profile manager
*----------------------------------------------------------------------------
* DESCRIPTION:  
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/


#ifndef _PROFILEMANAGERMAIN_H_
#define _PROFILEMANAGERMAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_SET
#include "stl_pif.h"

#include <core/profileTrace.h>


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

typedef enum
	{
		IFUnknown,
		IFProfileCCA=1,
		IFProfileDBUS,
		IFProfileOnline
	} enIFID;

#define NULL_POINTER_CHECK(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return;\
   }

#define TRACE_BUFFER_MAXSIZE  250
#define PMINTERNAL_MSG_LEN    5       

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class CCAAppMain;
class ServiceProfileMngrCCA;
class ProfileMngrSpmClient;
namespace profileMngr {class ProfileAppIF;class profileData;}

class CCAAppMain : public ahl_tclBaseOneThreadApp
{

private:
   static CCAAppMain*   _poMainAppInstance;
   ServiceProfileMngrCCA * _pService;
   ProfileMngrSpmClient* _pClient;
public:
   CCAAppMain(profileMngr::ProfileAppIF & App);
   virtual ~CCAAppMain();



   /**************************************************************************
   * Overriding ahl_tclBaseOneThreadApp methods.
   **************************************************************************/
   virtual tBool bOnInit();
   virtual void vOnApplicationClose();
   virtual void vOnTimer(tU16 nTimerId);

   //using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual void vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   void vStart();

   //reference handling for __ created objects
private:
   /**************************************************************************
      * Assingment Operater, will not be implemented.
      * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
      * 'CCAAppMain' which has no assignment operator.
      * NOTE: This is a technique to disable the assignment operator for this
      * class. So if an attempt for the assignment is made compiler complains.
      **************************************************************************/
      CCAAppMain& operator= (const CCAAppMain &oApp);

      /**************************************************************************
      * Copy Constructor, will not be implemented.
      * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class
      * 'CCAAppMain' which has no copy constructor.
      * NOTE: This is a technique to disable the copy constructor for this
      * class. So if an attempt for the assignment is made compiler complains.
      **************************************************************************/
      CCAAppMain(const CCAAppMain &oApp);
      profileMngr::ProfileAppIF & m_App;
public:

   static void initCCA();

private:
   void vTracePlugIn();
   void vTraceUnplug();

   static void vTraceCallbackFunction(const tUChar* puchData);

   void vHandleTraceMessage(const tUChar* puchData);
   static tUChar _auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE];
}; 

#endif // _PROFILEMANAGERMAIN_H_

