/*****************************************************************************
* FILE:         CCAAppMain.cpp
* PROJECT:      A-IVI project
* SW-COMPONENT: profile manager
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/



#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "CCAAppMain.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"


#include "asfComp/cca/ServiceProfileMngrCCA.h"
#include "asfComp/cca/ProfileMngrSpmClient.h"
#include "core/profileApp.h"

#include "core/profileTrace.h"

CCAAppMain* CCAAppMain::_poMainAppInstance = NULL;
tUChar  CCAAppMain::_auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE] = {0};

/*******************************************************************************
*
* FUNCTION: CCAAppMain::CCAAppMain()
*
* DESCRIPTION: Constructor.
*
*              Initialize static self reference to be used in function
*              callbacks.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/

CCAAppMain::CCAAppMain(profileMngr::ProfileAppIF & App):ahl_tclBaseOneThreadApp(CCA_C_U16_APP_FC_USERMANAGER)
,_pService(NULL),_pClient(NULL)
,m_App(App)
{
   CCAAppMain::_poMainAppInstance   = this;
   vTracePlugIn();
}

/*******************************************************************************
*
* FUNCTION: CCAAppMain::~CCAAppMain()
*
* DESCRIPTION: Destructor.
*
*              Invalidate static self reference.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
CCAAppMain::~CCAAppMain()
{
   vTraceUnplug();
   CCAAppMain::_poMainAppInstance = NULL;
}

/*******************************************************************************
*
* FUNCTION: tBool CCAAppMain::bOnInit()
*
* DESCRIPTION: This function is called by the CCA framework before starting any
*              CCA message related communication action. As default this
*              function always returns TRUE. The user has to implement all his
*              local application initialization (create client and service
*              handler, create worker threads, allocate application memory,...).
*              If returns TRUE, initialization could be successfully performed
*              and framework will register application, else, a reset of the
*              system is forced immediately.
*
*              This function is the counterpart of vOnApplicationClose().
*
* PARAMETER: None.
*
* RETURNVALUE: TRUE  = Application successfully initialized.
*              FALSE = Application NOT successfully initialized.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
*******************************************************************************/
tBool CCAAppMain::bOnInit()
{
   tBool bSuccess = TRUE;
   traceN(trCCAbOnInit,4,0);
   _pService=new ServiceProfileMngrCCA(this,m_App.getData());
   _pClient=new ProfileMngrSpmClient(this);
   return bSuccess;
}

/*******************************************************************************
*
* FUNCTION: tVoid CCAAppMain::vOnApplicationClose()
*
* DESCRIPTION: This function is called by the CCA framework to indicate the
*              imminent shutdown of the application. The user has to implement
*              the de-initialization of all his local application data (destroy
*              client and service handler, destroy worker threads, free
*              application memory, ... ). After this function call the
*              destructor of this application will be called.
*
*              This function is the counterpart of bOnInit().
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
*******************************************************************************/
tVoid CCAAppMain::vOnApplicationClose()
{
   ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
*
* FUNCTION: tVoid CCAAppMain::vOnTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called by the CCA framework on the expiration
*              of a previously via function bStartTimer() started timer. The
*              expired timer is forwarded to the respective service or
*              client-handler via a call of vProcessTimer().
*
*              The function is called from this applications context and
*              therefore no interthread programming rules must be considered
*              and the application methods and/or member variables can be
*              accessed without using the static self reference
*              'm_poMainAppInstance'.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
*******************************************************************************/
tVoid CCAAppMain::vOnTimer(tU16 u16TimerId)
{

}

/*******************************************************************************
*
* FUNCTION: tVoid CCAAppMain::vOnLoopback
*                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called by the CCA framework if a message was
*              sent from one if this applications services or from a
*              callback-handler of this application (so called self or loopback
*              messages).
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*
*            [IN] poMessage = Message object.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
*******************************************************************************/
tVoid CCAAppMain::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage)
{
}

/*******************************************************************************
* FUNCTION   : CCAAppMain::vTracePlugIn
* DESCRIPTION: Activate the TTFIS command channel for profilemanager
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid CCAAppMain::vTracePlugIn(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;

   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_APPINFRA_USERMGMT;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)CCAAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &MyTraceChannel);
      if (s32Err == OSAL_OK) {
         //good
      } else {
    	  traceN(tcInitTraceFailed,0,s32Err);
      }
      // close trace device and clear channel
      OSAL_s32IOClose(desc);	
   }
}

/*******************************************************************************
* FUNCTION   : CCAAppMain::vTraceUnplug
* DESCRIPTION: Deactivate the TTFIS command channel for profilemanager
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid CCAAppMain::vTraceUnplug(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;
   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_APPINFRA_USERMGMT;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)CCAAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &MyTraceChannel);

      if (s32Err == OSAL_OK) {
         //good
      } else {/* not nede, to trace error on shutdown*/  }

      // close trace device and clear channel
      OSAL_s32IOClose(desc);	
   }
}

/*******************************************************************************
* FUNCTION   : CCAAppMain::vTraceCallbackFunction
* DESCRIPTION: Callback function for TTFIS command channel of __APP_NAME__
* PARAMETER  : [IN] puchData = buffer with trace input data
* RETURNVALUE: None
*******************************************************************************/
tVoid CCAAppMain::vTraceCallbackFunction(const tUChar* puchData)
{
	(tVoid)memcpy((tVoid*)_auchTraceInputBuffer, puchData, TRACE_BUFFER_MAXSIZE);

	_poMainAppInstance->vHandleTraceMessage(_auchTraceInputBuffer);
}

tVoid CCAAppMain::initCCA()
{
    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t)"/dev/root/opt/bosch/base/registry/procpm.reg")) != OSAL_OK)
        	traceN(trCCALoadRegitryFailed,0,0);
    }
    OSAL_s32IOClose(regHandle);
    amt_bInit();
	scd_init();
}

tVoid CCAAppMain::vHandleTraceMessage(const tUChar* puchData)
{
	if(puchData[0] < TRACE_BUFFER_MAXSIZE )
	{
		uint16_t MsgCode = (puchData[1] << 8) | (puchData[2]);
		if (ProfileApp::getInst().onTraceCmd(MsgCode,puchData)==false)
			_pService->vHandleTraceMessage(MsgCode,puchData);
	}
}
