/*!
*******************************************************************************
* \file               SmartProxy.h
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Header for smart proxy to perform traffic classification
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
22.09.2017 | rhk6kor                  | Initial Version
05.10.2017 | Deepa Jose(RBEI/ECO2)    | 1.0             | Smart proxy main file
\endverbatim
******************************************************************************/
#ifndef _SMARTPROXY_H_
#define _SMARTPROXY_H_

#include <glib.h>
#include <pthread.h>
#include "system_types.h"
#include "dbuscommmanager.h"

//DBUS CLIENT 
#define SP_CLIENT_XMLPATH             	(tString) 	"/var/opt/bosch/static/com.bosch.AutomotiveProxy.E2ENavigation.xml"
#define SP_CLIENT_BUSNAME             	(tCString) 	"com.bosch.AutomotiveProxy"
#define SP_CLIENT_OBJPATH             	(tCString) 	"/com/bosch/AutomotiveProxy/E2ENavigation"

//DBUS SERVER 
#define SP_SERVER_BUSNAME             	(tCString) 	"com.renault.ipcm.dbusmgr"
#define SP_SERVER_OBJPATH             	(tCString) 	"/com/renault/ipcm/dbusmgr"


static gchar Server_XML[] =
	"<node>"
	"<interface name='com.renault.ipcm.dbusmgr'>"
	" 	<method name='invokeSmartService'>"
	"    	<arg name='serviceName' type='s' direction='in' />"
	"       <arg name='params' 		type='s' direction='in' />"
	"       <arg name='result' 		type='s' direction='out' />"
	"  	</method>"
	"</interface>"
	"</node>";


typedef struct  
{
  char* bus_name;
  char* xml_path;
  char* obj_path;
  char* iface_name;
  GDBusNodeInfo* nodeInfo;
  RegisterClient_cb fn_callback;
}StIpcmClientInfo;      
     
/******************************************************************************
 * FUNCTION         :      bInitSmartProxy
*******************************************************************************
 * Description      :      bInitSmartProxy
 * Parameters       :      (void)
 * Return           :      gboolean
*******************************************************************************/
gboolean bInitSmartProxy();

/**
*******************************************************************************
** FUNCTION   : bInitSmartProxy
*******************************************************************************
* \fn     bInitSmartProxy
* \brief  callback function from DBus communication manager
* \param  None.
* \retval gboolean.
******************************************************************************/
void vhandleMethodRequest_cb(const gchar *sender, const gchar *methodName,
                             GVariant *parameters, const void* request_handle);

/**
****************************************************************************
** FUNCTION   : bInitSmartProxy
*******************************************************************************
* \fn     bInitSmartProxy
* \brief  Function to init smart proxy
* \param  None.
* \retval gint32.
******************************************************************************/
guint64 vhandleMethodResponse_cb(const char* identity,const char* data,
                                                guint64 request_handle);


/**
****************************************************************************
** FUNCTION   : vCleanUpSmartProxy
*******************************************************************************
* \fn     vCleanUpSmartProxy
* \brief  Function to cleanup smartproxy
* \param  None.
* \retval tVoid.
******************************************************************************/
void vCleanUpSmartProxy();


tVoid GenericMethodCall_request (tCString sender, tCString method_name, 
                                    GVariant *gparams
                                    ,const void* request_handle);

/**
*******************************************************************************
** FUNCTION   : vParsexmlfile
*******************************************************************************
* \fn     vParsexmlfile
* \brief  Function to parse interface file and converts it as character buffer
* \param  tString.
* \retval tString.
******************************************************************************/
tString vParsexmlfile(tString arg_filename);

/**
*******************************************************************************
** FUNCTION   : vhandleSignal_cb
*******************************************************************************
* \fn     vhandleSignal_cb
* \brief  Function to cleanup smartproxy
* \param  None.
* \retval void.
******************************************************************************/
void  vhandleSignal_cb(const gchar* signalName, GVariant* gparams);

/**
****************************************************************************
** FUNCTION   : bRegisterRPCClinet
*******************************************************************************
* \fn     bRegisterRPCClinet
* \brief  Function for registering with DBus Communication Manager
* \param  None.
* \retval interface_agents*.
******************************************************************************/
interface_agents* bRegisterWithDBusCM();

/******************************************************************************
* Function:       vE2EIfaceAvailable_cb
* Description:    vE2EIfaceAvailable_cb
* Parameters:     (interface_agents*)
* Return:         void
*****************************************************************************/
void vE2EIfaceAvailable_cb(interface_agents* interfaceAgent);

/******************************************************************************
* Function:       vVDIfaceAvailable_cb
* Description:    vVDIfaceAvailable_cb
* Parameters:     (interface_agents*)
* Return:         void
*****************************************************************************/
void vVDIfaceAvailable_cb(interface_agents* interfaceAgent);

#endif //_SMARTPROXY_H_
