/*
*******************************************************************************
* file               rpcclient.c
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Implementation for RPC client
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
22.09.2017 | rhk6kor                  | Initial Version
04.10.2014 | svs7kor				  | Version 1.0
\endverbatim
******************************************************************************/

#include "rpcclient.h"
DLT_DECLARE_CONTEXT(RPCCLIENT);

#define ID                     (tString)   "id"
#define RESULT             (tString)   "result"
#define METHOD             (tString)   "method"
/******************************************************************************
** FUNCTION   : HandleResponse
*******************************************************************************
* brief  Function to handle responses from ATL
* param  const char* appid,const char* reposne
* retval tVoid.
******************************************************************************/
tVoid HandleResponse(const char* appid,const char* response)
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN- HandleResponse :: APPID"),\
            DLT_STRING(appid));
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN- HandleResponse ::Response"),\
            DLT_STRING(response));
	 tString convertstr;
	tString sRequestId = strdup(sParseJsonStr(response,ID));
	convertstr = strtok(sRequestId, "\"");
	DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("IPCM- sId=")
            ,DLT_STRING(convertstr));
	 
	gint64 l_RequestId = g_ascii_strtoll (convertstr, NULL, 10);//validation
	DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("IPCM- RequestId=")
            ,DLT_INT(l_RequestId));
	 requestMessage * value_messageItem =
                g_hash_table_lookup(hRequestMessage_hashTable
                                    , GINT_TO_POINTER (l_RequestId));							
		 tCString l_sMethod =  sParseJsonStr(response,METHOD);							
		 tCString l_sParsedString =  sParseJsonStr(response,RESULT);
        DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("IPCM- parsed string =")
                ,DLT_STRING(l_sParsedString));						
	 if(value_messageItem != NULL)
    {
		DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("IPCM- RequestId Retreived"));
		responseCB(l_sMethod,l_sParsedString,value_messageItem->uRequestHandle);
		
	}
	g_free(sRequestId);
}


/******************************************************************************
** FUNCTION   : NotifyConnectionState
*******************************************************************************
* brief  Function to NotifyConnectionState
* param  const char* appid,const char* reposne
* retval int.
******************************************************************************/
tVoid NotifyConnectionState(const char* AppId,const char* response)
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN- NotifyConnectionState"));
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Received AppId:"),DLT_STRING(AppId));
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Received response"),DLT_STRING(response));
}


/******************************************************************************
** FUNCTION   : bInitRPCClient
*******************************************************************************
* brief  Function to init RPC Client
* param  None.
* retval gboolean.
******************************************************************************/
gboolean bInitRPCClient()
{
    DLT_REGISTER_CONTEXT(RPCCLIENT,"RPCC","RPCC context for logging");
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN- bInitRPCClient"));

    int iATL = iATL_Register(RPC_CLIENT,&HandleResponse);
    //iATL =0 success, 1 for failure;
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("ATL_Register status"),DLT_INT(iATL));

    //int iATLConnState = iATL_RegisterConnState(RPC_CLIENT,&NotifyConnectionState);
    //DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("RegisterATLConnState status"),DLT_INT(iATLConnState));

	gboolean bRet = bInitAgentPlugin();        //RPC Client initialization
	if(bRet)
	{
		DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("IPCM- bInitAgentPlugin - success"));
	}
	else
	{
		DLT_LOG(RPCCLIENT,DLT_LOG_INFO,DLT_STRING("IPCM- bInitAgentPlugin - failed"));
	}
	
    if(!iATL)
    {
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Register ATL success"));
        return TRUE; //Handle message flow
    }
    else{
        DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("Register ATL failure"));
        return FALSE ; //Stop message flow
    }
}


/******************************************************************************
** FUNCTION   : vCleanUpRPCClient
*******************************************************************************
* fn     vCleanUpRPCClient
* brief  Function to cleanup RPCClient
* param  None.
* retval void.
******************************************************************************/
void vCleanUpRPCClient()
{
    DLT_LOG(RPCCLIENT ,DLT_LOG_INFO,DLT_STRING("IN- vCleanUpRPCClient"));
    bDeregisterRPCClinet();
    iATL_DeRegister(RPC_CLIENT);
}
