/********************************************************************************
* \file               jsoncutils.cpp
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Handler for json conversion library
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
10.11.2017 | Naveen D R (RBEI/ECO2) | 0.0.1    | Initial version
\endverbatim
******************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Jsonvalidationcutils.h"

#ifdef __cplusplus
}
#endif


#include "Jsonvalidationcutils.h"
#include "JsonRPC2_0Validation.h"

DLT_DECLARE_CONTEXT(JSONVAL);

/******************************************************************************
** FUNCTION   : sConstructJsonValidation
*******************************************************************************
* \fn     sConstructJsonValidation
* \brief  Function to construct json string...
* \param  None.
* \retval None.
******************************************************************************/ 
tBool bInitJsonValidation()
{
	DLT_REGISTER_CONTEXT(JSONVAL,"JSON","RPCC context for logging");
    DLT_LOG(JSONVAL, DLT_LOG_INFO, DLT_STRING(__FUNCTION__));
	return true;
}

/******************************************************************************
** FUNCTION   : validateJson
*******************************************************************************
* \fn     validateJson
* \brief  Function to validate json string...
* \param  const char*.
* \retval JsonRPC2_0Err.
******************************************************************************/ 
 JsonRPC2_0Err validateJson(const char* jsonstring)
{
	DLT_LOG(JSONVAL, DLT_LOG_INFO, DLT_STRING(__FUNCTION__));
	JsonRPC2_0Err l_Err = JsonRPC20Message::getInstance()->validateJson_RPC20(jsonstring);
	return l_Err;
}

/******************************************************************************
** FUNCTION   : sConstruct_ErrorResponse
*******************************************************************************
* \fn     sConstruct_ErrorResponse
* \brief  Function to construct error response
* \param  iErrorCode.
* \retval const char*.
******************************************************************************/ 
const char* sConstruct_ErrorResponse(int iErrorCode,int id)
{
	 DLT_LOG(JSONVAL, DLT_LOG_INFO, DLT_STRING(__FUNCTION__));
	 const char* l_ErrorResponse = JsonRPC20Message::getInstance()->strConstruct_ErrorResponse(iErrorCode,id);
	 return l_ErrorResponse;
}

/******************************************************************************
** FUNCTION   : sConstruct_Response
*******************************************************************************
* \fn     sConstruct_Response
* \brief  Function to construct  response
* \param  const char*.
* \retval const char*.
******************************************************************************/ 
const char* sConstruct_Response(const char*  arg_resultstr,int id)
 {
	DLT_LOG(JSONVAL, DLT_LOG_INFO, DLT_STRING(__FUNCTION__)); 
	Json::Value root;
    Json::Reader reader;
    bool parsedSuccess = reader.parse(arg_resultstr, root);
    if(!parsedSuccess)
    {
        DLT_LOG(JSONVAL ,DLT_LOG_INFO,DLT_STRING("IN- Failed to parse JSON"));
        DLT_LOG(JSONVAL ,DLT_LOG_INFO,DLT_STRING(reader.getFormattedErrorMessages().c_str()));
		return NULL;
    }
    else{

        DLT_LOG(JSONVAL ,DLT_LOG_INFO,DLT_STRING("IN- Success"));
		const char* sConstructedResponse = JsonRPC20Message::getInstance()->strConstruct_Response(root,id);
		return sConstructedResponse;
    }
	 return NULL;
 }





