#ifndef _JSONRPC20_H_
#define _JSONRPC20_H_

#include <iostream>
#include <string.h>
#include <json/json.h>
#include "JsonRPC2_0Error.h"
#include "dlt/dlt.h"
#include <glib.h>

class JsonRPC20Message
{
private:

    std::string m_protocol;
    std::string m_method;
    std::string m_params;
    std::string m_id;
    std::string m_result;
    std::string m_error;
    int iGetID();
    std::string strGetMethod();
    Json::Value jsonGetParams();
    char* getStrFromErr(int iErrorCode);
     JsonRPC2_0Err bIsJson_RPC20(Json::Value);
     JsonRPC2_0Err eReturnJsonRPC_MessageType(Json::Value);
    bool isEqualVectors(std::vector<std::string> DefinedV
                        ,std::vector<std::string> ReceivedV);

public :
	static JsonRPC20Message* getInstance();
	static JsonRPC20Message *m_pJsonRPC20Message;
    std::string m_methodString;
    Json::Value m_RequestParams;
    int m_RequestId;
    JsonRPC20Message();
    ~JsonRPC20Message();
    bool bIsJson(const char*,Json::Value&);
     JsonRPC2_0Err validateJson_RPC20(const char* json);
    void vSetMethod(std::string method);
    void vSetParams(Json::Value params);
    void vSetId(int id);
    const char* strConstruct_ErrorResponse(int iErrorCode,int id);
    const char* strConstruct_Response(Json::Value result,int id);
    const char* strConstruct_JSONRPC20_request();
    void vValidateResponse_constructed();
};

#endif //_JSONRPC20_H_
