/*!
*******************************************************************************
* \file               ipcm_main.h
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Header for main application
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
21.09.2017 | rhk6kor                  | Initial Version
\endverbatim
******************************************************************************/

#ifndef _IPCMMAIN_H_
#define _IPCMMAIN_H_

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include <glib.h>
#include <stdio.h>
#include "dlt/dlt.h"
#include "ATL/interface/atl_if.h"
#include "dbuscommmanager/dbuscommmanager.h"
#include "rpcserver/rpcserver.h"
#include "rpcclient/rpcclient.h"
#include "pluginmanager.h"

/******************************************************************************
| defines
|----------------------------------------------------------------------------*/

/*!
* \struct definition
*/


/******************************************************************************
** FUNCTION   : bInitialize
*******************************************************************************
* \fn     bInitialize
* \brief  Function to initialize the main component
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bInitialize();

/******************************************************************************
** FUNCTION   : poGetMainLoop
*******************************************************************************
* \fn     getMainLoop
* \brief  Function to return the main loop.
* \param  None.
* \retval gboolean.
******************************************************************************/
GMainLoop* poGetMainLoop();

/******************************************************************************
** FUNCTION   : bStart
*******************************************************************************
* \fn     bStart
* \brief  Function to start the main application.
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bStart();

/******************************************************************************
** FUNCTION   : vStop
*******************************************************************************
* \fn     vStop
* \brief  Function to stop the main application.
* \param  None.
* \retval gboolean.
******************************************************************************/
void vStop();

#endif //_IPCMMAIN_H_