/*!
*******************************************************************************
* \file               ipcm_main.h
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Header for main application
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
21.09.2017 | rhk6kor                  | Initial Version. starter functions.
\endverbatim
******************************************************************************/
#include "ipcm_main.h"
#include "rpcclient.h"
#include "SmartProxy.h"
#include "watchdog.h"
#include "Jsonvalidationcutils.h"

//DLT APPID & CONTEXT DECLARATION
#define APPID_IPCM "IPCM"
DLT_DECLARE_CONTEXT(IPCM_MAIN);


static GMainLoop *mainLoop = NULL;
/******************************************************************************
** FUNCTION   : bInitialize
*******************************************************************************
* \fn     bInitialize
* \brief  Function to initialize the main component
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bInitialize()
{
   DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("bInitialize"));
   mainLoop = g_main_loop_new (NULL, FALSE);
   return TRUE;
}

/******************************************************************************
** FUNCTION   : poGetMainLoop
*******************************************************************************
* \fn     getMainLoop
* \brief  Function to return the main loop.
* \param  None.
* \retval gboolean.
******************************************************************************/
GMainLoop* getMainLoop()
{
   DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("getMainLoop"));
   return mainLoop;
}

/******************************************************************************
** FUNCTION   : bStart
*******************************************************************************
* \fn     bStart
* \brief  Function to start the main application.
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bStart()
{
   DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("bStart"));
   gboolean bRet = FALSE;

   //ATL 
   bRet = iATL_Init();             //ATL Init .. First ATL will get initialized always 
   if(bRet)
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- iATL_Init - success"));
   }
   else
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- iATL_Init - failed"));
	  return bRet;
   }
   
   //DBUS CommMgr
   bRet = bInitDBusCommMgr();        //Dbus comm mgr initialization
   if(bRet)
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitDBusCommMgr - success"));
   }
   else
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitDBusCommMgr - failed"));
	  return bRet;
   }
   
   //RPC Server
   bRet = bInitRPCServer();        //RPC Server initialization
   if(bRet)
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitRPCServer - success"));
   }
   else
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitRPCServer - failed"));
   }
   
   //RPC Client
   bRet = bInitRPCClient();        //RPC Client initialization
   if(bRet)
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitRPCClient - success"));
   }
   else
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitRPCClient - failed"));
   }
   
   //PluginManager 
   bRet = bInitPluginmanager();          //Plugin Manager initialization 
   if(bRet)
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitPluginmanager - success"));
   }
   else
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitPluginmanager - failed"));
   }

   //SmartProxy
   bRet = bInitSmartProxy();            //SmartProxy initialization 
   if(bRet)
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitSmartproxy - success"));
   }
   else
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitSmartproxy - failed"));
   }
   
  bRet = bInitJsonValidation();            //JsonValidation initialization 
   if(bRet)
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitJsonValidation - success"));
   }
   else
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- bInitJsonValidation - failed"));
   }

   //Now that all subsystems are initialized, notify systemd about the startup.
#if WATCHDOG
   bRet = bInitWatchDog();
   if(bRet)
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- watchdog - success"));
   }
   else
   {
      DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- watchdogs - failed"));
   }
#endif
   
   g_main_loop_run(mainLoop);
   
   return bRet;
}

/******************************************************************************
** FUNCTION   : vStop
*******************************************************************************
* \fn     vStop
* \brief  Function to stop the main application.
* \param  None.
* \retval gboolean.
******************************************************************************/
void vStop()
{
  DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("vStop"));
#if WATCHDOG
   vStopWatchDog();
#endif
   g_main_loop_unref(mainLoop);
}

/******************************************************************************
** FUNCTION   : main
*******************************************************************************
* \fn     main
* \brief  Entry function of main application.
* \param  int argc, char *argv[].
* \retval int.
******************************************************************************/
int main (int argc, char *argv[])
{
   DLT_REGISTER_APP(APPID_IPCM, "IPCM application for logging");
   DLT_REGISTER_CONTEXT(IPCM_MAIN,"MAIN","MAIN IPCM");
   
   
   DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- starting main ipcm application"));
   gboolean bInitRet = bInitialize();
   DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- Init status"),DLT_INT(bInitRet));
   gboolean bStartRet = bStart();
   DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- Main loop started"),DLT_INT(bStartRet));
   vStop();
   DLT_LOG(IPCM_MAIN,DLT_LOG_INFO,DLT_STRING("IPCM- exiting ipcm"));

   return 0;
}