/*!
*******************************************************************************
* @file             : atl.h
*******************************************************************************
*  - PROJECT:       : IPCM
*  - SW-COMPONENT   : Abstract Transport Layer
*  - DESCRIPTION    : Provides abstraction over MQTT transport protocol
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          | Version  | Modification
* ----------|---------------|----------|---------------------------------------
*28.09.2017 | Ashsih Kumar  (RBEI/ECO2)| 0.0.1    | Initial version
******************************************************************************/

#ifndef _ATL_H_ 
#define _ATL_H_

//Headers
#include "atl_if.h"

#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <mosquitto.h>
#include <pthread.h>
#include <errno.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
//#include <glib-object.h>
//#include <glib/gstdio.h>
#include "dlt/dlt.h"

//tInt
#define QOS                                 (tInt)       2

//HOST ADDRESS
#define MQTT_HOSTNAME                       (tCString)   "10.19.229.143"    //"localhost" 
#define MQTT_PORT                           (tInt)       1883

//FILE USERNAME
//#define USERNAME_SERVER					    (tCString)   "RPCSERVER"
//#define USERNAME_CLIENT					    (tCString)   "RPCCLIENT"

//FILE PATH
//#define MQTT_PASSWD_FILE_PATH 		 	(tCString)   "/tmp/shared/ipcm/plain_pwfile.txt"
#define MQTT_PASSWD_FILE_PATH 				(tCString)   "/var/opt/bosch/dynamic/ipcm/plain_pwfile.txt"
#define MQTT_PASSWD_FILE_LEN 				(tInt)   	 52

//SERVER MQTT TOPIC
#define SERVER_TOPIC_SUBSCRIBE_ALL          (tCString)   "ipcm/sp/#"
#define SERVER_TOPIC_SUBSCRIBE_REQUEST      (tCString)   "ipcm/sp/+/rpc/request"

#define SERVER_TOPIC_SUBSCRIBE_APPSTATE     (tCString)   "ipcm/sp/+/state"

#define SERVER_TOPIC_PUBLISH_RESPONSE_P1    (tCString)   "ipcm/sp/"
#define SERVER_TOPIC_PUBLISH_RESPONSE_P2    (tCString)   "/rpc/response"


//CLIENT MQTT TOPIC
#define CLIENT_TOPIC_SUBSCRIBE_ALL          (tCString)   "sp/ipcm/#"
#define CLIENT_TOPIC_SUBSCRIBE_RESPONSE     (tCString)   "sp/ipcm/+/rpc/response"

#define CLIENT_TOPIC_PUBLISH_REQUEST_P1     (tCString)   "sp/ipcm/"
#define CLIENT_TOPIC_PUBLISH_REQUEST_P2     (tCString)   "/rpc/request"

#define CLIENT_TOPIC_PUBLISH_TELEMETRY      (tCString)   "ipcm/sp/telemetry/rscd"

//Internal
/******************************************************************************
* FUNCTION         :      bFileCheck
*******************************************************************************
* Description      :      bFileCheck
* Parameters       :      const gchar *
* Return           :      gboolean
*******************************************************************************/
gboolean bFileCheck(const gchar *);


/******************************************************************************
* FUNCTION         :      iATL_GetAppID
*******************************************************************************
* Description      :      iATL_GetAppID
* Parameters       :      tString
* Return           :      tString
*******************************************************************************/
tString iATL_GetAppID(tString messageTopic);


/******************************************************************************
* FUNCTION         :      iATL_Register_Server
*******************************************************************************
* Description      :      iATL_Register_Server
* Parameters       :      void
* Return           :      ATL_ERR
*******************************************************************************/
ATL_ERR iATL_Register_Server();


/******************************************************************************
* FUNCTION         :      iATL_Register_Client
*******************************************************************************
* Description      :      iATL_Register_Client
* Parameters       :      void
* Return           :      ATL_ERR
*******************************************************************************/
ATL_ERR iATL_Register_Client();



/******************************************************************************
* FUNCTION         :      iATL_Publish_Server
*******************************************************************************
* Description      :      iATL_Publish_Server
* Parameters       :      appId, payload, topicType
* Return           :      ATL_ERR
*******************************************************************************/
ATL_ERR iATL_Publish_Server( tCString   appId,
                             tCString   payload,
                             eTopicType topicType );

/******************************************************************************
* FUNCTION         :      iATL_Publish_Client
*******************************************************************************
* Description      :      iATL_Publish_Client
* Parameters       :      appId, payload, topicType
* Return           :      ATL_ERR
*******************************************************************************/
ATL_ERR iATL_Publish_Client( tCString   appId,
                             tCString   payload, 
                             eTopicType topicType );

#endif //_ATL_H_
