/*!
*******************************************************************************
* @file             : atl_if.h
*******************************************************************************
*  - PROJECT:       : IPCM
*  - SW-COMPONENT   : Abstract Transport Layer
*  - DESCRIPTION    : Provides abstraction over MQTT transport protocol
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          | Version  | Modification
* ----------|---------------|----------|---------------------------------------
*28.09.2017 | Ashsih Kumar (RBEI/ECO2) | 0.0.1    | Initial version
******************************************************************************/

#ifndef _ATL_IF_H_ 
#define _ATL_IF_H_

//Headers
#include <glib.h>
#include <gio/gio.h>
#include "dlt/dlt.h"
#include "system_types.h"
#include "atl_enums.h"

//PEER TYPE
#define RPC_SERVER                     (tCString)   "RPCSERVER"
#define RPC_CLIENT                     (tCString)   "RPCCLIENT"

//CALLBACK FUNCTIONs
typedef tVoid (*fpHandleResponse)(tCString,tCString);
typedef tVoid (*fpNotifyConnectionState)(tCString,tCString);

//HandleResponse  Variable
fpHandleResponse Server_ResponseCB;
fpHandleResponse Client_ResponseCB;

//NotifyConnectionState Variable
fpNotifyConnectionState Server_StateNotifyResponseCB;
fpNotifyConnectionState Client_StateNotifyResponseCB;

// Topic Types
typedef enum
{
   IPCM_DEFAULT_TOPIC = 0,
   IPCM_TELEMETRY_TOPIC = 1
} eTopicType;

/******************************************************************************
 * FUNCTION       :      iATL_Init
*******************************************************************************
 * Description    :      To Initialise the ATL
 * Parameters     :      void
 * Return         :      gboolean
*******************************************************************************/
gboolean iATL_Init();



/******************************************************************************
 * FUNCTION       :      iATL_Stop
*******************************************************************************
 * Description    :      To Stop the ATL
 * Parameters     :      void
 * Return         :      ATL_ERR
*******************************************************************************/
ATL_ERR iATL_Stop();



/******************************************************************************
 * FUNCTION         :      iATL_Register
*******************************************************************************
 * Description      :      iATL_Register
 * Parameters       :      (char*,fpHandleResponse)
 * Return           :      ATL_ERR
*******************************************************************************/
ATL_ERR iATL_Register(tCString peer,fpHandleResponse responseCB);



/******************************************************************************
 * FUNCTION         :      iATL_RegisterConnState
*******************************************************************************
 * Description      :      iATL_RegisterConnState
 * Parameters       :      (const char*,fpNotifyConnectionState ATLConnStateCB)
 * Return           :      ATL_ERR
*******************************************************************************/
ATL_ERR iATL_RegisterConnState(tCString peer,fpNotifyConnectionState ATLConnStateCB);



/******************************************************************************
 * FUNCTION         :      iATL_SendMessage
*******************************************************************************
 * Description      :      iATL_SendMessage
 * Parameters       :      (tCString,tCString,tCString, topicType)
 * Return           :      ATL_ERR
*******************************************************************************/
ATL_ERR  iATL_SendMessage( tCString   peer,
                           tCString   appId,
                           tCString   payload, 
                           eTopicType topicType );



/******************************************************************************
 * FUNCTION         :      iATL_DeRegister
*******************************************************************************
 * Description      :      iATL_DeRegister
 * Parameters       :      (tCString peer)
 * Return           :      ATL_ERR
*******************************************************************************/
ATL_ERR  iATL_DeRegister(tCString peer);

 
  
  
#endif //_ATL_IF_H_


