/*
*******************************************************************************
* \file               HelloService.h
*******************************************************************************
\verbatim
PROJECT:        IPCM
SW-COMPONENT:   IPCM
DESCRIPTION:    Implementation for HelloService
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
22.09.2017 | rhk6kor                  | Initial Version
23.10.2017 | svs7kor                  | Version 1.1
\endverbatim
******************************************************************************/
#include "HelloService.h"
#include "jsoncutils.h"
#include <openssl/sha.h>
DLT_DECLARE_CONTEXT(HELLOSERVICE)

#define CARCONFIG_XML "/var/opt/bosch/static/com.bosch.AutomotiveProxy.CarConfiguration.xml"
#define CARINTERFACE "com.bosch.AutomotiveProxy.CarConfiguration";
#define BUSNAME "com.bosch.AutomotiveProxy"
#define OBJECT_PATH "/com/bosch/AutomotiveProxy/CarConfiguration"
#define CARCONFIG_METHOD "GetConfigurationValue"
#define AP_CARCONFIGURATION_HUID 2
#define AP_CARCONFIGURATION_SW_VER 5
#define OSRELEASE_FILE_PATH "/etc/os-release"
#define HELLO_MAJOR_VERSION 1
#define HELLO_MINOR_VERSION 0

guint uHUIDvalue = 0;
static unsigned char buffer[65] = { 0};
char* poDBusXMLToStr(char* arg_filename);

enum ERRORS_SHA256
{
	ERROR_SHA256 = -1,
	SUCCESS_SHA256
};

struct serviceStruct {
    char* service;
    int major_version;
    int minor_version;
} temp;
 struct serviceStruct service_array[]={{"sendDestination",1,0}
              ,{"sendParkLocation",2,3},{"hello",1,2},{"lasMileGuid",2,8}};
 
 /******************************************************************************
** FUNCTION   : vSha256
*******************************************************************************
* \fn     vSha256
* \brief  Function to calculate sha256sum of given string
* \param  char *string, char* outputBuffer.
* \retval void.
******************************************************************************/
enum ERRORS_SHA256 vCalculate_Sha256(char *string, char* outputBuffer)
{
	DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING(__FUNCTION__));
    unsigned char hash[SHA256_DIGEST_LENGTH];
    SHA256_CTX sha256;
    int iInitVal =  SHA256_Init(&sha256);
	DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING("iInitVal:")
	       ,DLT_INT(iInitVal));
    int iUpdateVal =  SHA256_Update(&sha256, string, strlen(string));
    DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING("iUpdateVal:")
	       ,DLT_INT(iUpdateVal));
    int iFinalVal =  SHA256_Final(hash, &sha256);
	DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING("iFinalVal:")
	       ,DLT_INT(iFinalVal));
	if(!(iInitVal && iUpdateVal && iFinalVal))
	{
		DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		     ,DLT_STRING("Error in sha256 algorithm:"));
		return ERROR_SHA256;
	}
    int i = 0;
    for(i = 0; i < SHA256_DIGEST_LENGTH; i++)
    {
        sprintf(outputBuffer + (i * 2), "%02x", hash[i]);
    }
    outputBuffer[64] = 0;
	return SUCCESS_SHA256;
}
 /******************************************************************************
** FUNCTION   : strReturn_ServiceHash
*******************************************************************************
* \fn     strReturn_ServiceHash
* \brief  Function to return sha256sum of serviceList 
* \param  char *string, char* outputBuffer.
* \retval void.
******************************************************************************/
void strReturn_ServiceHash()
{
	int i, j;
   
   //service* vGetServiceList()        REQUESTING RPC SERVER FOR THE SERVICE LIST
   
	size_t n = sizeof(service_array)/sizeof(service_array[0]);
	DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		     ,DLT_STRING("Array size is::"),DLT_INT(n));
    //sorting
    for (i = 1; i < n; i++)
    {
        for (j = 0; j < n - i; j++) {
            if (strcmp(service_array[j].service, service_array[j + 1].service) > 0) {
                temp = service_array[j];
                service_array[j] = service_array[j + 1];
                service_array[j + 1] = temp;
            }
        }
    }

    //printing sorted result
    for (i = 0; i < n; i++) {
        printf("\n%s\t%d\t%d",service_array[i].service,service_array[i].major_version,service_array[i].minor_version);
    }

    //formulating input for hash function
    gchar *str = NULL;
    for (i = 0; i < n; i++)
    {
        gchar * tempStr = NULL;
        gchar *strMajor = g_strdup_printf("%i", service_array[i].major_version);
		DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		     ,DLT_STRING("strMajor of struct ::"),DLT_STRING(strMajor));

        gchar *strMinor = g_strdup_printf("%i",  service_array[i].minor_version);
		DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		     ,DLT_STRING("strMinor of struct::"),DLT_STRING(strMinor));

        if(i== n-1)
        {
            tempStr = g_strconcat(service_array[i].service,"_",strMajor,"_",strMinor,NULL);
			DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		     ,DLT_STRING("tempstr of struct :"),DLT_STRING(tempStr));

        }else
        {
            tempStr = g_strconcat(service_array[i].service,"_",strMajor,"_",strMinor,"#",NULL);
			DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		     ,DLT_STRING("tempstr of struct :"),DLT_STRING(tempStr));

        }
        if(i== 0)
        {
            str = g_strconcat(tempStr,NULL);
			DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		     ,DLT_STRING("str of struct first time :"),DLT_STRING(str));
        }
        else
        {
            str = g_strconcat(str,tempStr,NULL);
			DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		     ,DLT_STRING("str of struct::"),DLT_STRING(str));

        }
        g_free(strMajor);
        g_free(strMinor);
        g_free(tempStr);
    }

	DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		     ,DLT_STRING("Final str:"),DLT_STRING(str));
    //calculating sha256sum
    if(SUCCESS_SHA256 == vCalculate_Sha256(str, buffer))
	{
		DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING("Sha256sum success"));
		DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		     ,DLT_STRING("Final hash val :"),DLT_STRING(buffer));
	}
	else{
		DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING("Sha256sum failure"));
	}
}


/******************************************************************************
** FUNCTION   : vReadOSReleaseFile
*******************************************************************************
* \fn     vReadOSReleaseFile
* \brief  Function to read os-release file
* \param  char *string, char* outputBuffer.
* \retval void.
******************************************************************************/
GVariant* vReadOSReleaseFile(char* file)
{
	DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING(__FUNCTION__));
	GVariant *poRelease_info = NULL;
	GVariantBuilder *builder;
	builder = g_variant_builder_new(G_VARIANT_TYPE("a{sv}"));
	FILE *fptr; char *line = NULL; size_t len = 0;
	fptr = fopen(file, "r");char* token;
	char *key;
	if(fptr != NULL)
	{
		DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING("File open success"));
		while(!feof(fptr) )
		{
			 if(getline(&line, &len, fptr) != -1) 
			 {
				DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
				    ,DLT_STRING("Line ::"),DLT_STRING(line));
				 char* newLine = strrchr(line,'\n');
				 if(newLine != NULL)
				 {
					  *newLine = '\0';				 
				 }				
				 DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
				    ,DLT_STRING("After LIne ::: "),DLT_STRING(line));
				  token = strtok(line, "=");
					key= token;
					while( token != NULL ) 
					{						
						DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
							,DLT_STRING("Token ::: "),DLT_STRING(token));
						token = strtok(NULL, "=");
						if(token != NULL)
						{
						  g_variant_builder_add (builder, "{sv}"
							, key,g_variant_new("s",token)); 
						}					
					}	
					
			 }
			 
		}
		g_free(line);
		DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING("End Of File"));
			
	}else{
		DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING("Error opening the file"));
	}
	if(fptr != NULL)
		fclose(fptr);//To supress coverity
	
	poRelease_info = g_variant_builder_end (builder);
    char* variantString = g_variant_print(poRelease_info,TRUE);
	//printf("Converted string is : %s\n",variantString);
	DLT_LOG(HELLOSERVICE,DLT_LOG_INFO,
	    DLT_STRING("Converted string is "),DLT_STRING(variantString));
	g_free(variantString);
	g_variant_builder_unref (builder); 
	return poRelease_info;
}
/******************************************************************************
** FUNCTION   : sendResponseToRPCServer
*******************************************************************************
* \fn     sendResponseToRPCServer
* \brief  Function to handle hello request from rpc server
* \param  GVariant* var, CallParams* call
				,GError** error, HandleE2EResponse HandleResponseFromRPCServer
				,gint64 request_id.
* \retval void.
******************************************************************************/
void sendResponseToRPCServer(GVariant* var, CallParams* call
				,GError** error, HandleE2EResponse HandleResponseFromRPCServer
				,gint64 request_id)
{
	DLT_LOG(HELLOSERVICE, DLT_LOG_INFO, DLT_STRING(__FUNCTION__));
	GError *l_poError = NULL;	
	GVariant *gCapabilities = NULL, *gResponse = NULL ;
	GVariantBuilder *builder_capabilities, *builder; 
	
	builder_capabilities = g_variant_builder_new(G_VARIANT_TYPE("a{sv}"));
	g_variant_builder_add (builder_capabilities, "{sv}"
	             , "iface",g_variant_new("s","IVC")); 
	g_variant_builder_add (builder_capabilities, "{sv}"
	             , "cellular",g_variant_new("s","none")); 
	g_variant_builder_add (builder_capabilities, "{sv}"
	             , "special",g_variant_new("s","none")); 
	gCapabilities = g_variant_builder_end (builder_capabilities);
	g_variant_builder_unref (builder_capabilities);
	
	builder = g_variant_builder_new (G_VARIANT_TYPE ("a{sv}"));
	g_variant_builder_add (builder, "{sv}", "APP_ID",g_variant_new("s","IPCM"));
	g_variant_builder_add (builder, "{sv}", "Type",g_variant_new("s","none"));
	g_variant_builder_add (builder, "{sv}", "Token",g_variant_new("s","none"));
	g_variant_builder_add (builder, "{sv}", "Model",g_variant_new("u",uHUIDvalue));
	g_variant_builder_add (builder, "{sv}"
	             , "Software version",g_variant_new("s","1.0.0"));
	
	// /etc/os-release content converted to JSONOBJECT
	GVariant *poRelease_info = vReadOSReleaseFile(OSRELEASE_FILE_PATH);
	g_variant_builder_add (builder, "{sv}"
	             , "OSversion",g_variant_new("v",poRelease_info));
	g_variant_builder_add (builder, "{sv}"
	             , "Capabilities",g_variant_new("v",gCapabilities));
	
	
	char* serviceList = "{ \"ServiceID\":\"hello\", \"MajorVersion\":1, \"MinorVersion\":0 },\r\n{ \"ServiceID\":\"lastMileGuid\", \"MajorVersion\":1, \"MinorVersion\":0 },\r\n{ \"ServiceID\":\"sendDestination\", \"MajorVersion\":1, \"MinorVersion\":0 },\r\n{ \"ServiceID\":\"sendParkLocation\", \"MajorVersion\":1, \"MinorVersion\":0 }";
	g_variant_builder_add (builder, "{sv}"
	             , "ServiceList",g_variant_new("s",serviceList)); //TBD

	strReturn_ServiceHash();
	g_variant_builder_add (builder, "{sv}", "ServiceHash",g_variant_new("s",buffer));
	
	gResponse = g_variant_builder_end (builder);
	g_variant_builder_unref (builder);
	//g_free(poRelease_info);
    char* variantString = g_variant_print(gResponse, TRUE);
    DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
	             ,DLT_STRING("HELLO SERVICER : Constructed gvariant:: ")
                 ,DLT_STRING(variantString));
	//printf( "HELLO SERVICER : Constructed gvariant:: %s",variantString);
	g_free(variantString);	
	HandleResponseFromRPCServer(gResponse,&l_poError,request_id, IPCM_DEFAULT_TOPIC);
	//g_free(poRelease_info);
	/*DLT_LOG(HELLOSERVICE,DLT_LOG_INFO
		,DLT_STRING("ERROR in HandleResponseFromRPCServer")
                , DLT_STRING(l_poError->message));*/
				//Don't print this,crashes since l_poError is NULL

}
/******************************************************************************
** FUNCTION   : poDBusXMLToStr
*******************************************************************************
* \fn     poDBusXMLToStr
* \brief  Function to parse xml file
* \param  None.
* \retval char*.
******************************************************************************/
char* poDBusXMLToStr(char* arg_filename)
{
    DLT_LOG(HELLOSERVICE, DLT_LOG_INFO, DLT_STRING(__FUNCTION__));
    if (g_file_test (arg_filename, G_FILE_TEST_EXISTS))
    {
        DLT_LOG(HELLOSERVICE, DLT_LOG_INFO
                , DLT_STRING("HELLO SERVICE - car config xml file exists"));
        gsize fileSize; char * strFileContent;
        if (g_file_get_contents(arg_filename, &strFileContent, &fileSize, NULL))
        {
            return strFileContent;
        }
		else
		{
            DLT_LOG(HELLOSERVICE,DLT_LOG_INFO,
                DLT_STRING("HELLO SERVICE - Error reading the file content"));
		}
    }
	else{
         DLT_LOG(HELLOSERVICE, DLT_LOG_INFO
            ,DLT_STRING("HELLO SERVICE - car config xml file doesn't exists"));
	}
    return NULL;
}
/******************************************************************************
** FUNCTION   : vAsyncCarConfigHUID_callback
*******************************************************************************
* \fn     vAsyncCarConfigHUID_callback
* \brief  Callback funtion for
* \param  None.
* \retval None.
******************************************************************************/
void vAsyncCarConfigHUID_callback(GVariant* Variant, GError** Error,void* data)				   
{
    DLT_LOG(HELLOSERVICE, DLT_LOG_INFO, DLT_STRING(__FUNCTION__));
 /*   GError *error = NULL;	

	if (var_data != NULL)
	{
		uHUIDvalue = g_variant_get_uint32 (var_data);
		DLT_LOG(HELLOSERVICE,DLT_LOG_INFO
		      ,DLT_STRING("HELLO SERVICE- HUID :"), DLT_UINT32(uHUIDvalue));
		//g_variant_unref (var_data);
	}
	else
	{
		DLT_LOG(HELLOSERVICE,DLT_LOG_INFO
		,DLT_STRING("ERROR in vAsyncCarConfigHUID_callback")
                , DLT_STRING(error->message));
	} */
	
}


void vRegisterclientsuccess_cb(interface_agents* l_interface_agents)
{
	DLT_LOG(HELLOSERVICE, DLT_LOG_INFO, DLT_STRING(__FUNCTION__));
	
}

/**
*******************************************************************************
** FUNCTION   : poRegisterWithDBusCM_Hello
*******************************************************************************
* \fn     poRegisterWithDBusCM_Hello
* \brief  Function to init poRegisterWithDBusCM_Hello
* \param  None.
* \retval interface_agents*.
******************************************************************************/
interface_agents* poRegisterWithDBusCM_Hello()
{
    DLT_LOG(HELLOSERVICE, DLT_LOG_INFO, DLT_STRING(__FUNCTION__));
    GError *l_poError = NULL;

    char* l_filename = CARCONFIG_XML;
    char* l_xml = poDBusXMLToStr(l_filename);
    interface_agents* l_interface_agents =
            RegisterClient(l_xml, BUSNAME, OBJECT_PATH, &l_poError,&vRegisterclientsuccess_cb);
    // Request car config method												 
    if(l_interface_agents)
    {
        DLT_LOG(HELLOSERVICE, DLT_LOG_INFO
                , DLT_STRING("HELLO SERVICE -: interface_agents isn't NULL"));
		GVariant* g_methodRequestparams = 
		   g_variant_new ("(y)",AP_CARCONFIGURATION_HUID);
		
		method_request_info* l_Requestinfo =g_new0(method_request_info,1);
		l_Requestinfo->handleMethodResponseCBAsync = &vAsyncCarConfigHUID_callback;
		l_Requestinfo->request_id = 0;//For Hello Service
	
		 iTriggerMethodAsync(l_interface_agents, CARCONFIG_METHOD
                            , g_methodRequestparams
                            , l_Requestinfo);
		
	//free g_methodRequestparams : TBD

    }
    else
    {
        DLT_LOG(HELLOSERVICE, DLT_LOG_INFO
            , DLT_STRING("HELLO SERVICE - interface_agents is NULL"));
    }

    return l_interface_agents;
}

/******************************************************************************
** FUNCTION   : bInit_HelloService
*******************************************************************************
* \fn     bInit_HelloService
* \brief  Function to initialize the hello service
* \param  None.
* \retval gboolean.
******************************************************************************/
gboolean bInit_HelloService()
{
   DLT_REGISTER_CONTEXT(HELLOSERVICE,"HSER","IPCM HELLO SERVICE");
	DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO,DLT_STRING("IN- bInitHelloService"));
	 size_t size_service =1;
	 
	 service **l_poservice =g_new0(service *, size_service);
    l_poservice[0] = g_new0(service, 1);
    l_poservice[0]->service=g_strdup("\"hello_1\"");
    l_poservice[0]->major_version = HELLO_MAJOR_VERSION;
    l_poservice[0]->minor_version =HELLO_MINOR_VERSION;
    l_poservice[0]->handleE2EMessageCBAsync =&sendResponseToRPCServer;
	
   vRegister_RPCServer(l_poservice,size_service); 
   
	//Register with DBus communication Manager as a CLIENT
    interface_agents* l_po_interface_agents = poRegisterWithDBusCM_Hello();
	if(NULL != l_po_interface_agents)
	{
		DLT_LOG(HELLOSERVICE ,DLT_LOG_INFO
		  ,DLT_STRING("Registered to DBUS communication manager"));
	}
	//g_free(l_poservice); crashed with this
	return TRUE;
}

/******************************************************************************
** FUNCTION   : vExit
*******************************************************************************
* \fn     vExit
* \brief  Function to cleanup hello service
* \param  None.
* \retval void.
******************************************************************************/
void vExit()
{
	DLT_LOG(HELLOSERVICE, DLT_LOG_INFO, DLT_STRING(__FUNCTION__));
	//list handles, free up, rpcserver deregistration etc
}

