/*****************************************************************************
* FILE:         videomanager_ServiceVdmSrvIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// videomanager_tclServiceVdmSrvIfIncludes: user specific code start
#include "videomanager_lookuptable.h"
tCString cszContainerSemName  = "RSE_ProcessGuardian";
#include <string>
// videomanager_tclServiceVdmSrvIfIncludes: user specific code end

#include "videomanager_ServiceVdmSrvIf.h"
#include "I_videomanager_ServiceVdmSrv.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_VDM_APP_SERVER_VDMSRV
#include "trcGenProj/Header/videomanager_ServiceVdmSrvIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: videomanager_tclServiceVdmSrvIf::
*             videomanager_tclServiceVdmSrvIf(videomanager_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
videomanager_tclServiceVdmSrvIf* videomanager_tclServiceVdmSrvIf::_poMyStaticRef = NULL;

videomanager_tclServiceVdmSrvIf::videomanager_tclServiceVdmSrvIf(videomanager_tclAppMain* poMainAppl)
: Ivideomanager_tclServiceVdmSrvIf(poMainAppl)
, _hStateTimer(OSAL_C_INVALID_HANDLE)
, _hDataUpdateSemaphore (OSAL_C_INVALID_HANDLE)
{
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf() entered."));
   _poServerRef = OSAL_NULL;

   // videomanager_tclServiceVdmSrvIfConstructor: user specific code start
   // create timer
   if(OSAL_s32TimerCreate ((OSAL_tpfCallback)vStateTimer, (tPVoid) this, &_hStateTimer) != OSAL_OK)
   {
	   _hStateTimer = OSAL_C_INVALID_HANDLE;
   }

   // create and initialize semaphore
   tS32 s32TmpResult = OSAL_s32SemaphoreCreate ( cszContainerSemName, &_hDataUpdateSemaphore, 1);
   if (OSAL_OK != s32TmpResult)
   {
       ETG_TRACE_ERR((" SemCreate failed:code=%s", RSE_OsalErrorString() ));
   	   NORMAL_M_ASSERT_ALWAYS();
   }

   _bIsAlreadyAcknowledged = true;
   u32TimeoutDuration = 2000;
   sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE;
   sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN;

   _poMyStaticRef = this;
   _s8NumberOfSourceToBeStored = -1;
   _bVideomanagerWaiting = false;
   _bTimerIsRunning = false;
   _s32TimerIndex = 0;
   _bVectorHasEntriesChecking = false;
   // videomanager_tclServiceVdmSrvIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: videomanager_tclServiceVdmSrvIf::
*             ~videomanager_tclServiceVdmSrvIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
videomanager_tclServiceVdmSrvIf::~videomanager_tclServiceVdmSrvIf(tVoid)
{
   ETG_TRACE_USR4(("~videomanager_tclServiceVdmSrvIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // videomanager_tclServiceVdmSrvIfDestructor: user specific code start
   if (OSAL_C_INVALID_HANDLE != _hStateTimer) {
   		  if (OSAL_s32TimerSetTime( _hStateTimer, 0, 0) != OSAL_OK){     // Stop Timer before deleting
   			 ETG_TRACE_ERR( ( "~videomanager_tclServiceVdmSrvIf(): SPM: !!!!!! Error detected !!!!!!" ) );
   		  }
   		  if( OSAL_s32TimerDelete( _hStateTimer) != OSAL_OK){            // Delete Timer
   			 ETG_TRACE_ERR( ( "~videomanager_tclServiceVdmSrvIf(): SPM: !!!!!! Error detected !!!!!!" ) );
   		  }
   		  _hStateTimer = OSAL_C_INVALID_HANDLE;
   	 }
   // videomanager_tclServiceVdmSrvIfDestructor: user specific code end
}

/******************************************************************************
 *
 * FUNCTION:    vStartVideoSourceTimer
 *
 * DESCRIPTION: start the timer
 *
 * PARAMETER:   [in]
 *              tU32 time in ms
 *
 * RETURNVALUE: none
 *
 *****************************************************************************/
tVoid videomanager_tclServiceVdmSrvIf::vStartVideoSourceTimer(tU32 u32Time)
{
	if(OSAL_C_INVALID_HANDLE != _hStateTimer)
	{
		if(_bTimerIsRunning == false)
		{
			ETG_TRACE_USR1(("videomanager_sourcehandler::vStartVideoSourceTimer() --> %dms!",u32Time));
			if(u32Time > 0)
			{
				// set timer active
				OSAL_s32TimerSetTime(_hStateTimer,u32Time,0);
			}
			else
			{
				// reset timer
				OSAL_s32TimerSetTime(_hStateTimer,0,0);
			}
		}
		else
		{
			ETG_TRACE_USR4(("Timer currently not available, already running"));
		}
	}
}

/******************************************************************************
 *
 * FUNCTION:    vStateTimer
 *
 * DESCRIPTION: will be called after timeout
 *
 * PARAMETER:   [in]
 *              tVoid *pArg
 *
 * RETURNVALUE: OSAL_tpfCallback
 *
 *****************************************************************************/
OSAL_tpfCallback videomanager_tclServiceVdmSrvIf::vStateTimer(tVoid *pArg)
{
	(tVoid)pArg;
	ETG_TRACE_USR1(("videomanager_tclServiceVdmSrvIf::vStateTimer() --> timeout detected! INDEX = %d",_poMyStaticRef->_s32TimerIndex));

	// if we are here we detected a timeout but we need to handle the new source anyway
	if(_poMyStaticRef->_bIsAlreadyAcknowledged == false)
	{
		videomanager_fi_tcl_e8_vdmVideoSource videosource;
		videosource.enType = (videomanager_fi_tcl_e8_vdmVideoSource::tenType)_poMyStaticRef->sourceTBA.source;
		videomanager_fi_tcl_e8_vdmSourceState videostate;
		videostate.enType = (videomanager_fi_tcl_e8_vdmSourceState::tenType)_poMyStaticRef->sourceTBA.state;

		std::string sourcename(_poMyStaticRef->sourceNames[videosource.enType]);
		std::string statename(_poMyStaticRef->stateNames[videostate.enType]);
		//char *timerIndex = itoa(_poMyStaticRef->_s32TimerIndex);
		std::string myIndex(std::to_string(_poMyStaticRef->_s32TimerIndex));
		std::string myString;
	    myString = "::: TIMEOUT WILL HANDLE ACKNOWLEDGEMENT WITH SOURCE " + sourcename + " IN STATE " + statename + " FOR INDEX " +myIndex+ " :::";
		ETG_TRACE_USR4(("%s",myString.c_str()));
		// we acknowledging the outstanding acknowledgment by calling with values are already known
		_poMyStaticRef->onAcknowledgeStateMStart(videosource,videostate);
	}
	_poMyStaticRef->_bIsAlreadyAcknowledged = true;
	_poMyStaticRef->setVideomanagerWaiting(false);
	_poMyStaticRef->_bTimerIsRunning = false;
	if(_poMyStaticRef->_bVectorHasEntriesChecking == false)
	{
	    _poMyStaticRef->vRequestVectorHasEntries();
	}
	_poMyStaticRef->_bVectorHasEntriesChecking = false;
	return (0);
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrvIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'videomanager_ServiceVdmSrvIf.h':
*     Add forward declaration:
*         class Ifc_vdm_app_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_vdm_app_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_vdm_app_tclObject2Get*>(_cpoMain->getHandler("Ifc_vdm_app_tclObject2Get"));
*     VDMSRV_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrvIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Ivideomanager_tclServiceVdmSrv*>(_cpoMain->getHandler("Ivideomanager_tclServiceVdmSrv"));

   VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // videomanager_tclServiceVdmSrvIfvGetReferences: user specific code start
   _poLookupTable = dynamic_cast<videomanager_lookuptable*>(_cpoMain->getHandler("videomanager_lookuptable"));
   // videomanager_tclServiceVdmSrvIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrvIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrvIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vStartCommunication() entered."));
   // videomanager_tclServiceVdmSrvIfvStartCommunication: user specific code start
   // videomanager_tclServiceVdmSrvIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrvIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrvIf::vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(videomanager_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // videomanager_tclServiceVdmSrvIfvHandleMessage: user specific code start
   // videomanager_tclServiceVdmSrvIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrvIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrvIf::vHandleTraceMessage(const tUChar* puchData)
{
   VIDEOMANAGER_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // videomanager_tclServiceVdmSrvIfvHandleTraceMessage: user specific code start
   // videomanager_tclServiceVdmSrvIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrvIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrvIf::vTraceInfo()
{
   // videomanager_tclServiceVdmSrvIfvTraceInfo: user specific code start
   // videomanager_tclServiceVdmSrvIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrvIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrvIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::onServiceAvailable() entered."));

   // videomanager_tclServiceVdmSrvIfvOnServiceAvailable: user specific code start
   // videomanager_tclServiceVdmSrvIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclServiceVdmSrvIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid videomanager_tclServiceVdmSrvIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::onServiceUnavailable() entered."));

   // videomanager_tclServiceVdmSrvIfvOnServiceUnavailable: user specific code start
   // videomanager_tclServiceVdmSrvIfvOnServiceUnavailable: user specific code end
}

tBool videomanager_tclServiceVdmSrvIf::onRVCASet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onRVCASet: user specific code start
   // onRVCASet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrvIf::onRVCDSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onRVCDSet: user specific code start
   // onRVCDSet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrvIf::onDTVSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onDTVSet: user specific code start
   // onDTVSet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrvIf::onSPCXSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onSPCXSet: user specific code start
   // onSPCXSet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrvIf::onDVDSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onDVDSet: user specific code start
   // onDVDSet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrvIf::onUSBSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onUSBSet: user specific code start
   // onUSBSet: user specific code end
   return _bResult;
}
tBool videomanager_tclServiceVdmSrvIf::onDeserializerUsedBySet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onDeserializerUsedBySet: user specific code start
   // onDeserializerUsedBySet: user specific code end
   return _bResult;
}

tVoid videomanager_tclServiceVdmSrvIf::onRequestVideoSourceStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmRequestedSourceState tRequestedState) {

    // onRequestVideoSourceStateMStart: user specific code start
	std::string sourcename(sourceNames[tVideoSource.enType]);
	std::string statename(requestNames[tRequestedState.enType]);
	std::string myString;
	myString = "videomanager_tclServiceVdmSrvIf::onRequestVideoSourceStateMStart() entered with source " + sourcename + " and state " + statename;

	ETG_TRACE_USR4(("%s",myString.c_str()));

	if(isVideomanagerWaiting() == false)
	{
		setVideomanagerWaiting(true);
		/*
		 * Check for activation of sources
		 */

		// protect the following sequence with semaphore
		vEnterCriticalSection("onRequestVideoSourceStateMStart");

		if(tRequestedState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN) sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE;
		else if(tRequestedState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE) sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE;

		std::string sourceName(sourceNames[_poLookupTable->gets8NumOfActiveVideoSource()]);
		ETG_TRACE_USR4(("Current running source is %s",sourceName.c_str()));

		sourceTBA.source = tVideoSource.enType;
		_poLookupTable->setS8NumOfRequestingSource(tVideoSource.enType);
		_bIsAlreadyAcknowledged = false;

		switch(tVideoSource.enType)
		{

		//===========================
		//       NONE ==> Reset FI
		//===========================
		case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE:
			if(tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE)
			{
				vResetFI();
				return;
			}
			break;

		//===================
		//       RVCA
		//===================
		case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA:
			if(tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE)
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("RVCA ACTIVE WITH INDEX %d",_s32TimerIndex));

				if(_poLookupTable->bSourceChangeApproved(_poLookupTable->eRVCA) == true)
				{
					//vStartVideoSourceTimer(u32TimeoutDuration);

					// check if any other source is running
					if (_poLookupTable->gets8NumOfActiveVideoSource() != videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE)
					{
						// check if DTV is running
						if (_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV)
						{
							ETG_TRACE_USR4(("Switching from DTV -----> RVCA, setting DTV to RESTRICTED"));

							_poLookupTable->setS8NumOfSourceWhileRvc(_poLookupTable->eDTV);
							videomanager_fi_tcl_e8_vdmSourceState StateInfo;
							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
							sourceTBA.source = _poLookupTable->gets8NumOfActiveVideoSource();
							sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;

							sendDTVStatus(StateInfo);

							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
							sendSPCXStatus(StateInfo);
							sendDVDStatus(StateInfo);
							sendUSBStatus(StateInfo);
						}

						else if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX)
						{
							ETG_TRACE_USR4(("Switching from SPCX -----> RVCA, setting SPCX to RESTRICTED"));

							_poLookupTable->setS8NumOfSourceWhileRvc(_poLookupTable->eSPCX);
							videomanager_fi_tcl_e8_vdmSourceState StateInfo;
							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
							sourceTBA.source = _poLookupTable->gets8NumOfActiveVideoSource();
							sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;

							sendSPCXStatus(StateInfo);

							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
							sendDTVStatus(StateInfo);
							sendDVDStatus(StateInfo);
							sendUSBStatus(StateInfo);
						}

						else if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD)
						{
							ETG_TRACE_USR4(("Switching from DVD -----> RVCA, setting DVD to RESTRICTED"));

							_poLookupTable->setS8NumOfSourceWhileRvc(_poLookupTable->eDVD);
							videomanager_fi_tcl_e8_vdmSourceState StateInfo;
							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
							sourceTBA.source = _poLookupTable->gets8NumOfActiveVideoSource();
							sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;

							sendDVDStatus(StateInfo);

							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
							sendDTVStatus(StateInfo);
							sendSPCXStatus(StateInfo);
							sendUSBStatus(StateInfo);
						}
						else if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB)
						{
							ETG_TRACE_USR4(("Switching from USB -----> RVCA, setting USB to RESTRICTED"));

							_poLookupTable->setS8NumOfSourceWhileRvc(_poLookupTable->eUSB);
							videomanager_fi_tcl_e8_vdmSourceState StateInfo;
							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
							sourceTBA.source = _poLookupTable->gets8NumOfActiveVideoSource();
							sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;

							sendUSBStatus(StateInfo);

							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
							sendDTVStatus(StateInfo);
							sendDVDStatus(StateInfo);
							sendSPCXStatus(StateInfo);
						}
					}
					else
					{
					   if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA) vActivateRVCA();
					   videomanager_fi_tcl_e8_vdmSourceState StateInfo;
					   StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
					   sendDTVStatus(StateInfo);
					   sendDVDStatus(StateInfo);
					   sendSPCXStatus(StateInfo);
					   sendUSBStatus(StateInfo);
					}
				}
			}
			else if((tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE) &&
					(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA))
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("RVCA INACTIVE WITH INDEX %d",_s32TimerIndex));
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA);
			}

			break;
		//===================
		//       RVCD
		//===================
		case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD:
			if(tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE)
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("RVCD ACTIVE WITH INDEX %d",_s32TimerIndex));

				if(_poLookupTable->bSourceChangeApproved(_poLookupTable->eRVCD) == true)
				{

					// check if any other source is running
					if (_poLookupTable->gets8NumOfActiveVideoSource() != videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE)
					{
						// check if DTV is running
						if (_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV)
						{
							ETG_TRACE_USR4(("Switching from DTV -----> RVCD, setting DTV to RESTRICTED"));

							_poLookupTable->setS8NumOfSourceWhileRvc(_poLookupTable->eDTV);
							videomanager_fi_tcl_e8_vdmSourceState StateInfo;
							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
							sourceTBA.source = _poLookupTable->gets8NumOfActiveVideoSource();
							sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;

							sendDTVStatus(StateInfo);

							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
							sendSPCXStatus(StateInfo);
							sendDVDStatus(StateInfo);
							sendUSBStatus(StateInfo);
						}

						else if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX)
						{
							ETG_TRACE_USR4(("Switching from SPCX -----> RVCD, setting SPCX to RESTRICTED"));

							_poLookupTable->setS8NumOfSourceWhileRvc(_poLookupTable->eSPCX);
							videomanager_fi_tcl_e8_vdmSourceState StateInfo;
							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
							sourceTBA.source = _poLookupTable->gets8NumOfActiveVideoSource();
							sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;

							sendSPCXStatus(StateInfo);

							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
							sendDTVStatus(StateInfo);
							sendDVDStatus(StateInfo);
							sendUSBStatus(StateInfo);
						}

						else if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD)
						{
							ETG_TRACE_USR4(("Switching from DVD -----> RVCD, setting DVD to RESTRICTED"));

							_poLookupTable->setS8NumOfSourceWhileRvc(_poLookupTable->eDVD);
							videomanager_fi_tcl_e8_vdmSourceState StateInfo;
							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
							sourceTBA.source = _poLookupTable->gets8NumOfActiveVideoSource();
							sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;

							sendDVDStatus(StateInfo);

							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
							sendDTVStatus(StateInfo);
							sendSPCXStatus(StateInfo);
							sendUSBStatus(StateInfo);
						}
						else if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB)
						{
							ETG_TRACE_USR4(("Switching from USB -----> RVCD, setting USB to RESTRICTED"));

							_poLookupTable->setS8NumOfSourceWhileRvc(_poLookupTable->eUSB);
							videomanager_fi_tcl_e8_vdmSourceState StateInfo;
							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
							sourceTBA.source = _poLookupTable->gets8NumOfActiveVideoSource();
							sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;

							sendUSBStatus(StateInfo);

							StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
							sendDTVStatus(StateInfo);
							sendDVDStatus(StateInfo);
							sendSPCXStatus(StateInfo);
						}
					}
					else
					{
						if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD) vActivateRVCD();
						videomanager_fi_tcl_e8_vdmSourceState StateInfo;
						StateInfo.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
						sendDTVStatus(StateInfo);
						sendDVDStatus(StateInfo);
						sendSPCXStatus(StateInfo);
						sendUSBStatus(StateInfo);
					}
				}
			}
			else if((tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE) &&
					(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD))
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("RVCD INACTIVE WITH INDEX %d",_s32TimerIndex));
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD);
			}

			break;
		//===================
		//       DTV
		//===================
		case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV:
			if(tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE)
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("DTV ACTIVE WITH INDEX %d",_s32TimerIndex));

				if(_poLookupTable->bSourceChangeApproved(_poLookupTable->eDTV) == true)
				{
					if (_poLookupTable->gets8NumOfActiveVideoSource() != videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE)
					{
						 vDeactivateSource(_poLookupTable->gets8NumOfActiveVideoSource());
					}
					else
					{
						 if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV) vActivateDTV();
					}
				}

				// FIX for NCG3D-107421 ==> Set Prio2 source to "Restricted" if started while RVC is running
				else if ((_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA) ||
						 (_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD))
				{
					s8DeactivateRestrictedSources();

					ETG_TRACE_USR4(("Request DTV while RVC is active ==> set DTV to RESTRICTED"));
					videomanager_fi_tcl_e8_vdmSourceState state;
					state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
					sendDTVStatus(state);
					sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV;
					sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
				//	vStartVideoSourceTimer(u32TimeoutDuration); ==> do not start timer twice
					_poLookupTable->setS8NumOfSourceWhileRvc((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV);
				}
			}
			else if((tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE) &&
					(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV))
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("DTV INACTIVE WITH INDEX %d",_s32TimerIndex));
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV);
			}
			break;
		//===================
		//       SPCX
		//===================
		case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX:
			if(tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE)
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("SPCX ACTIVE WITH INDEX %d",_s32TimerIndex));

				if(_poLookupTable->bSourceChangeApproved(_poLookupTable->eSPCX) == true)
				{
					if (_poLookupTable->gets8NumOfActiveVideoSource() != videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE)
					{
						 vDeactivateSource(_poLookupTable->gets8NumOfActiveVideoSource());
					}
					else
					{
						 if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX) vActivateSPCX();
					}
				}
				// FIX for NCG3D-107421 ==> Set Prio2 source to "Restricted" if started while RVC is running
				else if ((_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA) ||
						 (_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD))
				{
					s8DeactivateRestrictedSources();

					ETG_TRACE_USR4(("Request SPCX while RVC is active ==> set SPCX to RESTRICTED"));
					videomanager_fi_tcl_e8_vdmSourceState state;
					state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
					sendSPCXStatus(state);
					sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX;
					sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
					//vStartVideoSourceTimer(u32TimeoutDuration); ==> do not start timer twice
					_poLookupTable->setS8NumOfSourceWhileRvc((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX);
				}
				else if ((_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA) ||
						 (_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD))
				{
					ETG_TRACE_USR4(("Request SPCX while RVC is active ==> storing request"));
					setS8NumberOfSourceToBeStored(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX);
				}
			}
			else if((tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE) &&
					(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX))
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("SPCX INACTIVE WITH INDEX %d",_s32TimerIndex));
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX);
			}
			break;
		//===================
		//       DVD
		//===================
		case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD:
			if(tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE)
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("DVD ACTIVE WITH INDEX %d",_s32TimerIndex));

				if(_poLookupTable->bSourceChangeApproved(_poLookupTable->eDVD) == true)
				{
					if (_poLookupTable->gets8NumOfActiveVideoSource() != videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE)
					{
						 vDeactivateSource(_poLookupTable->gets8NumOfActiveVideoSource());
					}
					else
					{
						 if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD) vActivateDVD();
					}
				}
				// FIX for NCG3D-107421 ==> Set Prio2 source to "Restricted" if started while RVC is running
				else if ((_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA) ||
						 (_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD))
				{

					s8DeactivateRestrictedSources();

					ETG_TRACE_USR4(("Request DVD while RVC is active ==> set DVD to RESTRICTED"));
					videomanager_fi_tcl_e8_vdmSourceState state;
					state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
					sendDVDStatus(state);
					sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD;
					sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
					//vStartVideoSourceTimer(u32TimeoutDuration); ==> do not start timer twice
					_poLookupTable->setS8NumOfSourceWhileRvc((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD);
				}
			}
			else if((tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE) &&
					(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD))
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("DVD INACTIVE WITH INDEX %d",_s32TimerIndex));
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD);
			}
			break;
		//===================
		//       USB
		//===================
		case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB:
			if(tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE)
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("USB ACTIVE WITH INDEX %d",_s32TimerIndex));

				if(_poLookupTable->bSourceChangeApproved(_poLookupTable->eUSB) == true)
				{
					if (_poLookupTable->gets8NumOfActiveVideoSource() != videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE)
					{
						 vDeactivateSource(_poLookupTable->gets8NumOfActiveVideoSource());
					}
					else
					{
						 if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB) vActivateUSB();
					}
				}
				// FIX for NCG3D-107421 ==> Set Prio2 source to "Restricted" if started while RVC is running
				else if ((_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA) ||
						 (_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD))
				{
					s8DeactivateRestrictedSources();

					ETG_TRACE_USR4(("Request USB while RVC is active ==> set USB to RESTRICTED"));
					videomanager_fi_tcl_e8_vdmSourceState state;
					state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
					sendUSBStatus(state);
					sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB;
					sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
					//vStartVideoSourceTimer(u32TimeoutDuration); ==> do not start timer twice
					_poLookupTable->setS8NumOfSourceWhileRvc((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB);
				}
			}
			else if((tRequestedState.enType == videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE) &&
					(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB))
			{
				vStartVideoSourceTimer(u32TimeoutDuration);
				_bTimerIsRunning = true;
				_s32TimerIndex++;
				ETG_TRACE_USR4(("USB INACTIVE WITH INDEX %d",_s32TimerIndex));
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB);
			}
			break;
		default:
			break;
		}
		ETG_TRACE_USR4(("-----------------------------------------------"));
		ETG_TRACE_USR4(("---  Current state after REQUEST of source  ---"));
		ETG_TRACE_USR4(("-----------------------------------------------"));
		vPrintCurrentStatus();

		_bIsAlreadyAcknowledged = false;

		sourceToBeAcknowledged.tVideoSource = tVideoSource;
		sourceToBeAcknowledged.s8RequestedState = sourceTBA.state;

		// release semaphore
		vReleaseCriticalSection("onRequestVideoSourceStateMStart");
	}

	//==================================
	// Handle request vector
	//==================================
	// check if videomanager is waiting for processing requests, add the next request to vector
	else if ((isVideomanagerWaiting() == true) && (tVideoSource.enType > 0))
	{
		ETG_TRACE_USR4(("Request cannot be processed, will be checked to be added to message queue"));

		std::string sourcename(sourceNames[tVideoSource.enType]);
		std::string statename(requestNames[tRequestedState.enType]);
		std::string myString;
		myString = "Checking for " +sourcename+" with state "+statename+" to be added to request vector";
		ETG_TRACE_USR4(("%s",myString.c_str()));


		_sRequestsToBeProcessed request;
		request.tVideoSource = tVideoSource;
		request.tRequestedState = tRequestedState;

		// if vector is empty
		if (_vRequestVector.empty())
		{
			// add entry to vector
			_vRequestVector.push_back(request);
		}
		// if vector is not empty
		else
		{
			// read vector size and set i to last entry
			int i = _vRequestVector.size() - 1;

			// limit vector to a size of 4 entries maximal, ignore more
			if( i < 4 )
			{
				// if new entry is different from already set entry (store only once!!!)
				if((_vRequestVector[i].tVideoSource.enType != request.tVideoSource.enType) ||
				   (_vRequestVector[i].tRequestedState.enType != request.tRequestedState.enType))
				{
					bool bHasBeenDeleted = false;

					// eliminate DVD -> active and next entry is DVD -> inactive, delete both
					// check if more than one entry
					if(_vRequestVector.size() > 0)
					{
						// go through the vector and remove active / inactive for same source
						for(int j=0 ; j<_vRequestVector.size() ; j++)
						{
							if((_vRequestVector[j].tVideoSource.enType == request.tVideoSource.enType) &&
							   (_vRequestVector[j].tRequestedState.enType != request.tRequestedState.enType))
							{
								std::string sourcename(sourceNames[_vRequestVector[j].tVideoSource.enType]);
								std::string statename(requestNames[_vRequestVector[j].tRequestedState.enType]);
								std::string myString;
								myString = "DELETING VECTOR ENTRY " +sourcename+"     |     "+statename;
								ETG_TRACE_USR4(("%s",myString.c_str()));

							    _vRequestVector.erase(_vRequestVector.begin()+j);
							    bHasBeenDeleted = true;
							    break;
							}
						}
					}

					// if a request from RVC is coming add this entry to front
					if((request.tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA) ||
					   (request.tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD))
					{
					    _vRequestVector.insert(_vRequestVector.begin(),request);
					}
					else
					{
					    // add entry at the end of the vector if no deletion has been done
						if(bHasBeenDeleted == false) _vRequestVector.push_back(request);
					}
				}
			}
		}


		ETG_TRACE_USR4(("###         VECTOR START        ###"));
		for (int i=0 ; i < _vRequestVector.size(); i++)
		{
			std::string sourcename(sourceNames[_vRequestVector[i].tVideoSource.enType]);
			std::string statename(requestNames[_vRequestVector[i].tRequestedState.enType]);
			std::string myString;
			myString = "###      " +sourcename+"     |     "+statename+"     |###";
			ETG_TRACE_USR4(("%s",myString.c_str()));
		}
		ETG_TRACE_USR4(("###          VECTOR END           ###"));
	}

   // onRequestVideoSourceStateMStart: user specific code end
}

tVoid videomanager_tclServiceVdmSrvIf::onRequestAccessToDeserializerMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource) {

   // onRequestAccessToDeserializerMStart: user specific code start
   // onRequestAccessToDeserializerMStart: user specific code end
}

tVoid videomanager_tclServiceVdmSrvIf::onAcknowledgeStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmSourceState tVideoState) {

    // onAcknowledgeStateMStart: user specific code start
	std::string sourcename(sourceNames[tVideoSource.enType]);
	std::string statename(stateNames[tVideoState.enType]);

	std::string myString;
	myString = "videomanager_tclServiceVdmSrvIf::onAcknowledgeStateMStart() entered with source " + sourcename + " and state " + statename;

	ETG_TRACE_USR4(("%s",myString.c_str()));

	// protect sequence with semaphore
	vEnterCriticalSection("onAcknowledgeStateMStart");

	//setVideomanagerWaiting(false);
	_bIsAlreadyAcknowledged = true;

	//==========================================================
	// Check if the current acknowledgment fits to last request
	//==========================================================
	if(((tS8)tVideoSource.enType == sourceTBA.source) && ((tS8)tVideoState.enType == sourceTBA.state))
	{

		ETG_TRACE_USR4(("Current acknowledgement fits to sourceTBA"));

		//========================
        // check for source change
		//========================
		if((sourceTBA.state == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE) &&
		   (_poLookupTable->getS8NumOfRequestingSoure() != sourceTBA.source))
		{
		    if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA)
		    {
		    	ETG_TRACE_USR4(("Source change: Starting RVCA"));
		    	vActivateRVCA();
		    }
		    else if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD)
			{
		    	ETG_TRACE_USR4(("Source change: Starting RVCD"));
				vActivateRVCD();
			}
		    else if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV)
			{
		    	ETG_TRACE_USR4(("Source change: Starting DTV"));
				vActivateDTV();
			}
		    else if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX)
			{
		    	ETG_TRACE_USR4(("Source change: Starting SPCX"));
				vActivateSPCX();
			}
		    else if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD)
			{
		    	ETG_TRACE_USR4(("Source change: Starting DVD"));
				vActivateDVD();
			}
		    else if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB)
			{
		    	ETG_TRACE_USR4(("Source change: Starting USB"));
				vActivateUSB();
			}
		}

		//================================================================
		// if RESTRICTED is acknowledged (received), activate RVCA or RVCD
		//================================================================

		if ((_poLookupTable->getS8NumOfSourceWhileRvc() == tVideoSource.enType) &&
		    (tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED))
		{
			ETG_TRACE_USR4(("RESTRICTED acknowledged, starting high prio source"));
			if(_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA) vActivateRVCA();
			else if (_poLookupTable->getS8NumOfRequestingSoure() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD) vActivateRVCD();
		}

		//===============================================================
		// ((RVCA || RVCD) && (INACTIVE || UNKNOWN))
		// ===> RVCA or RVCD shutting down
		// check who is currently restricted and reactivate this
		//===============================================================

		else if (((tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA)    ||
				  (tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD))   &&
				 ((tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE) ||
			      (tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN)))
		{
			ETG_TRACE_USR4(("Check status for Prio 2 sources if they need to be reactivated (currently RESTRICTED)"));

			//=====
			// DTV
			//=====
			videomanager_mainfi_tclMsgDTVStatus dtvStatus;
			_poServerRef->vGetDTVMsg(dtvStatus);
			tU8 dtvState = dtvStatus.DTV_StateInfo.enType;

			if(dtvState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
			{
				ETG_TRACE_USR4(("Reactivate DTV"));
				vActivateDTV();
			}

			//======
			// SPCX
			//======
			videomanager_mainfi_tclMsgSPCXStatus spcxStatus;
			_poServerRef->vGetSPCXMsg(spcxStatus);
			tU8 spcxState = spcxStatus.SPCX_StateInfo.enType;

			if(spcxState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
			{
   				ETG_TRACE_USR4(("Reactivate SPCX"));
			    vActivateSPCX();
			}

			//=====
			// DVD
			//=====
			videomanager_mainfi_tclMsgDVDStatus dvdStatus;
			_poServerRef->vGetDVDMsg(dvdStatus);
			tU8 dvdState = dvdStatus.DVD_StateInfo.enType;

			if(dvdState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
			{
			    ETG_TRACE_USR4(("Reactivate DVD"));
				vActivateDVD();
			}

			//=====
			// USB
			//=====
			videomanager_mainfi_tclMsgUSBStatus usbStatus;
			_poServerRef->vGetUSBMsg(usbStatus);
			tU8 usbState = usbStatus.USB_StateInfo.enType;

			if(usbState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
			{
				ETG_TRACE_USR4(("Reactivate USB"));
				vActivateUSB();
			}

			// reset numOfSourceWhileRVC to 0
			_poLookupTable->setS8NumOfSourceWhileRvc((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
		}
		_poLookupTable->setS8NumOfRequestingSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
	}

	else ETG_TRACE_USR4(("Current acknowledgement fits NOT to sourceTBA. sourceTBA is %d, source acknowledgement is %d",sourceTBA.source, tVideoState.enType));

	//===============================================================================
	// if RVCA is set to "unknown" (system start) and reports "active" activate RVCA,
	// at "inactive" set to "inactive"
	//===============================================================================

	//======
	// RVCA
	//======
	if(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA)
	{
		// read RVCA state
	    videomanager_mainfi_tclMsgRVCAStatus rvcaStatus;
	    _poServerRef->vGetRVCAMsg(rvcaStatus);
 	    tU8 rvcaState = rvcaStatus.RVCA_StateInfo.enType;

 	    if(rvcaState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN)
 	    {
 	    	if(tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE)
			{
 	    		ETG_TRACE_USR4(("System startup: Set RVCA to active"));
				vActivateRVCA();

				// set all others to blocked
				videomanager_fi_tcl_e8_vdmSourceState state;
				state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
				if (u8GetSourceWithRestrictedState() == 1) state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
				else state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
				sendDTVStatus(state);

				if (u8GetSourceWithRestrictedState() == 2) state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
				else state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
				sendSPCXStatus(state);

				if (u8GetSourceWithRestrictedState() == 3) state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
				else state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
				sendDVDStatus(state);

				if (u8GetSourceWithRestrictedState() == 4) state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
				else state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
				sendUSBStatus(state);

				_poLookupTable->sets8NumOfActiveVideoSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA);
			}
			else if (tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE)
			{
				_poLookupTable->setS8NumOfRequestingSource((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA);
			}
 	    }
	}

	//======
	// RVCD
	//======
	if(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD)
	{
		videomanager_mainfi_tclMsgRVCDStatus rvcdStatus;
	    _poServerRef->vGetRVCDMsg(rvcdStatus);
	    tU8 rvcdState = rvcdStatus.RVCD_StateInfo.enType;

	    if (rvcdState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN)
 	    {
			if(tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE)
			{
				ETG_TRACE_USR4(("System startup: Set RVCD to active"));
				vActivateRVCD();

				// set all others to blocked
				videomanager_fi_tcl_e8_vdmSourceState state;
				state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
				if (u8GetSourceWithRestrictedState() == 1) state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
				else state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
				sendDTVStatus(state);

				if (u8GetSourceWithRestrictedState() == 2) state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
				else state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
				sendSPCXStatus(state);

				if (u8GetSourceWithRestrictedState() == 3) state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
				else state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
				sendDVDStatus(state);

				if (u8GetSourceWithRestrictedState() == 4) state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED;
				else state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED;
				sendUSBStatus(state);

				_poLookupTable->sets8NumOfActiveVideoSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD);
			}
			else if (tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE)
			{
				_poLookupTable->setS8NumOfRequestingSource((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD);
			}
 	    }
	}

	//======
	// DTV
	//======
	if(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV)
	{
		videomanager_mainfi_tclMsgDTVStatus dtvStatus;
		_poServerRef->vGetDTVMsg(dtvStatus);
		tU8 dtvState = dtvStatus.DTV_StateInfo.enType;

		if(dtvState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN)
 	    {
			if(tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE)
			{
				ETG_TRACE_USR4(("System startup: Set DTV to active"));
				vActivateDTV();
				_poLookupTable->sets8NumOfActiveVideoSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV);
			}
			else if (tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE)
			{
				_poLookupTable->setS8NumOfRequestingSource((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV);
			}
 	    }
	}

	//======
	// SPCX
	//======
	if(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX)
	{
		videomanager_mainfi_tclMsgSPCXStatus spcxStatus;
		_poServerRef->vGetSPCXMsg(spcxStatus);
		tU8 spcxState = spcxStatus.SPCX_StateInfo.enType;

		if(spcxState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN)
 	    {
			if(tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE)
			{
				ETG_TRACE_USR4(("System startup: Set SPCX to active"));
				vActivateSPCX();
				_poLookupTable->sets8NumOfActiveVideoSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX);
			}
			else if (tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE)
			{
				_poLookupTable->setS8NumOfRequestingSource((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX);
			}
 	    }
	}

	//======
	// DVD
	//======
	if(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD)
	{
		videomanager_mainfi_tclMsgDVDStatus dvdStatus;
		_poServerRef->vGetDVDMsg(dvdStatus);
		tU8 dvdState = dvdStatus.DVD_StateInfo.enType;

		if(dvdState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN)
 	    {
			if(tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE)
			{
				ETG_TRACE_USR4(("System startup: Set DVD to active"));
				vActivateDVD();
				_poLookupTable->sets8NumOfActiveVideoSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD);
			}
			else if (tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE)
			{
				_poLookupTable->setS8NumOfRequestingSource((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD);
			}
 	    }
	}

	//======
	// USB
	//======
	if(tVideoSource.enType == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB)
	{
		videomanager_mainfi_tclMsgUSBStatus usbStatus;
		_poServerRef->vGetUSBMsg(usbStatus);
		tU8 usbState = usbStatus.USB_StateInfo.enType;

		if(usbState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN)
 	    {
			if(tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE)
			{
				ETG_TRACE_USR4(("System startup: Set USB to active"));
				vActivateUSB();
				_poLookupTable->sets8NumOfActiveVideoSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB);
			}
			else if (tVideoState.enType == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE)
			{
				_poLookupTable->setS8NumOfRequestingSource((tS8)videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
				vDeactivateSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB);
			}
 	    }
	}

	//_poLookupTable->setS8NumOfRequestingSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);

	vCheckForResetOfActiveSource();

	// print current status
	ETG_TRACE_USR4(("---------------------------------------------------"));
	ETG_TRACE_USR4(("---  Current state after ACKNOWLEDGE of source  ---"));
	ETG_TRACE_USR4(("---------------------------------------------------"));
	vPrintCurrentStatus();

	setVideomanagerWaiting(false);

	_bTimerIsRunning = false;

	// release semaphore
	vReleaseCriticalSection("onAcknowledgeStateMStart");

	_bVectorHasEntriesChecking = true;
	vRequestVectorHasEntries();
   // onAcknowledgeStateMStart: user specific code end
}

tVoid videomanager_tclServiceVdmSrvIf::sendRVCAStatus(videomanager_fi_tcl_e8_vdmSourceState RVCA_StateInfo) {
    //just forward send request
    VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendRVCAStatus(RVCA_StateInfo);
}

tVoid videomanager_tclServiceVdmSrvIf::sendRVCDStatus(videomanager_fi_tcl_e8_vdmSourceState RVCD_StateInfo) {
    //just forward send request
    VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendRVCDStatus(RVCD_StateInfo);
}

tVoid videomanager_tclServiceVdmSrvIf::sendDTVStatus(videomanager_fi_tcl_e8_vdmSourceState DTV_StateInfo) {
    //just forward send request
    VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDTVStatus(DTV_StateInfo);
}

tVoid videomanager_tclServiceVdmSrvIf::sendSPCXStatus(videomanager_fi_tcl_e8_vdmSourceState SPCX_StateInfo) {
    //just forward send request
    VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSPCXStatus(SPCX_StateInfo);
}

tVoid videomanager_tclServiceVdmSrvIf::sendDVDStatus(videomanager_fi_tcl_e8_vdmSourceState DVD_StateInfo) {
    //just forward send request
    VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDVDStatus(DVD_StateInfo);
}

tVoid videomanager_tclServiceVdmSrvIf::sendUSBStatus(videomanager_fi_tcl_e8_vdmSourceState USB_StateInfo) {
    //just forward send request
    VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendUSBStatus(USB_StateInfo);
}

tVoid videomanager_tclServiceVdmSrvIf::sendDeserializerUsedByStatus(videomanager_fi_tcl_e8_vdmVideoSource Deserializer_SourceInfo) {
    //just forward send request
    VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDeserializerUsedByStatus(Deserializer_SourceInfo);
}

tVoid videomanager_tclServiceVdmSrvIf::sendRequestVideoSourceStateMResult(tBool bSourceChangeGranted) {
    //just forward send request
    VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendRequestVideoSourceStateMResult(bSourceChangeGranted);
}

tVoid videomanager_tclServiceVdmSrvIf::sendRequestAccessToDeserializerMResult(tBool bAccessIsGranted) {
    //just forward send request
    VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendRequestAccessToDeserializerMResult(bAccessIsGranted);
}

tVoid videomanager_tclServiceVdmSrvIf::sendAcknowledgeStateMResult() {
    //just forward send request
    VIDEOMANAGER_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAcknowledgeStateMResult();
}

// videomanager_tclServiceVdmSrvIfvideomanager_ServiceVdmSrvIf: user specific code start

/*******************************************************************************
*
* FUNCTION:    vRequestVectorHasEntries
*
* DESCRIPTION: checks if our message queue contains some requests
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vRequestVectorHasEntries()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::bRequestVectorHasEntries() entered"));

	if(_vRequestVector.size() > 0)
	{
		int i = _vRequestVector.size() - 1;
		std::string sourcename(sourceNames[_vRequestVector[i].tVideoSource.enType]);
		std::string statename(requestNames[_vRequestVector[i].tRequestedState.enType]);
		std::string myString;
		myString = "RequestVector sends source" +sourcename+" with state "+statename+" for requesting";
		ETG_TRACE_USR4(("%s",myString.c_str()));

		setVideomanagerWaiting(false);
		onRequestVideoSourceStateMStart(_vRequestVector.front().tVideoSource,_vRequestVector.front().tRequestedState);
		_vRequestVector.erase(_vRequestVector.begin());
	}
}

/*******************************************************************************
*
* FUNCTION:    vCheckForResetOfActiveSource
*
* DESCRIPTION: checks if no source is active and set "activeSource" to 0
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vCheckForResetOfActiveSource()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vCheckForResetOfActiveSource() entered"));

	bool bIsSourceStillActive = false;

	//======
	// RVCA
	//======
	videomanager_mainfi_tclMsgRVCAStatus rvcaStatus;
	_poServerRef->vGetRVCAMsg(rvcaStatus);
	tU8 rvcaState = rvcaStatus.RVCA_StateInfo.enType;
	if(rvcaState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE) bIsSourceStillActive = true;

	//======
	// RVCD
	//======
	videomanager_mainfi_tclMsgRVCDStatus rvcdStatus;
	_poServerRef->vGetRVCDMsg(rvcdStatus);
	tU8 rvcdState = rvcdStatus.RVCD_StateInfo.enType;
	if(rvcdState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE) bIsSourceStillActive = true;

	//======
	// DTV
	//======
	videomanager_mainfi_tclMsgDTVStatus dtvStatus;
	_poServerRef->vGetDTVMsg(dtvStatus);
	tU8 dtvState = dtvStatus.DTV_StateInfo.enType;
	if(dtvState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE) bIsSourceStillActive = true;

	//======
	// SPCX
	//======
	videomanager_mainfi_tclMsgSPCXStatus spcxStatus;
	_poServerRef->vGetSPCXMsg(spcxStatus);
	tU8 spcxState = spcxStatus.SPCX_StateInfo.enType;
	if(spcxState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE) bIsSourceStillActive = true;

	//======
	// DVD
	//======
	videomanager_mainfi_tclMsgDVDStatus dvdStatus;
	_poServerRef->vGetDVDMsg(dvdStatus);
	tU8 dvdState = dvdStatus.DVD_StateInfo.enType;
	if(dvdState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE) bIsSourceStillActive = true;

	//======
	// USB
	//======
	videomanager_mainfi_tclMsgUSBStatus usbStatus;
	_poServerRef->vGetUSBMsg(usbStatus);
	tU8 usbState = usbStatus.USB_StateInfo.enType;
	if(usbState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE) bIsSourceStillActive = true;

	if(bIsSourceStillActive == false)
	{
		_poLookupTable->sets8NumOfActiveVideoSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
	}

}

/*******************************************************************************
*
* FUNCTION:    vActivateRVCA
*
* DESCRIPTION: activates the RVCA device
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vActivateRVCA()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vActivateRVCA() entered"));
    /*
	 * TODO: Start here the procedure to activate the RVCA as needed
	 * use video handler class !!
	 */

	videomanager_fi_tcl_e8_vdmSourceState sourceState;
	sourceState.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE;
	_poLookupTable->sets8NumOfActiveVideoSource(_poLookupTable->eRVCA);
	sendRVCAStatus(sourceState);
}

/*******************************************************************************
*
* FUNCTION:    vActivateRVCD
*
* DESCRIPTION: activates the RVCD device
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vActivateRVCD()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vActivateRVCD() entered"));
    /*
	 * TODO: Start here the procedure to activate the RVCA as needed
	 * use video handler class !!
	 */

	videomanager_fi_tcl_e8_vdmSourceState sourceState;
	sourceState.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE;
	_poLookupTable->sets8NumOfActiveVideoSource(_poLookupTable->eRVCD);
	sendRVCDStatus(sourceState);
}

/*******************************************************************************
*
* FUNCTION:    vActivateDTV
*
* DESCRIPTION: activates the DTV device
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vActivateDTV()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vActivateDTV() entered"));

	/*
	 * TODO: Start here the procedure to activate the DTV as needed
	 * use video handler class !!
	 */

	videomanager_fi_tcl_e8_vdmSourceState sourceState;
	sourceState.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE;
	_poLookupTable->sets8NumOfActiveVideoSource(_poLookupTable->eDTV);
	sendDTVStatus(sourceState);
}

/*******************************************************************************
*
* FUNCTION:    vActivateSPCX
*
* DESCRIPTION: activates the SPCX device
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vActivateSPCX()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vActivateSPCX() entered"));

	/*
	 * TODO: Start here the procedure to activate the SPCX as needed
	 * use video handler class !!
	 */

	videomanager_fi_tcl_e8_vdmSourceState sourceState;
	sourceState.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE;
	_poLookupTable->sets8NumOfActiveVideoSource(_poLookupTable->eSPCX);
	sendSPCXStatus(sourceState);
}

/*******************************************************************************
*
* FUNCTION:    vActivateDVD
*
* DESCRIPTION: activates the DVD device
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vActivateDVD()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vActivateDVD() entered"));

	/*
	 * TODO: Start here the procedure to activate the DVD as needed
	 * use video handler class !!
	 */

	videomanager_fi_tcl_e8_vdmSourceState sourceState;
	sourceState.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE;
	_poLookupTable->sets8NumOfActiveVideoSource(_poLookupTable->eDVD);
	sendDVDStatus(sourceState);
}

/*******************************************************************************
*
* FUNCTION:    vActivateUSB
*
* DESCRIPTION: activates the USB device
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vActivateUSB()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vActivateUSB() entered"));

	/*
	 * TODO: Start here the procedure to activate the SPCX as needed
	 * use video handler class !!
	 */

	videomanager_fi_tcl_e8_vdmSourceState sourceState;
	sourceState.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE;
	_poLookupTable->sets8NumOfActiveVideoSource(_poLookupTable->eUSB);
	sendUSBStatus(sourceState);
}

/*******************************************************************************
*
* FUNCTION:    vDectivateSource
*
* DESCRIPTION: deactivates any video source
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vDeactivateSource(tU8 sourceToDeactivate)
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vDeactivateSource() entered with source %s",sourceNames[sourceToDeactivate]));

	videomanager_fi_tcl_e8_vdmSourceState sourceState;
	sourceState.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE;

	videomanager_mainfi_tclMsgDTVStatus dtvStatus;
	_poServerRef->vGetDTVMsg(dtvStatus);
	tU8 dtvState = dtvStatus.DTV_StateInfo.enType;

	videomanager_mainfi_tclMsgSPCXStatus spcxStatus;
	_poServerRef->vGetSPCXMsg(spcxStatus);
	tU8 spcxState = spcxStatus.SPCX_StateInfo.enType;

	videomanager_mainfi_tclMsgDVDStatus dvdStatus;
	_poServerRef->vGetDVDMsg(dvdStatus);
	tU8 dvdState = dvdStatus.DVD_StateInfo.enType;

	videomanager_mainfi_tclMsgUSBStatus usbStatus;
	_poServerRef->vGetUSBMsg(usbStatus);
	tU8 usbState = usbStatus.USB_StateInfo.enType;

	sourceTBA.state = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE;

	switch(sourceToDeactivate)
	{
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA:

		if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA)
		{
		/*
		 * TODO: Deactivate RVCA
		 */
		}
		sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA;
		sendRVCAStatus(sourceState);

		if (dtvState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED) sendDTVStatus(sourceState);
		if (spcxState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED) sendSPCXStatus(sourceState);
		if (dvdState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED) sendDVDStatus(sourceState);
		if (usbState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED) sendUSBStatus(sourceState);

		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD:
		if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD)
		{
		/*
		 * TODO: Deactivate RVCD
		 */
		}
		sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD;
		sendRVCDStatus(sourceState);

		if (dtvState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED) sendDTVStatus(sourceState);
		if (spcxState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED) sendSPCXStatus(sourceState);
		if (dvdState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED) sendDVDStatus(sourceState);
		if (usbState == videomanager_fi_tcl_e8_vdmSourceState::FI_EN_BLOCKED) sendUSBStatus(sourceState);

		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV:
		if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV)
		{
		/*
		 * TODO: Deactivate DTV
		 */
		}
		sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV;
		sendDTVStatus(sourceState);
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX:
		if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX)
		{
		/*
		 * TODO: Deactivate SPCX
		 */
		}
		sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX;
		sendSPCXStatus(sourceState);
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD:
		if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD)
		{
		/*
		 * TODO: Deactivate DVD
		 */
		}
		sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD;
		sendDVDStatus(sourceState);
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB:
		if(_poLookupTable->gets8NumOfActiveVideoSource() == videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB)
		{
		/*
		 * TODO: Deactivate USB
		 */
		}
		sourceTBA.source = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB;
		sendUSBStatus(sourceState);
		break;
	default:
		break;
	}

	// finally set the current source to 0
	ETG_TRACE_USR4(("_poLookupTable->getS8NumOfSourceWhileRvc() IS %d",_poLookupTable->getS8NumOfSourceWhileRvc()));
}

/*******************************************************************************
*
* FUNCTION:    vResetFI
*
* DESCRIPTION: Reset the FI for test purposes
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
tVoid videomanager_tclServiceVdmSrvIf::vResetFI()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vResetFI() entered"));
	videomanager_fi_tcl_e8_vdmSourceState state;
	state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_UNKNOWN;

	sendRVCAStatus(state);
	sendRVCDStatus(state);
	sendDTVStatus(state);
	sendSPCXStatus(state);
	sendDVDStatus(state);
	sendUSBStatus(state);

	_poLookupTable->setS8NumOfRequestingSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
	_poLookupTable->sets8NumOfActiveVideoSource(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);
	_poLookupTable->setS8NumOfSourceWhileRvc(videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE);

	vPrintCurrentStatus();
}

/*******************************************************************************
*
* FUNCTION:    s8DeactivateRestrictedSources
*
* DESCRIPTION: deactivate restricted sources
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::s8DeactivateRestrictedSources()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::s8DeactivateRestrictedSources() entered"));

	videomanager_fi_tcl_e8_vdmSourceState state;
	state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE;

	videomanager_mainfi_tclMsgDTVStatus dtvStatus;
	_poServerRef->vGetDTVMsg(dtvStatus);
	if(dtvStatus.DTV_StateInfo.enType == (tU8)videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
	{
		ETG_TRACE_USR4(("Start timer for DTV : RESTRICTED ==> INACTIVE"));
		sendDTVStatus(state);
		vStartVideoSourceTimer(u32TimeoutDuration);
	}

	videomanager_mainfi_tclMsgSPCXStatus spcxStatus;
	_poServerRef->vGetSPCXMsg(spcxStatus);
	if(spcxStatus.SPCX_StateInfo.enType == (tU8)videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
	{
		ETG_TRACE_USR4(("Start timer for SPCX : RESTRICTED ==> INACTIVE"));
		sendSPCXStatus(state);
		vStartVideoSourceTimer(u32TimeoutDuration);
	}

	videomanager_mainfi_tclMsgDVDStatus dvdStatus;
	_poServerRef->vGetDVDMsg(dvdStatus);
	if(dvdStatus.DVD_StateInfo.enType == (tU8)videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
	{
		ETG_TRACE_USR4(("Start timer for DVD : RESTRICTED ==> INACTIVE"));
		sendDVDStatus(state);
		vStartVideoSourceTimer(u32TimeoutDuration);
	}

	videomanager_mainfi_tclMsgUSBStatus usbStatus;
	_poServerRef->vGetUSBMsg(usbStatus);
	if(usbStatus.USB_StateInfo.enType == (tU8)videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
	{
		ETG_TRACE_USR4(("Start timer for USB : RESTRICTED ==> INACTIVE"));
		sendUSBStatus(state);
		vStartVideoSourceTimer(u32TimeoutDuration);
	}
}

/*******************************************************************************
*
* FUNCTION:    u8GetSourceWithRestrictedState
*
* DESCRIPTION: returns the number of source which is in state "RESTRICTED"
*
* PARAMETER:   n.a.
*
* RETURNVALUE: (tU8) number of source
*
********************************************************************************/
tU8 videomanager_tclServiceVdmSrvIf::u8GetSourceWithRestrictedState()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::u8GetSourceWithRestrictedState() entered"));

	tU8 result = 0;
	videomanager_mainfi_tclMsgDTVStatus dtvStatus;
	_poServerRef->vGetDTVMsg(dtvStatus);
	if(dtvStatus.DTV_StateInfo.enType == (tU8)videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
	{
		return 1;
	}

	videomanager_mainfi_tclMsgSPCXStatus spcxStatus;
	_poServerRef->vGetSPCXMsg(spcxStatus);
	if(spcxStatus.SPCX_StateInfo.enType == (tU8)videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
	{
		return 2;
	}

	videomanager_mainfi_tclMsgDVDStatus dvdStatus;
	_poServerRef->vGetDVDMsg(dvdStatus);
	if(dvdStatus.DVD_StateInfo.enType == (tU8)videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
	{
		return 3;
	}

	videomanager_mainfi_tclMsgUSBStatus usbStatus;
	_poServerRef->vGetUSBMsg(usbStatus);
	if(usbStatus.USB_StateInfo.enType == (tU8)videomanager_fi_tcl_e8_vdmSourceState::FI_EN_RESTRICTED)
	{
		return 4;
	}
	return result;
}

/*******************************************************************************
*
* FUNCTION:    vPrintCurrentStatus
*
* DESCRIPTION: prints out the current state
*
* PARAMETER:   n.a.
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vPrintCurrentStatus()
{
	ETG_TRACE_USR4(("videomanager_tclServiceVdmSrvIf::vPrintCurrentStatus() entered"));
	ETG_TRACE_USR4(("--------------------------------"));

	tS8 s8CurrentSource = _poLookupTable->gets8NumOfActiveVideoSource();
	tS8 s8OldSource = _poLookupTable->getS8NumOfSourceWhileRvc();

	switch(s8CurrentSource)
	{
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE:
		ETG_TRACE_USR4(("There is currently no video source"));
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA:
		ETG_TRACE_USR4(("Current video source is RVCA   "));
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD:
		ETG_TRACE_USR4(("Current video source is RVCD   "));
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV:
		ETG_TRACE_USR4(("Current video source is DTV    "));
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX:
		ETG_TRACE_USR4(("Current video source is SPCX   "));
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD:
		ETG_TRACE_USR4(("Current video source is DVD    "));
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB:
		ETG_TRACE_USR4(("Current video source is USB    "));
		break;
	default:
		break;
	}

	switch(s8OldSource)
	{
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE:
		ETG_TRACE_USR4(("No video source to return to!   "));
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV:
		ETG_TRACE_USR4(("Video source to return to is DTV"));
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX:
		ETG_TRACE_USR4(("Video source to return to is SPCX"));
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD:
		ETG_TRACE_USR4(("Video source to return to is DVD"));
		break;
	case videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB:
		ETG_TRACE_USR4(("Video source to return to is USB"));
		break;
	default:
		break;
	}

	bool bIsActiveSource = false;
	videomanager_mainfi_tclMsgRVCAStatus rvcaStatus;
	_poServerRef->vGetRVCAMsg(rvcaStatus);
	tU8 rvcaState = rvcaStatus.RVCA_StateInfo.enType;

	videomanager_mainfi_tclMsgRVCDStatus rvcdStatus;
	_poServerRef->vGetRVCDMsg(rvcdStatus);
	tU8 rvcdState = rvcdStatus.RVCD_StateInfo.enType;

	videomanager_mainfi_tclMsgDTVStatus dtvStatus;
	_poServerRef->vGetDTVMsg(dtvStatus);
	tU8 dtvState = dtvStatus.DTV_StateInfo.enType;

	videomanager_mainfi_tclMsgSPCXStatus spcxStatus;
	_poServerRef->vGetSPCXMsg(spcxStatus);
	tU8 spcxState = spcxStatus.SPCX_StateInfo.enType;

	videomanager_mainfi_tclMsgDVDStatus dvdStatus;
	_poServerRef->vGetDVDMsg(dvdStatus);
	tU8 dvdState = dvdStatus.DVD_StateInfo.enType;

	videomanager_mainfi_tclMsgUSBStatus usbStatus;
	_poServerRef->vGetUSBMsg(usbStatus);
	tU8 usbState = usbStatus.USB_StateInfo.enType;

	ETG_TRACE_USR4(("--------------------------------"));
	ETG_TRACE_USR4(("        CURRENT FI STATE        "));
	ETG_TRACE_USR4(("================================"));
    ETG_TRACE_USR4(("        RVCA --> %s     ",stateNames[rvcaState]));
	ETG_TRACE_USR4(("        RVCD --> %s     ",stateNames[rvcdState]));
	ETG_TRACE_USR4(("        DTV  --> %s     ",stateNames[dtvState]));
	ETG_TRACE_USR4(("        SPCX --> %s     ",stateNames[spcxState]));
	ETG_TRACE_USR4(("        DVD  --> %s     ",stateNames[dvdState]));
	ETG_TRACE_USR4(("        USB  --> %s     ",stateNames[usbState]));
	ETG_TRACE_USR4(("================================"));
	ETG_TRACE_USR4(("        CURRENT LOOKUP STATE    "));
	ETG_TRACE_USR4((" REQUESTING SOURCE: %s    ",sourceNames[_poLookupTable->getS8NumOfRequestingSoure()]));
	ETG_TRACE_USR4((" RESTRICTED SOURCE: %s    ",sourceNames[_poLookupTable->getS8NumOfSourceWhileRvc()]));
	ETG_TRACE_USR4((" ACTIVE SOURCE    : %s    ",sourceNames[_poLookupTable->gets8NumOfActiveVideoSource()]));
	ETG_TRACE_USR4(("--------------------------------"));

	ETG_TRACE_USR4(("###        VECTOR START       ###"));

	for (int i=0 ; i < _vRequestVector.size(); i++)
	{
		std::string sourcename(sourceNames[_vRequestVector[i].tVideoSource.enType]);
		std::string statename(requestNames[_vRequestVector[i].tRequestedState.enType]);
		std::string myString;
		myString = "###|   " +sourcename+"   |   "+statename+"   |###";
		ETG_TRACE_USR4(("%s",myString.c_str()));
	}
	ETG_TRACE_USR4(("###       VECTOR END          ###"));
}

/*******************************************************************************
*
* FUNCTION:    vEnterCriticalSection
*
* DESCRIPTION: set and start a semaphore for undisturbed execution
*
* PARAMETER:   tCString (String of source who is calling a semaphore)
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vEnterCriticalSection(tCString from)
{
	ETG_TRACE_COMP(("videomanager_tclServiceVdmSrvIf::vEnterCriticalSection: called from %s", from));
	RSE_ASSERT_NORMAL_RETURN(OSAL_C_INVALID_HANDLE != _hDataUpdateSemaphore);
	tS32 s32Err = OSAL_s32SemaphoreWait( _hDataUpdateSemaphore, OSAL_C_TIMEOUT_FOREVER);

	if (OSAL_OK != s32Err) {
		ETG_TRACE_ERR((" vEnterCriticalSection:failed:code=%s", RSE_OsalErrorString() ));
	}
}

/*******************************************************************************
*
* FUNCTION:    vReleaseCriticalSection
*
* DESCRIPTION: set and stop a semaphore for undisturbed execution
*
* PARAMETER:   tCString (String of source who is calling a semaphore)
*
* RETURNVALUE: void
*
********************************************************************************/
void videomanager_tclServiceVdmSrvIf::vReleaseCriticalSection(tCString from)
{
	ETG_TRACE_COMP(("videomanager_tclServiceVdmSrvIf::vReleaseCriticalSection: called from %s", from));
	RSE_ASSERT_NORMAL_RETURN(OSAL_C_INVALID_HANDLE!=_hDataUpdateSemaphore);

	tS32 s32Err = OSAL_s32SemaphorePost( _hDataUpdateSemaphore );
	if (OSAL_OK != s32Err) {
		ETG_TRACE_ERR((" vReleaseCriticalSection:failed:code=%s", RSE_OsalErrorString() ));
	}
}

// videomanager_tclServiceVdmSrvIfvideomanager_ServiceVdmSrvIf: user specific code end

//EOF
