/*****************************************************************************
* FILE:         videomanager_AppMain_trace.cpp        
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     applMain_trace.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "videomanager_AppMain.h"


// videomanager_AppMain_traceInclude: user specific code start
#include "videomanager_ServiceVdmSrvIf.h"
// videomanager_AppMain_traceInclude: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_VDM_APP_APPLICATION
#include "trcGenProj/Header/videomanager_AppMain_trace.cpp.trc.h"
#endif

tVoid videomanager_tclAppMain::vHandleTraceMessage(const tUChar* puchData) {
    tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
    
    ETG_TRACE_USR1(("videomanager_tclAppMain::vHandleTraceMessage(): process command: %d.", u32MsgCode));
    
    switch (u32MsgCode) {

    case FC_VDM_APP_VIDEOMANAGER_CMDHELP:
        {

            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_FC_VDM_APP_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3000 );

        }
        break;
#ifndef _CCA_APPLICATION_WO_SERVICE
    case FC_VDM_APP_VIDEOMANAGER_POSTBROADCASTCMD:
        {
            // Post an internal message to all application object handler.
            tU16 param1 = (tU16)(((tU16)puchData[3]<<8) | (tU16)puchData[4]);

            videomanager_tclBaseIf::TMsg oMsg;
            (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
            oMsg.eCmd = (videomanager_tclBaseIf::ECmdTypes)param1;
            oMsg.strClassName[0]=0;
            oMsg.u.u32Data = 0;

            // VIDEOMANAGER_PostBroadcastCmd: user specific code start
            // VIDEOMANAGER_PostBroadcastCmd: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;

    case FC_VDM_APP_VIDEOMANAGER_POSTBROADCASTCMDPARAM:
        {
            // Post an internal message with parameter to all application object handler.
            tU16 param1 = (tU16)(((tU16)puchData[3]<<8) | (tU16)puchData[4]);
            tU32 param2 = (tU32)(((tU32)puchData[5]<<24) | ((tU32)puchData[6]<<16) | ((tU32)puchData[7] << 8) | (tU32)puchData[8]);

            videomanager_tclBaseIf::TMsg oMsg;
            (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
            oMsg.eCmd = (videomanager_tclBaseIf::ECmdTypes)param1;
            oMsg.strClassName[0]=0;
            oMsg.u.u32Data = param2;

            // VIDEOMANAGER_PostBroadcastCmdParam: user specific code start
            // VIDEOMANAGER_PostBroadcastCmdParam: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;

    case FC_VDM_APP_VIDEOMANAGER_POSTCMDTOCLASS:
        {
            // Post an internal message with parameter to a specific application object handler.
            tU16 param1 = (tU16)(((tU16)puchData[3]<<8) | (tU16)puchData[4]);
            tU32 param2 = (tU32)(((tU32)puchData[5]<<24) | ((tU32)puchData[6]<<16) | ((tU32)puchData[7] << 8) | (tU32)puchData[8]);
            const tChar* pString3 = (const tChar*)&puchData[9];

            videomanager_tclBaseIf::TMsg oMsg;
            (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
            oMsg.eCmd = (videomanager_tclBaseIf::ECmdTypes)param1;
            OSAL_szStringNCopy(oMsg.strClassName, pString3, sizeof(oMsg.strClassName)-1);
            oMsg.u.u32Data = param2;
            // VIDEOMANAGER_PostCmdToClass: user specific code start
            // VIDEOMANAGER_PostCmdToClass: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;
#endif
    case FC_VDM_APP_VIDEOMANAGER_TRACEINFO:
        {
            // Printout information of an object of the given interface name. Set interface name tp '\\0' every information is shown.
            const tChar* pString1 = (const tChar*)&puchData[3];
    
            // VDDIMMING_VDDIM_TRACEINFO: user specific code start
            // VDDIMMING_VDDIM_TRACEINFO: user specific code end
            std::set<videomanager_tclBaseIf*>::iterator iter;
            for (iter = _poMainAppInstance->_oObjList.begin(); iter != _poMainAppInstance->_oObjList.end(); iter++) {
               // then check for specific implementation
               if (pString1[0] != 0) 
               {
                  if (0 == OSAL_s32StringCompare((*iter)->getIfName(), pString1)) {
                     (*iter)->vTraceInfo();
                  }
               } else {
                  (*iter)->vTraceInfo();
               }
            }
            
        }
        break;


    case FC_VDM_APP_VIDEOMANAGER_STARTVIDEOSOURCE:
        {
            // 
            tU8 param1 = puchData[3];
    

            // FC_VDM_APP_VIDEOMANAGER_STARTVIDEOSOURCE: user specific code start
            videomanager_tclServiceVdmSrvIf* service = dynamic_cast<videomanager_tclServiceVdmSrvIf*>(_poMainAppInstance->getHandler("videomanager_tclServiceVdmSrvIf"));
			VIDEOMANAGER_NULL_POINTER_CHECK(service);

			videomanager_fi_tcl_e8_vdmVideoSource source;
			if (puchData[3] == 0) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE;
			if (puchData[3] == 1) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA;
			if (puchData[3] == 2) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD;
			if (puchData[3] == 3) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV;
			if (puchData[3] == 4) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX;
			if (puchData[3] == 5) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD;
			if (puchData[3] == 6) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB;

			videomanager_fi_tcl_e8_vdmRequestedSourceState state;
			state.enType = videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_ACTIVE;

			service->onRequestVideoSourceStateMStart(source,state);
            // FC_VDM_APP_VIDEOMANAGER_STARTVIDEOSOURCE: user specific code end
            
        }
        break;
    case FC_VDM_APP_VIDEOMANAGER_STOPVIDEOSOURCE:
        {
            // 
            tU8 param1 = puchData[3];
    

            // FC_VDM_APP_VIDEOMANAGER_STOPVIDEOSOURCE: user specific code start
            videomanager_tclServiceVdmSrvIf* service = dynamic_cast<videomanager_tclServiceVdmSrvIf*>(_poMainAppInstance->getHandler("videomanager_tclServiceVdmSrvIf"));
			VIDEOMANAGER_NULL_POINTER_CHECK(service);

			videomanager_fi_tcl_e8_vdmVideoSource source;
			if (puchData[3] == 0) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE;
			if (puchData[3] == 1) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA;
			if (puchData[3] == 2) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD;
			if (puchData[3] == 3) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV;
			if (puchData[3] == 4) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX;
			if (puchData[3] == 5) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD;
			if (puchData[3] == 6) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB;

			videomanager_fi_tcl_e8_vdmRequestedSourceState state;
			state.enType = videomanager_fi_tcl_e8_vdmRequestedSourceState::FI_EN_INACTIVE;

			service->onRequestVideoSourceStateMStart(source,state);
            // FC_VDM_APP_VIDEOMANAGER_STOPVIDEOSOURCE: user specific code end
            
        }
        break;
    case FC_VDM_APP_VIDEOMANAGER_ACKNOWLEDGEACTIVE:
        {
            // 
            tU8 param1 = puchData[3];
    

            // FC_VDM_APP_VIDEOMANAGER_ACKNOWLEDGEACTIVE: user specific code start
            videomanager_tclServiceVdmSrvIf* service = dynamic_cast<videomanager_tclServiceVdmSrvIf*>(_poMainAppInstance->getHandler("videomanager_tclServiceVdmSrvIf"));
			VIDEOMANAGER_NULL_POINTER_CHECK(service);

			videomanager_fi_tcl_e8_vdmVideoSource source;
			if (puchData[3] == 0) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE;
			if (puchData[3] == 1) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA;
			if (puchData[3] == 2) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD;
			if (puchData[3] == 3) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV;
			if (puchData[3] == 4) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX;
			if (puchData[3] == 5) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD;
			if (puchData[3] == 6) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB;

			videomanager_fi_tcl_e8_vdmSourceState state;
			state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_ACTIVE;

			service->onAcknowledgeStateMStart(source,state);
            // FC_VDM_APP_VIDEOMANAGER_ACKNOWLEDGEACTIVE: user specific code end
            
        }
        break;
    case FC_VDM_APP_VIDEOMANAGER_ACKNOWLEDGEINACTIVE:
        {
            // 
            tU8 param1 = puchData[3];
    

            // FC_VDM_APP_VIDEOMANAGER_ACKNOWLEDGEINACTIVE: user specific code start
            videomanager_tclServiceVdmSrvIf* service = dynamic_cast<videomanager_tclServiceVdmSrvIf*>(_poMainAppInstance->getHandler("videomanager_tclServiceVdmSrvIf"));
			VIDEOMANAGER_NULL_POINTER_CHECK(service);

			videomanager_fi_tcl_e8_vdmVideoSource source;
			if (puchData[3] == 0) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_NONE;
			if (puchData[3] == 1) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCA;
			if (puchData[3] == 2) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_RVCD;
			if (puchData[3] == 3) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DTV;
			if (puchData[3] == 4) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_SPCX;
			if (puchData[3] == 5) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_DVD;
			if (puchData[3] == 6) source.enType = videomanager_fi_tcl_e8_vdmVideoSource::FI_EN_USB;

			videomanager_fi_tcl_e8_vdmSourceState state;
			state.enType = videomanager_fi_tcl_e8_vdmSourceState::FI_EN_INACTIVE;

			service->onAcknowledgeStateMStart(source,state);
            // FC_VDM_APP_VIDEOMANAGER_ACKNOWLEDGEINACTIVE: user specific code end
            
        }
        break;
    case FC_VDM_APP_VIDEOMANAGER_PRINTCURRENTFISTATE:
        {
            // 
    

            // FC_VDM_APP_VIDEOMANAGER_PRINTCURRENTFISTATE: user specific code start
        	videomanager_tclServiceVdmSrvIf* service = dynamic_cast<videomanager_tclServiceVdmSrvIf*>(_poMainAppInstance->getHandler("videomanager_tclServiceVdmSrvIf"));
        	VIDEOMANAGER_NULL_POINTER_CHECK(service);
        	service->vPrintCurrentStatus();
            // FC_VDM_APP_VIDEOMANAGER_PRINTCURRENTFISTATE: user specific code end
            
        }
        break;
    case FC_VDM_APP_VIDEOMANAGER_SETTIMEOUTDURATION:
        {
            // 
            tU32 param1 = ((tU32)puchData[3] << 24) | ((tU32)puchData[4] << 16) | ((tU32)puchData[5] <<  8) | (tU32)puchData[6];
    

            // FC_VDM_APP_VIDEOMANAGER_SETTIMEOUTDURATION: user specific code start
            videomanager_tclServiceVdmSrvIf* service = dynamic_cast<videomanager_tclServiceVdmSrvIf*>(_poMainAppInstance->getHandler("videomanager_tclServiceVdmSrvIf"));
            VIDEOMANAGER_NULL_POINTER_CHECK(service);
            service->u32TimeoutDuration = param1;
            // FC_VDM_APP_VIDEOMANAGER_SETTIMEOUTDURATION: user specific code end
            
        }
        break;


    default:
        ETG_TRACE_USR4(("videomanager_tclAppMain::vHandleTraceMessage(): unknown command %d.", u32MsgCode));
        break;
    }
    // videomanager_tclAppMainFunction_vHandleTraceMessage: user specific code start
    // videomanager_tclAppMainFunction_vHandleTraceMessage: user specific code end
    
    return;
}
// videomanager_AppMain_trace: user specific code start
// videomanager_AppMain_trace: user specific code end
