/*****************************************************************************
* FILE:         videomanager_AppMain.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     applMain.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#include "videomanager_AppMain.h"

// videomanager_tclAppMainIncludes: user specific code start
// videomanager_tclAppMainIncludes: user specific code end

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_VDM_APP_APPLICATION
#include "trcGenProj/Header/videomanager_AppMain.cpp.trc.h"
#endif


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/

// Static self reference to be used in function callbacks.
videomanager_tclAppMain* videomanager_tclAppMain::_poMainAppInstance = NULL;

tUChar  videomanager_tclAppMain::_auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE] = {0};

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
* FUNCTION   : videomanager_tclAppMain::theServer()
* DESCRIPTION: Creates new server object by using the singleton pattern.
* PARAMETER  : None.
* RETURNVALUE: Pointer to the instance of this application.
*******************************************************************************/
videomanager_tclAppMain* videomanager_tclAppMain::theServer()
{
   if ( NULL == _poMainAppInstance )
   {
      _poMainAppInstance = new videomanager_tclAppMain();
   }
   return _poMainAppInstance;
}


/*******************************************************************************
*
* FUNCTION: videomanager_tclAppMain::videomanager_tclAppMain()
*
* DESCRIPTION: Constructor.
*
*              Initialize static self reference to be used in function
*              callbacks.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
videomanager_tclAppMain::videomanager_tclAppMain():ahl_tclBaseOneThreadApp(CCA_C_U16_APP_VIDEO_MANAGER)
{
   ETG_TRACE_USR4(("videomanager_tclAppMain() entered."));

   videomanager_tclAppMain::_poMainAppInstance   = this;
   
   _bStartPerformed = FALSE;   

   // videomanager_tclAppMainConstructor: user specific code start
   // videomanager_tclAppMainConstructor: user specific code end

   vTracePlugIn();
}

/*******************************************************************************
*
* FUNCTION: videomanager_tclAppMain::~videomanager_tclAppMain()
*
* DESCRIPTION: Destructor.
*
*              Invalidate static self reference.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
videomanager_tclAppMain::~videomanager_tclAppMain()
{
   ETG_TRACE_USR4(("~videomanager_tclAppMain() entered."));

   // --- unplug TTFIS trace ---
   vTraceUnplug();   

   // videomanager_tclAppMainDestructor: user specific code start
   // videomanager_tclAppMainDestructor: user specific code end

   videomanager_tclAppMain::_poMainAppInstance = NULL;
}

/*******************************************************************************
*
* FUNCTION: tBool videomanager_tclAppMain::vStart()
*
* DESCRIPTION:
*
* PARAMETER: None.
*
* RETURNVALUE: None
*
*******************************************************************************/
tVoid videomanager_tclAppMain::vStart(tVoid)
{

   if (!_bStartPerformed) {

      // videomanager_tclAppMainvStart: user specific code start
      // videomanager_tclAppMainvStart: user specific code end
   
      vGetReferences();
      vStartCommunication();
      
       _bStartPerformed = TRUE;   
   }
}

/*******************************************************************************
*
* FUNCTION: tBool videomanager_tclAppMain::bOnInit()
*
* DESCRIPTION: This function is called by the CCA framework before starting any
*              CCA message related communication action. As default this
*              function always returns TRUE. The user has to implement all his
*              local application initialization (create client and service
*              handler, create worker threads, allocate application memory,...).
*              If returns TRUE, initialization could be successfully performed
*              and framework will register application, else, a reset of the
*              system is forced immediately.
*
*              This function is the counterpart of vOnApplicationClose().
*
* PARAMETER: None.
*
* RETURNVALUE: TRUE  = Application successfully initialized.
*              FALSE = Application NOT successfully initialized.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
*******************************************************************************/
tBool videomanager_tclAppMain::bOnInit()
{
   tBool bSuccess = TRUE;

   ETG_TRACE_USR4(("bOnInit() entered."));

   while (!_bStartPerformed) {
       OSAL_s32ThreadWait(100);
       ETG_TRACE_FATAL(("videomanager_tclAppMain::bOnInit(): vStart not called now --> wait."));
   }
   
   // videomanager_tclAppMainbOnInit: user specific code start
   // videomanager_tclAppMainbOnInit: user specific code end

   
   return bSuccess;
}

/********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState).
*******************************************************************************/
tVoid videomanager_tclAppMain::vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState)
{
    if (u32AppState == AMT_C_U32_STATE_OFF) {
        // videomanager_tclAppMainvOnNewAppStateOff: user specific code start
        // videomanager_tclAppMainvOnNewAppStateOff: user specific code end
    } else {
        // videomanager_tclAppMainvOnNewAppStateNotOff: user specific code start
        // videomanager_tclAppMainvOnNewAppStateNotOff: user specific code end
    }
  
    // videomanager_tclAppMainvOnNewAppState: user specific code start
    // videomanager_tclAppMainvOnNewAppState: user specific code end

    ahl_tclBaseOneThreadApp::vOnNewAppState(u32OldAppState, u32AppState);
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclAppMain::vOnApplicationClose()
*
* DESCRIPTION: This function is called by the CCA framework to indicate the
*              imminent shutdown of the application. The user has to implement
*              the de-initialization of all his local application data (destroy
*              client and service handler, destroy worker threads, free
*              application memory, ... ). After this function call the
*              destructor of this application will be called.
*
*              This function is the counterpart of bOnInit().
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
*******************************************************************************/
tVoid videomanager_tclAppMain::vOnApplicationClose()
{
   ETG_TRACE_USR4(("vOnApplicationClose() entered."));

   // videomanager_tclAppMainvOnApplicationClose: user specific code start
   // videomanager_tclAppMainvOnApplicationClose: user specific code end

   ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclAppMain::vOnTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called by the CCA framework on the expiration
*              of a previously via function bStartTimer() started timer. The
*              expired timer is forwarded to the respective service or
*              client-handler via a call of vProcessTimer().
*
*              The function is called from this applications context and
*              therefore no interthread programming rules must be considered
*              and the application methods and/or member variables can be
*              accessed without using the static self reference
*              'm_poMainAppInstance'.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
*******************************************************************************/
tVoid videomanager_tclAppMain::vOnTimer(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("vOnTimer(id: %d) entered.", u16TimerId ));

   // videomanager_tclAppMainvOnTimer: user specific code start
   // videomanager_tclAppMainvOnTimer: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclAppMain::vOnLoopback
*                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called by the CCA framework if a message was
*              sent from one if this applications services or from a
*              callback-handler of this application (so called self or loopback
*              messages). The message can be forwarded to the respective service
*              via a call of vOnLoopbackService(). If there is no service
*              registered for this message then the user has the option to
*              directly evaluate the message in the default block of this.
*              methods switch-clause.
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*
*            [IN] poMessage = Message object.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
*******************************************************************************/
tVoid videomanager_tclAppMain::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("vOnLoopback() entered with service ID %04x.", u16ServiceID));

   // videomanager_tclAppMainvOnLoopback_entry: user specific code start
   // videomanager_tclAppMainvOnLoopback_entry: user specific code end
   
   gm_tclStreamMessage oVisitorMsg(poMessage);

   videomanager_tclBaseIf::TMsg oMsg;

   if (oVisitorMsg.u32GetDataSize() >= sizeof(oMsg)) {
      memcpy((tVoid*)&oMsg, oVisitorMsg.pcocGetData(), sizeof(oMsg));
      
      if (oMsg.eCmd != (videomanager_tclBaseIf::ECmdTypes)poMessage->u16GetFunctionID()) {
         ETG_TRACE_FATAL(("vOnLoopbackService() failed. iFID = 0x%04x, cmd = 0x%04x.", (tU32)poMessage->u16GetFunctionID(), (tU32)oMsg.eCmd));
         NORMAL_M_ASSERT_ALWAYS();
      }
      else {
         //post message
         tU8* pu8MsgData = NULL;
         if ((oMsg.tDataTrailer.pu8Data != NULL) && (oMsg.tDataTrailer.u32Len != 0)) {
             pu8MsgData = new tU8[oMsg.tDataTrailer.u32Len];
             if (pu8MsgData != NULL) {
                 memcpy((tVoid*)pu8MsgData, oVisitorMsg.pcocGetData()+sizeof(oMsg), oMsg.tDataTrailer.u32Len);
                 oMsg.tDataTrailer.pu8Data = pu8MsgData;
             }

         }
         vDispatchInternalMsg(&oMsg);
         if (pu8MsgData != NULL) {
             delete[] pu8MsgData;
         }
      }
   }
   else {
      ETG_TRACE_FATAL(("vOnLoopbackService() failed. message data size = %d, internal message size = %d.", (tU32)oVisitorMsg.u32GetDataSize(), (tU32)sizeof(oMsg) ));
      NORMAL_M_ASSERT_ALWAYS();
   }

   // videomanager_tclAppMainvOnLoopback_exit: user specific code start
   // videomanager_tclAppMainvOnLoopback_exit: user specific code end   
}


tVoid videomanager_tclAppMain::vDispatchInternalMsg(videomanager_tclBaseIf::TMsg* pInternalMsg)
{
   if (pInternalMsg->eCmd == videomanager_tclBaseIf::eCmdTraceCmdReceived) {
      //vHandleTraceMessageGen(_auchTraceInputBuffer);
       vHandleTraceMessage(_auchTraceInputBuffer);
 
       std::set<videomanager_tclBaseIf*>::iterator iter;
       for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
            (*iter)->vHandleTraceMessage(_auchTraceInputBuffer);
       }
   }
   else {
      std::set<videomanager_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (pInternalMsg->strClassName[0] != 0) 
         {
            if (0 == OSAL_s32StringCompare((*iter)->getIfName(), pInternalMsg->strClassName)) {
               (*iter)->vHandleMessage(pInternalMsg);
            }
            if (0 == OSAL_s32StringCompare((*iter)->getName(), pInternalMsg->strClassName)) {
               (*iter)->vHandleMessage(pInternalMsg);
            }
         } else {
            (*iter)->vHandleMessage(pInternalMsg);
         }
      }
   }
}

#ifndef _CCA_APPLICATION_WO_SERVICE
tVoid videomanager_tclAppMain::vPostInternalMessage(videomanager_tclBaseIf::TMsg* pInternalMsg)
{
   ETG_TRACE_USR1(("videomanager_tclAppMain::vPostInternalMessage(): post internal message '%d'.", ETG_CENUM(videomanager_tclBaseIf::ECmdTypes, pInternalMsg->eCmd)));
   
   // videomanager_tclAppMainPostInternStartUserSpecificClassCode: user specific code start
   // videomanager_tclAppMainPostInternStartUserSpecificClassCode: user specific code end

   tU32 u32DataLengthMsg = sizeof(videomanager_tclBaseIf::TMsg);
   tU8* pu8MsgData = NULL;

   const tChar* pStreamMsg = (const tChar*)pInternalMsg;

   if ((pInternalMsg->tDataTrailer.pu8Data != NULL) && (pInternalMsg->tDataTrailer.u32Len != 0)) {
       u32DataLengthMsg = (tU32)sizeof(videomanager_tclBaseIf::TMsg) + pInternalMsg->tDataTrailer.u32Len;

       pu8MsgData = new tU8[u32DataLengthMsg];

       if (pu8MsgData != NULL) {
           (tVoid)OSAL_pvMemoryCopy((tVoid*)&pu8MsgData[0], pInternalMsg, sizeof(videomanager_tclBaseIf::TMsg));
           (tVoid)OSAL_pvMemoryCopy((tVoid*)&pu8MsgData[sizeof(videomanager_tclBaseIf::TMsg)], pInternalMsg->tDataTrailer.pu8Data, pInternalMsg->tDataTrailer.u32Len);

           pStreamMsg = (const tChar*)pu8MsgData;
           ETG_TRACE_FATAL(("videomanager_tclAppMain::vPostInternalMessage(): send stream message '%d'.", ETG_CENUM(videomanager_tclBaseIf::ECmdTypes, pInternalMsg->eCmd)));
       }
   }

   gm_tclStreamMessage oStreamMsg(u16GetAppId(), u16GetAppId(), 0, 0, 229, (tU16)pInternalMsg->eCmd, AMT_C_U8_CCAMSG_OPCODE_SET, u32DataLengthMsg );
   if (OSAL_NULL != oStreamMsg.pu8GetSharedMemBase()) {
       oStreamMsg.vSetData((const tChar*)pStreamMsg);
       if ( oStreamMsg.bIsValid() ) {
          if (enPostMessage(&oStreamMsg, TRUE) != AIL_EN_N_NO_ERROR) {
             NORMAL_M_ASSERT_ALWAYS();
          }
       } else {
          NORMAL_M_ASSERT_ALWAYS();
       }
   } else {
      ETG_TRACE_ERRMEM(("videomanager_tclAppMain::vPostInternalMessage(): message %d with data size %u bytes could not create! No shared memory.",
            ETG_CENUM(videomanager_tclBaseIf::ECmdTypes, pInternalMsg->eCmd), (tUInt)sizeof(videomanager_tclBaseIf::TMsg) ));
   }

   if (pu8MsgData != NULL) {
       delete[] pu8MsgData;
   }
   // videomanager_tclAppMainPostInternEndUserSpecificClassCode: user specific code start
   // videomanager_tclAppMainPostInternEndUserSpecificClassCode: user specific code end

}
#endif

/*******************************************************************************
* FUNCTION   : videomanager_tclAppMain::vTracePlugIn
* DESCRIPTION: Activate the TTFIS command channel for fc_vdm_app
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid videomanager_tclAppMain::vTracePlugIn(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;

   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_FC_VIDMGR;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)videomanager_tclAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &MyTraceChannel);
      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TracePlugin"));
      }
      // close trace device and clear channel
      OSAL_s32IOClose(desc);
   }
}

/*******************************************************************************
* FUNCTION   : videomanager_tclAppMain::vTraceUnplug
* DESCRIPTION: Deactivate the TTFIS command channel for fc_vdm_app
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid videomanager_tclAppMain::vTraceUnplug(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;
   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_FC_VIDMGR;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)videomanager_tclAppMain::vTraceCallbackFunction;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &MyTraceChannel);

      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TraceUnplug"));
      }

      // close trace device and clear channel
      OSAL_s32IOClose(desc);
   }
}

/*******************************************************************************
* FUNCTION   : videomanager_tclAppMain::vTraceCallbackFunction
* DESCRIPTION: Callback function for TTFIS command channel of __APP_NAME__
* PARAMETER  : [IN] puchData = buffer with trace input data
* RETURNVALUE: None
*******************************************************************************/
tVoid videomanager_tclAppMain::vTraceCallbackFunction(const tUChar* puchData)
{
#ifdef _CCA_APPLICATION_WO_SERVICE

   //videomanager_tclAppMain::vHandleTraceMessageGen(puchData);
   videomanager_tclAppMain::vHandleTraceMessage(puchData);
#else
   if (puchData[0] < TRACE_BUFFER_MAXSIZE) {
      ETG_TRACE_USR4(("vTraceCallbackFunction(), length of TTFis message=%u\n Data: %*p",puchData[0],ETG_LIST_LEN(puchData[0]), ETG_LIST_PTR_T8(&(puchData[1]))));
      memcpy(_auchTraceInputBuffer, puchData, puchData[0]+1);

      if (NULL != _poMainAppInstance) {
         videomanager_tclBaseIf::TMsg oMsg;
         (tVoid)memset((tVoid*)&oMsg, OSAL_NULL, sizeof(oMsg));
         
         oMsg.eCmd = videomanager_tclBaseIf::eCmdTraceCmdReceived;
         oMsg.strClassName[0]=0;
         oMsg.u.u32Data = 0;

         _poMainAppInstance->vPostInternalMessage(&oMsg);
      }
   } else {
      ETG_TRACE_ERR(("MAIN :: Input trace command too long"));
   }
#endif // _CCA_APPLICATION_WO_SERVICE
}

tVoid videomanager_tclAppMain::vLoadRegistry() 
{
    OSAL_tIODescriptor  regHandle;
    if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
    {
        if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(intptr_t)"/dev/root/opt/bosch/base/registry/procvideomanager.reg")) == OSAL_OK)
        {
            ETG_TRACE_FATAL(("REGISTRY loaded '/opt/bosch/base/registry/procvideomanager.reg'!"));

        } else {
            ETG_TRACE_FATAL(("!!!!!!!!!! FAILED to load REGISTRY  '/opt/bosch/base/registry/procvideomanager.reg'!"));
        }
    }
    OSAL_s32IOClose(regHandle);
}

#ifndef _CCA_APPLICATION_WO_SERVICE

#endif

// videomanager_tclAppMainUserSpecificClassCode: user specific code start
// videomanager_tclAppMainUserSpecificClassCode: user specific code end


/*******************************************************************************
*                                       E O F
*******************************************************************************/
