/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          videomanager_ServiceVdmSrvCallbackIF.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: fc_vdm_app
  * @Template:     serviceCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                service callback interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef __videomanager_main_fi_CALLBACKIF_H_
#define __videomanager_main_fi_CALLBACKIF_H_

class videomanager_tclServiceVdmSrvCallbackIF
{
   public:
       virtual ~videomanager_tclServiceVdmSrvCallbackIF() {};

       virtual tVoid onServiceAvailable() = 0;
       virtual tVoid onServiceUnavailable() = 0;

       virtual tBool onRVCASet(tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onRVCDSet(tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onDTVSet(tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onSPCXSet(tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onDVDSet(tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onUSBSet(tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onDeserializerUsedBySet(tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;

       virtual tVoid onRequestVideoSourceStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmRequestedSourceState tRequestedState) = 0;
       virtual tVoid onRequestAccessToDeserializerMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource) = 0;
       virtual tVoid onAcknowledgeStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmSourceState tVideoState) = 0;
};

#endif //__videomanager_main_fi_CALLBACKIF_H_


