/*****************************************************************************
* FILE:         videomanager_ServiceVdmSrv.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __videomanager_ServiceVdmSrv_H_
#define __videomanager_ServiceVdmSrv_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_videomanager_ServiceVdmSrv.h"
#include "videomanager_AppMain.h"

// videomanager_tclServiceVdmSrv_Include: user specific code start
// videomanager_tclServiceVdmSrv_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class videomanager_tclServiceVdmSrvCallbackIF;

class videomanager_tclServiceVdmSrv : public Ivideomanager_tclServiceVdmSrv
{
protected:
   class tclMethodResultManager {
   public:

      // Constructors and destructors
      tclMethodResultManager(){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };
      ~tclMethodResultManager(){};

      tVoid vInit(tVoid){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };

      tVoid vMemorize(tBool bPending, tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID) {
         _bPending = bPending;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      tBool bIsPending(tVoid) const {return _bPending;};    
      tVoid vSetPending(tVoid) {_bPending = TRUE;};
      tVoid vSetPendingValue(tBool _bPendingValue){_bPending = _bPendingValue;};
      tVoid vClearPending(tVoid){_bPending = FALSE;};
      tBool bGetPending(tVoid) const {return _bPending;};    

      tU16 u16GetSourceAppID(tVoid) const {return _u16SourceAppID;};    
      tU16 u16GetRegisterID(tVoid) const {return _u16RegisterID;};    
      tU16 u16GetCMDCounter(tVoid) const {return _u16CmdCounter;};    
      tU16 u16GetFctID(tVoid) const {return _u16FctID;};    

   private:                    
      tBool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:

   videomanager_tclServiceVdmSrv(tVoid); 
   videomanager_tclServiceVdmSrv(videomanager_tclAppMain* poMainAppl);
   virtual ~videomanager_tclServiceVdmSrv();

   virtual tVoid vSetCallbackIf(videomanager_tclServiceVdmSrvCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // videomanager_tclServiceVdmSrvDeclarations: user specific code start
   // videomanager_tclServiceVdmSrvDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'videomanager_tclServiceVdmSrv' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   videomanager_tclServiceVdmSrv& operator = (const videomanager_tclServiceVdmSrv &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
public:
   virtual const tChar* getName() const { return "videomanager_tclServiceVdmSrv"; };
   
   virtual tVoid vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
private:
   videomanager_tclServiceVdmSrvCallbackIF* _poCallbackIf;

public:



    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendRVCAStatus(videomanager_fi_tcl_e8_vdmSourceState RVCA_StateInfo);
   virtual tVoid sendRVCDStatus(videomanager_fi_tcl_e8_vdmSourceState RVCD_StateInfo);
   virtual tVoid sendDTVStatus(videomanager_fi_tcl_e8_vdmSourceState DTV_StateInfo);
   virtual tVoid sendSPCXStatus(videomanager_fi_tcl_e8_vdmSourceState SPCX_StateInfo);
   virtual tVoid sendDVDStatus(videomanager_fi_tcl_e8_vdmSourceState DVD_StateInfo);
   virtual tVoid sendUSBStatus(videomanager_fi_tcl_e8_vdmSourceState USB_StateInfo);
   virtual tVoid sendDeserializerUsedByStatus(videomanager_fi_tcl_e8_vdmVideoSource Deserializer_SourceInfo);

   virtual tBool onRVCASet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onRVCDSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDTVSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onSPCXSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDVDSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onUSBSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDeserializerUsedBySet(tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid onRequestVideoSourceStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmRequestedSourceState tRequestedState);
   virtual tVoid vHandleRequestVideoSourceStateOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onRequestAccessToDeserializerMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource);
   virtual tVoid vHandleRequestAccessToDeserializerOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onAcknowledgeStateMStart(videomanager_fi_tcl_e8_vdmVideoSource tVideoSource, videomanager_fi_tcl_e8_vdmSourceState tVideoState);
   virtual tVoid vHandleAcknowledgeStateOpMStart(amt_tclServiceData* poMessage);

   virtual tVoid sendRequestVideoSourceStateMResult(tBool bSourceChangeGranted);
   virtual tVoid sendRequestAccessToDeserializerMResult(tBool bAccessIsGranted);
   virtual tVoid sendAcknowledgeStateMResult();

   virtual void vGetRVCAMsg(videomanager_mainfi_tclMsgRVCAStatus& oStatus) {
      oStatus.RVCA_StateInfo = _tRVCA_RVCA_StateInfo;
   }
   virtual void vGetRVCDMsg(videomanager_mainfi_tclMsgRVCDStatus& oStatus) {
      oStatus.RVCD_StateInfo = _tRVCD_RVCD_StateInfo;
   }
   virtual void vGetDTVMsg(videomanager_mainfi_tclMsgDTVStatus& oStatus) {
      oStatus.DTV_StateInfo = _tDTV_DTV_StateInfo;
   }
   virtual void vGetSPCXMsg(videomanager_mainfi_tclMsgSPCXStatus& oStatus) {
      oStatus.SPCX_StateInfo = _tSPCX_SPCX_StateInfo;
   }
   virtual void vGetDVDMsg(videomanager_mainfi_tclMsgDVDStatus& oStatus) {
      oStatus.DVD_StateInfo = _tDVD_DVD_StateInfo;
   }
   virtual void vGetUSBMsg(videomanager_mainfi_tclMsgUSBStatus& oStatus) {
      oStatus.USB_StateInfo = _tUSB_USB_StateInfo;
   }
   virtual void vGetDeserializerUsedByMsg(videomanager_mainfi_tclMsgDeserializerUsedByStatus& oStatus) {
      oStatus.Deserializer_SourceInfo = _tDeserializerUsedBy_Deserializer_SourceInfo;
   }
   virtual void vGetRequestVideoSourceStateMsg(videomanager_mainfi_tclMsgRequestVideoSourceStateMethodStart& oMethodStart) {
      oMethodStart.tVideoSource = _tRequestVideoSourceState_tVideoSource;
      oMethodStart.tRequestedState = _tRequestVideoSourceState_tRequestedState;
   }
   virtual void vGetRequestAccessToDeserializerMsg(videomanager_mainfi_tclMsgRequestAccessToDeserializerMethodStart& oMethodStart) {
      oMethodStart.tVideoSource = _tRequestAccessToDeserializer_tVideoSource;
   }
   virtual void vGetAcknowledgeStateMsg(videomanager_mainfi_tclMsgAcknowledgeStateMethodStart& oMethodStart) {
      oMethodStart.tVideoSource = _tAcknowledgeState_tVideoSource;
      oMethodStart.tVideoState = _tAcknowledgeState_tVideoState;
   }

private:
   // Add status information properties.
   videomanager_fi_tcl_e8_vdmSourceState _tRVCA_RVCA_StateInfo;

   videomanager_fi_tcl_e8_vdmSourceState _tRVCD_RVCD_StateInfo;

   videomanager_fi_tcl_e8_vdmSourceState _tDTV_DTV_StateInfo;

   videomanager_fi_tcl_e8_vdmSourceState _tSPCX_SPCX_StateInfo;

   videomanager_fi_tcl_e8_vdmSourceState _tDVD_DVD_StateInfo;

   videomanager_fi_tcl_e8_vdmSourceState _tUSB_USB_StateInfo;

   videomanager_fi_tcl_e8_vdmVideoSource _tDeserializerUsedBy_Deserializer_SourceInfo;

   videomanager_fi_tcl_e8_vdmVideoSource _tRequestVideoSourceState_tVideoSource;
   videomanager_fi_tcl_e8_vdmRequestedSourceState _tRequestVideoSourceState_tRequestedState;
   videomanager_fi_tcl_e8_vdmVideoSource _tRequestAccessToDeserializer_tVideoSource;
   videomanager_fi_tcl_e8_vdmVideoSource _tAcknowledgeState_tVideoSource;
   videomanager_fi_tcl_e8_vdmSourceState _tAcknowledgeState_tVideoState;
   tclMethodResultManager _oMemRequestVideoSourceState;
   tclMethodResultManager _oMemRequestAccessToDeserializer;
   tclMethodResultManager _oMemAcknowledgeState;
   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(videomanager_tclServiceVdmSrv) 

// videomanager_tclServiceVdmSrvDeclarationsPart2: user specific code start
// videomanager_tclServiceVdmSrvDeclarationsPart2: user specific code end

};

#endif // __videomanager_ServiceVdmSrv_H_


