/*****************************************************************************
* FILE:         videomanager_ClientSpmIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __videomanager_ClientSpmIf__IF__H_
#define __videomanager_ClientSpmIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_videomanager_ClientSpmIf.h"
#include "videomanager_AppMain.h"
#include "videomanager_ClientSpmCallbackIf.h"

// videomanager_tclClientSpmIf_Include: user specific code start
// videomanager_tclClientSpmIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ivideomanager_tclClientSpm;

class videomanager_tclClientSpmIf : public Ivideomanager_tclClientSpmIf, public videomanager_tclClientSpmCallbackIF
{
public:

   videomanager_tclClientSpmIf(tVoid); 
   videomanager_tclClientSpmIf(videomanager_tclAppMain* poMainAppl);
   virtual ~videomanager_tclClientSpmIf();

   virtual const tChar* getName() const { return "videomanager_tclClientSpmIf"; };
   
   virtual tVoid vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

   virtual tBool sendSubStatesSet(spm_fi_tcl_SPM_e32_SubStateType SubStateType, tBool SubStateData) {
       //just forward send request
       VIDEOMANAGER_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSubStatesSet(SubStateType, SubStateData);
   }

   virtual tVoid getSubStatesStatus(tU32& rSubState, tU32& rHwSubState, tU32& rInternSubState){
       //just forward send request
       VIDEOMANAGER_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getSubStatesStatus(rSubState, rHwSubState, rInternSubState);
   }


   virtual tBool sendSubStatesGet(){
       //just forward send request
       VIDEOMANAGER_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSubStatesGet();
   }
   virtual tVoid getCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT& rCvmEvent){
       //just forward send request
       VIDEOMANAGER_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getCvmEventStatus(rCvmEvent);
   }


   virtual tBool sendCvmEventGet(){
       //just forward send request
       VIDEOMANAGER_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendCvmEventGet();
   }

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onSubStatesStatus(tU32 SubState, tU32 HwSubState, tU32 InternSubState);
   virtual tVoid onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent);


   // videomanager_tclClientSpmIfDeclarations: user specific code start
   // videomanager_tclClientSpmIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ivideomanager_tclClientSpm* _poClientRef;

// videomanager_tclClientSpmIfDeclarationsPart2: user specific code start
// videomanager_tclClientSpmIfDeclarationsPart2: user specific code end

};

#endif // __videomanager_ClientSpmIf__IF__H_


