/*****************************************************************************
* FILE:         videomanager_ClientDiagLogIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __videomanager_ClientDiagLogIf__IF__H_
#define __videomanager_ClientDiagLogIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_videomanager_ClientDiagLogIf.h"
#include "videomanager_AppMain.h"
#include "videomanager_ClientDiagLogCallbackIf.h"

// videomanager_tclClientDiagLogIf_Include: user specific code start
// videomanager_tclClientDiagLogIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ivideomanager_tclClientDiagLog;

class videomanager_tclClientDiagLogIf : public Ivideomanager_tclClientDiagLogIf, public videomanager_tclClientDiagLogCallbackIF
{
public:

   videomanager_tclClientDiagLogIf(tVoid); 
   videomanager_tclClientDiagLogIf(videomanager_tclAppMain* poMainAppl);
   virtual ~videomanager_tclClientDiagLogIf();

   virtual const tChar* getName() const { return "videomanager_tclClientDiagLogIf"; };
   
   virtual tVoid vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tVoid getSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure& rNextTestResultStruct, tBool& rStatus){
       //just forward send request
       VIDEOMANAGER_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getSendNextTestResultStatus(rNextTestResultStruct, rStatus);
   }


   virtual tBool sendSaveTestResultMStart(midw_fi_tcl_TestResultList TestResultList){
       //just forward send request
       VIDEOMANAGER_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSaveTestResultMStart(TestResultList);
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status);

   virtual tVoid onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status);

   // videomanager_tclClientDiagLogIfDeclarations: user specific code start
   // videomanager_tclClientDiagLogIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ivideomanager_tclClientDiagLog* _poClientRef;

// videomanager_tclClientDiagLogIfDeclarationsPart2: user specific code start
// videomanager_tclClientDiagLogIfDeclarationsPart2: user specific code end

};

#endif // __videomanager_ClientDiagLogIf__IF__H_


