
/*****************************************************************************
* FILE:         videomanager_ClientDiagLogIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_vdm_app
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// videomanager_tclClientDiagLogIfIncludes: user specific code start
// videomanager_tclClientDiagLogIfIncludes: user specific code end

#include "videomanager_ClientDiagLogIf.h"
#include "Ivideomanager_ClientDiagLog.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_VDM_APP_CLIENT_DIAGLOG
#include "trcGenProj/Header/videomanager_ClientDiagLogIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: videomanager_tclClientDiagLogIf::
*             videomanager_tclClientDiagLogIf(videomanager_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
videomanager_tclClientDiagLogIf::videomanager_tclClientDiagLogIf(videomanager_tclAppMain* poMainAppl) : 
Ivideomanager_tclClientDiagLogIf(poMainAppl)
{
   ETG_TRACE_USR4(("videomanager_tclClientDiagLogIf() entered."));
   _poClientRef = OSAL_NULL;

   // videomanager_tclClientDiagLogIfConstructor: user specific code start
   // videomanager_tclClientDiagLogIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: videomanager_tclClientDiagLogIf::
*             ~videomanager_tclClientDiagLogIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
videomanager_tclClientDiagLogIf::~videomanager_tclClientDiagLogIf(tVoid)
{
   ETG_TRACE_USR4(("~videomanager_tclClientDiagLogIf() entered."));
   _poClientRef = OSAL_NULL;

   // videomanager_tclClientDiagLogIfDestructor: user specific code start
   // videomanager_tclClientDiagLogIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientDiagLogIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'videomanager_ClientDiagLogIf.h':
*     Add forward declaration:
*         class Ifc_vdm_app_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_vdm_app_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_vdm_app_tclObject2Get*>(_cpoMain->getHandler("Ifc_vdm_app_tclObject2Get"));
*     DIAGLOG_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclClientDiagLogIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("videomanager_tclClientDiagLogIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ivideomanager_tclClientDiagLog*>(_cpoMain->getHandler("Ivideomanager_tclClientDiagLog"));

   VIDEOMANAGER_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // videomanager_tclClientDiagLogIfvGetReferences: user specific code start
   // videomanager_tclClientDiagLogIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientDiagLogIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclClientDiagLogIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("videomanager_tclClientDiagLogIf::vStartCommunication() entered."));
   // videomanager_tclClientDiagLogIfvStartCommunication: user specific code start
   // videomanager_tclClientDiagLogIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientDiagLogIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   videomanager_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclClientDiagLogIf::vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("videomanager_tclClientDiagLogIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(videomanager_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // videomanager_tclClientDiagLogIfvHandleMessage: user specific code start
   // videomanager_tclClientDiagLogIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientDiagLogIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclClientDiagLogIf::vHandleTraceMessage(const tUChar* puchData)
{
   VIDEOMANAGER_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("videomanager_tclClientDiagLogIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // videomanager_tclClientDiagLogIfvHandleTraceMessage: user specific code start
   // videomanager_tclClientDiagLogIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientDiagLogIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid videomanager_tclClientDiagLogIf::vTraceInfo()
{
   // videomanager_tclClientDiagLogIfvTraceInfo: user specific code start
   // videomanager_tclClientDiagLogIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientDiagLogIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid videomanager_tclClientDiagLogIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("videomanager_tclClientDiagLogIf::onServiceAvailable() entered."));

   // videomanager_tclClientDiagLogIfvOnServiceAvailable: user specific code start
   // videomanager_tclClientDiagLogIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid videomanager_tclClientDiagLogIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid videomanager_tclClientDiagLogIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("videomanager_tclClientDiagLogIf::onServiceUnavailable() entered."));

   // videomanager_tclClientDiagLogIfvOnServiceUnavailable: user specific code start
   // videomanager_tclClientDiagLogIfvOnServiceUnavailable: user specific code end
}

tVoid videomanager_tclClientDiagLogIf::onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status) {
   ETG_TRACE_USR1( ( "videomanager_tclClientDiagLogIf::onSendNextTestResultStatus(): CALLED" ) );

   // onSendNextTestResultStatus: user specific code start
   // onSendNextTestResultStatus: user specific code end
}

tVoid videomanager_tclClientDiagLogIf::onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status) {
   ETG_TRACE_USR1( ( "videomanager_tclClientDiagLogIf::onSaveTestResultMResult(): CALLED" ) );

   // onSaveTestResultMResult: user specific code start
   // onSaveTestResultMResult: user specific code end
}



// videomanager_tclClientDiagLogIfvideomanager_ClientDiagLogIf: user specific code start
// videomanager_tclClientDiagLogIfvideomanager_ClientDiagLogIf: user specific code end

//EOF
