/************************************************************************
* FILE:        	I_videomanager_lookuptable.h
* PROJECT:		Nissan / Renault A-IVI
* SW-COMPONENT:	fc_videomanager
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class to look up table
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                | Modification
* 16.02.2017| CM-CI1/ERN4-E Schurig | initial introduction
*
*************************************************************************/

#ifndef _I_VIDEOMANAGER_LOOKUPTABLE_H_
#define _I_VIDEOMANAGER_LOOKUPTABLE_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "videomanager_AppMain.h"

class I_videomanager_lookuptable : public videomanager_tclBaseIf
{
public:
	I_videomanager_lookuptable(void);
	I_videomanager_lookuptable(const videomanager_tclAppMain* poMainAppl) : videomanager_tclBaseIf (poMainAppl){;};

	virtual ~I_videomanager_lookuptable(){};

	virtual const tChar* getIfName() const { return "Ivideomanager_lookuptable"; };

	virtual void  vSetCurrentSource(tU8 currentSource) = 0;
	virtual tBool bSourceChangeApproved(tU8 newSource) = 0;

	virtual void vHandleMessage(videomanager_tclBaseIf::TMsg* pMsg) = 0;
	virtual void vHandleTraceMessage(const tUChar* puchData) = 0;
	virtual void vGetReferences() = 0;
	virtual void vStartCommunication() = 0;
	virtual void vTraceInfo() = 0;

	// This enum makes sure that a possibly new source may added
	// to the current implementation
	enum eListOfVideoSources
	{
		eRVCA = 0,
		eRVCD,
		eDTV,
		eSPCX,
		eDVD,
		eUSB,
		eMaxSource
	};
};

#endif // _I_VIDEOMANAGER_LOOKUPTABLE_H_
