

/*****************************************************************************
* FILE:         fc_aux_ServiceAuxSrvIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_aux_app
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// fc_aux_tclServiceAuxSrvIfIncludes: user specific code start
// fc_aux_tclServiceAuxSrvIfIncludes: user specific code end

#include "fc_aux_ServiceAuxSrvIf.h"
#include "I_fc_aux_ServiceAuxSrv.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUX_APP_SERVER_AUXSRV
#include "trcGenProj/Header/fc_aux_ServiceAuxSrvIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_aux_tclServiceAuxSrvIf::
*             fc_aux_tclServiceAuxSrvIf(fc_aux_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_aux_tclServiceAuxSrvIf::fc_aux_tclServiceAuxSrvIf(fc_aux_tclAppMain* poMainAppl) : 
Ifc_aux_tclServiceAuxSrvIf(poMainAppl)
{
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrvIf() entered."));
   _poServerRef = OSAL_NULL;

   // fc_aux_tclServiceAuxSrvIfConstructor: user specific code start
   _poServerRef = dynamic_cast<Ifc_aux_tclServiceAuxSrv*>(_cpoMain->getHandler("Ifc_aux_tclServiceAuxSrv"));
   // fc_aux_tclServiceAuxSrvIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: fc_aux_tclServiceAuxSrvIf::
*             ~fc_aux_tclServiceAuxSrvIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_aux_tclServiceAuxSrvIf::~fc_aux_tclServiceAuxSrvIf(tVoid)
{
   ETG_TRACE_USR4(("~fc_aux_tclServiceAuxSrvIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // fc_aux_tclServiceAuxSrvIfDestructor: user specific code start
   // fc_aux_tclServiceAuxSrvIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrvIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'fc_aux_ServiceAuxSrvIf.h':
*     Add forward declaration:
*         class Ifc_aux_app_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_aux_app_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_aux_app_tclObject2Get*>(_cpoMain->getHandler("Ifc_aux_app_tclObject2Get"));
*     AUXSRV_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrvIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrvIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Ifc_aux_tclServiceAuxSrv*>(_cpoMain->getHandler("Ifc_aux_tclServiceAuxSrv"));

   FC_AUX_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // fc_aux_tclServiceAuxSrvIfvGetReferences: user specific code start
   // fc_aux_tclServiceAuxSrvIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrvIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrvIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrvIf::vStartCommunication() entered."));
   // fc_aux_tclServiceAuxSrvIfvStartCommunication: user specific code start
   // fc_aux_tclServiceAuxSrvIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrvIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrvIf::vHandleMessage(fc_aux_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrvIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(fc_aux_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // fc_aux_tclServiceAuxSrvIfvHandleMessage: user specific code start
   // fc_aux_tclServiceAuxSrvIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrvIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrvIf::vHandleTraceMessage(const tUChar* puchData)
{
   FC_AUX_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrvIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // fc_aux_tclServiceAuxSrvIfvHandleTraceMessage: user specific code start
   // fc_aux_tclServiceAuxSrvIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrvIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrvIf::vTraceInfo()
{
   // fc_aux_tclServiceAuxSrvIfvTraceInfo: user specific code start
   // fc_aux_tclServiceAuxSrvIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrvIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrvIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrvIf::onServiceAvailable() entered."));

   // fc_aux_tclServiceAuxSrvIfvOnServiceAvailable: user specific code start
   // fc_aux_tclServiceAuxSrvIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclServiceAuxSrvIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_aux_tclServiceAuxSrvIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("fc_aux_tclServiceAuxSrvIf::onServiceUnavailable() entered."));

   // fc_aux_tclServiceAuxSrvIfvOnServiceUnavailable: user specific code start
   // fc_aux_tclServiceAuxSrvIfvOnServiceUnavailable: user specific code end
}

tBool fc_aux_tclServiceAuxSrvIf::onAvailibilitySet(tU8 enAUXNumber, aux_fi_tcl_e8_AUXAvailabilityState enAUXAvailState, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onAvailibilitySet: user specific code start
   // onAvailibilitySet: user specific code end
   return _bResult;
}


tVoid fc_aux_tclServiceAuxSrvIf::sendAvailibilityStatus(aux_fi_tcl_AUX_States oStates) {
    //just forward send request
    FC_AUX_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAvailibilityStatus(oStates);
}

tVoid fc_aux_tclServiceAuxSrvIf::sendConnectionStateStatus(aux_fi_tcl_AUX_States oStates) {
    //just forward send request
    FC_AUX_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendConnectionStateStatus(oStates);
}







// fc_aux_tclServiceAuxSrvIffc_aux_ServiceAuxSrvIf: user specific code start
// fc_aux_tclServiceAuxSrvIffc_aux_ServiceAuxSrvIf: user specific code end

//EOF
