/*****************************************************************************
* FILE:         I_fc_aux_ServiceAuxSrv.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_aux_app
* Template:     I_ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _I_fc_aux_ServiceAuxSrv_H_
#define _I_fc_aux_ServiceAuxSrv_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
//Include FI interface of used service
#define AUX_FI_S_IMPORT_INTERFACE_AUX_MAINFI_STDVISITORS
#define AUX_FI_S_IMPORT_INTERFACE_AUX_MAINFI_FUNCTIONIDS
#include "aux_fi_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

//include base class
#include "fc_aux_AppMain.h"

// Ifc_aux_tclServiceAuxSrv_Include: user specific code start
// Ifc_aux_tclServiceAuxSrv_Include: user specific code end

class fc_aux_tclServiceAuxSrvCallbackIF;

class Ifc_aux_tclServiceAuxSrv : public ahl_tclBaseOneThreadService, public fc_aux_tclBaseIf
{
public:
   Ifc_aux_tclServiceAuxSrv(fc_aux_tclAppMain* poMainAppl, tU16 u16ServiceID, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion):
		ahl_tclBaseOneThreadService(poMainAppl, u16ServiceID, u16ServiceMajorVersion, u16ServiceMinorVersion),
		fc_aux_tclBaseIf(poMainAppl) {;}
   virtual ~Ifc_aux_tclServiceAuxSrv() {;}
   virtual const tChar* getIfName() const { return "Ifc_aux_tclServiceAuxSrv"; };

   virtual tVoid vSetCallbackIf(fc_aux_tclServiceAuxSrvCallbackIF* poCallback) = 0;


   virtual tBool onAvailibilitySet(tU8 enAUXNumber, aux_fi_tcl_e8_AUXAvailabilityState enAUXAvailState, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;

   virtual tVoid sendAvailibilityStatus(aux_fi_tcl_AUX_States oStates) = 0;
   virtual tVoid sendConnectionStateStatus(aux_fi_tcl_AUX_States oStates) = 0;



// Ifc_aux_tclServiceAuxSrvDeclarations: user specific code start
// Ifc_aux_tclServiceAuxSrvDeclarations: user specific code end
};

#endif // _I_fc_aux_ServiceAuxSrv_H_


