/*****************************************************************************
* FILE:         I_fc_aux_ClientSpm.h
* PROJECT:      G3G project
* SW-COMPONENT: __APP_NAME__
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _I_fc_aux_ClientSpm_H_
#define _I_fc_aux_ClientSpm_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
//Include FI interface of used service
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

//include base class
#include "fc_aux_AppMain.h"

// Ifc_aux_tclClientSpm_Include: user specific code start
// Ifc_aux_tclClientSpm_Include: user specific code end

class fc_aux_tclClientSpmCallbackIF;

class Ifc_aux_tclClientSpm : public ahl_tclBaseOneThreadClientHandler, public fc_aux_tclBaseIf
{
public:
   Ifc_aux_tclClientSpm(fc_aux_tclAppMain* poMainAppl, tU16 u16ServiceID, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion):
		ahl_tclBaseOneThreadClientHandler(poMainAppl, u16ServiceID, u16ServiceMajorVersion, u16ServiceMinorVersion),
		fc_aux_tclBaseIf(poMainAppl) {;}
   virtual ~Ifc_aux_tclClientSpm() {;}
   virtual const tChar* getIfName() const { return "Ifc_aux_tclClientSpm"; };

   virtual tVoid vSetCallbackIf(fc_aux_tclClientSpmCallbackIF* poCallback) = 0;

   virtual tBool sendSubStatesSet(spm_fi_tcl_SPM_e32_SubStateType SubStateType, tBool SubStateData) = 0;

   virtual tVoid getSubStatesStatus(tU32& rSubState, tU32& rHwSubState, tU32& rInternSubState) = 0;

   virtual tBool sendSubStatesGet() = 0;
   virtual tVoid getCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT& rCvmEvent) = 0;

   virtual tBool sendCvmEventGet() = 0;


// Ifc_aux_tclClientSpmDeclarations: user specific code start
// Ifc_aux_tclClientSpmDeclarations: user specific code end
};

#endif // _I_fc_aux_ClientSpm_H_


