

/*****************************************************************************
* FILE:         fc_aux_ClientDiagLog.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_aux_app
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// fc_aux_tclClientDiagLogIncludes: user specific code start
// fc_aux_tclClientDiagLogIncludes: user specific code end

#include "fc_aux_ClientDiagLog.h"
#include "fc_aux_ClientDiagLogCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUX_APP_CLIENT_DIAGLOG
#include "trcGenProj/Header/fc_aux_ClientDiagLog.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define DIAGLOG_SERVICE_ID              112
#define DIAGLOG_FI_MAJOR_VERSION        1
#define DIAGLOG_FI_MINOR_VERSION        6

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_aux_tclClientDiagLog, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleSendNextTestResultOpStatus)
   ON_MESSAGE_SVCDATA(MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleSaveTestResultOpMResult)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_aux_tclClientDiagLog::
*             fc_aux_tclClientDiagLog(fc_aux_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_aux_tclClientDiagLog::fc_aux_tclClientDiagLog(fc_aux_tclAppMain* poMainAppl) : 
Ifc_aux_tclClientDiagLog(poMainAppl, DIAGLOG_SERVICE_ID, DIAGLOG_FI_MAJOR_VERSION, DIAGLOG_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLog() entered."));
   _poCallbackIf = OSAL_NULL;
   _Status_SendNextTestResultStatus = FALSE;
   
   // fc_aux_tclClientDiagLogConstructor: user specific code start
   // fc_aux_tclClientDiagLogConstructor: user specific code end
   vAddAutoRegisterForProperty(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT);
}

/*******************************************************************************
*
* FUNCTION: fc_aux_tclClientDiagLog::
*             ~fc_aux_tclClientDiagLog(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_aux_tclClientDiagLog::~fc_aux_tclClientDiagLog(tVoid)
{
   ETG_TRACE_USR4(("~fc_aux_tclClientDiagLog() entered."));
   _poCallbackIf = OSAL_NULL;

   // fc_aux_tclClientDiagLogDestructor: user specific code start
   // fc_aux_tclClientDiagLogDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLog::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'fc_aux_ClientDiagLog.h':
*     Add forward declaration:
*         class Ifc_aux_app_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_aux_app_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_aux_app_tclObject2Get*>(_cpoMain->getHandler("Ifc_aux_app_tclObject2Get"));
*     DIAGLOG_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientDiagLog::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLog::vGetReferences() entered."));
   
   // fc_aux_tclClientDiagLogvGetReferences: user specific code start
   // fc_aux_tclClientDiagLogvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLog::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientDiagLog::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLog::vStartCommunication() entered."));
   // fc_aux_tclClientDiagLogvStartCommunication: user specific code start
   // fc_aux_tclClientDiagLogvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLog::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   fc_aux_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientDiagLog::vHandleMessage(fc_aux_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLog::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(fc_aux_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // fc_aux_tclClientDiagLogvHandleMessage: user specific code start
   // fc_aux_tclClientDiagLogvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLog::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientDiagLog::vHandleTraceMessage(const tUChar* puchData)
{
   FC_AUX_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("fc_aux_tclClientDiagLog::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // fc_aux_tclClientDiagLogvHandleTraceMessage: user specific code start
   // fc_aux_tclClientDiagLogvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLog::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientDiagLog::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      SendNextTestResult (MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SaveTestResult (MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT) -> Opcode: MethodStart, MethodResult, Error, "));

   // fc_aux_tclClientDiagLogvTraceInfo: user specific code start
   // fc_aux_tclClientDiagLogvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLog::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_aux_tclClientDiagLog::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // fc_aux_tclClientDiagLogvOnServiceAvailable: user specific code start
   // fc_aux_tclClientDiagLogvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientDiagLog::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_aux_tclClientDiagLog::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // fc_aux_tclClientDiagLogvOnServiceUnavailable: user specific code start
   // fc_aux_tclClientDiagLogvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT
*******************************************************************************/

tVoid fc_aux_tclClientDiagLog::vHandleSendNextTestResultOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         midw_diaglogfi_tclMsgSendNextTestResultStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, DIAGLOG_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _NextTestResultStruct_SendNextTestResultStatus = oStatus.NextTestResultStruct;
            _Status_SendNextTestResultStatus = oStatus.Status;

            ETG_TRACE_USR1(("fc_aux_tclClientDiagLog::vHandleSendNextTestResultOpStatus(): Status update message received for 'MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT' (FID: 0x000A)!"));

            onSendNextTestResultStatus(oStatus.NextTestResultStruct, oStatus.Status);

            // vHandleSendNextTestResultOpStatus: user specific code start
            // vHandleSendNextTestResultOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("fc_aux_tclClientDiagLog::vHandleSendNextTestResultOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid fc_aux_tclClientDiagLog::onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status) {

   if (_poCallbackIf) _poCallbackIf->onSendNextTestResultStatus(NextTestResultStruct, Status); 

   // onSendNextTestResultStatus: user specific code start
   // onSendNextTestResultStatus: user specific code end

}



/*******************************************************************************
* Handling of property MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT
*******************************************************************************/

tVoid fc_aux_tclClientDiagLog::vHandleSaveTestResultOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         midw_diaglogfi_tclMsgSaveTestResultMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, DIAGLOG_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("fc_aux_tclClientDiagLog::vHandleSaveTestResultOpMResult(): Method result update message received for 'MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT' (FID: 0x0001)!"));

            onSaveTestResultMResult(oMResult.Status);

            // vHandleSaveTestResultOpMResult: user specific code start
            // vHandleSaveTestResultOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("fc_aux_tclClientDiagLog::vHandleSaveTestResultOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid fc_aux_tclClientDiagLog::onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status) {

   if (_poCallbackIf) _poCallbackIf->onSaveTestResultMResult(Status); 

   // onSaveTestResultMResult: user specific code start
   // onSaveTestResultMResult: user specific code end

}





tBool fc_aux_tclClientDiagLog::sendSaveTestResultMStart(midw_fi_tcl_TestResultList TestResultList) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      midw_diaglogfi_tclMsgSaveTestResultMethodStart  oMStart;
      //the data content
      oMStart.TestResultList = TestResultList;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "fc_aux_tclClientDiagLog::sendSaveTestResultMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// fc_aux_tclClientDiagLogfc_aux_ClientDiagLog: user specific code start
// fc_aux_tclClientDiagLogfc_aux_ClientDiagLog: user specific code end

//EOF
