
/*****************************************************************************
* FILE:         fc_aux_ClientSpmIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_aux_app
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// fc_aux_tclClientSpmIfIncludes: user specific code start
#include "../../../appl/jack_detection/I_fc_auxJackDetection.h"
// fc_aux_tclClientSpmIfIncludes: user specific code end

#include "fc_aux_ClientSpmIf.h"
#include "Ifc_aux_ClientSpm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUX_APP_CLIENT_SPM
#include "trcGenProj/Header/fc_aux_ClientSpmIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_aux_tclClientSpmIf::
*             fc_aux_tclClientSpmIf(fc_aux_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_aux_tclClientSpmIf::fc_aux_tclClientSpmIf(fc_aux_tclAppMain* poMainAppl) : 
Ifc_aux_tclClientSpmIf(poMainAppl)
{
   ETG_TRACE_USR4(("fc_aux_tclClientSpmIf() entered."));
   _poClientRef = OSAL_NULL;

   // fc_aux_tclClientSpmIfConstructor: user specific code start
   // fc_aux_tclClientSpmIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: fc_aux_tclClientSpmIf::
*             ~fc_aux_tclClientSpmIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_aux_tclClientSpmIf::~fc_aux_tclClientSpmIf(tVoid)
{
   ETG_TRACE_USR4(("~fc_aux_tclClientSpmIf() entered."));
   _poClientRef = OSAL_NULL;

   // fc_aux_tclClientSpmIfDestructor: user specific code start
   // fc_aux_tclClientSpmIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientSpmIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'fc_aux_ClientSpmIf.h':
*     Add forward declaration:
*         class Ifc_aux_app_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_aux_app_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_aux_app_tclObject2Get*>(_cpoMain->getHandler("Ifc_aux_app_tclObject2Get"));
*     SPM_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientSpmIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("fc_aux_tclClientSpmIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ifc_aux_tclClientSpm*>(_cpoMain->getHandler("Ifc_aux_tclClientSpm"));

   FC_AUX_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // fc_aux_tclClientSpmIfvGetReferences: user specific code start
   // fc_aux_tclClientSpmIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientSpmIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientSpmIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("fc_aux_tclClientSpmIf::vStartCommunication() entered."));
   // fc_aux_tclClientSpmIfvStartCommunication: user specific code start
   // fc_aux_tclClientSpmIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientSpmIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   fc_aux_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientSpmIf::vHandleMessage(fc_aux_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("fc_aux_tclClientSpmIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(fc_aux_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // fc_aux_tclClientSpmIfvHandleMessage: user specific code start
   // fc_aux_tclClientSpmIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientSpmIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientSpmIf::vHandleTraceMessage(const tUChar* puchData)
{
   FC_AUX_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("fc_aux_tclClientSpmIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // fc_aux_tclClientSpmIfvHandleTraceMessage: user specific code start
   // fc_aux_tclClientSpmIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientSpmIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_aux_tclClientSpmIf::vTraceInfo()
{
   // fc_aux_tclClientSpmIfvTraceInfo: user specific code start
   // fc_aux_tclClientSpmIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientSpmIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_aux_tclClientSpmIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("fc_aux_tclClientSpmIf::onServiceAvailable() entered."));

   // fc_aux_tclClientSpmIfvOnServiceAvailable: user specific code start
   // fc_aux_tclClientSpmIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_aux_tclClientSpmIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_aux_tclClientSpmIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("fc_aux_tclClientSpmIf::onServiceUnavailable() entered."));

   // fc_aux_tclClientSpmIfvOnServiceUnavailable: user specific code start
   // fc_aux_tclClientSpmIfvOnServiceUnavailable: user specific code end
}

tVoid fc_aux_tclClientSpmIf::onSubStatesStatus(tU32 SubState, tU32 HwSubState, tU32 InternSubState) {
   ETG_TRACE_USR1( ( "fc_aux_tclClientSpmIf::onSubStatesStatus(): CALLED" ) );

   // onSubStatesStatus: user specific code start
   // onSubStatesStatus: user specific code end
}
tVoid fc_aux_tclClientSpmIf::onCvmEventStatus(spm_fi_tcl_SPM_e32_CVM_EVENT CvmEvent) {
   ETG_TRACE_USR1( ( "fc_aux_tclClientSpmIf::onCvmEventStatus(): CALLED" ) );

   // onCvmEventStatus: user specific code start
   I_fc_auxJackDetection* _jackDetection = dynamic_cast<I_fc_auxJackDetection*>(_cpoMain->getHandler("I_fc_auxJackDetection"));
   FC_AUX_NULL_POINTER_CHECK(_jackDetection);

   switch(CvmEvent.enType)
   {
   case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START:
	   ETG_TRACE_USR1(("fc_aux_tclClientSpmIf::onCvmEventStatus(): CRITICAL LOW VOLTAGE START"));
	   _jackDetection->bSetVoltageIsOK(false);
	   break;
   case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END:
	   ETG_TRACE_USR1(("fc_aux_tclClientSpmIf::onCvmEventStatus(): CRITICAL LOW VOLTAGE END"));
	   _jackDetection->bSetVoltageIsOK(true);
	   break;
   case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START:
	   ETG_TRACE_USR1(("fc_aux_tclClientSpmIf::onCvmEventStatus(): LOW VOLTAGE START"));
	   _jackDetection->bSetVoltageIsOK(true);
	   break;
   case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END:
	   ETG_TRACE_USR1(("fc_aux_tclClientSpmIf::onCvmEventStatus(): LOW VOLTAGE END"));
	   _jackDetection->bSetVoltageIsOK(true);
	   break;
   case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START:
	   ETG_TRACE_USR1(("fc_aux_tclClientSpmIf::onCvmEventStatus(): HIGH VOLTAGE START"));
	   _jackDetection->bSetVoltageIsOK(true);
	   break;
   case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END:
	   ETG_TRACE_USR1(("fc_aux_tclClientSpmIf::onCvmEventStatus(): HIG VOLTAGE END"));
	   _jackDetection->bSetVoltageIsOK(true);
	   break;
   case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START:
	   ETG_TRACE_USR1(("fc_aux_tclClientSpmIf::onCvmEventStatus(): CRITICAL HIGH VOLTAGE START"));
	   _jackDetection->bSetVoltageIsOK(true);
	   break;
   case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END:
	   ETG_TRACE_USR1(("fc_aux_tclClientSpmIf::onCvmEventStatus(): CRITICAL HIG VOLTAGE END"));
	   _jackDetection->bSetVoltageIsOK(true);
	   break;
   case spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT:
	   ETG_TRACE_USR1(("fc_aux_tclClientSpmIf::onCvmEventStatus(): NO EVENT"));
      _jackDetection->bSetVoltageIsOK(true);
      break;
   default:
	   break;
   }
   // onCvmEventStatus: user specific code end
}




// fc_aux_tclClientSpmIffc_aux_ClientSpmIf: user specific code start
// fc_aux_tclClientSpmIffc_aux_ClientSpmIf: user specific code end

//EOF
