/************************************************************************
* FILE:        	I_fc_auxJackDetection.h
* PROJECT:		Nissan / Renault A-IVI
* SW-COMPONENT:	fc_aux
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class to jack detection
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 13.05.2015| CM-AI/EPB2 Schurig | init
*
*************************************************************************/

#ifndef I_FC_AUXJACKDETECTION_H_
#define I_FC_AUXJACKDETECTION_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "fc_aux_AppMain.h"

class I_fc_auxJackDetection : public fc_aux_tclBaseIf
{
public:
	I_fc_auxJackDetection(void);
	I_fc_auxJackDetection(const fc_aux_tclAppMain* poMainAppl) : fc_aux_tclBaseIf (poMainAppl) {;};
	
	virtual ~I_fc_auxJackDetection(){};
	
	virtual const tChar* getIfName() const { return "I_fc_auxJackDetection"; };

	virtual bool bGetVoltageIsOK() = 0;
	virtual void bSetVoltageIsOK(bool voltageIsOK) = 0;
	virtual void vSetNewConnectionStatus(bool bIsNewDevice = false) = 0;

protected:
	bool _bVoltageIsOK = false;
};

#endif /* I_FC_AUXJACKDETECTION_H_ */
