/*
 * Copyright (C) 2008-2013 J.Rios <anonbeat@gmail.com>
 * Copyright (C) 2013 Jörn Magens
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This Program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file LICENSE.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth 
 * Floor, Boston, MA  02110-1301  USA
 * https://www.gnu.org/licenses/lgpl-2.1.txt
 *
 * Author:
 * 	Jörn Magens <shuerhaaken@googlemail.com>
 * 	Pavel Vasin <rat4vier@gmail.com>
 */



#include "taginfo.h"
#include <stdio.h>
#include <string.h>
#include "taginfo_internal.h"

#define COVER_ART_FRONT         "COVER ART (FRONT)"
#define COVER_ART_OTHER         "COVER ART (OTHER)"
#define TAG_LYRICS              "LYRICS"
#define TAG_LYRICS_UNSYNCED     "UNSYNCED LYRICS"



void check_ape_label_frame(TagLib::APE::Tag * apetag, const char * description, const String &value) {
    if(apetag->itemListMap().contains(description))
        apetag->removeItem(description);
    if(!value.isEmpty()) {
            apetag->addValue(description, value);
    }
}


bool get_ape_item_image(const TagLib::APE::Item &item, char*& data, int &data_length, ImageType &image_type) {
    image_type = IMAGE_TYPE_UNKNOWN;
    if(item.type() == TagLib::APE::Item::Binary) {
        TagLib::ByteVector CoverData = item.binaryData();
        if(CoverData.size() > 0) {
            data_length = CoverData.size();
            data = new char[data_length];
            memcpy(data, CoverData.data(), CoverData.size());
            return true;
        }
    }
    return false;
}


bool get_ape_image(TagLib::APE::Tag * apetag, char*& data, int &data_length, ImageType &image_type) {
    data = NULL;
    data_length = 0;
    
    if(apetag) {
        //for(APE::ItemListMap::ConstIterator it = apetag->itemListMap().begin();
        //   it != apetag->itemListMap().end(); ++it) {
        //  cout << (*it).first << " - \""  << "\"" << endl; //<< (*it).second.toString()
        //}
        
        if(apetag->itemListMap().contains(COVER_ART_FRONT)) {
            return get_ape_item_image(apetag->itemListMap()[COVER_ART_FRONT],
                                      data, data_length, image_type);
        }
        else if(apetag->itemListMap().contains(COVER_ART_OTHER)) {
            return get_ape_item_image(apetag->itemListMap()[COVER_ART_OTHER],
                                      data, data_length, image_type);
        }
        return false;
    }
    return false;
}



bool set_ape_image(TagLib::APE::Tag * apetag, const char* data, int data_length, ImageType image_type) {
    if(apetag) {
        APE::ItemListMap listmap = apetag->itemListMap();
        if(listmap.contains(COVER_ART_FRONT))
            apetag->removeItem(COVER_ART_FRONT);
        
        if(!data || data_length <= 0)
            return true;
        
        ByteVector ImgData = ByteVector((TagLib::uint) data_length);
        memcpy(ImgData.data(), data, data_length);
        
        APE::Item imageItem = APE::Item();
        imageItem.setType(TagLib::APE::Item::Binary);
        imageItem.setKey(COVER_ART_FRONT);
        imageItem.setBinaryData(ImgData);
        //if(imageItem.isEmpty())
        //    cout << "set#5.1" << endl;
        //else
        //    cout << "set#5.2" << endl;
        apetag->setItem(COVER_ART_FRONT, imageItem);
        return true;
    }
    return false;
}



String get_ape_lyrics(APE::Tag * apetag) {
    if(apetag) {
        if(apetag->itemListMap().contains(TAG_LYRICS)) {
            return apetag->itemListMap()[TAG_LYRICS].toStringList().front();
        }
        else if(apetag->itemListMap().contains(TAG_LYRICS_UNSYNCED)) {
            return apetag->itemListMap()[TAG_LYRICS_UNSYNCED].toStringList().front();
        }
    }
    return String();
}


bool set_ape_lyrics(APE::Tag * apetag, const String &lyrics) {
    if(apetag) {
        if(apetag->itemListMap().contains(TAG_LYRICS)) {
            apetag->removeItem(TAG_LYRICS);
        }
        if(apetag->itemListMap().contains(TAG_LYRICS_UNSYNCED)) {
            apetag->removeItem(TAG_LYRICS_UNSYNCED);
        }
        if(!lyrics.isEmpty()) {
            apetag->addValue(TAG_LYRICS, lyrics);
        }
        return true;
    }
    return false;
}

