#include <stdio.h>
#include <taglib/fileref.h>
#include <taglib/vorbisfile.h>  //ogg file
#include <taglib/mpegfile.h>    //mp3 file
#include <taglib/rifffile.h>    //riff file
#include <taglib/wavfile.h>     //wave file
#include <taglib/aifffile.h>    //aiff file
#include <taglib/asffile.h>     //asf file
#include <taglib/mp4file.h>     //mp4 file
#include <taglib/mp4tag.h>      //mp4tag
#include <taglib/id3v2tag.h>    //id3 tag
#include <taglib/id3v2frame.h>  //id3 frame
#include <taglib/attachedpictureframe.h>
#include <taglib/id3v2header.h>
#include <taginfo.h>
#include<sys/time.h>
#include <unistd.h>

#ifdef DEBUG_VIDEOMETASCAN
#include<syslog.h>
#endif //DEBUG_VIDEOMETASCAN

const short int VideoMetascanProcessPriority = 30;
const short int VideoMetascanProcessNiceness = -4;
const short int uidofRootUser = 0;

using namespace std;
using namespace TagInfo;

int main(int argc, char **argv)
{
    int processpid = (int)getpid();
    char renicecommand[100];
    snprintf(renicecommand, sizeof(renicecommand), "renice -n %d -p %d",VideoMetascanProcessNiceness,processpid );

    char chrtcommand[100];
    snprintf(chrtcommand,sizeof(chrtcommand),"chrt -r  -p %d %d ",VideoMetascanProcessPriority,processpid);


    if(uidofRootUser == (int)getuid())
    {
#ifdef DEBUG_VIDEOMETASCAN
        syslog(LOG_INFO, " VideoMetascan trying to renice the process with command : %s",renicecommand);
        syslog(LOG_INFO, " VideoMetascan trying to priorities the process with command : %s",chrtcommand);
#endif//DEBUG_VIDEOMETASCAN
        system(renicecommand);
        system(chrtcommand);
    }
    //Remark: do not use "-1" as return value because it is used for general system call error


#ifdef DEBUG_VIDEOMETASCAN
    syslog(LOG_INFO, "GST_REGISTRY_FORK : %s\n", getenv("GST_REGISTRY_FORK"));
    syslog(LOG_INFO, "GST_REGISTRY_UPDATE : %s\n", getenv("GST_REGISTRY_UPDATE"));
    syslog(LOG_INFO, "GST_REGISTRY : %s\n", getenv("GST_REGISTRY"));
#endif//DEBUG_VIDEOMETASCAN

#ifdef TARGET_BUILD
    gst_registry_fork_set_enabled (false);
#endif


#ifdef DEBUG_VIDEOMETASCAN
    syslog(LOG_INFO, "Entry VideoMetascan");
#endif //DEBUG_VIDEOMETASCAN

    if (argc <= 2) {
        printf("usage: %s video-file-name [output-file-name]\n", argv[0]);
        exit(-2);
    }

    char *videoFileName = NULL;
    char *outputFileName = NULL;
    FILE *fpOut = stdout;

    videoFileName = argv[1];
    if (argc == 3) {
        outputFileName = argv[2];

#ifdef DEBUG_VIDEOMETASCAN
        syslog(LOG_INFO, "VideoMetascan:OPEN temp File %s",outputFileName);
#endif //DEBUG_VIDEOMETASCAN

        fpOut = fopen(outputFileName, "w");
        if (!fpOut) {
            fprintf(stderr, "error: could not open %s for writing\n", outputFileName);
            exit(-3);
        }
#ifdef DEBUG_VIDEOMETASCAN
        syslog(LOG_INFO, "VideoMetascan:temp File OPENED");
#endif//DEBUG_VIDEOMETASCAN

    }

#ifdef DEBUG_VIDEOMETASCAN
    syslog(LOG_INFO, "VideoMetascan:create_tag_info");
#endif //DEBUG_VIDEOMETASCAN

    /* open video file and read all needed information */
    Info *info = Info::create_tag_info(videoFileName);

#ifdef DEBUG_VIDEOMETASCAN
    syslog(LOG_INFO, "VideoMetascan:create_tag_info DONE");
#endif //DEBUG_VIDEOMETASCAN

    if(info)
    {

#ifdef DEBUG_VIDEOMETASCAN
        syslog(LOG_INFO, "VideoMetascan:Begin info->read()");
#endif //DEBUG_VIDEOMETASCAN.

        if(info->read())
        {

#ifdef DEBUG_VIDEOMETASCAN
            syslog(LOG_INFO, "VideoMetascan:Finished info->read()");
#endif //DEBUG_VIDEOMETASCAN

            /* write output data */
            fprintf(fpOut, "videoFileName=%.1024s\n", videoFileName);
            fprintf(fpOut, "videocodec=%.256s\n", info->get_videocodec().toCString(true));
            fprintf(fpOut, "profile=%.256s\n", info->get_profile().toCString(true));
            fprintf(fpOut, "level=%f\n", info->get_level());
            fprintf(fpOut, "width=%d\n", info->get_width());
            fprintf(fpOut, "height=%d\n", info->get_height());
            fprintf(fpOut, "bitRate=%d\n", info->get_bitrate());
            fprintf(fpOut, "frameRate=%d\n", info->get_framerate());
            fprintf(fpOut, "isLatin1=%d\n", info->get_title().isLatin1());
            fprintf(fpOut, "title.to8Bit(false)=%.256s\n", const_cast<char*>((info->get_title().to8Bit(false)).c_str()));
            fprintf(fpOut, "title.to8Bit(true)=%.256s\n", const_cast<char*>((info->get_title().to8Bit(true)).c_str()));
            fprintf(fpOut, "title.toCString(convertToUnicode0)=%.256s\n", info->get_title().toCString(false));
            fprintf(fpOut, "title.toCString(convertToUnicode1)=%.256s\n", info->get_title().toCString(true));
            fprintf(fpOut, "duration=%lld\n", info->get_duration());
            fprintf(fpOut, "tracknumber=%d\n", info->get_tracknumber());
            fprintf(fpOut, "encrypted=%d\n", info->get_encrypted());
            fprintf(fpOut, "media_type=%d\n", info->get_media_type());

#ifdef DEBUG_VIDEOMETASCAN
            syslog(LOG_INFO, "VideoMetascan:info->read() RESULT Stored");
#endif //DEBUG_VIDEOMETASCAN


            if (fpOut) fclose(fpOut);

        } else {

#ifdef DEBUG_VIDEOMETASCAN
            syslog(LOG_INFO, "VideoMetascan:info->read() returned NULL");
#endif //DEBUG_VIDEOMETASCAN

            if (fpOut) fclose(fpOut);
            exit(-5);
        }
    } else {

#ifdef DEBUG_VIDEOMETASCAN
        syslog(LOG_INFO, "VideoMetascan:info CREATION  NULL");
#endif //DEBUG_VIDEOMETASCAN

        if (fpOut) fclose(fpOut);
        exit(-4);
    }

#ifdef DEBUG_VIDEOMETASCAN
   syslog(LOG_INFO, "Exit VideoMetascan");
#endif// DEBUG_VIDEOMETASCAN

    exit(0);
}
