/************************************************************************
* FILE:         vdmmgr_clienthandlerdiaglog.h
* PROJECT:      MIB2_ENTRY
* SW-COMPONENT: Virtual Device Media Manager
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2006 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 20.04.06  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/

#ifndef _VDMMGR_CLIENT_HANDLERDIAGLOG_H_
#define _VDMMGR_CLIENT_HANDLERDIAGLOG_H_

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#include "Config.h"

class vdmmgr_tclApp;//lint !e763 Info 763;Redundant declaration for symbol 'x'
class midw_fi_tcl_TestResult; //forward declaration of pointer


//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------

//service id
#define VDMMGR_C_U16_SERVICE_DIAGLOG_MAJOR_VERSION 1 
#define VDMMGR_C_U16_SERVICE_DIAGLOG_MINOR_VERSION 0

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
// --- the application has one client message handler for each service ---
class vdmmgr_tclclienthandlerdiaglog : public ahl_tclBaseWork
{
private:
   vdmmgr_tclApp*            poMain;

   // ---   to store the RegID of the service    ---
   tU16     _u16RegID;
   tBool    _bFidReg;
   // Asynchronous registration for Service has started
   tBool    _bRegAsyncStarted;

   //---------------------------------------------------------------------
   tBool bRegisterForService();
   //---------------------------------------------------------------------
   tBool bUnregisterForService();
   //---------------------------------------------------------------------
   tBool bRegisterForFID(tU16 u16FID);
   //---------------------------------------------------------------------
   tBool bUnregisterForFID(tU16 u16FID);
   //---------------------------------------------------------------------
   vdmmgr_tclclienthandlerdiaglog();//lint !e1704 ;Constructor 'vdmmgr_tclclienthandlerdiaglog::vdmmgr_tclclienthandlerdiaglog(void)' has private access specification
   /*lint -e1704 
       Info 1704: Constructor 'vdmmgr_tclclienthandlerdiaglog::vdmmgr_tclclienthandlerdiaglog(const vdmmgr_tclclienthandlerdiaglog &)' has private access specification
   */
   vdmmgr_tclclienthandlerdiaglog& operator=( const vdmmgr_tclclienthandlerdiaglog& oTheOther )
   {
      if(this != &oTheOther)
      {
         poMain            = NULL;
         _u16RegID         = AMT_C_U16_REGID_INVALID;
         _bFidReg          = FALSE;
         _bRegAsyncStarted = FALSE;
         _ItcMap           = oTheOther._ItcMap;
      }
      return  *this ;
   };

   vdmmgr_tclclienthandlerdiaglog(const vdmmgr_tclclienthandlerdiaglog& oTheOther)
                                   :ahl_tclBaseWork(oTheOther)
   {
      poMain            = NULL;
      _u16RegID         = AMT_C_U16_REGID_INVALID;
      _bFidReg          = FALSE;
      _bRegAsyncStarted = FALSE;
      *this = oTheOther; 
   };
   /*lint -restore*/

protected:
   //---------------------------------------------------------------------
   virtual tVoid vOnUnknownMessage( amt_tclBaseMessage* poMessage );
   //---------------------------------------------------------------------

public:
   // public variables
   // stl map for error status and routine status for an ITC
   vdmmgr_tclITC_Map _ItcMap;

   // public functions
   //---------------------------------------------------------------------
   vdmmgr_tclclienthandlerdiaglog      (vdmmgr_tclApp* poMain); // constructor
   //---------------------------------------------------------------------
   tVoid    vOnNewAppState             ( tU32 u32OldAppState, tU32 u32AppState );
   //---------------------------------------------------------------------
   tVoid vOnAsyncRegisterConf          ( tU16 u16RegisterId, tU16 u16ServerAppId,tU16 u16ServiceId, tU16 u16TargetSubId );
   //---------------------------------------------------------------------
   tVoid    vHandleSaveTestResult      ( amt_tclServiceData* poMessage ) ;
   tVoid    vHandleSendNextTestResult  ( amt_tclServiceData* poMessage );
   //--------------------------------------------------------------------


   tBool    bStoreITCValueInDiagLog    ( const midw_fi_tcl_TestResult* poe8TestResult );
   //---------------------------------------------------------------------
#ifdef USE_REPLACE_E8_TESTRESULT
   tVoid    vSetITC                    ( tU16 u16ITC, tU8 oe8TestResult );
#else
    tVoid    vSetITC                    ( tU16 u16ITC, midw_fi_tcl_TestResult::tenType oe8TestResult );
#endif




   //---------------------------------------------------------------------
   tVoid vOnServiceState( tU16 u16ServiceId, tU16 u16ServerId, tU16 u16RegisterId, 
                          tU8  u8ServiceState, tU16 u16SubId );
   //---------------------------------------------------------------------

   /* +++   Enter your public Data and functions here   +++ */


   DECLARE_MSG_MAP(vdmmgr_tclclienthandlerdiaglog)

};

#endif // _VDMMGR_CLIENT_HANDLERDIAGLOG_H_
