/************************************************************************
* FILE:         vdmmgr_ITC_Map.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Virtual Device Keyboard
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 13.09.06  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/

#ifndef _VDMMGR_ITC_MAP_H
#define _VDMMGR_ITC_MAP_H

#include "Config.h"

class vdmmgr_tclITC_Map
{
public:

   typedef std::map< tU16, vdmmgr_tclITC_Container*> itc_map_t;

   tBool bAddITCContainer  (vdmmgr_tclITC_Container*);

   // Set functions
   tBool bSetErrorStatusForITC   ( tU16 u16ITC, tU16 u16ErrorStatus );
   tBool bSetRoutineStatusForITC ( tU16 u16ITC, tU16 u16RoutineStatus );
   // Get functions
   tU16 bGetErrorStatusForITC    ( tU16 u16ITC );
   tU16 bGetRoutineStatusForITC  ( tU16 u16ITC );

   vdmmgr_tclITC_Map();
   virtual ~vdmmgr_tclITC_Map();

private:
   itc_map_t   _Map;  // Composition

};
#endif //_VDMMGR_ITC_MAP_H
