/************************************************************************
* FILE:         vdmmgr_ITC_Map.cpp
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Virtual Device Keyboard
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 13.09.06  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/
#include "Config.h"
#include <map>
#include <algorithm>

#define VDMMGR_S_IMPORT_INTERFACE_MSG
#include "vdmmgr_if.h"              // for VD MMgr and System

#include "vdmmgr_ITC_Container.h"
#include "vdmmgr_ITC_Map.h"


namespace
{
    // Functor
    struct delete_itc
    {
        void operator()( const vdmmgr_tclITC_Map::itc_map_t::value_type& val ) const
        {
            delete val.second;
        }
    };
} // close anonymous namespace


vdmmgr_tclITC_Map::vdmmgr_tclITC_Map() 
{
}


vdmmgr_tclITC_Map::~vdmmgr_tclITC_Map()
{
   (tVoid)std::for_each( _Map.begin(), _Map.end(), delete_itc());//lint !e1551 Function may throw exception '...' in destructor 'vdkbd_tclApp::~vdkbd_tclApp(void)'
}


tBool vdmmgr_tclITC_Map::bAddITCContainer( vdmmgr_tclITC_Container* potclITCContainer )
{
   tBool bRet = TRUE;
   tBool bExists;

   // Check if the ITC already exists in _Map
   bExists = ( _Map.find( potclITCContainer->u16GetITC() ) != _Map.end() );//lint !e1702 !e1793 Info 1702; operator 'operator!=' is both an ordinary function
   if( bExists )
   {
      bRet = FALSE;     // do nothing if the ITC already exists
      // Normaly this shouldn't happen
   }
   else
   {
      // Make ITC and pointer a pair and insert it into _Map
      (tVoid)_Map.insert(std::make_pair( potclITCContainer->u16GetITC( ), potclITCContainer ) );
      bRet = TRUE;
   }

   return bRet;
}


tBool vdmmgr_tclITC_Map::bSetErrorStatusForITC( tU16 u16ITC, tU16 u16ErrorStatus )
{
   tBool bFound;
   vdmmgr_tclITC_Container* pContainer;

   itc_map_t::const_iterator it = _Map.find( u16ITC );
   bFound = ( it != _Map.end() );//lint !e1702 Info 1702;;operator 'operator!=' is both an ordinary function
   if( bFound )
   {
      pContainer = it->second;
      pContainer->vSetErrorStatus( u16ErrorStatus );
   }
   return bFound;
}


tBool vdmmgr_tclITC_Map::bSetRoutineStatusForITC( tU16 u16ITC, tU16 u16RoutineStatus )
{
   tBool bFound;
   vdmmgr_tclITC_Container* pContainer;

   itc_map_t::const_iterator it = _Map.find( u16ITC );
   bFound = ( it != _Map.end() );//lint !e1702 Info 1702;;operator 'operator!=' is both an ordinary function
   if( bFound )
   {
      pContainer = it->second;
      pContainer->vSetRoutineStatus( u16RoutineStatus );
   }
   return bFound;
}


tU16 vdmmgr_tclITC_Map::bGetErrorStatusForITC( tU16 u16ITC )
{
   tBool bFound;
   vdmmgr_tclITC_Container* pContainer;

   itc_map_t::const_iterator it = _Map.find( u16ITC );
   bFound = ( it != _Map.end() );//lint !e1702 Info 1702;;operator 'operator!=' is both an ordinary function
   if( bFound )
   {
      pContainer = it->second;
      return pContainer->u16GetErrorStatus( );
   }
   else
   {
      return FALSE;
   }
}


tU16 vdmmgr_tclITC_Map::bGetRoutineStatusForITC( tU16 u16ITC )
{
   tBool bFound;
   vdmmgr_tclITC_Container* pContainer;

   itc_map_t::const_iterator it = _Map.find( u16ITC );
   bFound = ( it != _Map.end() );//lint !e1702 Info 1702;;operator 'operator!=' is both an ordinary function
   if( bFound )
   {
      pContainer = it->second;
      return pContainer->u16GetRoutineStatus( );
   }
   else
   {
      return FALSE;
   }
}
