/************************************************************************
* FILE:         vdmmgr_ITC_Container.h
* PROJECT:      ARION Prototyp
* SW-COMPONENT: Virtual Device Keyboard
*----------------------------------------------------------------------
*
* DESCRIPTION: VD MediaManager
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 13.09.06  | CM-DI/ESA2 Fiebing | initial version
*
*************************************************************************/

#ifndef _VDMMGR_ITC_CONTAINER_H
#define _VDMMGR_ITC_CONTAINER_H

#include "Config.h"

class vdmmgr_tclITC_Container
{
private:
   tU16  _u16ITC;
   tU16  _u16ErrorStatus;
   tU16  _u16RoutineStatus;
   vdmmgr_tclITC_Container();//lint !e1704 ;Constructor 'vdmmgr_tclITC_Container::vdmmgr_tclITC_Container(void)' has private access specification

public:
   // constructor / destructor
   vdmmgr_tclITC_Container( tU16 u16ITC, tU16 u16ErrorStatus = (tU16)MMGR_RoutineNeverRan, tU16 u16RoutineStatus = (tU16)MMGR_RoutineNotRunning ) :
                                                            _u16ITC( u16ITC ), _u16ErrorStatus(u16ErrorStatus), _u16RoutineStatus(u16RoutineStatus )
   {
   }

   virtual ~vdmmgr_tclITC_Container(){};

   // Get functions
   tU16  u16GetITC() const           { return _u16ITC; }
   tU16  u16GetErrorStatus() const   { return _u16ErrorStatus; }
   tU16  u16GetRoutineStatus() const { return _u16RoutineStatus; }
   // Set functions
   tVoid vSetErrorStatus   ( tU16 u16ErrorStatus );
   tVoid vSetRoutineStatus ( tU16 u16RoutineStatus );
};

#endif //_VDMMGR_ITC_CONTAINER_H
