///@todo check if History works still fine
///@todo throw out UNKNOWN_DEVICE which i still send if clients register
///@todo ROADMAP13035_Overtemp: Rename VD_DeviceManager_Service_DeviceManager to VD_DeviceManagerService
/*-----------------------------------------------------------------------------*
 * VD_DeviceManager_service_DeviceManager.cpp                                  *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2012 Robert Bosch GmbH, Hildesheim                        *
 *
           *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file VD_DeviceManager_service_DeviceManager.cpp
 *
 * \brief This file holds the implementation for class
 *        vd_devicemanager_tclService_DeviceManager. With this class CCA
 *        messages are created for the clients
 *
 * \version Initial Version
 * \version 05.08.2011, Koechling, Christian (Bosch), Interface VD_DeviceManager
 *          changed
 * \version 01.11.2011, Koechling, Christian (Bosch),
 *          -# added function to support stateTable to inform clients
 *          -# added function to support TTFIS cmd to get last msg send to
 *          clients ttfis command
 * \version 17.11.2011, Koechling, Christian  (Bosch),cleanup: 1st step to shift
 *          includes to Common.h
 * \version 21.11.2011, Koechling, Christian (Bosch), cleanup includes and
 *          intermediate defines which marked bugfixes
 * \version 28.11.2011, Koechling, Christian (Bosch), cleanup - add headers
 * \version 06.12.2011, Koechling, Christian (Bosch), add send index for better
 *          analysis
 * \version 06.01.2012, Koechling, Christian (Bosch), cleanup FATAL traces
 * \version 16.02.2012, Negi, Sunder (Montavista)   , added some logs, cleanup -- lint
 * \version 23.02.2012, Koechling, Christian (Bosch), extend status property to
 *          send with index>0 all connected devices
 * \version 07.03.2012, Koechling, Christian (Bosch), merged MV-code Feb27 -
 *          contains issue for startup synchronisation
 * \version 10.03.2012, Koechling, Christian (Bosch), cleanup function to trace
 *          history of messages send to clients
 * \version 23.03.2012, Keochling, Christian (Bosch), trace: in case of service
 *          unavailable show that VD_DVM did not send property
 * \version 19.07.2012, Koechling, Christian (Bosch), add mechanism to log
 *          histories for analysis to USB-stick
 * \version 27.07.2012, Negi, Sunder (MontaVista), Cleaned up file hierarchy
 * \version 02.08.2012, Negi, Sunder (MontaVista),
 *          -# Refactored debug information logging
 *          -# Added History Manager, refer define HISTORY_MANAGER
 * \version 05.08.2012, Negi, Sunder (MontaVista), Modified and fixed doxygen comments
 * \version 10.08.2012, Negi, Sunder (MontaVista), renamed singleton functions
 * \version 12.08.2012, Negi, Sunder (MontaVista), cleanup HISTORY_MANAGER
 * \version 13.08.2012, Negi, Sunder (MontaVista), cleanup logging to usb (WRITEHISTORYTOUSBSTICK)
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH  2010-2016
 */

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include <stdio.h>
#include "Config.h"

#define INCLUDE_VD_DVM_AILAHL
#define INCLUDE_VD_DVM_GENERIC
#define INCLUDE_VD_DVM_BASICS
#include "Common.h"

#define DIAGLIB_INCLUDE_GENERIC
#include <diaglib_if.h>
using namespace diaglib;

#include "Enums.h"
#include "Device.h"
#include "DeviceCard.h"
#include "Diagnosis.h"
#include "StateTable.h"
#include "device/DeviceListManager.h"
#include "interface/DeviceManagerInterface.h"

#include "diag/DiagLibHandlerGen2.h"
#include "client/VD_DeviceManager_clienthandler_Diaglog.h"
#include "WorkThread.h"
#include "service/VD_DeviceManager_service_DeviceManager.h"
#include "VD_DeviceManager_main.h"

#include "debug/HistoryManager.h"
#include "ports/PortListManager.h"

#include "config/ConfigurationManager.h"

/*-----------------------------------------------------------------------------*
 * ETG Tracing                                                                 *
 *-----------------------------------------------------------------------------*/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_dvm.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER
#include "trcGenProj/Header/VD_DeviceManager_service_DeviceManager.cpp.trc.h"
#endif

#include "ETGTrace.h"
#endif //VARIANT_S_FTR_ENABLE_UNITTEST

/*-----------------------------------------------------------------------------*
 * Defines                                                                     *
 *-----------------------------------------------------------------------------*/
#define VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION  MPLAY_DEVICEMANAGERFI_C_U16_SERVICE_MAJORVERSION
#define VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION  MPLAY_DEVICEMANAGERFI_C_U16_SERVICE_MINORVERSION
#define VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_PATCH_VERSION  0 //TODO find out proper defines from the generated fi code

/*-----------------------------------------------------------------------------*
 * CCA_Message MAP                                                             *
 *-----------------------------------------------------------------------------*/
BEGIN_MSG_MAP(vd_devicemanager_tclService_DeviceManager, ahl_tclBaseWork)

// Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
// method should be called on receiving a specific message.
//message map for Get Device properties
ON_MESSAGE_SVCDATA(DEVMGR_GETDEVPROPERTIES,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
                   vHandle_DeviceManagerGetDeviceProperties_MethodStart)
// message map for properties of all connected devices
ON_MESSAGE_SVCDATA(DEVMGR_GETALLCONNECTEDDEVICES,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
                   vHandle_DeviceManagerGetAllConnectedDevices_MethodStart)
#ifdef DEVMGR_MOUNTCDROMINTERNAL //to keep it backward compatible with old Nissan throw this out later
// message map for properties of all connected devices
ON_MESSAGE_SVCDATA(DEVMGR_MOUNTCDROMINTERNAL,                                //Roadmap 14002 MountCDROM
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
                   vHandle_DeviceManagerMountCDRomInternal_MethodStart)
#endif
// message map for properties of all connected devices
ON_MESSAGE_SVCDATA(DEVMGR_EJECTOPTICALDISC,                                //Roadmap 15002 CD Audio device Detection
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
                   vHandle_DeviceManagerOpticalDiscEject_MethodStart)

ON_MESSAGE_SVCDATA(DEVMGR_SETCONFIGURATIONVALUE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
                   vHandle_DeviceManagerSetConfigurationValue_MethodStart)
ON_MESSAGE_SVCDATA(DEVMGR_GETCONFIGURATIONVALUE,
                   AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
                   vHandle_DeviceManagerGetConfigurationValue_MethodStart)

END_MSG_MAP()

/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace statetbl;
using namespace servicedvm;

/*-----------------------------------------------------------------------------*
 * defines
 *-----------------------------------------------------------------------------*/
#define UNDEF_ELEM ((tInt) -1)

/*-----------------------------------------------------------------------------*
 * Constructor                                                                 *
 *-----------------------------------------------------------------------------*/
vd_devicemanager_tclService_DeviceManager::
vd_devicemanager_tclService_DeviceManager(vd_devicemanager_tclApp* poMainAppl)
    :ahl_tclBaseOneThreadService(
          /* Application Pointer              */ poMainAppl,
          /* ID of offered Service            */ CCA_C_U16_SRV_DEVICEMANAGER,
          /* MajorVersion of offered Service  */ VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION,
          /* MinoreVersion of offered Service */ VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION,
          /* PatchVersion of offered Service  */ VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_PATCH_VERSION)
{
    ETG_TRACE_USR4(("Begin: Constructor of vd_devicemanager_tclService_DeviceManager"));

    if(DEVMGR_SERVICE_MAJORVERSION!=VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION)
    {
        ETG_TRACE_FATAL(("ERROR: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
        ETG_TRACE_FATAL(("ERROR: FI incompatible!"));
        ETG_TRACE_FATAL(("ERROR: DEVMGR_SERVICE_MAJORVERSION                                                      = 0x%x",DEVMGR_SERVICE_MAJORVERSION));
        ETG_TRACE_FATAL(("ERROR: VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION used by this component   = 0x%x",VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION));
        ETG_TRACE_FATAL(("ERROR: DEVMGR_SERVICE_MINORVERSION                                                      = 0x%x",DEVMGR_SERVICE_MINORVERSION));
        ETG_TRACE_FATAL(("ERROR: VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION used by this component   = 0x%x",VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION));
        ETG_TRACE_FATAL(("ERROR: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
    }
    else if(DEVMGR_SERVICE_MINORVERSION!=VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION)
    {
        ETG_TRACE_FATAL(("ERROR: ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));
        ETG_TRACE_FATAL(("ERROR: NOTE: FI minor version different!"));
        ETG_TRACE_FATAL(("ERROR: DEVMGR_SERVICE_MINORVERSION                                                      = 0x%x",DEVMGR_SERVICE_MINORVERSION));
        ETG_TRACE_FATAL(("ERROR: VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION used by this component   = 0x%x",VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION));
        ETG_TRACE_FATAL(("ERROR: ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));
    }
    else
    {
        ETG_TRACE_USR1(("FI is compatible"));
    }

    m_bConnectClients  = TRUE;
    m_bServAvailable   = FALSE;
    m_poMainApp        = poMainAppl;
    m_objCurNotifiedDevice.m_iSendNo = UNDEF_ELEM;  //mark that it is unused until now

    SERVICEHISTORY.ClearHistory ();//init list which is used for error analysis

    vSetServiceAvailable(FALSE);
    vClearReceiverInfo(m_oReceiverInfo);



    ETG_TRACE_USR4(("End  : Constructor of vd_devicemanager_tclService_DeviceManager"));
}

/*-----------------------------------------------------------------------------*
 * clear function                                                                  *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vClearReceiverInfo(trReceiverInfo &f_oReceiverInfo) const
{
    ETG_TRACE_USR4(("vClearReceiverInfo() entered."));
    f_oReceiverInfo.bValid            = FALSE;
    f_oReceiverInfo.u16GetSourceAppID = 0;
    f_oReceiverInfo.u16GetRegisterID  = 0;
    f_oReceiverInfo.u16GetCmdCounter  = 0;
    f_oReceiverInfo.u16GetFunctionID  = 0;
}

/*-----------------------------------------------------------------------------*
 * Destructor                                                                  *
 *-----------------------------------------------------------------------------*/
vd_devicemanager_tclService_DeviceManager::~vd_devicemanager_tclService_DeviceManager(tVoid)
{
    ETG_TRACE_USR4(("~vd_devicemanager_tclService_DeviceManager() entered."));
    m_poMainApp = NULL;
}

/*-----------------------------------------------------------------------------*
 * tVoid vOnServiceAvailable()                                                 *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vOnServiceAvailable()
{
    ETG_TRACE_USR4(("vOnServiceAvailable() entered."));
    m_bServAvailable = TRUE;
}

/*-----------------------------------------------------------------------------*
 * tVoid vOnServiceUnavailable()                                               *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vOnServiceUnavailable()
{
    ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));
    m_bServAvailable = FALSE;
}


/*-----------------------------------------------------------------------------*
 * tBool bProcessSet(amt_tclServiceData* poMessage,                            *
 *                   tBool& bPropertyChanged,                                  *
 *                   tU16& u16ErrorCode)                                       *
 *-----------------------------------------------------------------------------*/
//Roadmap13035Overtemperature - adjust function
tBool vd_devicemanager_tclService_DeviceManager
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
    (tVoid) u16ErrorCode;     // This line is added to avoid LINT warnings
    tBool bSuccess = false;

    tU16 u16FunctionId = poMessage->u16GetFunctionID();
    fi_tclVisitorMessage oVisitorMsg(poMessage);
    ETG_TRACE_USR4(("bProcessSet() entered. FID = 0x%4x.", u16FunctionId));

    switch(u16FunctionId)
    {
#ifdef DEVMGR_DEVMANAGEROVERTEMPCD //to keep it backward compatible - see VD_DevicemanagerInterface.h
    case DEVMGR_DEVMANAGEROVERTEMPCD: //Roadmap13035_OverTemperature
    {

        FIDEVMGR_OVERTEMPCDSET oFiDataObject;
        if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {
            tBool bOverTemperature = oFiDataObject.OverTemperature;
            DeviceManagerInterface::GetInstance()->vSetOverTemperatureCDDrive(bOverTemperature);
            bSuccess = true;
        }
        ETG_TRACE_USR1(("bProcessSet: DEVMGR_DEVMANAGEROVERTEMPCD - disabled for Get"));
        break;
    }
#endif
#ifdef DEVMGR_DEVMANAGERTELEMATICSBOXALIVE
    case DEVMGR_DEVMANAGERTELEMATICSBOXALIVE:
    {
        FIDEVMGR_TELEMATICSBOXALIVESET oFiDataObject;
        if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObject,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {
            tBool bIsBTAAlive = oFiDataObject.BTAConnectionStatus;
            tU32 u32TimoutBeforeSendingITC = oFiDataObject.TimoutBeforeSendingITC;

            DeviceManagerInterface::GetInstance()->vSetTelematicsBoxApplicationLayerAlive(bIsBTAAlive,u32TimoutBeforeSendingITC);
            bSuccess = true;
        }
        ETG_TRACE_USR1(("bProcessSet: DEVMGR_DEVMANAGERTELEMATICSBOXALIVE - disabled for Get"));

        break;
    }
#endif
    case DEVMGR_NOTIFYSDCARD:
    {
        ETG_TRACE_USR1(("bProcessSet: DEVMGR_NOTIFYSDCARD - disabled for Get"));
        break;
    }
    case DEVMGR_NOTIFYCONNECTION:
    {
        ETG_TRACE_USR1(("bProcessSet: DEVMGR_NOTIFYCONNECTION - disabled for Get"));
        break;

    }
    case DEVMGR_DVDDRIVEINFO:
    {
        FIDEVMGR_DVDDRIVEINFOSET oFiDataObjectset;
        if (OSAL_ERROR != oVisitorMsg.s32GetData(oFiDataObjectset,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {
            // Retrieve the parameters from the message
            FISHARED_E8_DVDDISCTYPE l_DVDDiscType  = oFiDataObjectset.e8DVDDiscType;
            trDVDDriveInfo l_rDVDDriveInfo;
            l_rDVDDriveInfo.DVDDiscType = NON_DATA_DISC;
            switch(l_DVDDiscType.enType)
            {
            case FISHARED_E8_DVDDISCTYPE::FI_EN_E8NON_DISC_DATA:
                l_rDVDDriveInfo.DVDDiscType = NON_DATA_DISC;
                break;
            case FISHARED_E8_DVDDISCTYPE::FI_EN_E8DISC_DATA:
                l_rDVDDriveInfo.DVDDiscType = DATA_DISC;
                break;
            }

            FISHARED_E8_DVDDRIVEMODE l_DVDDriveMode = oFiDataObjectset.e8DVDDriveMode;
            l_rDVDDriveInfo.DVDDriveMode = MASS_STORAGE_MODE;
            switch(l_DVDDriveMode.enType)
            {
            case FISHARED_E8_DVDDRIVEMODE::FI_EN_E8MASS_STORAGE_MODE:
                l_rDVDDriveInfo.DVDDriveMode = MASS_STORAGE_MODE;
                break;
            case FISHARED_E8_DVDDRIVEMODE::FI_EN_E8TRANSITION_TO_MASS_STORAGE_MODE:
                l_rDVDDriveInfo.DVDDriveMode = TRANSITION_TO_MASS_STORAGE_MODE;
                break;
            case FISHARED_E8_DVDDRIVEMODE::FI_EN_E8BACKEND_MODE:
                l_rDVDDriveInfo.DVDDriveMode = BACKEND_MODE;
                break;
            case FISHARED_E8_DVDDRIVEMODE::FI_EN_E8TRANSITION_TO_BACKEND_MODE:
                l_rDVDDriveInfo.DVDDriveMode = TRANSITION_TO_BACKEND_MODE;
                break;
            case FISHARED_E8_DVDDRIVEMODE::FI_EN_E8INVALID_MODE:
                l_rDVDDriveInfo.DVDDriveMode = INVALID_MODE;
                break;
            }

            ETG_TRACE_USR1(("bProcessSet: DEVMGR_DVDDRIVEINFO - l_rDVDDriveInfo.DVDDriveMode = %d",ETG_ENUM(TENDVDDISCTYPE,l_rDVDDriveInfo.DVDDriveMode)));
            ETG_TRACE_USR1(("bProcessSet: DEVMGR_DVDDRIVEINFO - l_rDVDDriveInfo.DVDDiscType = %d",ETG_ENUM(TENDVDDRIVEMODE,l_rDVDDriveInfo.DVDDiscType)));
            DeviceManagerInterface::GetInstance()->vSetDVDDriveInfo(l_rDVDDriveInfo);
            bSuccess = true;
        }
        ETG_TRACE_USR1(("bProcessSet: DEVMGR_DVDDRIVEINFO - disabled for Get"));

        break;
    }
    default:
        ETG_TRACE_ERR(("bProcessSet(). Invalid 'FID = %u'.", u16FunctionId));
        break;
    }

    if (true == bSuccess)
    {
        bPropertyChanged = true;
    }
    else
    {
        ETG_TRACE_ERR(("bProcessSet(). Setting of property with 'FID = %u' failed.", u16FunctionId));
    }

    return bSuccess;
}

/*-----------------------------------------------------------------------------*
 * tVoid vOnLoopbackService(amt_tclServiceData* poMessage)                     *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vOnLoopbackService(
        amt_tclServiceData* poMessage) const
{
    gm_tclU32Message oVisitorMsg(poMessage);

    tU16 u16FunctionId = poMessage->u16GetFunctionID();

    tU32 u32MsgContent = oVisitorMsg.u32GetDWord();

    //    ETG_TRACE_USR4(("vOnLoopbackService() entered. iFID = 0x%4x, u32MsgContent = %u.",
    //                  u16FunctionId,
    //                  u32MsgContent));

    switch(u16FunctionId)
    {
        case DEVICEMANAGER_C_U16_IFID_EXAMPLE_1 :
        {
#ifndef USE_SUPPRESS_TRACES_LOOPBACK
            ETG_TRACE_USR4(("vOnLoopbackService:DEVICEMANAGER_C_U16_IFID_EXAMPLE_1"));
#endif
            switch(u32MsgContent)
            {
                case DEVICEMANAGER_C_U32_MSGID_EXAMPLE_1 :
                {
#ifndef USE_SUPPRESS_TRACES_LOOPBACK
                    ETG_TRACE_USR4(("vOnLoopbackService:DEVICEMANAGER_C_U32_MSGID_EXAMPLE_1"));
#endif
                }
                break;

                default:
                {

                }
            }
        }
        break;
    default:
    {
        //            ETG_TRACE_ERR(("vOnLoopbackService(). Unknown iFID %u.", u16FunctionId));
    }
    }
}

/*-----------------------------------------------------------------------------*
 * tVoid vProcessTimer(tU16 u16TimerId)                                        *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vProcessTimer(tU16 u16TimerId)
{
    //    ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));

    (void) u16TimerId;

    gm_tclU32Message oExampleMsg(_poMainAppl->u16GetAppId(),  // Source AppID
                                 _poMainAppl->u16GetAppId(),  // Target AppID
                                 0,                           // RegisterID
                                 0,                           // CmdCounter
                                 _u16ServiceID,               // ServiceID
                                 DEVICEMANAGER_C_U16_IFID_EXAMPLE_1,  // Function ID
                                 AMT_C_U8_CCAMSG_OPCODE_STATUS  // Opcode
                                 );

    oExampleMsg.vSetDWord(DEVICEMANAGER_C_U32_MSGID_EXAMPLE_1);

    if ( oExampleMsg.bIsValid() )
    {
        if (_poMainAppl->enPostMessage(&oExampleMsg, TRUE) != AIL_EN_N_NO_ERROR)
        {
            //DVM_NORMAL_M_ASSERT_ALWAYS();
        }
    }
    else
    {
        //DVM_NORMAL_M_ASSERT_ALWAYS();
    }
}

/*-----------------------------------------------------------------------------*
 * Handler functions for FI messages                                           *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * tVoid vHandle_DeviceManagerGetDeviceProperties_MethodStart(                 *
 *                                       amt_tclServiceData* poMessage)        *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager
::vHandle_DeviceManagerGetDeviceProperties_MethodStart(
        amt_tclServiceData* poMessage)
{

    ETG_TRACE_USR4(("Begin: vHandle_DeviceManagerGetDeviceProperties_MethodStart"));

    CDevice l_oCDeviceProperty;
    GENSTRING oDdeviceSerialNumber;

    ETG_TRACE_FATAL((" ------------------------------------------------------------------------------------------------------------------------------------"));
    ETG_TRACE_FATAL(("[DEPRICATED FUNCTION]:GetAllConnectedDevices_MethodStart: Don't use this for Gen3 projects"));
    ETG_TRACE_FATAL(("                      use 'Get on DevManagerNotifyConnection' instead"));
    ETG_TRACE_FATAL((" ---------------------------------------------------------------------------------------------------------"));

    if( poMessage )
    {
        ETG_TRACE_USR4(("vHandle_DeviceManagerGetDeviceProperties_MethodStart. SourceAppID = %x; FID = %x.", ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID()), ETG_ENUM(DVM_FCTID, poMessage->u16GetFunctionID()) ));

        if(!m_bConnectClients)
        {
            ETG_TRACE_FATAL(("WARNING: In Test mode: VD_DVM disconnected from property notifiation but clients uses method (vHandle_DeviceManagerGetDeviceProperties_MethodStart)"));
        }

        FIDEVMGR_GETDEVPROPERTIES_METHODSTART oFiDataObject_Get;
        fi_tclVisitorMessage oVisitorMsg(poMessage);

        // tString szDeviceSerialNo = NULL;
        if (OSAL_ERROR != oVisitorMsg.s32GetData (oFiDataObject_Get, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {
            // Retrieve the serial number of device from message
            ETG_TRACE_SYS (("**********************************************************************************"));
            ETG_TRACE_SYS (("vHandle_DeviceManagerGetDeviceProperties_MethodStart: DeviceSerialNo = %s",(const char *) oFiDataObject_Get.DeviceSerialNo));
            ETG_TRACE_SYS (("**********************************************************************************"));

            oDdeviceSerialNumber = (const char*)oFiDataObject_Get.DeviceSerialNo;
            DeviceManagerInterface::GetInstance()->getDeviceProperties(oDdeviceSerialNumber,l_oCDeviceProperty);

        }
        else
        {
            ETG_TRACE_ERR (("vHandle_DeviceManagerGetDeviceProperties_MethodStart: ERROR: Received message invalid"));
        }

        // Always destroy the (message related) FI data object (before leaving its
        // creation scope)
        oFiDataObject_Get.vDestroy();

        //==========================================
        // send result to sender
        //==========================================
        trReceiverInfo l_oReceiverInfo;
        l_oReceiverInfo.u16GetSourceAppID = poMessage->u16GetSourceAppID();
        l_oReceiverInfo.u16GetRegisterID  = poMessage->u16GetRegisterID();
        l_oReceiverInfo.u16GetCmdCounter  = poMessage->u16GetCmdCounter();
        l_oReceiverInfo.u16GetFunctionID  = poMessage->u16GetFunctionID();
        vHandle_DeviceManagerGetDeviceProperties_MethodReturn(l_oReceiverInfo, &l_oCDeviceProperty);



    }   // if( poMessage )
    else
    {
        ETG_TRACE_FATAL(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: FATAL: invalid pointer <poMessage>"));
    }

    ETG_TRACE_USR4(("End  : vHandle_DeviceManagerGetDeviceProperties_MethodStart"));
}


OUT tVoid vd_devicemanager_tclService_DeviceManager::
vHandle_DeviceManagerGetDeviceProperties_MethodReturn(const trReceiverInfo &f_oReceiverInfo, CDevice *f_pCDeviceProperty)
{
    // check for null pointer

    // Create the object of FIDEVMGR_GETDEVPROPERTIES_METHODRESULT
    FIDEVMGR_GETDEVPROPERTIES_METHODRESULT oFiDataObject;

    FIDEVMGR_DEVICEPROPERTY l_objConnectNotify;

    vShowDeviceProperty(f_pCDeviceProperty);


    f_pCDeviceProperty->m_rSendTime_ms = (tU32)ConfigurationManager::GetInstance()->GetEclapsedTime_ms();
    //            l_pCDeviceProperty->m_eTypeOfNotify = CGlobalEnumerations::enUnotify;   // @todo ersatz schaffen f�r "used fct.:vHandle_DeviceManagerGetDeviceProperties_MethodStart"

    SERVICEHISTORY.AddToHistory (m_objCurNotifiedDevice);

    l_objConnectNotify = CreateDevicePropertyObject(f_pCDeviceProperty);

    oFiDataObject.DeviceProperty = l_objConnectNotify;

    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg_Result(oFiDataObject, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION);

    // Here the message related header information is added and by this the
    // creation of the message is completed.
    vInitServiceData(oMsg_Result,                           // ServiceDataMsg
                     f_oReceiverInfo.u16GetSourceAppID,     // Target AppID
                     f_oReceiverInfo.u16GetRegisterID,      // RegisterID
                     f_oReceiverInfo.u16GetCmdCounter,      // CmdCounter,
                     f_oReceiverInfo.u16GetFunctionID,      // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);  // Opcode

    // Post the message to the client
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg_Result, TRUE);
    // Check for Error after posting message
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("vHandle_DeviceManagerGetDeviceProperties_MethodStart: ERROR: ail_tenCommunicationError = %d",(tU32)enResult));
    }

    // Always destroy the (message related) FI data object (before leaving its
    // creation scope)
    oFiDataObject.vDestroy();
}

/*-----------------------------------------------------------------------------*
 * tVoid vHandle_DeviceManagerGetAllConnectedDevices_MethodStart(              *
 *                                       amt_tclServiceData* poMessage)        *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::
vHandle_DeviceManagerGetAllConnectedDevices_MethodStart( amt_tclServiceData* poMessage)
{
    ETG_TRACE_USR4(("Begin: GetAllConnectedDevices_MethodStart"));

    StateTable                 *l_pStateTableManagerApp = NULL;
    vector<structNotifyClients> l_vClientsAllConnected; // creating the vector pointer for getting information of All connected devices
    trReceiverInfo              l_oReceiverInfo;

    ETG_TRACE_FATAL((" ------------------------------------------------------------------------------------------------------------------------------------"));
    ETG_TRACE_FATAL(("[DEPRICATED FUNCTION]:GetAllConnectedDevices_MethodStart: Don't use this for Gen3 projects"));
    ETG_TRACE_FATAL(("                      use 'Get on DevManagerNotifyConnection' instead"));
    ETG_TRACE_FATAL((" ---------------------------------------------------------------------------------------------------------"));


    if( poMessage )
    {
        ETG_TRACE_USR4(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart. SourceAppID = %x; FID = %x.", ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID()), ETG_ENUM(DVM_FCTID, poMessage->u16GetFunctionID()) ));

        if(!m_bConnectClients)
        {
            ETG_TRACE_FATAL(("WARNING: In Test mode: VD_DVM disconnected from property notifiation but clients uses method (vHandle_DeviceManagerGetAllConnectedDevices_MethodStart)"));
        }

        //===============================================================
        //receive and unmarshal message
        //===============================================================
        FIDEVMGR_GETALLCONNECTEDDEVICES_METHODSTART oFiDataObject_Get;   //lint !e1502  defined object oFiDataObject_Get  has no  nonstatic data members automatically generated no chance to make adjustements
        fi_tclVisitorMessage                        oVisitorMsg(poMessage);   //create the visitor message

        //check for the error in the message
        if (OSAL_ERROR != oVisitorMsg.s32GetData (oFiDataObject_Get,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {
            //-----------------------------------------
            //getting the information of all connected devices
            //-----------------------------------------
            DeviceManagerInterface::GetInstance()->getAllConnectedDevices(l_vClientsAllConnected);

            ETG_TRACE_COMP(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart:l_vClientsAllConnected.size()=%d",l_vClientsAllConnected.size()))


        }
        else
        {
            ETG_TRACE_ERR (("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: ERROR: Invalid Message"));
        }

        //--------------------------
        //show found or not found list
        //-------------------------
        vd_devicemanager_tclService_DeviceManager::vShowDeviceProperty(l_vClientsAllConnected);

        oFiDataObject_Get.vDestroy();  // Always destroy the (message related) FI data object (before leaving its creation scope)

        //=======================
        //send result to sender
        //=======================
        l_oReceiverInfo.u16GetSourceAppID = poMessage->u16GetSourceAppID();
        l_oReceiverInfo.u16GetRegisterID  = poMessage->u16GetRegisterID();
        l_oReceiverInfo.u16GetCmdCounter  = poMessage->u16GetCmdCounter();
        l_oReceiverInfo.u16GetFunctionID  = poMessage->u16GetFunctionID();

        vHandle_DeviceManagerGetAllConnectedDevices_MethodReturn(l_oReceiverInfo,l_vClientsAllConnected, l_pStateTableManagerApp); //called only if poMessage!= NULL

    }   // if( poMessage )
    else
    {
        ETG_TRACE_FATAL(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: FATAL: invalid pointer <poMessage>"));
    }

    ETG_TRACE_USR4(("end  :vHandle_DeviceManagerGetAllConnectedDevices_MethodStart"));
}


/*-----------------------------------------------------------------------------*
 * tVoid vHandle_DeviceManagerGetAllConnectedDevices_Methodreturn(   )
 *-----------------------------------------------------------------------------*/
OUT tVoid vd_devicemanager_tclService_DeviceManager::
vHandle_DeviceManagerGetAllConnectedDevices_MethodReturn(const trReceiverInfo &f_oReceiverInfo,
                                                         vector<structNotifyClients> &f_vClientsAllConnected,
                                                         const StateTable *f_pStateTableManagerApp)
{
    ETG_TRACE_USR4(("Begin: vHandle_DeviceManagerGetAllConnectedDevices_MethodReturn"));

    CDevice oCurDevice; //device necessary to prepare sending it

    FIDEVMGR_GETALLCONNECTEDDEVICES_METHODRESULT oFiDataObject;    // send the result back to the client


    for (unsigned int l_uiCount=0; l_uiCount < f_vClientsAllConnected.size(); l_uiCount++)    // fill the information of all connected devices
    {
        // push the data to the FI object
        if( f_pStateTableManagerApp )
        {
            f_pStateTableManagerApp->bFillCDevice(&oCurDevice,&f_vClientsAllConnected.at(l_uiCount));
            oFiDataObject.DevInfoArr.DevList.push_back(CreateDevicePropertyObject(&oCurDevice) );

            //list for debugging //@todo cleanup make subfunction

            oCurDevice.m_rSendTime_ms = (tU32)ConfigurationManager::GetInstance()->GetEclapsedTime_ms();

            SERVICEHISTORY.AddToHistory (oCurDevice);
        }
        else
        {
            ETG_TRACE_ERR (("ERROR: vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: l_pStateTableManagerApp == NULL"));
        }
    }

    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg_Result(oFiDataObject,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION);

    // Here the message related header information is added and by this the
    // creation of the message is completed.
    vInitServiceData(oMsg_Result,                          // ServiceDataMsg
                     f_oReceiverInfo.u16GetSourceAppID,    // Target AppID
                     f_oReceiverInfo.u16GetRegisterID,     // RegisterID
                     f_oReceiverInfo.u16GetCmdCounter,     // CmdCounter,
                     f_oReceiverInfo.u16GetFunctionID,     // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODRESULT); // Opcode

    // Post the message to the client
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg_Result, TRUE);

    // Check for Error after posting message
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: ERROR: enPostMessage() 'ail_tenCommunicationError'= %d", (int)enResult));
    }

    oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)

    ETG_TRACE_USR4(("End  : vHandle_DeviceManagerGetAllConnectedDevices_MethodReturn"));

}

/*------------------------------------------------------------------------------------------------*
 * IN tVoid vSendOpticalDiscEjectMethodResult(IN CDEjectMethodResult e8CDEjectResult)     *
 *------------------------------------------------------------------------------------------------*/
//send from VD_DVM to Mediaplayer which send this to HMI - is asynchronous answer after eject has been called
IN tVoid vd_devicemanager_tclService_DeviceManager::vSendOpticalDiscEjectMethodResult(IN tOpticalDiscEjectMethodResult e8OpticalDiscEjectResult)//Roadmap 15002 CD Audio device Detection
{
    ETG_TRACE_USR4(("Begin: vSendOpticalDiscEjectMethodResult: Status:%d",ETG_ENUM(CDEjectMethodResult,e8OpticalDiscEjectResult)));

    tBool bSend = TRUE;

    FIDEVMGR_EJECTOPTICALDISC_METHODRESULT oFiDataObject;    // send the result back to the client

    switch(e8OpticalDiscEjectResult)
    {
        case ACCEPTED:
             oFiDataObject.ServiceStatus.enType = mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::FI_EN_ACCEPTED;
             break;
        case NOTACCEPTED:
             oFiDataObject.ServiceStatus.enType = mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::FI_EN_NOTACCEPTED;
             break;
        case DEVICENOTREADY:
             oFiDataObject.ServiceStatus.enType = mplay_fi_tcl_e8_EjectOpticalDisc_MethodResult::FI_EN_DEVICENOTREADY;
             break;
        default:
            bSend = FALSE;
            ETG_TRACE_FATAL(("vSendOpticalDiscEjectMethodResult: unexpected value: %d",ETG_CENUM(tOpticalDiscEjectMethodResult,e8OpticalDiscEjectResult)));
            break;
    }

    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg_Result(oFiDataObject,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION);
    if(bSend)
    {
        if(m_oReceiverInfo.bValid)
        {
            // Here the message related header information is added and by this the
            // creation of the message is completed.
            vInitServiceData(oMsg_Result,                          // ServiceDataMsg
                             m_oReceiverInfo.u16GetSourceAppID,    // Target AppID
                             m_oReceiverInfo.u16GetRegisterID,     // RegisterID
                             m_oReceiverInfo.u16GetCmdCounter,     // CmdCounter,
                             m_oReceiverInfo.u16GetFunctionID,     // Function ID
                             AMT_C_U8_CCAMSG_OPCODE_METHODRESULT); // Opcode

            // Post the message to the client
            ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg_Result, TRUE);

            // Check for Error after posting message
            if (AIL_EN_N_NO_ERROR != enResult)
            {
                ETG_TRACE_ERR (("vSendOpticalDiscEjectMethodResult: ERROR: enPostMessage() 'ail_tenCommunicationError'= %d", (int)enResult));
            }

            vClearReceiverInfo(m_oReceiverInfo);
        }
        else
        {
            ETG_TRACE_FATAL(("[ERROR]: vSendOpticalDiscEjectMethodResult:unexpected message:  == FALSE"));
        }
    }


    oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)


    ETG_TRACE_USR4(("End: vSendOpticalDiscEjectMethodResult"));
}

/*-------------------------------------------------------------------------------------------------------------------------*
 * IN tVoid vHandle_DeviceManagerEjectAudioCD_MethodStart(...)
 *--------------------------------------------------------------------------------------------------------------------------*/
///@todo not yet written to history
//HMI calls MediaPlayer which calls VD_DVM
IN tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerOpticalDiscEject_MethodStart(amt_tclServiceData* poMessage) ////Roadmap 15002 CD Audio device Detection
{
    ETG_TRACE_USR4(("Begin: vHandle_DeviceManagerOpticalDiscEject_MethodStart"));
    tBool bSend = TRUE;
    tDMOpticalDiscEjectCmd etDMOpticalDiscEjectCmd = DM_OPTDISC_CMD_EJECT;
    if(!m_bConnectClients)
    {
        ETG_TRACE_FATAL(("WARNING: In Test mode: VD_DVM disconnected from property notifiation but clients uses method (vHandle_OpticalDiscEject_MethodStart)"));
    }
    if(poMessage)
    {
        ETG_TRACE_USR4(("vHandle_DeviceManagerOpticalDiscEject_MethodStart. SourceAppID = %x; FID = %x.", ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID()), ETG_ENUM(DVM_FCTID, poMessage->u16GetFunctionID()) ));

        //===============================================================
        //receive and unmarshal message
        //===============================================================
        FIDEVMGR_EJECTOPTICALDISC_METHODSTART   oFiDataObject_Get;   // create the object of FIDEVMGR_EJECTOPTICALDISC_METHODSTART
        fi_tclVisitorMessage                    oVisitorMsg(poMessage);   //create the visitor message

        if (OSAL_ERROR != oVisitorMsg.s32GetData (oFiDataObject_Get, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {
            FISHARED_E8_CMDEJECTPARMTYPE enCmdEjectParam  = (FISHARED_E8_CMDEJECTPARMTYPE)oFiDataObject_Get.eCmdParam;

            // Retrieve the serial number of device from message
            ETG_TRACE_SYS (("***********************************************************************************************"));
            ETG_TRACE_SYS (("vHandle_OpticalDiscEject_MethodStart: enCmdEjectParam       = 0x%x",enCmdEjectParam.enType));
            ETG_TRACE_SYS (("************************************************************************************************"));

            switch(enCmdEjectParam.enType)
            {
                case FISHARED_E8_CMDEJECTPARMTYPE::FI_EN_E8CMD_EJECT:
                    etDMOpticalDiscEjectCmd = DM_OPTDISC_CMD_EJECT;
                    break;
                case FISHARED_E8_CMDEJECTPARMTYPE::FI_EN_E8CMD_INSERT:
                    etDMOpticalDiscEjectCmd = DM_OPTDISC_CMD_INSERT;
                    break;
                default:
                    bSend = FALSE;
                    ETG_TRACE_FATAL(("vHandle_DeviceManagerOpticalDiscEject_MethodStart: Unexpected value: enCmdEjectParam: %d",(int)enCmdEjectParam.enType));
                    break;
            }
            if(TRUE == bSend )
            {
                //=======================
                //send result to sender
                //=======================
                m_oReceiverInfo.bValid            = TRUE;
                m_oReceiverInfo.u16GetSourceAppID = poMessage->u16GetSourceAppID();
                m_oReceiverInfo.u16GetRegisterID  = poMessage->u16GetRegisterID();
                m_oReceiverInfo.u16GetCmdCounter  = poMessage->u16GetCmdCounter();
                m_oReceiverInfo.u16GetFunctionID  = poMessage->u16GetFunctionID();
                DeviceManagerInterface::GetInstance()->vSendOpticalDiscEjectRequest(etDMOpticalDiscEjectCmd);
             }
             else
             {
                 ETG_TRACE_FATAL(("vHandle_DeviceManagerOpticalDiscEject_MethodStart: Ignore Message. Reason: Previous message still executing in VD_DVM"));
             }
          }

        oFiDataObject_Get.vDestroy();


    }
    ETG_TRACE_USR4(("End  : vHandle_DeviceManagerOpticalDiscEject_MethodStart"));
}

/*-------------------------------------------------------------------------------------------------------------------------*
 * IN tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerMountCDRomInternal_MethodStart(...)
 *--------------------------------------------------------------------------------------------------------------------------*/
///@todo not yet written to history
IN tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerMountCDRomInternal_MethodStart(amt_tclServiceData* poMessage) //Roadmap 14002 MountCDROM MixMode Diag
{
    ETG_TRACE_USR4(("Begin: MountCDRomInternal_MethodStart"));

    tBool          bMount;
    std::string    strDeviceName;

    if(!m_bConnectClients)
    {
        ETG_TRACE_FATAL(("WARNING: In Test mode: VD_DVM disconnected from property notifiation but clients uses method (vHandle_DeviceManagerMountCDRomInternal_MethodStart)"));
    }

    if(poMessage)
    {
        ETG_TRACE_USR4(("vHandle_DeviceManagerMountCDRomInternal_MethodStart. SourceAppID = %x; FID = %x.", ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID()), ETG_ENUM(DVM_FCTID, poMessage->u16GetFunctionID()) ));

        //===============================================================
        //receive and unmarshal message
        //===============================================================
        FIDEVMGR_MOUNTCDROMINTERNAL_METHODSTART oFiDataObject_Get;   // create the object of FIDEVMGR_GETALLCONNECTEDDEVICES_METHODSTART
        fi_tclVisitorMessage                    oVisitorMsg(poMessage);   //create the visitor message

        if (OSAL_ERROR != oVisitorMsg.s32GetData (oFiDataObject_Get, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {
            bMount        = (tBool)oFiDataObject_Get.Mount;
            strDeviceName = (const char *) oFiDataObject_Get.BlockDevice;

            // Retrieve the serial number of device from message
            ETG_TRACE_SYS (("***********************************************************************************************"));
            ETG_TRACE_SYS (("MountCDRomInternal_MethodStart: Mount       = 0x%x",bMount));
            ETG_TRACE_SYS (("MountCDRomInternal_MethodStart: BlockDevice = %s  ",strDeviceName.c_str()));
            ETG_TRACE_SYS (("************************************************************************************************"));
            if(true == strDeviceName.empty())
            {
                ETG_TRACE_USR4(("MountCDRomInternal_MethodStart: BlockDevice is empty"));
            }

            if(m_oReceiverInfo.bValid== FALSE) //it is possible to send another message if the previous has been answered!!!
            {
                //=======================
                //send result to sender
                //=======================
                m_oReceiverInfo.bValid            = TRUE;
                m_oReceiverInfo.u16GetSourceAppID = poMessage->u16GetSourceAppID();
                m_oReceiverInfo.u16GetRegisterID  = poMessage->u16GetRegisterID();
                m_oReceiverInfo.u16GetCmdCounter  = poMessage->u16GetCmdCounter();
                m_oReceiverInfo.u16GetFunctionID  = poMessage->u16GetFunctionID();
                DeviceManagerInterface::GetInstance()->vDiagMountCDRom(IN bMount, IN strDeviceName /*e.g. /dev/sr0*/); //Roadmap 14002 MountCDROM (diagMixeMode)
            }
            else
            {
                ETG_TRACE_FATAL(("MountCDRomInternal_MethodStart: Ignore Message. Reason: Previous message still executing in VD_DVM"));
            }

        }

        oFiDataObject_Get.vDestroy();
    }

    ETG_TRACE_USR4(("End  : MountCDRomInternal_MethodStart"));
}

/*-------------------------------------------------------------------------------------------------------------------------*
 * IN tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerMountCDRomInternal_MethodReturn(...)
 *--------------------------------------------------------------------------------------------------------------------------*/
OUT tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerMountCDRomInternal_MethodReturn(tBool bSuccess)
{
    ETG_TRACE_USR4(("Begin: MountCDRomInternal_MethodReturn: Success:0x%x",bSuccess));

    FIDEVMGR_MOUNTCDROMINTERNAL_METHODRESULT oFiDataObject;    // send the result back to the client
    oFiDataObject.Success = bSuccess;


    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg_Result(oFiDataObject,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION);

    if(m_oReceiverInfo.bValid)
    {
        // Here the message related header information is added and by this the
        // creation of the message is completed.
        vInitServiceData(oMsg_Result,                          // ServiceDataMsg
                         m_oReceiverInfo.u16GetSourceAppID,    // Target AppID
                         m_oReceiverInfo.u16GetRegisterID,     // RegisterID
                         m_oReceiverInfo.u16GetCmdCounter,     // CmdCounter,
                         m_oReceiverInfo.u16GetFunctionID,     // Function ID
                         AMT_C_U8_CCAMSG_OPCODE_METHODRESULT); // Opcode

        // Post the message to the client
        ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg_Result, TRUE);

        // Check for Error after posting message
        if (AIL_EN_N_NO_ERROR != enResult)
        {
            ETG_TRACE_ERR (("MountCDRomInternal_MethodReturn: ERROR: enPostMessage() 'ail_tenCommunicationError'= %d", (int)enResult));
        }

        vClearReceiverInfo(m_oReceiverInfo);
    }
    else
    {
        ETG_TRACE_FATAL(("[ERROR]: MountCDRomInternal_MethodReturn:unexpected message:  == FALSE"));
    }

    oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)


    ETG_TRACE_USR4(("End: MountCDRomInternal_MethodReturn"));
}

//#ifdef REFACTOR_STATETABLE_OUTPUT
/*-----------------------------------------------------------------------------*
 * tVoid RequestDeviceManagerNotifyConnectionStatus()
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::RequestDeviceManagerNotifyConnectionStatus()
{
    ETG_TRACE_USR4(("Begin: RequestDeviceManagerNotifyConnectionStatus()"));

    if(m_bConnectClients)
    {
        eUpdateClients(DEVMGR_NOTIFYCONNECTION); //triggers call of bStatusMessageFactory
    }
    else
    {
        ETG_TRACE_FATAL(("WARNING: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
        ETG_TRACE_FATAL(("WARNING: RequestDeviceManagerNotifyConnectionStatus: Nothing send to clients m_bConnectClients=FALSE"));
        ETG_TRACE_FATAL(("WARNING: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
    }

    ETG_TRACE_USR4(("End  : RequestDeviceManagerNotifyConnectionStatus"));
}
//#endif //REFACTOR_STATETABLE_OUTPUT

/*-----------------------------------------------------------------------------*
 * tVoid RequestDeviceManagerNotifyConnectionStatus(                           *
 *                       structNotifyClients *f_pNotifyClients,                *
 *                       const StateTable *pStateTabl                          *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::
RequestDeviceManagerNotifyConnectionStatus(
        const structNotifyClients *f_pNotifyClients, const StateTable *pStateTable)
{
    ETG_TRACE_USR4(("Begin: RequestDeviceManagerNotifyConnectionStatus"));

    if( (NULL!=f_pNotifyClients) || (NULL!= pStateTable) )
    {
        if(m_bConnectClients)
        {
            //filling the object with required information
            pStateTable->bFillCDevice(&m_objCurNotifiedDevice,f_pNotifyClients);

            //list for debugging
            m_objCurNotifiedDevice.m_rSendTime_ms = (tU32)ConfigurationManager::GetInstance()->GetEclapsedTime_ms();


            SERVICEHISTORY.AddToHistory (m_objCurNotifiedDevice);

            DeviceListManager::GetInstance()->vListAddRemoveDevice(DEVLIST_DEVICEMGRSERVICE,m_objCurNotifiedDevice);

            vShowDeviceProperty(m_objCurNotifiedDevice); //show trace

            eUpdateClients(DEVMGR_NOTIFYCONNECTION); //Implicitly calling message factory for given property
        }
        else
        {
            ETG_TRACE_FATAL(("WARNING: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
            ETG_TRACE_FATAL(("WARNING: RequestDeviceManagerNotifyConnectionStatus: Nothing send to clients m_bConnectClients=FALSE"));
            ETG_TRACE_FATAL(("WARNING: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"));
        }
    }
    else
    {
        //-----------------------------------------
        //no devices connected hence send HW-signals only
        //-----------------------------------------
        ETG_TRACE_COMP(("RequestDeviceManagerNotifyConnectionStatus: (NULL==f_pNotifyClients) || (NULL== pStateTable)"));

        PortListManager::GetInstance()->vShowHardwareSignals();
        eUpdateClients(DEVMGR_NOTIFYCONNECTION); //Implicitly calling message factory for given property
        ETG_TRACE_COMP(("RequestDeviceManagerNotifyConnectionStatus: (NULL==f_pNotifyClients) || (NULL== pStateTable)"));


    }

    ETG_TRACE_USR4(("End  : RequestDeviceManagerNotifyConnectionStatus"));
}


/*-----------------------------------------------------------------------------*
 *tVoid ConvertConnectStatus(OUT FIDEVMGR_DEVICEPROPERTY &f_objConnectNotify, IN DEVICE_CONNECTSTATUS_Type eConnectStatus)     *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::ConvertConnectStatus(OUT FIDEVMGR_DEVICEPROPERTY &f_objConnectNotify, IN DEVICE_CONNECTSTATUS_Type f_eConnectStatus) const
{

    switch(f_eConnectStatus)
    {
    case USB_DEV_UNDEFINED:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.m_eConnectStatus     = USB_DEV_UNDEFINED"));
        f_objConnectNotify.DeviceConnectStatus.enType = FIDEVMGR_E8_DEVICECONNECTSTATUS::FI_EN_USB_DEV_UNDEFINED;
        break;

    case USB_DEV_WARNING:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.m_eConnectStatus     = USB_DEV_WARNING"));
        f_objConnectNotify.DeviceConnectStatus.enType = FIDEVMGR_E8_DEVICECONNECTSTATUS::FI_EN_USB_DEV_WARNING;
        break;

    case USB_DEV_CONNECTED:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.m_eConnectStatus     = USB_DEV_CONNECTED"));
        f_objConnectNotify.DeviceConnectStatus.enType = FIDEVMGR_E8_DEVICECONNECTSTATUS::FI_EN_USB_DEV_CONNECTED;
        break;

    case USB_DEV_REMOVED_BY_USR:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.m_eConnectStatus     = USB_DEV_REMOVED_BY_USR"));
        f_objConnectNotify.DeviceConnectStatus.enType = FIDEVMGR_E8_DEVICECONNECTSTATUS::FI_EN_USB_DEV_REMOVED_BY_USR;
        break;

    case USB_DEV_UNAVAIL_BAT_LOWVOLT:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.m_eConnectStatus     = USB_DEV_UNAVAIL_BAT_LOWVOLT"));
        f_objConnectNotify.DeviceConnectStatus.enType = FIDEVMGR_E8_DEVICECONNECTSTATUS::FI_EN_USB_DEV_UNAVAIL_BAT_LOWVOLT;
        break;

    case USB_DEV_UNAVAIL_HW_MALFUNC:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.m_eConnectStatus     = USB_DEV_UNAVAIL_HW_MALFUNC"));
        f_objConnectNotify.DeviceConnectStatus.enType = FIDEVMGR_E8_DEVICECONNECTSTATUS::FI_EN_USB_DEV_UNAVAIL_HW_MALFUNC;
        break;

#ifdef BUGFIX_CARE_PERMANENT_OVERCURRENT
    case USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.m_eConnectStatus     = USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT"));
        f_objConnectNotify.DeviceConnectStatus.enType = FIDEVMGR_E8_DEVICECONNECTSTATUS::FI_EN_USB_DEV_UNAVAIL_HW_MALFUNC_PERMANENT;
        break;
#endif
    case USB_DEV_UNAVAIL_CDDRIVE_TEMPERATURE: /*Roadmap 13035 Overtemperature*/
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.m_eConnectStatus     = USB_DEV_UNAVAIL_CDDRIVE_TEMPERATURE"));
        f_objConnectNotify.DeviceConnectStatus.enType = FIDEVMGR_E8_DEVICECONNECTSTATUS::FI_EN_USB_DEV_UNAVAIL_OVERTEMP;
        break;
    default:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.m_eConnectStatus     = Default"));
        f_objConnectNotify.DeviceConnectStatus.enType = FIDEVMGR_E8_DEVICECONNECTSTATUS::FI_EN_USB_DEV_UNDEFINED;
    }


}

tVoid vd_devicemanager_tclService_DeviceManager::ConvertDeviceType(OUT FIDEVMGR_DEVICEPROPERTY &f_objConnectNotify,IN CGlobalEnumerations::DEVICE_TYPE_Type f_eDeviceType) const
{

    switch(f_eDeviceType)
    {
    case CGlobalEnumerations::DTY_CDROM:
        if(DVM_OFF == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_CDROM_AS_USB))
        {
            f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_CDROM;
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_CDROM"));
            break;
        }//else goto  next case below (DTY_DTY_USB)
    case CGlobalEnumerations::DTY_USB:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_USB;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_USB"));
        break;
    case CGlobalEnumerations::DTY_SD_INTERNAL:
        if(DVM_OFF == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_SDINT_AS_SD))//if DVM_ON in UDEVManager device has changed from DTY_SDD_INTERNAL to  DTY_SD thus hits another case here
        {
            f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_SDCARD_INTERNAL;
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_SDCARD_INTERNAL"));
            break;
        }//else goto next case below (DTY_SD)
    case CGlobalEnumerations::DTY_SD:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_SDCARD; //add SDCard internal to FI and enable/disable this in dependency of a configuration
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_SDCARD"));
        break;
    case CGlobalEnumerations::DTY_CDDA:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_CDDA;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_CDDA"));
        break;

    case CGlobalEnumerations::DTY_IPAD:
        if(DVM_OFF == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_IPAD_AS_IPOD)) //if DVM_ON in UDEVManager device has changed from DTY_IPAD to DTY_IPOD thus hits another case here
        {
            f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_IPAD;
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_IPAD"));
            break;
        }//else goto next case below (IPOD)
    case CGlobalEnumerations::DTY_IPOD:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_IPOD;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_IPOD"));
        break;

    case CGlobalEnumerations::DTY_IPHONE:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_IPHONE;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_IPHONE"));
        break;

    case CGlobalEnumerations::DTY_MTP:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_MTP;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_MTP"));
        break;

    case CGlobalEnumerations::DTY_MSZUNE:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_MSZUNE;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_MSZUNE"));
        break;

    case CGlobalEnumerations::DTY_NOT_SUPPORTED:
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_NOTIFY_UNSUPPORTED_DEVTYPE))
        {
            f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_NOT_SUPPORTED;
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_NOT_SUPPORTED"));
            break;
        }//else next case below (DTY_UNKNOWN)
    case CGlobalEnumerations::DTY_DIGIAUX:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_DIGITALAUX;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_DIGITALAUX "));
        break;
    case CGlobalEnumerations::DTY_BTA:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_BTA;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FIDEVMGR_E8_DEVICE::FI_EN_DTY_BTA "));
        break;
    case CGlobalEnumerations::DTY_HUB:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_HUB;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FIDEVMGR_E8_DEVICE::FI_EN_DTY_HUB "));
        break;
    case CGlobalEnumerations::DTY_DVD_DRIVE:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_DVD_DRIVE;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FIDEVMGR_E8_DEVICE::FI_EN_DTY_DVD_DRIVE "));
        break;
    case CGlobalEnumerations::DTY_UNKNOWN:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_UNKNOWN;
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_UNKNOWN"));
        break;

    default:
        f_objConnectNotify.DeviceType.enType = FIDEVMGR_E8_DEVICE::FI_EN_DTY_UNKNOWN;
        ETG_TRACE_FATAL(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType: FI_EN_DTY_UNKNOWN (default)"));
    }


    ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType           = 0x%x", f_objConnectNotify.DeviceType.enType )); //@todo find solution !!
    /* these give compiler error although I took effort to add corresponding headers to *prod.xml
    ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType           = %d", ETG_CENUM(FIDEVMGR_E8_DEVICE::tenType, f_objConnectNotify.DeviceType.enType) )); //@todo find solution !!
    ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceType           = %d", ETG_CENUM(mplay_fi_tcl_e8_Device::tenType, f_objConnectNotify.DeviceType.enType) )); //@todo find solution !!
    */


}

tVoid  vd_devicemanager_tclService_DeviceManager::ConvertFileSystemType(OUT FIDEVMGR_DEVICEPROPERTY &f_objConnectNotify, CGlobalEnumerations::FILESYSTEM_TYPE_Type eFSType) const
{
    switch(eFSType)
    {
    case CGlobalEnumerations::FSTY_FAT:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.FileSystemType      = FI_EN_FSTY_FAT"));
        f_objConnectNotify.FileSystemType.enType = FIDEVMGR_E8_FILESYSTEM::FI_EN_FSTY_FAT;
        break;
    case CGlobalEnumerations::FSTY_NTFS:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.FileSystemType      = FI_EN_FSTY_NTFS"));
        f_objConnectNotify.FileSystemType.enType = FIDEVMGR_E8_FILESYSTEM::FI_EN_FSTY_NTFS;
        break;
    case CGlobalEnumerations::FSTY_EXT3_4:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.FileSystemType      = FI_EN_FSTY_EXT4"));
        f_objConnectNotify.FileSystemType.enType = FIDEVMGR_E8_FILESYSTEM::FI_EN_FSTY_EXT4;
        break;
    case CGlobalEnumerations::FSTY_HFS:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.FileSystemType      = FI_EN_FSTY_HFS"));
        f_objConnectNotify.FileSystemType.enType = FIDEVMGR_E8_FILESYSTEM::FI_EN_FSTY_HFS;
        break;
    case CGlobalEnumerations::FSTY_EXFAT:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.FileSystemType      = FI_EN_FSTY_EXFAT"));
        f_objConnectNotify.FileSystemType.enType = FIDEVMGR_E8_FILESYSTEM::FI_EN_FSTY_EXFAT;
        break;
    case CGlobalEnumerations::FSTY_ISO9660:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.FileSystemType      = FI_EN_FSTY_ISO9660"));
        f_objConnectNotify.FileSystemType.enType = FIDEVMGR_E8_FILESYSTEM::FI_EN_FSTY_ISO9660;
        break;
    case CGlobalEnumerations::FSTY_UDF:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.FileSystemType      = FI_EN_FSTY_UDF"));
        f_objConnectNotify.FileSystemType.enType = FIDEVMGR_E8_FILESYSTEM::FI_EN_FSTY_UDF;
        break;
    case CGlobalEnumerations::FSTY_UNKNOWN:
    case CGlobalEnumerations::FSTY_LASTELEM:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.FileSystemType      = FI_EN_FSTY_UNKNOWN"));
        f_objConnectNotify.FileSystemType.enType = FIDEVMGR_E8_FILESYSTEM::FI_EN_FSTY_UNKNOWN;
        break;
    default:
        ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.FileSystemType      = FI_EN_FSTY_UNKNOWN (DEFAULT)"));
        f_objConnectNotify.FileSystemType.enType = FIDEVMGR_E8_FILESYSTEM::FI_EN_FSTY_UNKNOWN;
    }

}


tVoid vd_devicemanager_tclService_DeviceManager::ConvertString(OUT FIDEVMGR_DEVICEPROPERTY &f_objConnectNotify,IN GENSTRING f_oString, IN tenElemOfProperty  eElemOfProp) const
{
    tU32 u32TextLength;    // set the max length of string
    tString l_cString;

    u32TextLength = (tU32)f_oString.length();  //result code review
    l_cString = (tString) OSAL_pvMemoryAllocate( u32TextLength+1 );

    if(NULL != l_cString)
    {

        (void)memset(l_cString, (tU32)'\0', u32TextLength+1);

        l_cString[u32TextLength]='\0';

        (void)memcpy(l_cString,f_oString.toStdString().c_str(),(tU32)f_oString.length());


        switch(eElemOfProp)
        {
        case eSerialID:
            f_objConnectNotify.DeviceSerialNo.bSet((tCString) l_cString,FIDEVMGR_STRING::FI_EN_UTF8);
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceSerialNo       = %s",
                            f_objConnectNotify.DeviceSerialNo.szGet(FIDEVMGR_STRING::FI_EN_UTF8) ));
            break;
        case ecUSBPort:
            f_objConnectNotify.USBPortNo.bSet((tCString) l_cString,FIDEVMGR_STRING::FI_EN_UTF8);
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.USBPortNo            = %s",
                            f_objConnectNotify.USBPortNo.szGet(FIDEVMGR_STRING::FI_EN_UTF8) ));
            break;
        case ecDeviceVersion:
            f_objConnectNotify.DeviceVersion.bSet((tCString) l_cString,FIDEVMGR_STRING::FI_EN_UTF8);
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceVersion        = %s",
                            f_objConnectNotify.DeviceVersion.szGet(FIDEVMGR_STRING::FI_EN_UTF8) ));
            break;
        case eDeviceName:
            f_objConnectNotify.DeviceName.bSet((tCString) l_cString,FIDEVMGR_STRING::FI_EN_UTF8);
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceName           = %s",
                            f_objConnectNotify.DeviceName.szGet(FIDEVMGR_STRING::FI_EN_UTF8) ));
            break;
        case eAccessoryName:
            f_objConnectNotify.AccessoryName.bSet((tCString) l_cString,FIDEVMGR_STRING::FI_EN_UTF8);
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.AccessoryName        = %s",
                            f_objConnectNotify.AccessoryName.szGet(FIDEVMGR_STRING::FI_EN_UTF8) ));
            break;
        case eMountPoint:
            f_objConnectNotify.MountPoint.bSet((tCString) l_cString,FIDEVMGR_STRING::FI_EN_UTF8);
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.MountPoint           = %s",
                            f_objConnectNotify.MountPoint.szGet(FIDEVMGR_STRING::FI_EN_UTF8) ));
            break;
        case eManufacturer:
            f_objConnectNotify.Manufacturer.bSet((tCString) l_cString,FIDEVMGR_STRING::FI_EN_UTF8);
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.Manufacturer           = %s",
                            f_objConnectNotify.Manufacturer.szGet(FIDEVMGR_STRING::FI_EN_UTF8) ));
            break;
        case eAccessoryName2:
            f_objConnectNotify.AccessoryName2.bSet((tCString) l_cString,FIDEVMGR_STRING::FI_EN_UTF8);
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.AccessoryName2           = %s",
                            f_objConnectNotify.AccessoryName2.szGet(FIDEVMGR_STRING::FI_EN_UTF8) ));
            break;
        case eDevicePath:
            f_objConnectNotify.DevicePath.bSet((tCString) l_cString,FIDEVMGR_STRING::FI_EN_UTF8);
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DevicePath           = %s",
                            f_objConnectNotify.DevicePath.szGet(FIDEVMGR_STRING::FI_EN_UTF8) ));
            break;

        case eDeviceNode:
            f_objConnectNotify.DeviceNode.bSet((tCString) l_cString,FIDEVMGR_STRING::FI_EN_UTF8);
            ETG_TRACE_USR4(("CreateDevicePropertyObject: l_objConnectNotify.DeviceNode           = %s",
                            f_objConnectNotify.DeviceNode.szGet(FIDEVMGR_STRING::FI_EN_UTF8) ));
            break;

        default:
            ETG_TRACE_FATAL(("CreateDevicePropertyObject: CHECK VALUE :%d",ETG_CENUM(tenElemOfProperty,eElemOfProp)));
            break;
        }

        OSAL_vMemoryFree((tPVoid)l_cString);
    }

}


tVoid vd_devicemanager_tclService_DeviceManager::ConvertOpticalDiscSlotState(OUT FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC &f_OpticalDiscSlotStateFI,IN const tDMOpticalDiscSlotState f_OpticalDiscSlotStateInternal) const //Roadmap 15002_CDAudio_DetectionAndDiagnosis
{

    ETG_TRACE_USR4(("Begin ConvertOpticalDiscSlotState"));
    switch(f_OpticalDiscSlotStateInternal)
    {
        case INITIALISING:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_INITIALISING;
            break;
        case INITIALISED:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_INITIALISED;
            break;
        case LASTMODE_EMTPY:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_LASTMODE_EMTPY;
            break;
        case LASTMODE_INSERTED_CDDA:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_LASTMODE_INSERTED_CDDA;
            break;
        case LASTMODE_INSERTED_CDROM:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_LASTMODE_INSERTED_CDROM;
            break;
        case LASTMODE_INSERTED_CDERROR:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_LASTMODE_INSERTED_CDERROR;
            break;
        case INSERTING:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_INSERTING;
            break;
        case INSERTED_CDAUDIO:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_INSERTED_CDAUDIO;
            break;
        case INSERTED_CDROM:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_INSERTED_CDROM;
            break;
        case INSERTED_CDERROR:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_INSERTED_CDERROR;
            break;
        case INSERTED_AUTOMATIC_CDAUDIO:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_INSERTED_AUTOMATIC_CDAUDIO;
            break;
        case INSERTED_AUTOMATIC_CDROM:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_INSERTED_AUTOMATIC_CDROM;
            break;
        case INSERTED_AUTOMATIC_CDERROR:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_INSERTED_AUTOMATIC_CDERROR;
            break;
        case EJECTING:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_EJECTING;
            break;
        case EJECTED_READY_TO_REMOVE:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_EJECTED_READY_TO_REMOVE;
            break;
        case EJECTED_EMPTY:
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_EJECTED_EMPTY;
            break;
        case UNDEFINED_STATE:
           f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_UNDEFINED;
            break;
        default:
            ETG_TRACE_FATAL(("ConvertOpticalDiscSlotState: unexpected type: f_OpticalDiscSlotStateInternal: %d",ETG_CENUM(tDMOpticalDiscSlotState,f_OpticalDiscSlotStateInternal)));
            f_OpticalDiscSlotStateFI.enType = FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC::FI_EN_UNDEFINED;
            break;

    }
    ETG_TRACE_USR4(("End ConvertOpticalDiscSlotState"));

}


tVoid vd_devicemanager_tclService_DeviceManager::ConvertOpticalDiscDeviceState(OUT mplay_fi_tcl_e8DeviceState &f_OpticalDiscDeviceStateFI,IN  tenOpticalDeviceState f_OpticalDiscDeviceStateInternal) const //CD Info
{

    ETG_TRACE_USR4(("Begin ConvertOpticalDiscDeviceState"));
    switch(f_OpticalDiscDeviceStateInternal)
    {
        case DEVICE_NOT_READY:
            f_OpticalDiscDeviceStateFI.enType = mplay_fi_tcl_e8DeviceState::FI_EN_MMGR_DEVICE_NOT_READY;
            break;
        case DEVICE_READY:
            f_OpticalDiscDeviceStateFI.enType = mplay_fi_tcl_e8DeviceState::FI_EN_MMGR_DEVICE_READY;
            break;
        default:
            ETG_TRACE_FATAL(("ConvertOpticalDiscDeviceState: unexpected type: "));
            f_OpticalDiscDeviceStateFI.enType = mplay_fi_tcl_e8DeviceState::FI_EN_MMGR_DEVICE_NOT_READY;
            break;

    }
    ETG_TRACE_USR4(("End ConvertOpticalDiscDeviceState"));

}

tVoid vd_devicemanager_tclService_DeviceManager::ConvertDeviceSpeedUSB(OUT FIDEVMGR_DEVICEPROPERTY &f_objConnectNotify,IN  tenDeviceSpeedUSB f_DeviceSpeedUSB) const //DeviceSpeed USB
{



    switch(f_DeviceSpeedUSB)
    {
        case UNKNOWN:
            f_objConnectNotify.DeviceSpeedUsb.enType = FISHARED_E8_DEVICESPEED::FI_EN_UNKNOWN;
            break;
        case LOW_SPEED:
            f_objConnectNotify.DeviceSpeedUsb.enType = FISHARED_E8_DEVICESPEED::FI_EN_LOW_SPEED;
            break;
        case FULL_SPEED:
            f_objConnectNotify.DeviceSpeedUsb.enType = FISHARED_E8_DEVICESPEED::FI_EN_FULL_SPEED;
            break;
        case HI_SPEED:
            f_objConnectNotify.DeviceSpeedUsb.enType = FISHARED_E8_DEVICESPEED::FI_EN_HI_SPEED;
            break;
        case SUPER_SPEED:
            f_objConnectNotify.DeviceSpeedUsb.enType = FISHARED_E8_DEVICESPEED::FI_EN_SUPER_SPEED;
            break;
        default:
            ETG_TRACE_FATAL(("CreateDevicePropertyObject: ConvertDeviceSpeedUSB: unexpected value: %d",f_DeviceSpeedUSB));
            f_objConnectNotify.DeviceSpeedUsb.enType = FISHARED_E8_DEVICESPEED::FI_EN_UNKNOWN;
            break;
    }

}

tVoid vd_devicemanager_tclService_DeviceManager::ConvertDeviceUnsupportedReason(OUT FIDEVMGR_DEVICEPROPERTY &f_objConnectNotify,IN  tenDevice_UnsupportedReason f_DeviceUnsupportedReason) const //DeviceUnsupportedReason
{
    switch(f_DeviceUnsupportedReason)
    {
        case OK:
            f_objConnectNotify.UnsupportedReason.enType = FISHARED_E8_UNSUPPORTEDREASON::FI_EN_OK;
            break;
        case NotMountedbyAutomounter:
        case NotMountedbyAutomounter_UNSUPPORTED_FILESYSTEM: //Roadmap 1615 Internal DVD-Drive integration
        case NotMountedbyAutomounter_UNSUPPORTED_NO_FILESYSTEM:
        case NotMountedbyAutomounter_UNSUPPORTED_AUDIO_CD:
        case NotMountedbyAutomounter_UNSUPPORTED_AUDIO_MIXED_MODE:
        case NotMountedbyAutomounter_UNSUPPORTED_BLACKLISTED:
            f_objConnectNotify.UnsupportedReason.enType = FISHARED_E8_UNSUPPORTEDREASON::FI_EN_NOTMOUNTEDDEVICE;
            break;
        case DisabledInConfiguration:
            f_objConnectNotify.UnsupportedReason.enType = FISHARED_E8_UNSUPPORTEDREASON::FI_EN_DISABLEDINCONFIGURATION;
            break;
        case NotSupportedByDVM:
            f_objConnectNotify.UnsupportedReason.enType = FISHARED_E8_UNSUPPORTEDREASON::FI_EN_NOTSUPPORTEDBYDVM;
            break;
        case HubButNotCustomerHub:
            f_objConnectNotify.UnsupportedReason.enType = FISHARED_E8_UNSUPPORTEDREASON::FI_EN_HUBBUTNOTCUSTOMERHUB;
            break;
        case PossiblySupportedByOtherClient:
            f_objConnectNotify.UnsupportedReason.enType = FISHARED_E8_UNSUPPORTEDREASON::FI_EN_POSSIBLYSUPPORTEDBYOTHERCLIENT;
            break;
        case Multipart_UnSupportedPartition:
            f_objConnectNotify.UnsupportedReason.enType = FISHARED_E8_UNSUPPORTEDREASON::FI_EN_MULTIPART_UNSUPPORTEDPARTITION;
            break;
        case AppleDeviceNotConnectedOnCustomerHub:
            f_objConnectNotify.UnsupportedReason.enType = FISHARED_E8_UNSUPPORTEDREASON::FI_EN_APPLEDEVICENOTCONNECTEDONCUSTOMERHUB;
            break;
        default:
            ETG_TRACE_FATAL(("CreateDevicePropertyObject: ConvertDeviceUnsupportedReason: unexpected value: %d",f_DeviceUnsupportedReason));

            break;
    }

}


/*-----------------------------------------------------------------------------*
 * FIDEVMGR_PORTSTATES vd_devicemanager_tclService_DeviceManager::CreatePortListObject(...)
 *-----------------------------------------------------------------------------*/
FIDEVMGR_PORTSTATES vd_devicemanager_tclService_DeviceManager::
CreatePortListObject(const trPortStates& f_rPortState) const
{

    FIDEVMGR_PORTSTATES l_objConnectNotify;

    l_objConnectNotify.USBPortNo    = f_rPortState.u8USBPortNo;
    l_objConnectNotify.OverCurrent  = f_rPortState.bOverCurrent;
    l_objConnectNotify.UnderVoltage = f_rPortState.bUndervoltage;
    l_objConnectNotify.HubConnected = f_rPortState.bHubConnected;
    l_objConnectNotify.OpenCircuit  = f_rPortState.bOpenCircuit;
    l_objConnectNotify.ElectricalFailure      = f_rPortState.bElectricalFailure;
    l_objConnectNotify.USBPowerON             = f_rPortState.bUSBPowerON;
    l_objConnectNotify.USBPortConfiguredUsed  = f_rPortState.bUSBPortConfiguredUsed;


    ETG_TRACE_USR4(("l_objConnectNotify.USBPortNo:              %d   (Note:eUSBUndef=%d)",ETG_ENUM(TENDEVMANAGERUSBHOST,l_objConnectNotify.USBPortNo),eUSBUndef));
    ETG_TRACE_USR4(("l_objConnectNotify.OverCurrent:  0x%x  ",l_objConnectNotify.OverCurrent));
    ETG_TRACE_USR4(("l_objConnectNotify.UnderVoltage: 0x%x  ",l_objConnectNotify.UnderVoltage));
    ETG_TRACE_USR4(("l_objConnectNotify.HubConnected: 0x%x  ",l_objConnectNotify.HubConnected));
    ETG_TRACE_USR4(("l_objConnectNotify.OpenCircuit:  0x%x  ",l_objConnectNotify.OpenCircuit));
    ETG_TRACE_USR4(("l_objConnectNotify.ElectricalFailure:      0x%x  ",l_objConnectNotify.ElectricalFailure));
    ETG_TRACE_USR4(("l_objConnectNotify.USBPowerON:             0x%x  ",l_objConnectNotify.USBPowerON));
    ETG_TRACE_USR4(("l_objConnectNotify.USBPortConfiguredUsed:  0x%x  ",l_objConnectNotify.USBPortConfiguredUsed));


    return l_objConnectNotify;
}

/*-----------------------------------------------------------------------------*
 * FIDEVMGR_DEVICEPROPERTY CreateDevicePropertyObject(           *
 *                       const CDevice* f_pCurPropertyDevice)                  *
 *-----------------------------------------------------------------------------*/
FIDEVMGR_DEVICEPROPERTY vd_devicemanager_tclService_DeviceManager::
CreateDevicePropertyObject( const CDevice* f_pCurPropertyDevice) const
{

    // Use member variables to fill the FI data object
    FIDEVMGR_DEVICEPROPERTY l_objConnectNotify;

    if( !f_pCurPropertyDevice )
    {
        //@todo check if l_objConnectNotify must be get default values
        ETG_TRACE_ERR(("ERROR:CreateDevicePropertyObject: f_pCurPropertyDevice == NULL"));
        return l_objConnectNotify;
    }

    ConvertString(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_cSerialID,     IN eSerialID );
    ConvertString(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_cUSBPort,      IN ecUSBPort);
    ConvertString(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_cDeviceVersion,IN ecDeviceVersion);
    ConvertString(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_cDeviceName,   IN eDeviceName);
    ConvertString(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_cAccessoryName,IN eAccessoryName);
    ConvertString(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_cMountPoint,   IN eMountPoint);

    if((DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_NOTIFY_DEVPATH)))
    {
        ConvertString(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_cDevpath,      IN eDevicePath);
    }

    ConvertString(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_cDevnode,      IN eDeviceNode);
#ifdef MSD_BIGGEST_PARTITON_FEATURE
    ConvertString(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_cAccessoryName2,IN eAccessoryName2);
#endif
    ConvertDeviceType(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_eDeviceType);
    ConvertConnectStatus(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_eConnectStatus);

    ConvertString(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_cManufacturer,   IN eManufacturer);

    l_objConnectNotify.VendorID  = f_pCurPropertyDevice->m_iVendorID;
    l_objConnectNotify.ProductID = f_pCurPropertyDevice->m_iProductID;
    l_objConnectNotify.TotalSize = f_pCurPropertyDevice->m_u64Size;
    l_objConnectNotify.TotalSize = f_pCurPropertyDevice->m_u64Size;
    ETG_TRACE_USR4 (("CreateDevicePropertyObject: l_objConnectNotify.VendorID            = 0x%04x", l_objConnectNotify.VendorID ));
    ETG_TRACE_USR4 (("CreateDevicePropertyObject: l_objConnectNotify.ProductID           = 0x%04x", l_objConnectNotify.ProductID ));
    ETG_TRACE_USR4 (("CreateDevicePropertyObject: l_objConnectNotify.TotalSize/1024 (kB) = %u  ", (tUInt)(l_objConnectNotify.TotalSize/1024) ));

    l_objConnectNotify.ParitionNum =  (tU8)f_pCurPropertyDevice->m_iValidPartitionNo;
    ETG_TRACE_USR4 (("CreateDevicePropertyObject: l_objConnectNotify.m_iValidPartitionNo  = %u", l_objConnectNotify.ParitionNum ));

    ConvertDeviceSpeedUSB(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_DeviceSpeedUSB);
    ETG_TRACE_USR4 (("CreateDevicePropertyObject: l_objConnectNotify.DeviceSpeedUsb.enType = %d",ETG_ENUM(TENDEVICESPEEDUSB,l_objConnectNotify.DeviceSpeedUsb.enType)));

#ifdef USE_TOTAL_USED_FREE_SIZE
    l_objConnectNotify.TotalSize_kB = f_pCurPropertyDevice->m_u64TotalSize_KB;
    l_objConnectNotify.UsedSize_kB  = f_pCurPropertyDevice->m_u64UsedSize_KB;
    l_objConnectNotify.FreeSize_kB  = f_pCurPropertyDevice->m_u64FreeSize_KB;

    ETG_TRACE_USR4 (("CreateDevicePropertyObject: l_objConnectNotify.TotalSize_kB         = %u", l_objConnectNotify.TotalSize_kB ));
    ETG_TRACE_USR4 (("CreateDevicePropertyObject: l_objConnectNotify.UsedSize_kB          = %u", l_objConnectNotify.UsedSize_kB ));
    ETG_TRACE_USR4 (("CreateDevicePropertyObject: l_objConnectNotify.FreeSize_kB          = %u", l_objConnectNotify.FreeSize_kB ));
#endif //USE_TOTAL_USED_FREE_SIZE

    ETG_TRACE_USR4 (("CreateDevicePropertyObject: l_objConnectNotify.Deviceclass          = %u", l_objConnectNotify.BaseClassCodeUsb ));
#ifdef USE_FILESYSTEMTYPE_ALIAS_FSTY
    ConvertFileSystemType(OUT l_objConnectNotify, IN f_pCurPropertyDevice->m_eFSType);
#endif

    ConvertDeviceUnsupportedReason(OUT l_objConnectNotify,IN f_pCurPropertyDevice->m_eDeviceUnsupportedReason);
    ETG_TRACE_USR4 (("CreateDevicePropertyObject: l_objConnectNotify.UnsupportedReason.enType = %d",l_objConnectNotify.UnsupportedReason.enType));
    return l_objConnectNotify;
}


tVoid vd_devicemanager_tclService_DeviceManager::CreateDeviceSDCardPropertyObject( FIDEVMGR_SDCARDINFO* f_pSDCard , const CDeviceCard* f_pSDCardDevice ) const
{
    tInt i;
    if( f_pSDCardDevice )
    {
        f_pSDCard->SDCardSlot = (tU8)((tU8)f_pSDCardDevice->m_eSlot + 1);   // + 1 because: CCA description says: SD Card slot number starts with 1 for Navigation SD Card.
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: SDCardSlot = %u  ", ETG_ENUM(DVM_CARD_SLOT, f_pSDCard->SDCardSlot) ));

        if( f_pSDCardDevice->m_bSlotEnable ) // First check if this SD Card slot is enabled
        {
            f_pSDCard->PowerStatus.enType = ( f_pSDCardDevice->m_bOverCurrent ) ? FIDEVMGR_E8_POWERSTATUS::FI_EN_POWER_STATUS_OVERCURRENT_ACTIVE : FIDEVMGR_E8_POWERSTATUS::FI_EN_POWER_STATUS_OVERCURRENT_INACTIVE;
        }
        else   // SD Card slot isn't enaled -> staus is not available
        {
            f_pSDCard->PowerStatus.enType = FIDEVMGR_E8_POWERSTATUS::FI_EN_POWER_STATUS_NOT_AVAILABLE;
        }

        switch( f_pSDCardDevice->m_u16MediaType )  // copy FIDEVMGR_E8_MEDIATYPE
        {
        case OSAL_C_U16_MEDIA_EJECTED:
            f_pSDCard->SDCardMedia.enType = FIDEVMGR_E8_MEDIATYPE::FI_EN_MEDIA_EJECTED;
            break;
        case OSAL_C_U16_INCORRECT_MEDIA:
            f_pSDCard->SDCardMedia.enType = FIDEVMGR_E8_MEDIATYPE::FI_EN_INCORRECT_MEDIA;
            break;
        case OSAL_C_U16_DATA_MEDIA:
            f_pSDCard->SDCardMedia.enType = FIDEVMGR_E8_MEDIATYPE::FI_EN_DATA_MEDIA;
            break;
        case OSAL_C_U16_UNKNOWN_MEDIA:
        default:
            f_pSDCard->SDCardMedia.enType = FIDEVMGR_E8_MEDIATYPE::FI_EN_UNKNOWN_MEDIA;
            break;
        }

        switch( f_pSDCardDevice->m_u16MediaState )  // copy FIDEVMGR_E8_MEDIASTATE
        {
        case OSAL_C_U16_MEDIA_READY:
            f_pSDCard->SDCardState.enType = FIDEVMGR_E8_MEDIASTATE::FI_EN_MEDIA_READY;
            break;
        case OSAL_C_U16_MEDIA_NOT_READY:
        default:
            f_pSDCard->SDCardState.enType = FIDEVMGR_E8_MEDIASTATE::FI_EN_MEDIA_NOT_READY;
            break;
        }

        f_pSDCard->DeviceSerialNo     = f_pSDCardDevice->m_u32SerialNumber;
        f_pSDCard->DevManufactureId   = f_pSDCardDevice->m_u8ManufactureId;
        f_pSDCard->DevSpecVersion     = f_pSDCardDevice->m_u8SDCardSpecVersion;
        f_pSDCard->SW_WriteProtected  = f_pSDCardDevice->m_bSW_WriteProtected;
        f_pSDCard->HW_WriteProtected  = f_pSDCardDevice->m_bHW_WriteProtected;
        f_pSDCard->Mounted            = f_pSDCardDevice->m_bMounted;
        f_pSDCard->TotalSize          = f_pSDCardDevice->m_u64CardSize;
        f_pSDCard->CardIdentifierRegister.CID.begin();
        for( i=0; i<SizeCIDRegister; i++ )
        {
            f_pSDCard->CardIdentifierRegister.CID.push_back( f_pSDCardDevice->m_u8CIDRegister[i] );
        }
        f_pSDCard->MountPoint.bSet( f_pSDCardDevice->m_strMountPoint.toStdString().c_str(), FIDEVMGR_STRING::FI_EN_UTF8 );

        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: PowerStatus        = %u  ", ETG_ENUM(DVM_CARD_POWER_STATUS, f_pSDCard->PowerStatus.enType ) ));
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: SDCardMedia        = %u  ", ETG_ENUM(DVM_PRM_TABLE_STATUS_MEDIA_CHANGE, f_pSDCardDevice->m_u16MediaType) ));
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: SDCardState        = %u  ", ETG_ENUM(DVM_PRM_TABLE_STATUS_MEDIA_STATE, f_pSDCardDevice->m_u16MediaState) ));
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: DeviceSerialNo     = 0x%x  ", (f_pSDCard->DeviceSerialNo) ));
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: m_u8ManufactureId  = 0x%x  ", (f_pSDCard->DevManufactureId) ));
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: DevSpecVersion     = %u  ", ETG_ENUM(SDCARD_SPECVERSION, f_pSDCard->DevSpecVersion) ));
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: SW_WriteProtected  = %d  ", ETG_ENUM(BOOL, f_pSDCard->SW_WriteProtected) ));
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: HW_WriteProtected  = %d  ", ETG_ENUM(BOOL, f_pSDCard->HW_WriteProtected) ));
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: Mounted            = %d  ", ETG_ENUM(BOOL, f_pSDCard->Mounted) ));
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: MountPoint         = %s", f_pSDCardDevice->m_strMountPoint.toStdString().c_str() ));
        ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: TotalSize/1024 (kB)= %u ", (tUInt)(f_pSDCard->TotalSize/1024) ));
        if(f_pSDCard->TotalSize == OSAL_C_U64_MAX)
        {
            ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: TotalSize is OSAL_C_U64_MAX" ));
        }
        for( i=0; i<SizeCIDRegister; i++ )
        {
            ETG_TRACE_USR4 (("CreateDeviceSDCardPropertyObject: m_u8CIDRegister[%d] = %d ",i,f_pSDCardDevice->m_u8CIDRegister[i] ));
        }
    }
    else    // if( !f_pSDCardDevice )
    {
        ETG_TRACE_ERR(("ERROR:CreateDeviceSDCardPropertyObject: f_pSDCardDevice == NULL"));
    }
}


/*-----------------------------------------------------------------------------*
 * tVoid connectClients(tBool bConnect)                                        *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::connectClients(tBool bConnect)
{
    ETG_TRACE_COMP(("vd_devicemanager_tclService_DeviceManager::connectClients: bConnect=0x%x",bConnect));
    m_bConnectClients=bConnect;
}

/*-----------------------------------------------------------------------------*
 * tVoid vSetServiceAvailable(tBool bAvailable)                                *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vSetServiceAvailable(tBool bAvailable)
{
    ETG_TRACE_USR1(("Begin: vSetServiceAvailable 0x%x",bAvailable));
    ahl_tclBaseOneThreadService::vSetPrivateServiceAvailableAllowed(bAvailable);
    ETG_TRACE_USR1(("End  : vSetServiceAvailable"));
}


tVoid vd_devicemanager_tclService_DeviceManager::RequestDeviceManagerNotifyOpticalDiscSloteState(IN const tDMOpticalDiscSlotState  eOpticalDiscSlotState) //Roadmap 15002_CDAudio_DetectionAndDiagnosis
{
    ETG_TRACE_USR4(("Begin: RequestDeviceManagerNotifyStatusCard"));
     m_eOpticalDiscSlotState =  eOpticalDiscSlotState;
    eUpdateClients( DEVMGR_NOTIFYSLOTSTATEOPTICALDISC );//triggers call of bStatusMessageFactory

    ETG_TRACE_USR4(("End: RequestDeviceManagerNotifyStatusCard"));


}

tVoid vd_devicemanager_tclService_DeviceManager::RequestDeviceManagerNotifyOpticalDiscCDInfo(IN const trOpticalDiskCDInfo  f_OpticalDiskCDInfo) //CD Info
{
    ETG_TRACE_USR4(("Begin: RequestDeviceManagerNotifyOpticalDiscCDInfo"));

    m_rOpticalDiskCDInfo.OpticalDeviceState =  f_OpticalDiskCDInfo.OpticalDeviceState;
    strncpy(m_rOpticalDiskCDInfo.OpticalDriveVersion, f_OpticalDiskCDInfo.OpticalDriveVersion, sizeof m_rOpticalDiskCDInfo.OpticalDriveVersion);
    ETG_TRACE_USR4(("RequestDeviceManagerNotifyOpticalDiscCDInfo m_rOpticalDiskCDInfo.OpticalDriveVersion:%s",m_rOpticalDiskCDInfo.OpticalDriveVersion))
    ETG_TRACE_USR4(("RequestDeviceManagerNotifyOpticalDiscCDInfo m_rOpticalDiskCDInfo.OpticalDeviceState:%d", ETG_ENUM(VD_DVM_OPTDISC_DEVICESTATE,f_OpticalDiskCDInfo.OpticalDeviceState)));
    eUpdateClients( DEVMGR_NOTIFYOPTICALDEVICECDINFO );//triggers call of bStatusMessageFactory

    ETG_TRACE_USR4(("End: RequestDeviceManagerNotifyOpticalDiscCDInfo"));


}

/*-----------------------------------------------------------------------------*
 * tVoid RequestDeviceManagerNotifyStatusCard(                                 *
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::RequestDeviceManagerNotifyStatusCard( )
{
    ETG_TRACE_USR4(("Begin: RequestDeviceManagerNotifyStatusCard"));

    //Implicitly calling message factory for given property
    eUpdateClients( DEVMGR_NOTIFYSDCARD );

    ETG_TRACE_USR4(("End: RequestDeviceManagerNotifyStatusCard"));
}


/*-----------------------------------------------------------------------------*
 * vShowDeviceProperty(...)
 *-----------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vShowDeviceProperty(const vector<structNotifyClients> &f_vClientsAllConnected) const
{
    for (unsigned int l_uiCount=0; l_uiCount < f_vClientsAllConnected.size() ; l_uiCount++)
    {
        ETG_TRACE_SYS(("***************->vHandle_DeviceManagerGetAllConnectedDevices_MethodStart (from StateTable)**********"));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_cSerialID     : %s",f_vClientsAllConnected[l_uiCount].cSerialID)); //@check if short is used
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_cUSBPort      : %s",f_vClientsAllConnected[l_uiCount].cUSBPort));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_eDeviceType   : %d",ETG_ENUM(DVM_DEVICE_TYPE,f_vClientsAllConnected[l_uiCount].eDeviceType)));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_cDeviceVersion: %s",f_vClientsAllConnected[l_uiCount].cDeviceVersion));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_cDeviceName   : %s",f_vClientsAllConnected[l_uiCount].cDeviceName));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_cAcessoryName : %s",f_vClientsAllConnected[l_uiCount].cAccessoryName));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_cMountPoint   : %s",f_vClientsAllConnected[l_uiCount].cMountPoint));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_cDevpath      : %s",f_vClientsAllConnected[l_uiCount].cDevPath));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_eConnectStatus: %d",ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,f_vClientsAllConnected[l_uiCount].eConnectStatus)));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_cManufacturer : %s",f_vClientsAllConnected[l_uiCount].cManufacturer));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_iVendorID     : 0x%04x",f_vClientsAllConnected[l_uiCount].iVendorID));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_iProductID    : 0x%04x",f_vClientsAllConnected[l_uiCount].iProductID));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: u64Size [KB]    : %u",(tU32)(f_vClientsAllConnected[l_uiCount].u64Size/1024) ));
#ifdef USE_FILESYSTEMTYPE_ALIAS_FSTY
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_eFSType         : %d",
                       ETG_CENUM(CGlobalEnumerations::FILESYSTEM_TYPE_Type,f_vClientsAllConnected[l_uiCount].eFSType) ));
#endif
#ifdef USE_TOTAL_USED_FREE_SIZE
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_u64TotalSize_KB : %d",f_vClientsAllConnected[l_uiCount].u64TotalSize_KB ));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_u64UsedSize_KB  : %d",f_vClientsAllConnected[l_uiCount].u64UsedSize_KB  ));
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_u64FreeSize_KB  : %d",f_vClientsAllConnected[l_uiCount].u64FreeSize_KB ));
#endif
#ifdef USE_PARITIONNUMBER
        ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: m_u8PartitionNo   : %d",f_vClientsAllConnected[l_uiCount].u8ValidPartitionNo ));
#endif
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_IPAD_AS_IPOD))
        {
            ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: ->DTY_IPAD        : mapped to DTY_IPOD"));
        }
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_CDROM_AS_USB))
        {
            ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: ->DTY_CDROM       : mapped to DTY_USB"));
        }
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_SDINT_AS_SD))
        {
            ETG_TRACE_SYS(("vHandle_DeviceManagerGetAllConnectedDevices_MethodStart: ->DTY_SD_INTERNAL : mapped to DTY_SD"));
        }

        ETG_TRACE_SYS(("***************vHandle_DeviceManagerGetAllConnectedDevices_MethodStart<-**************************"));
    }
}

/*-------------------------------------------------------------------------------------------------------------------------*
 * tVoid vd_devicemanager_tclService_DeviceManager::vShowDeviceProperty(...)
 *--------------------------------------------------------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vShowDeviceProperty(const CDevice &f_objCurNotifiedDevice) const
{
    ETG_TRACE_SYS(("***************->RequestDeviceManagerNotifyConnectionStatus(eUpdateClients)**********"));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_cSerialID         : %s",f_objCurNotifiedDevice.m_cSerialID.toStdString().c_str())); //@check if short is used
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_cUSBPort          : %s",f_objCurNotifiedDevice.m_cUSBPort.toStdString().c_str() ));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_eDeviceType       : %d",ETG_ENUM(DVM_DEVICE_TYPE,f_objCurNotifiedDevice.m_eDeviceType)));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_cDeviceVersion    : %s",f_objCurNotifiedDevice.m_cDeviceVersion.toStdString().c_str()));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_cDeviceName       : %s",f_objCurNotifiedDevice.m_cDeviceName.toStdString().c_str()));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_cAcessoryName     : %s",f_objCurNotifiedDevice.m_cAccessoryName.toStdString().c_str()));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_cMountPoint       : %s",f_objCurNotifiedDevice.m_cMountPoint.toStdString().c_str()));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_cDevPath          : %s",f_objCurNotifiedDevice.m_cDevpath.toStdString().c_str()));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_eConnectStatus    : %d",ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,f_objCurNotifiedDevice.m_eConnectStatus)));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_cManufacturer     : %s",f_objCurNotifiedDevice.m_cManufacturer.toStdString().c_str()));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_iVendorID          : 0x%04x",f_objCurNotifiedDevice.m_iVendorID));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_iProductID         : 0x%04x",f_objCurNotifiedDevice.m_iProductID));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: u64Size [KB]         : %u",(tU32)(f_objCurNotifiedDevice.m_u64Size/1024) ));
#ifdef USE_FILESYSTEMTYPE_ALIAS_FSTY
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_eFSType         : %d",
                   ETG_CENUM(CGlobalEnumerations::FILESYSTEM_TYPE_Type,m_objCurNotifiedDevice.m_eFSType) ));
#endif
#ifdef USE_TOTAL_USED_FREE_SIZE
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_u64TotalSize_KB       : %d",f_objCurNotifiedDevice.m_u64TotalSize_KB ));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_u64UsedSize_KB        : %d",f_objCurNotifiedDevice.m_u64UsedSize_KB  ));
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_u64FreeSize_KB        : %d",f_objCurNotifiedDevice.m_u64FreeSize_KB ));
#endif
#ifdef USE_PARITIONNUMBER
    ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: m_iValidPartitionNo     : %d",f_objCurNotifiedDevice.m_iValidPartitionNo));
#endif
    ETG_TRACE_SYS(("[RequestDeviceManagerNotifyConnectionStatus: m_eUSB                  : %d] ",ETG_ENUM(tenDevManagerUSBHost,f_objCurNotifiedDevice.m_eUSB)));


    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_IPAD_AS_IPOD))
    {
        ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: ->DTY_IPAD          : mapped to DTY_IPOD"));
    }
    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_CDROM_AS_USB))
    {
        ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: ->DTY_CDROM         : mapped to DTY_USB"));
    }
    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_SDINT_AS_SD))
    {
        ETG_TRACE_SYS(("RequestDeviceManagerNotifyConnectionStatus: ->DTY_SD_INTERNAL   : mapped to DTY_SD"));
    }

    ETG_TRACE_SYS(("***************RequestDeviceManagerNotifyConnectionStatus<-**************************"));
}


/*-------------------------------------------------------------------------------------------------------------------------*
 * tVoid vd_devicemanager_tclService_DeviceManager::vShowDeviceProperty(...)
 *--------------------------------------------------------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vShowDeviceProperty(const CDevice *f_pCDeviceProperty) const
{
    ETG_TRACE_SYS(("***************->vHandle_DeviceManagerGetDeviceProperties_MethodStart**********"));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_cSerialID     : %s",f_pCDeviceProperty->m_cSerialID.toStdString().c_str())); //@check if short is used
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_cUSBPort      : %s",f_pCDeviceProperty->m_cUSBPort.toStdString().c_str()));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_eDeviceType   : %d",ETG_ENUM(DVM_DEVICE_TYPE,f_pCDeviceProperty->m_eDeviceType)));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_cDeviceVersion: %s",f_pCDeviceProperty->m_cDeviceVersion.toStdString().c_str()));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_cDeviceName   : %s",f_pCDeviceProperty->m_cDeviceName.toStdString().c_str()));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_cAcessoryName : %s",f_pCDeviceProperty->m_cAccessoryName.toStdString().c_str()));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_cMountPoint   : %s",f_pCDeviceProperty->m_cMountPoint.toStdString().c_str()));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_cDevpath      : %s",f_pCDeviceProperty->m_cDevpath.toStdString().c_str()));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_eConnectStatus: %d",ETG_ENUM(DEVICE_CONNECTSTATUS_TYPE,f_pCDeviceProperty->m_eConnectStatus)));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_cManufacturer : %s",f_pCDeviceProperty->m_cManufacturer.toStdString().c_str()));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_iVendorID     : 0x%04x",f_pCDeviceProperty->m_iVendorID));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: m_iProductID    : 0x%04x",f_pCDeviceProperty->m_iProductID));
    ETG_TRACE_SYS(("vHandle_DeviceManagerGetDeviceProperties_MethodStart: u64Size [KB]    : %u",(tU32)(f_pCDeviceProperty->m_u64Size/1024) ));
    ETG_TRACE_SYS(("***************vHandle_DeviceManagerGetDeviceProperties_MethodStart<-**************************"));
}

/*-------------------------------------------------------------------------------------------------------------------------*
 * tVoid vd_devicemanager_tclService_DeviceManager::vFillUndervoltage(...)
 *--------------------------------------------------------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vFillUndervoltage( FIDEVMGR_NOTIFYCONNECTIONSTATUS &f_oFiDataObject) const
{
    trPortStates l_rPortState;
    tBool bElemReceived;

    f_oFiDataObject.Undervoltage = FALSE; //in dubito we assume there is no undervoltage
#ifndef USE_HIGHRISK4USB_HWMALFUNCTION //I'm not sure what this will cause at the interface it - has been originally added for VAGMIBE
    if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_VOLTAGEMANAGER))
    {
        tUInt uiNumOfElements =  PortListManager::GetInstance()->uiGetSizeOfArrayHardwareSignals();

        for(tUInt i =(tUInt)eUSB1; i<=uiNumOfElements;i++)
        {
            PortListManager::GetInstance()->vClear(l_rPortState);
            bElemReceived = PortListManager::GetInstance()->bGetElement(IN i, OUT l_rPortState);

            if(TRUE == bElemReceived)
            {
                f_oFiDataObject.Undervoltage = l_rPortState.bUndervoltage;
                ETG_TRACE_COMP(("vFillUndervoltage: l_rPortState.bUndervoltage: 0x%x",l_rPortState.bUndervoltage));
                break; //unervoltage state is the same for all states hence it's ok to break here
            }

        }
    }
#endif
}

/*-------------------------------------------------------------------------------------------------------------------------*
 * tVoid vd_devicemanager_tclService_DeviceManager::vFillUSBPortList(...)
 *--------------------------------------------------------------------------------------------------------------------------*/

tVoid vd_devicemanager_tclService_DeviceManager::vFillUSBPortListVector( FIDEVMGR_NOTIFYCONNECTIONSTATUS &f_oFiDataObject) const
{
    ETG_TRACE_USR4(("bStatusMessageFactory: ----------------------------------Send USBPortList (Vector) to client-----------------------------------"));

    trPortStates l_rPortState;
    tBool bElemReceived;

    tUInt uiNumOfElements =  PortListManager::GetInstance()->uiGetSizeOfArrayHardwareSignals();

    for(tUInt i =(tUInt)eUSB1; i<=uiNumOfElements;i++)
    {

        PortListManager::GetInstance()->vClear(l_rPortState);
        bElemReceived = PortListManager::GetInstance()->bGetElement(IN i, OUT l_rPortState);
        if(TRUE == bElemReceived)
        {
            //@todo clarify if configured values should be send only  or all
            f_oFiDataObject.USBPortList.push_back(CreatePortListObject(l_rPortState));


        }

    }

}

/*-------------------------------------------------------------------------------------------------------------------------*
 * tVoid vd_devicemanager_tclService_DeviceManager::vFillDeviceTypeVector(...)
 *--------------------------------------------------------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vFillDeviceTypeVector(FIDEVMGR_NOTIFYCONNECTIONSTATUS &f_oFiDataObject)
{
    //-------------------------------------------------------------------------------------------
    // push first element to vector - last connected/removed etc. device [index=0 contains last changed device]
    //-------------------------------------------------------------------------------------------
    ETG_TRACE_USR4(("bStatusMessageFactory: ----------------------------------Send Deviceype (Vector) to client-----------------------------------"));

    int iOffset = 0;
    //---------------------------------
    //EMPTY: DEVLIST_DEVICEMGRSERVICE
    //---------------------------------
    if((DeviceListManager::GetInstance()->getSizeOfList(DEVLIST_DEVICEMGRSERVICE)) == 0)
    {
        ETG_TRACE_USR4(("bStatusMessageFactory: vector EMPTY"));
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_UNKNOWNDEV_AT_STARTUP))
        {
            //Workaround at startup  and if no devices are connected
            //do want to get rid of this but in GM prochmi-gm_out.out crashes in PDAL_tclDeviceManagerClient38vHandleDeviceManagerNotificationStatusEP18amt_tclServiceData
            f_oFiDataObject.Devicetype.push_back(CreateDevicePropertyObject(&m_objCurNotifiedDevice)); ///@todo don't send if list is empty!! I.e. prevent first transmission
            ETG_TRACE_USR4(("bStatusMessageFactory: Send UNKWOWN device at startup and if vector is empty"));
        }

    }
    //---------------------------------
    // FILLED: DEVLIST_DEVICEMGRSERVICE
    //---------------------------------
    else
    {
        ETG_TRACE_USR4(("bStatusMessageFactory: vector FILLED"));
        if(DVM_OFF == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_NOTIFY_NO_REDUNDAND_MSGS))
        {
            ETG_TRACE_USR4(("bStatusMessageFactory: ---------------------"));
            ETG_TRACE_USR4(("bStatusMessageFactory: Index:0 "));
            ETG_TRACE_USR4(("bStatusMessageFactory: ---------------------"));
            f_oFiDataObject.Devicetype.push_back(CreateDevicePropertyObject(&m_objCurNotifiedDevice));
            iOffset = 1;
        }

        //---------------------------------------------------------------------------------------
        //push the vector of all connected devices to the FI object [index 1--last - contains all connected devices]
        //--------------------------------------------------------------------------------------
        CDevice oCurrentDevice;
        tUInt iSize = DeviceListManager::GetInstance()->getSizeOfList(DEVLIST_DEVICEMGRSERVICE);

        ETG_TRACE_USR4(("bStatusMessageFactory: Num of connected devices: %d",iSize));
        for (unsigned int l_uiCount = 0; l_uiCount < iSize;l_uiCount++)
        {
            ETG_TRACE_USR4(("bStatusMessageFactory: ---------------------"));
            ETG_TRACE_USR4(("bStatusMessageFactory: Index: %d",l_uiCount+iOffset));
            ETG_TRACE_USR4(("bStatusMessageFactory: ---------------------"));
            if(TRUE == DeviceListManager::GetInstance()->getElement(DEVLIST_DEVICEMGRSERVICE,l_uiCount, oCurrentDevice))
            {
                f_oFiDataObject.Devicetype.push_back(CreateDevicePropertyObject(&oCurrentDevice));
            }
            else
            {
                ETG_TRACE_FATAL(("ERROR: bStatusMessageFactory:device not in list"));
            }
        }

        //----------------------------------------------------------------------------------------------------------------------
        // FYI:
        //here all removed notifications are send - StateStable which was calling InformClients to trigger this notification is allowed to delete removed devices
        // from the deviceListManager now - that these do not appear in future messages anymore
        //----------------------------------------------------------------------------------------------------------------------

    }
}


/*-------------------------------------------------------------------------------------------------------------------------*
 *tVoid vd_devicemanager_tclService_DeviceManager::vFillSDCardProperty(...)
 *--------------------------------------------------------------------------------------------------------------------------*/
tVoid vd_devicemanager_tclService_DeviceManager::vFillSDCardProperty(FIDEVMGR_NOTIFYSDCARDSTATUS &f_oFiDataObject) const
{
    //-------------------------------------------------------------------
    // push the card info to the FI object - all possible SD Card devices
    //-------------------------------------------------------------------
    CDeviceCard oCurDevCard;
    for( unsigned int l_uiCount = (tUInt)eCard0; l_uiCount < ARRAYSIZEFORCARD; l_uiCount++ )      // starting from first card
    {
        DeviceListManager* pDevListMgr = DeviceListManager::GetInstance();
        if( pDevListMgr )
        {
            pDevListMgr->getCardInfo( &oCurDevCard, (tenSlot)l_uiCount );
            // Use member variables to fill the FI data object
            FIDEVMGR_SDCARDINFO       l_objSDCard;
            CreateDeviceSDCardPropertyObject( &l_objSDCard, &oCurDevCard );
            f_oFiDataObject.SDCardList.push_back( l_objSDCard );
        }
        else
        {
            ETG_TRACE_FATAL(("ERROR: bStatusMessageFactory [DEVMGR_NOTIFYSDCARD]: fail to get instande <DeviceListManager::GetInstance()>"));
        }
    }
}



/*-----------------------------------------------------------------------------*
 * tBool bStatusMessageFactory(tU16 u16FunctionId,                             *
 *                             amt_tclServiceData& roOutMsg,                   *
 *                             amt_tclServiceData* poInMsg                     *
 *-----------------------------------------------------------------------------*/
tBool vd_devicemanager_tclService_DeviceManager
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
    ETG_TRACE_USR4(("[service]:Begin: bStatusMessageFactory"));

    (tVoid) poInMsg; // This line is added to avoid LINT warnings.
    // Please remove as soon as the variable is used.
    tBool bSuccess = FALSE;

    if( poInMsg )
    {
        ETG_TRACE_USR4(("bStatusMessageFactory() entered. SourceAppID = %x; FID = %x.", ETG_ENUM(ail_u16AppId, poInMsg->u16GetSourceAppID()), ETG_ENUM(DVM_FCTID, u16FunctionId) ));
    }
    else
    {
        ETG_TRACE_USR4(("bStatusMessageFactory() entered. FID = %4x.", u16FunctionId));/*ETG_ENUM(DVM_FCTID, u16FunctionId) */
    }

    switch(u16FunctionId)
    {
    // Handle creation of the FI data object for this function ID and the
    // handover to the referenced service data object 'roOutMsg' here ...

    // Set local variable 'bSuccess' to TRUE if the creation of the FI data
    // object and the handover to 'roOutMsg' was successful.

    // Notify the new connected device to the client
    case DEVMGR_NOTIFYCONNECTION:
    {
        ETG_TRACE_USR2(("bStatusMessageFactory:DEVMGR_NOTIFYCONNECTION"));
        ETG_TRACE_USR4(("bStatusMessageFactory: ===============================Send to clients ============================================"));
        // Create the object of FIDEVMGR_NOTIFYCONNECTIONSTATUS
        FIDEVMGR_NOTIFYCONNECTIONSTATUS oFiDataObject;

        //=================================================================================
        // Element: Undervoltage  (value)
        //=================================================================================
        vFillUndervoltage(oFiDataObject);

        //=================================================================================
        // Element: USBPortList  (vector of elements)
        //=================================================================================
        vFillUSBPortListVector(oFiDataObject);

        //=================================================================================
        //Element: Deviceype (vector of elements)
        //=================================================================================
        vFillDeviceTypeVector(oFiDataObject);

        ETG_TRACE_COMP(("bStatusMessageFactory: =================================================================================="));

        //==========================================================
        // Create FI VisitorMessage. (The FI data object will be streamed (each
        // parameter is copied individually) to shared memory.)
        // Afterwards the ownership for this shared memory is handed over to
        // the message rOutMsg.
        //==========================================================
        fi_tclVisitorMessage    oVisitorMsg( oFiDataObject, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION );
        bSuccess = oVisitorMsg.bHandOver( &roOutMsg );

        // Always destroy the (message related) FI data object (before leaving
        // its creation scope)
        oFiDataObject.vDestroy();

    }
        break;
    case DEVMGR_NOTIFYSDCARD:
    {
        ETG_TRACE_USR2(("bStatusMessageFactory:DEVMGR_NOTIFYSDCARD"));
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eConf_ENABLE_USE_PRM_SDCARDSIGNALS))
        {
            // Create the object of FIDEVMGR_NOTIFYSDCARDSTATUS
            FIDEVMGR_NOTIFYSDCARDSTATUS oFiDataObject;
            //=================================================================================
            //Element: SDCardProperty (vector of elements)
            //=================================================================================

            vFillSDCardProperty(oFiDataObject);

            // Create FI VisitorMessage. (The FI data object will be streamed (each
            // parameter is copied individually) to shared memory.)
            // Afterwards the ownership for this shared memory is handed over to
            // the message rOutMsg.
            fi_tclVisitorMessage    oVisitorMsg( oFiDataObject, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION );
            bSuccess = oVisitorMsg.bHandOver( &roOutMsg );

            // Always destroy the (message related) FI data object (before leaving its creation scope)
            oFiDataObject.vDestroy();

        }
        else
        {
            ETG_TRACE_COMP(("[WARNING] bStatusMessageFactory:DEVMGR_NOTIFYSDCARD: eConf_ENABLE_USE_PRM_SDCARDSIGNALS disabled"));
        }
        break;
    }
    case DEVMGR_NOTIFYSLOTSTATEOPTICALDISC: /*Roadmap 15002_CDAudio_DetectionAndDiagnosis*/
    {
        ETG_TRACE_USR2(("bStatusMessageFactory:DEVMGR_NOTIFYSLOTSTATEOPTICALDISC"));
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_INTERNAL_CDDA))
        {
            // Create the object of FIDEVMGR_NOTIFYSDCARDSTATUS
            FIDEVMGR_NOTIFYSLOTSTATEOPTICALDISCSTATUS oFiDataObject;
            if(UNDEFINED_STATE !=  m_eOpticalDiscSlotState )
            {
                FISHARED_E8_NOTIFYSLOTSTATEOPTICALDISC  l_eOpticalDiscSlotStatet;
                ConvertOpticalDiscSlotState(OUT  l_eOpticalDiscSlotStatet,IN  m_eOpticalDiscSlotState);
                oFiDataObject.OpticalDiscSlotState.push_back( l_eOpticalDiscSlotStatet);
            }

            // Create FI VisitorMessage. (The FI data object will be streamed (each
            // parameter is copied individually) to shared memory.)
            // Afterwards the ownership for this shared memory is handed over to
            // the message rOutMsg.
            fi_tclVisitorMessage    oVisitorMsg( oFiDataObject, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION );
            bSuccess = oVisitorMsg.bHandOver( &roOutMsg );

            // Always destroy the (message related) FI data object (before leaving its creation scope)
            oFiDataObject.vDestroy();

        }
        else
        {
            ETG_TRACE_COMP(("[WARNING] bStatusMessageFactory:DEVMGR_NOTIFYSDCARD: eConf_ENABLE_USE_PRM_SDCARDSIGNALS disabled"));
        }
        break;
    }
    case DEVMGR_NOTIFYOPTICALDEVICECDINFO: /*CD Info*/
    {
        ETG_TRACE_USR2(("bStatusMessageFactory:DEVMGR_NOTIFYOPTICALDEVICECDINFO"));
        if(DVM_ON == ConfigurationManager::GetInstance()->u16GetConfigurationValue(eCONF_ENABLE_INTERNAL_CDDA))
        {
            // Create the object of FIDEVMGR_NOTIFYCDINFOSTATUS
            FIDEVMGR_NOTIFYCDINFOSTATUS oFiDataObject;

            //FISHARED_E8_NOTIFYCDINFO  l_rOpticalDiscCDInfo;
            ConvertOpticalDiscDeviceState(OUT  oFiDataObject.CDInfo.e8DeviceState,IN  m_rOpticalDiskCDInfo.OpticalDeviceState);
            oFiDataObject.CDInfo.DriveVersion.bSet((tCString)m_rOpticalDiskCDInfo.OpticalDriveVersion,mplay_fi_tclString::FI_EN_UTF8);

            // Create FI VisitorMessage. (The FI data object will be streamed (each
            // parameter is copied individually) to shared memory.)
            // Afterwards the ownership for this shared memory is handed over to
            // the message rOutMsg.
            fi_tclVisitorMessage    oVisitorMsg( oFiDataObject, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION );
            bSuccess = oVisitorMsg.bHandOver( &roOutMsg );

            // Always destroy the (message related) FI data object (before leaving its creation scope)
            oFiDataObject.vDestroy();

        }
        else
        {
            ETG_TRACE_COMP(("[WARNING] bStatusMessageFactory:DEVMGR_NOTIFYSDCARD: eConf_ENABLE_USE_PRM_SDCARDSIGNALS disabled"));
        }
        break;
    }
    case DEVMGR_DEVMANAGEROVERTEMPCD:
    {
        ETG_TRACE_USR2(("bStatusMessageFactory:DEVMGR_DEVMANAGEROVERTEMPCD"));
        // Create the object of FIDEVMGR_OVERTEMPCDSTATUS
        FIDEVMGR_OVERTEMPCDSTATUS oFiDataObject;
        oFiDataObject.OverTemperature = DeviceManagerInterface::GetInstance()->bGetOverTemperatureCDDriveStatus();
        // Create FI VisitorMessage. (The FI data object will be streamed (each
        // parameter is copied individually) to shared memory.)
        // Afterwards the ownership for this shared memory is handed over to
        // the message rOutMsg.
        fi_tclVisitorMessage    oVisitorMsg( oFiDataObject, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION );
        bSuccess = oVisitorMsg.bHandOver( &roOutMsg );

        // Always destroy the (message related) FI data object (before leaving its creation scope)
        oFiDataObject.vDestroy();
        break;
    }
    case DEVMGR_DEVMANAGERTELEMATICSBOXALIVE:
    {
        ETG_TRACE_USR2(("bStatusMessageFactory:DEVMGR_DEVMANAGERTELEMATICSBOXALIVE"));
        // Create the object of FIDEVMGR_TELEMATICSBOXALIVESTATUS
        FIDEVMGR_TELEMATICSBOXALIVESTATUS oFiDataObject;
        oFiDataObject.BTAConnectionStatus = DeviceManagerInterface::GetInstance()->bGetTelematicsBoxApplicationLayerAliveStatus();
        // Create FI VisitorMessage. (The FI data object will be streamed (each
        // parameter is copied individually) to shared memory.)
        // Afterwards the ownership for this shared memory is handed over to
        // the message rOutMsg.
        fi_tclVisitorMessage    oVisitorMsg( oFiDataObject, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION );
        bSuccess = oVisitorMsg.bHandOver( &roOutMsg );

         // Always destroy the (message related) FI data object (before leaving its creation scope)
         oFiDataObject.vDestroy();
        break;
    }

    case DEVMGR_DVDDRIVEINFO:
    {
        ETG_TRACE_USR2(("bStatusMessageFactory:DEVMGR_DVDDRIVEINFO"));
        // Create the object of FIDEVMGR_DEVMGR_DVDDRIVEINFO
        FIDEVMGR_DVDDRIVEINFOSTATUS oFiDataObject;
        //Addition for future Property Status update. Uncomment below code and use the above FiObejct
        //oFiDataObject.BTAConnectionStatus = DeviceManagerInterface::GetInstance()->vGetDVDDriveInfo();
        // Create FI VisitorMessage. (The FI data object will be streamed (each
        // parameter is copied individually) to shared memory.)
        // Afterwards the ownership for this shared memory is handed over to
        // the message rOutMsg.
        //fi_tclVisitorMessage    oVisitorMsg( oFiDataObject, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MINOR_VERSION );
        //bSuccess = oVisitorMsg.bHandOver( &roOutMsg );

         // Always destroy the (message related) FI data object (before leaving its creation scope)
         //oFiDataObject.vDestroy();
        break;
    }



    default:  // cpr2hi - added a default case to complete the switch statement.
        if( poInMsg )
        {
            ETG_TRACE_ERR(( "bStatusMessageFactory: Unknown 'FID = %x', Requested from App = %x", ETG_ENUM(DVM_FCTID, u16FunctionId), ETG_ENUM(ail_u16AppId, poInMsg->u16GetSourceAppID()) ));
        }
        else
        {
            ETG_TRACE_ERR(( "bStatusMessageFactory: Unknown 'FID = %u'", u16FunctionId ));
        }
        DVM_NORMAL_M_ASSERT_ALWAYS();
        break;
    }

    if (FALSE == bSuccess)
    {
        ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

        //DVM_NORMAL_M_ASSERT_ALWAYS();
    }



    ETG_TRACE_USR4(("End  : bStatusMessageFactory"));

    return bSuccess;
}


IN tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerAddTelematicsBox_MethodStart( amt_tclServiceData* poMessage)
{
    ETG_TRACE_USR4(("Begin  : vHandle_DeviceManagerAddTelematicsBox_MethodStart"));

    if(!m_bConnectClients)
    {
        ETG_TRACE_FATAL(("WARNING: In Test mode: VD_DVM disconnected from property notification but clients uses method (vHandle_OpticalDiscEject_MethodStart)"));
    }
    if(poMessage)
    {
        ETG_TRACE_USR4(("vHandle_DeviceManagerAddTelematicsBox_MethodStart. SourceAppID = %x; FID = %x.", ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID()), ETG_ENUM(DVM_FCTID, poMessage->u16GetFunctionID()) ));

        //===============================================================
        //receive and unmarshal message
        //===============================================================
        FIDEVMGR_ADDTELEMATICSBOX_METHODSTART   oFiDataObject_Get;   // create the object of FIDEVMGR_ADDTELEMATICSBOX_METHODSTART
        fi_tclVisitorMessage                    oVisitorMsg(poMessage);   //create the visitor message

        if (OSAL_ERROR != oVisitorMsg.s32GetData (oFiDataObject_Get, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {
            // Retrieve the details of device from message
            tU16 u16VendorID                         = (tU16)oFiDataObject_Get.VendorID;
            tU16 u16ProductID                        = (tU16)oFiDataObject_Get.ProductID;
            tU16 u16USBPortNo                        = (tU16)oFiDataObject_Get.USBPortNo;
            FISHARED_E8_DEVICESPEED devicespeed      = oFiDataObject_Get.SpeedInfo;
            tBool bAdd                               = oFiDataObject_Get.Add;
            tBool bIsHighSpeedExpected               = FALSE;

            switch(devicespeed.enType)
            {

            case FISHARED_E8_DEVICESPEED::FI_EN_HI_SPEED:
            {
                bIsHighSpeedExpected = TRUE;
                break;
            }
            case FISHARED_E8_DEVICESPEED::FI_EN_FULL_SPEED:
            {
                bIsHighSpeedExpected = FALSE;
                break;
            }
            default:
                ETG_TRACE_FATAL(("vHandle_DeviceManagerAddTelematicsBox_MethodStart: unexpected value: %d",devicespeed.enType));
                break;

            }



            ETG_TRACE_SYS (("***********************************************************************************************"));
            ETG_TRACE_SYS (("vHandle_DeviceManagerAddTelematicsBox_MethodStart: u32VendorID          = 0x%x",u16VendorID));
            ETG_TRACE_SYS (("vHandle_DeviceManagerAddTelematicsBox_MethodStart: u32ProductID         = 0x%x",u16ProductID));
            ETG_TRACE_SYS (("vHandle_DeviceManagerAddTelematicsBox_MethodStart: u32USBPortNo         = %d"  ,u16USBPortNo));
            ETG_TRACE_SYS (("vHandle_DeviceManagerAddTelematicsBox_MethodStart: bIsHighSpeedExpected = %d",ETG_ENUM(TBOOL,bIsHighSpeedExpected)));
            ETG_TRACE_SYS (("************************************************************************************************"));

            trReceiverInfo  l_oReceiverInfo;
            l_oReceiverInfo.u16GetSourceAppID = poMessage->u16GetSourceAppID();
            l_oReceiverInfo.u16GetRegisterID  = poMessage->u16GetRegisterID();
            l_oReceiverInfo.u16GetCmdCounter  = poMessage->u16GetCmdCounter();
            l_oReceiverInfo.u16GetFunctionID  = poMessage->u16GetFunctionID();
            trTelematicsBoxDeviceInfo l_uiTelematicsBoxDeviceInfo;
            l_uiTelematicsBoxDeviceInfo.iProductID           = u16ProductID;
            l_uiTelematicsBoxDeviceInfo.iVendorID            = u16VendorID;
            l_uiTelematicsBoxDeviceInfo.eUsb                 = (statetbl::tenDevManagerUSBHost)u16USBPortNo;
            l_uiTelematicsBoxDeviceInfo.bIsHighSpeedExpected = bIsHighSpeedExpected;
            tBool bSuccess  = DeviceManagerInterface::GetInstance()->AddTelematicsBox(l_uiTelematicsBoxDeviceInfo,bAdd);
            //=======================
            //send result to sender
            //=======================
            vHandle_DeviceManagerAddTelematicsBox_MethodReturn(l_oReceiverInfo,bSuccess);
        }
        oFiDataObject_Get.vDestroy();
    }

    ETG_TRACE_USR4(("End    : vHandle_DeviceManagerAddTelematicsBox_MethodStart"));
}

OUT tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerAddTelematicsBox_MethodReturn(const trReceiverInfo &f_oReceiverInfo, tBool f_bSuccess)
{
    ETG_TRACE_USR4(("Begin  : vHandle_DeviceManagerAddTelematicsBox_MethodReturn"));

    FIDEVMGR_ADDTELEMATICSBOX_METHODRESULT oFiDataObject;

    oFiDataObject.Success = f_bSuccess;

    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg_Result(oFiDataObject,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION);

    // Here the message related header information is added and by this the
    // creation of the message is completed.
    vInitServiceData(oMsg_Result,                          // ServiceDataMsg
                     f_oReceiverInfo.u16GetSourceAppID,    // Target AppID
                     f_oReceiverInfo.u16GetRegisterID,     // RegisterID
                     f_oReceiverInfo.u16GetCmdCounter,     // CmdCounter,
                     f_oReceiverInfo.u16GetFunctionID,     // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODRESULT); // Opcode

    // Post the message to the client
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg_Result, TRUE);

    // Check for Error after posting message
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("vHandle_DeviceManagerAddTelematicsBox_MethodReturn: ERROR: enPostMessage() 'ail_tenCommunicationError'= %d", (int)enResult));
    }

    oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)

    ETG_TRACE_USR4(("End    : vHandle_DeviceManagerAddTelematicsBox_MethodReturn"));
}


IN tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerGetConfigurationValue_MethodStart( amt_tclServiceData* poMessage)
{
    ETG_TRACE_USR4(("Begin  : vHandle_DeviceManagerGetConfigurationValue_MethodStart"));
    if(!m_bConnectClients)
    {
        ETG_TRACE_FATAL(("WARNING: In Test mode: VD_DVM disconnected from property notification but clients uses method (vHandle_DeviceManagerGetConfigurationValue_MethodStart)"));
    }
    if(poMessage)
    {
        ETG_TRACE_USR4(("vHandle_DeviceManagerGetConfigurationValue_MethodStart. SourceAppID = %x; FID = %x.", ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID()), ETG_ENUM(DVM_FCTID, poMessage->u16GetFunctionID()) ));

        //===============================================================
        //receive and unmarshal message
        //===============================================================
        FIDEVMGR_GETCONFIGURATIONVALUE_METHODSTART   oFiDataObject_Get;   // create the object of FIDEVMGR_EJECTOPTICALDISC_METHODSTART
        fi_tclVisitorMessage                    oVisitorMsg(poMessage);   //create the visitor message

        if (OSAL_ERROR != oVisitorMsg.s32GetData (oFiDataObject_Get, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {

            // Retrieve the Configuration parameter from the message
            const char* l_strConfigParam = (const char*)oFiDataObject_Get.ConfigurationParam;




            ETG_TRACE_SYS (("***********************************************************************************************"));
            ETG_TRACE_SYS (("vHandle_DeviceManagerGetConfigurationValue_MethodStart: l_strConfigParam          = %s",l_strConfigParam));
            ETG_TRACE_SYS (("************************************************************************************************"));

            trReceiverInfo  l_oReceiverInfo;
            l_oReceiverInfo.u16GetSourceAppID = poMessage->u16GetSourceAppID();
            l_oReceiverInfo.u16GetRegisterID  = poMessage->u16GetRegisterID();
            l_oReceiverInfo.u16GetCmdCounter  = poMessage->u16GetCmdCounter();
            l_oReceiverInfo.u16GetFunctionID  = poMessage->u16GetFunctionID();

            tU16 u16RetVal = 0;

            tBool bSuccess = FALSE;
            bSuccess = ConfigurationManager::GetInstance()->vGetConfigurationValue(l_strConfigParam,u16RetVal);

            //=======================
            //send result to sender
            //=======================
            vHandle_DeviceManagerGetConfigurationValue_MethodReturn(l_oReceiverInfo,u16RetVal,bSuccess);
        }
        oFiDataObject_Get.vDestroy();
    }

    ETG_TRACE_USR4(("End    : vHandle_DeviceManagerGetConfigurationValue_MethodStart"));
}
OUT tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerGetConfigurationValue_MethodReturn(const trReceiverInfo &f_oReceiverInfo, tU16 u16Value,tBool f_bSuccess)
{
    ETG_TRACE_USR4(("Begin  : vHandle_DeviceManagerGetConfigurationValue_MethodReturn"));

    FIDEVMGR_GETCONFIGURATIONVALUE_METHODRESULT oFiDataObject;

    if(TRUE == f_bSuccess)
    {
        oFiDataObject.Value = u16Value;
    }

    ETG_TRACE_USR4(("vHandle_DeviceManagerGetConfigurationValue_MethodReturn f_bSuccess : %d ",ETG_ENUM(BOOL,f_bSuccess)));
    ETG_TRACE_USR4(("vHandle_DeviceManagerGetConfigurationValue_MethodReturn u16Value : %d ",u16Value));


    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg_Result(oFiDataObject,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION);

    // Here the message related header information is added and by this the
    // creation of the message is completed.
    vInitServiceData(oMsg_Result,                          // ServiceDataMsg
                     f_oReceiverInfo.u16GetSourceAppID,    // Target AppID
                     f_oReceiverInfo.u16GetRegisterID,     // RegisterID
                     f_oReceiverInfo.u16GetCmdCounter,     // CmdCounter,
                     f_oReceiverInfo.u16GetFunctionID,     // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODRESULT); // Opcode

    // Post the message to the client
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg_Result, TRUE);

    // Check for Error after posting message
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("vHandle_DeviceManagerGetConfigurationValue_MethodReturn: ERROR: enPostMessage() 'ail_tenCommunicationError'= %d", (int)enResult));
    }

    oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)

    ETG_TRACE_USR4(("End    : vHandle_DeviceManagerGetConfigurationValue_MethodReturn"));
}


IN tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerSetConfigurationValue_MethodStart( amt_tclServiceData* poMessage)
{
    ETG_TRACE_USR4(("Begin  : vHandle_DeviceManagerSetConfigurationValue_MethodStart"));
    if(!m_bConnectClients)
    {
        ETG_TRACE_FATAL(("WARNING: In Test mode: VD_DVM disconnected from property notifiation but clients uses method (vHandle_OpticalDiscEject_MethodStart)"));
    }
    if(poMessage)
    {
        ETG_TRACE_USR4(("vHandle_DeviceManagerSetConfigurationValue_MethodStart. SourceAppID = %x; FID = %x.", ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID()), ETG_ENUM(DVM_FCTID, poMessage->u16GetFunctionID()) ));

        //===============================================================
        //receive and unmarshal message
        //===============================================================
        FIDEVMGR_SETCONFIGURATIONVALUE_METHODSTART   oFiDataObject_Get;   // create the object of FIDEVMGR_EJECTOPTICALDISC_METHODSTART
        fi_tclVisitorMessage                    oVisitorMsg(poMessage);   //create the visitor message

        if (OSAL_ERROR != oVisitorMsg.s32GetData (oFiDataObject_Get, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {

            // Retrieve the Configuration parameter from the message
            const char* l_strConfigParam             = (const char*)oFiDataObject_Get.ConfigurationParam;
            tU16 u16Value                            = oFiDataObject_Get.Value;
            FISHARED_E8_SETTINGSMODE l_SettingsMode  = oFiDataObject_Get.SettingsMode;
            tenSettingsMode l_eSettingsMode = DEFAULT;
            switch(l_SettingsMode.enType)
            {
            case FISHARED_E8_SETTINGSMODE::FI_EN_TEMPORARY:
                l_eSettingsMode = TEMPORARY;
                break;
            case FISHARED_E8_SETTINGSMODE::FI_EN_PERMANENT:
                l_eSettingsMode = PERMANENT;
                break;
            case FISHARED_E8_SETTINGSMODE::FI_EN_DEFAULT:
                l_eSettingsMode = DEFAULT;
                break;
            }


            ETG_TRACE_SYS (("***********************************************************************************************"));
            ETG_TRACE_SYS (("vHandle_DeviceManagerSetConfigurationValue_MethodStart: l_strConfigParam       = %s",l_strConfigParam));
            ETG_TRACE_SYS (("vHandle_DeviceManagerSetConfigurationValue_MethodStart: u16Value               = %d",u16Value));
            ETG_TRACE_SYS (("vHandle_DeviceManagerSetConfigurationValue_MethodStart: l_eSettingsMode        = %d",l_eSettingsMode));
            ETG_TRACE_SYS (("************************************************************************************************"));

            trReceiverInfo  l_oReceiverInfo;
            l_oReceiverInfo.u16GetSourceAppID = poMessage->u16GetSourceAppID();
            l_oReceiverInfo.u16GetRegisterID  = poMessage->u16GetRegisterID();
            l_oReceiverInfo.u16GetCmdCounter  = poMessage->u16GetCmdCounter();
            l_oReceiverInfo.u16GetFunctionID  = poMessage->u16GetFunctionID();



            tBool bSuccess = FALSE;
            bSuccess = ConfigurationManager::GetInstance()->vSetConfigurationValue(l_strConfigParam,u16Value,l_eSettingsMode);


            //=======================
            //send result to sender
            //=======================
            vHandle_DeviceManagerSetConfigurationValue_MethodReturn(l_oReceiverInfo,bSuccess);
        }
        oFiDataObject_Get.vDestroy();
    }

    ETG_TRACE_USR4(("End    : vHandle_DeviceManagerSetConfigurationValue_MethodStart"));
}
OUT tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerSetConfigurationValue_MethodReturn( const trReceiverInfo &f_oReceiverInfo, tBool f_bSuccess )
{
    ETG_TRACE_USR4(("Begin  : vHandle_DeviceManagerSetConfigurationValue_MethodReturn"));
    FIDEVMGR_SETCONFIGURATIONVALUE_METHODRESULT oFiDataObject;


    oFiDataObject.Success = f_bSuccess;

    ETG_TRACE_USR4(("vHandle_DeviceManagerSetConfigurationValue_MethodReturn %d",ETG_ENUM(BOOL,f_bSuccess)));

    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg_Result(oFiDataObject,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION);

    // Here the message related header information is added and by this the
    // creation of the message is completed.
    vInitServiceData(oMsg_Result,                          // ServiceDataMsg
                     f_oReceiverInfo.u16GetSourceAppID,    // Target AppID
                     f_oReceiverInfo.u16GetRegisterID,     // RegisterID
                     f_oReceiverInfo.u16GetCmdCounter,     // CmdCounter,
                     f_oReceiverInfo.u16GetFunctionID,     // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODRESULT); // Opcode

    // Post the message to the client
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg_Result, TRUE);

    // Check for Error after posting message
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("vHandle_DeviceManagerSetConfigurationValue_MethodReturn: ERROR: enPostMessage() 'ail_tenCommunicationError'= %d", (int)enResult));
    }

    oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)

    ETG_TRACE_USR4(("End    : vHandle_DeviceManagerSetConfigurationValue_MethodReturn"));
}


IN tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerAddExternalHub_MethodStart( amt_tclServiceData* poMessage)
{
    ETG_TRACE_USR4(("Begin  : vHandle_DeviceManagerAddExternalHub_MethodStart"));

    if(!m_bConnectClients)
    {
        ETG_TRACE_FATAL(("WARNING: In Test mode: VD_DVM disconnected from property notification but clients uses method (vHandle_DeviceManagerAddExternalHub_MethodStart)"));
    }
    if(poMessage)
    {
        ETG_TRACE_USR4(("vHandle_DeviceManagerAddExternalHub_MethodStart. SourceAppID = %x; FID = %x.", ETG_ENUM(ail_u16AppId, poMessage->u16GetSourceAppID()), ETG_ENUM(DVM_FCTID, poMessage->u16GetFunctionID()) ));

        //===============================================================
        //receive and unmarshal message
        //===============================================================
        FIDEVMGR_ADDEXTERNALHUB_METHODSTART   oFiDataObject_Get;   // create the object of FIDEVMGR_ADDEXTERNALHUB_METHODSTART
        fi_tclVisitorMessage                    oVisitorMsg(poMessage);   //create the visitor message

        if (OSAL_ERROR != oVisitorMsg.s32GetData (oFiDataObject_Get, VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION))
        {
            // Retrieve the details of device from message
            tU16 u16VendorID                         = (tU16)oFiDataObject_Get.VendorID;
            tU16 u16ProductID                        = (tU16)oFiDataObject_Get.ProductID;
            tU16 u16USBPortNo                        = (tU16)oFiDataObject_Get.USBPortNo;
            tBool bAdd                               = oFiDataObject_Get.Add;

            ETG_TRACE_SYS (("***********************************************************************************************"));
            ETG_TRACE_SYS (("vHandle_DeviceManagerAddExternalHub_MethodStart: u32VendorID          = 0x%x",u16VendorID));
            ETG_TRACE_SYS (("vHandle_DeviceManagerAddExternalHub_MethodStart: u32ProductID         = 0x%x",u16ProductID));
            ETG_TRACE_SYS (("vHandle_DeviceManagerAddExternalHub_MethodStart: u32USBPortNo         = %d"  ,u16USBPortNo));
            ETG_TRACE_SYS (("************************************************************************************************"));

            trReceiverInfo  l_oReceiverInfo;
            l_oReceiverInfo.u16GetSourceAppID = poMessage->u16GetSourceAppID();
            l_oReceiverInfo.u16GetRegisterID  = poMessage->u16GetRegisterID();
            l_oReceiverInfo.u16GetCmdCounter  = poMessage->u16GetCmdCounter();
            l_oReceiverInfo.u16GetFunctionID  = poMessage->u16GetFunctionID();
            trExternalHubInfo l_uiExternalHubInfo;
            l_uiExternalHubInfo.iProductID           = u16ProductID;
            l_uiExternalHubInfo.iVendorID            = u16VendorID;
            l_uiExternalHubInfo.eUsb                 = (statetbl::tenDevManagerUSBHost)u16USBPortNo;
            tBool bSuccess  =  DeviceManagerInterface::GetInstance()->AddExternalHub(l_uiExternalHubInfo,bAdd);
            //=======================
            //send result to sender
            //=======================
            vHandle_DeviceManagerAddExternalHub_MethodReturn(l_oReceiverInfo,bSuccess);
        }
        oFiDataObject_Get.vDestroy();
    }

    ETG_TRACE_USR4(("End    : vHandle_DeviceManagerAddExternalHub_MethodStart"));
}

OUT tVoid vd_devicemanager_tclService_DeviceManager::vHandle_DeviceManagerAddExternalHub_MethodReturn(const trReceiverInfo &f_oReceiverInfo, tBool f_bSuccess)
{
    ETG_TRACE_USR4(("Begin  : vHandle_DeviceManagerAddExternalHub_MethodReturn"));

    FIDEVMGR_ADDEXTERNALHUB_METHODRESULT oFiDataObject;

    oFiDataObject.Success = f_bSuccess;

    // Create FI VisitorMessage. (The FI data object will be streamed (each
    // parameter is copied individually) to shared memory.)
    fi_tclVisitorMessage oMsg_Result(oFiDataObject,VD_DEVICEMANAGER_SERVICE_DEVICEMANAGER_FI_MAJOR_VERSION);

    // Here the message related header information is added and by this the
    // creation of the message is completed.
    vInitServiceData(oMsg_Result,                          // ServiceDataMsg
                     f_oReceiverInfo.u16GetSourceAppID,    // Target AppID
                     f_oReceiverInfo.u16GetRegisterID,     // RegisterID
                     f_oReceiverInfo.u16GetCmdCounter,     // CmdCounter,
                     f_oReceiverInfo.u16GetFunctionID,     // Function ID
                     AMT_C_U8_CCAMSG_OPCODE_METHODRESULT); // Opcode

    // Post the message to the client
    ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oMsg_Result, TRUE);

    // Check for Error after posting message
    if (AIL_EN_N_NO_ERROR != enResult)
    {
        ETG_TRACE_ERR (("vHandle_DeviceManagerAddExternalHub_MethodReturn: ERROR: enPostMessage() 'ail_tenCommunicationError'= %d", (int)enResult));
    }

    oFiDataObject.vDestroy(); // Always destroy the (message related) FI data object (before leaving its creation scope)

    ETG_TRACE_USR4(("End    : vHandle_DeviceManagerAddExternalHub_MethodReturn"));
}


////////////////////////////////////////////////////////////////////////////////
// <EOF>
