/*-----------------------------------------------------------------------------*
 * StorageInfoProvider.h
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen3                                                   *
 * COPYRIGHT   : (c) 2013-2020 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file StorageInfoProvider.h
 *
 * \brief new IStorgeInfoProvider used to fetch the storage info to devices using a temporary thread
 *
 *-----------------------------------------------------------------
 *                                   development for Gen3:
 *-----------------------------------------------------------------
 * \version Initial Version 24.08.2016, Rajeev Narayanan Sambhu (RBEI/ECO3) (Bosch)
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2013-2020
 */

#ifndef __STORAGEINFOPROVIDER_H__
#define __STORAGEINFOPROVIDER_H__

/*-----------------------------------------------------------------------------*
 * Includes                                                                    *
 *-----------------------------------------------------------------------------*/
#include "Config.h"
#include "IStorageInfoProvider.h"


/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/
using namespace std;
using namespace prmmgr;

/*-----------------------------------------------------------------------------*
 * Forward declaration                                                                  *
 *-----------------------------------------------------------------------------*/
class CUDevManager;

/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class StorageInfoProvider
 *
 * \brief new StorageInfoProvider used to fetch the storage info to devices using a temporary thread
 */

class StorageInfoProvider: public IStorageInfoProvider,public TFThread
{

    public:

    typedef enum
    {
       eThread_GetStorageInfo = 0,
       eThread_Last       = 1
    }tenThreadFunction;





   /*!
         * \brief Constructor
         */
    StorageInfoProvider();

    /*!
         * \brief Destructor
         */
    virtual ~StorageInfoProvider();

    int Initialize(tVoid) ;


    /**
     * \brief Thread function -
     *
     * Temporary thread to calculate the storage info of a device
     */
    virtual tVoid vThreadFunction(IN CDevice *f_pCurDevice);


    /**
    * This function request to fill the storage info of device
    *
    * @return void
    */

    tVoid vGetSizeMSC(IN const CDevice &f_CurDevice );

    /**
    * This function  forwards the storage information to UdevManager
    *
    * @return void
    */
    tVoid vUpdateStorageInfo(OUT CDevice f_CurDevice);

    /**
    * This function  forwards the status of Thread
    *
    * @return TRUE is there is no storage info calculation is going on in the temporary thread
    */
    tBool IsFreeSlotsAvailable();




    /**
    * This function derives from TFThread and starts a user function in a thread from the thread factory's thread pool.
    * After leaving the function used thread is stopped and released for other users
    *
    * @return void
    */
    virtual void Do(int functionID, void *ptr);

    private:

    DVMLOCK           m_StrongInfoLock;

    CUDevManager  *m_pCUDevManager;


    tBool m_IsThreadBusy;


};



#endif // __STORAGEINFOPROVIDER_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

