/*-----------------------------------------------------------------------------*
 * PlatformCtrl.h                                                                *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen3                                                   *
 * COPYRIGHT   : (c) 2014 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file PlatformCtrl.h
 *
 * \brief This file holds the declaration for PlatformCtrl
 *
 *PlatformCtrl is used to start and stop entities bound to platform. In this manner devmgrcore does not have to know
 *about which parts of the platform interfaces are defined to be used or not. E.g. entities might use prm or not. 
 *
 * \version Initial Version
 * \version 01.09.2014, Koechling, Christian (Bosch), initial version
 *
 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2014-2020
 */

#ifndef _PLATFORM_CTRL_H__
#define _PLATFORM_CTRL_H__

/*-----------------------------------------------------------------------------*
 * includes                                                                  *
 *-----------------------------------------------------------------------------*/
#include "IStateTableHWSignals.h"     //old interface
#include "IStateTableHWMalfunction.h" //new interface

#include "IAutomounterAdapter.h"
#include "IStorageInfoProvider.h"

/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * Structs                                                                     *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * forward declaration                                                           *
 *-----------------------------------------------------------------------------*/
class VoltageManager;
class PrmManager;
class HUBHardwareSignalReader;
class AutomounterAdapter;
class StorageInfoProvider;



/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/


/*!
 * \class PlatformCtrl
 */
class PlatformCtrl
{
 //=======
    public:
 //=======

 
        typedef enum 
        {
           enPrmManagerIF            = 0,
           enPrmManagerCardIF        = 1,
           enVoltageManagerIF        = 2,
           enGpioIF                  = 3,
           enHUBHardwareSignalreader = 5,
           enAutomounterAdapterIF    = 6,
           enStorageInfoProviderIF   = 8,
           enAllInterfaces           = 9
        }tenPlatformCtrlIF;

       
       /*! 
              * \brief constructor
              *
              * \todo think about using directly singleton call instead of handing over pointer
              */
             PlatformCtrl(IN IStateTableHWSignals *pIStateTableHWSignals,IN IStateTableHWMalfunction *pIStateTableHWMalfunction);
       
             /*!
              * \brief destructor 
              */
             ~PlatformCtrl();
       

            /*!
             * \brief Initializes the object
             *
             * \return [int] initialization status OSAL_OK or OSAL_ERROR
             */
        int Initialize();


        IPrmManager               *GetInterfacePrmManager();
        IPrmManagerCard           *GetInterfacePrmManagerCard();
        IVoltageManager           *GetInterfaceVoltageManager();
        IHUBHardwareSignalReader  *GetInterfaceHubHardwareSignalReader();
        IAutomounterAdapter       *GetInterfaceAutomounterAdapter();
        IStorageInfoProvider      *GetInterfaceStorageInfoProvider();


   //=======
   protected:
   //=======

        PrmManager              *m_pPrmManager;
        VoltageManager          *m_pVoltageManager;
        HUBHardwareSignalReader *m_pHUBHardwareSignalReader;
        AutomounterAdapter      *m_pAutomounterAdapter;
        StorageInfoProvider     *m_pStorageInfoProvider;

        
        IStateTableHWSignals     *m_pIStateTableHWSignals;
        IStateTableHWMalfunction *m_pIStateTableHWMalfunction;
        
        tBool m_bInitialised[enAllInterfaces];

};

#endif //_PLATFORM_CTRL_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>

