/*-----------------------------------------------------------------------------*
 * IUdevManagerInternalInput.h                                                                *
 *-----------------------------------------------------------------------------*
 *                                                                             *
 * SW-COMPONENT: VD_DeviceManager                                              *
 * PROJECT     : GM NextGen2                                                   *
 * COPYRIGHT   : (c) 2015 Robert Bosch GmbH, Hildesheim                        *
 *                                                                             *
 *-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*
 * doxygen style header                                                        *
 *-----------------------------------------------------------------------------*/
/*!
 * \file IUdevManagerInternalInput.h
 *
 * \brief Interface
 *
 * e.g. VD_DVM receives a CDROM mount via CCA-Interface from FC_DIAG. Mounts the CDROM (Mix mode) and triggers VD_DVM as ifplatform would have notified it
 *
 * \version Initial Version
 * \version 10.10.2011, Koechling, Christian (Bosch), added to serve unit test

 *
 * \copyright Copyright (c) Robert Bosch Car Multimedia GmbH 2010-2020
 */

#ifndef __INTERFACE_UDEV_MANAGER_INTERNALINPUT_H__
#define __INTERFACE_UDEV_MANAGER_INTERNALINPUT_H__



/*-----------------------------------------------------------------------------*
 * Namespaces                                                                  *
 *-----------------------------------------------------------------------------*/



/*-----------------------------------------------------------------------------*
 * Class declaration                                                           *
 *-----------------------------------------------------------------------------*/
/*!
 * \class PrmManager
 */
class IUdevManagerInternalInput
{
    public:

    
        /*!
         * \brief private destructor for singleton
         */
       virtual  ~IUdevManagerInternalInput(){};

  
       virtual void vSendMountDevice(tBool bMount,GENSTRING devicename, GENSTRING mountPoint) const = 0; //Roadmap 14002 MountCDROM (DiagMixeMode)


   
};

#endif //__INTERFACE_UDEV_MANAGER_INTERNALINPUT_H__

////////////////////////////////////////////////////////////////////////////////
// <EOF>
